/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarmAudio.AlarmAudioRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmAudio.AlarmAudioRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmAudioService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="alarmAudioService")
public class AlarmAudioServiceNvr800Impl
extends AbstractNvr800Service
implements AlarmAudioService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmAudioServiceNvr800Impl.class);

    public AlarmAudioRespond alarmAudioGet(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        AlarmAudioRespond respond;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject dataObject = new JSONObject();
            jsonObject.put("channel", (Object)request.getChannel());
            dataObject.put("data", (Object)jsonObject);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ALARM_AUDIO_LINKAGE_CONFIGURATION_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONObject channelInfo = rsp.getJSONObject("data").getJSONObject("channel_info");
            respond = new AlarmAudioRespond();
            JSONObject audioObject = new JSONObject();
            for (String a : channelInfo.keySet()) {
                ArrayList<AlarmAudioRespond.AudioList> audioList = new ArrayList<AlarmAudioRespond.AudioList>();
                if (!channelInfo.getJSONObject(a).containsKey((Object)"audio_list")) continue;
                JSONArray audioList1 = channelInfo.getJSONObject(a).getJSONArray("audio_list");
                for (int i = 0; i < audioList1.size(); ++i) {
                    JSONObject jsonObject1 = audioList1.getJSONObject(i);
                    AlarmAudioRespond.AudioList audioList2 = new AlarmAudioRespond.AudioList();
                    audioList2.setFileName(jsonObject1.getString("file_name"));
                    audioList2.setInternal(jsonObject1.getBoolean("internal").booleanValue());
                    audioList.add(audioList2);
                }
                int volume = 0;
                if (channelInfo.getJSONObject(a).containsKey((Object)"volume")) {
                    volume = channelInfo.getJSONObject(a).getIntValue("volume");
                    respond.setVolume(Integer.valueOf(volume));
                }
                if (request.getChannel().size() > 1) {
                    respond.setVolume(null);
                    AlarmAudioRespond audioRespond = new AlarmAudioRespond();
                    audioRespond.setVolume(Integer.valueOf(volume));
                    audioRespond.setAudioList(audioList);
                    audioObject.put(a, (Object)audioRespond);
                    continue;
                }
                respond.setAudioList(audioList);
            }
            respond.setAudioObject(audioObject);
        }
        catch (SDKException e) {
            LOGGER.error("alarmAudioGet happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public JSONObject alarmAudioAdd(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        JSONObject rsp;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject dataObject = new JSONObject();
            for (int i = 0; i < request.getChannel().size(); ++i) {
                jsonObject.put("channel", (Object)request.getChannel().getString(i));
            }
            jsonObject.put("file_name", (Object)request.getFileName());
            jsonObject.put("file_data", (Object)request.getFileData());
            jsonObject.put("volume", (Object)request.getVolume());
            dataObject.put("data", (Object)jsonObject);
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ALARM_AUDIO_LINKAGE_CONFIGURATION_ADD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("alarmAudioAdd happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public JSONObject alarmAudioDel(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        JSONObject rsp;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject dataObject = new JSONObject();
            JSONObject arrayObject = new JSONObject();
            JSONObject chnObject = new JSONObject();
            arrayObject.put("audio_list", (Object)request.getAudioList());
            for (int i = 0; i < request.getChannel().size(); ++i) {
                chnObject.put(request.getChannel().getString(i), (Object)arrayObject);
            }
            jsonObject.put("channel_info", (Object)chnObject);
            dataObject.put("data", (Object)jsonObject);
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.ALARM_AUDIO_LINKAGE_CONFIGURATION_DEl, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("alarmAudioDel happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

