/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.nvr800.device.ChannelListRequestNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.BaseRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.CommonRespondNvr800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AbilityService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.AbstractNvr800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abilityNvr800Service")
public class AbilityNvr800ServiceImpl
extends AbstractNvr800Service
implements AbilityService<IServerType.NVR800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbilityNvr800ServiceImpl.class);

    public Map<String, List<String>> getAbilities(ParamBean<ChannelListRequest> obj) {
        ChannelListRequestNvr800 requestNvr800 = new ChannelListRequestNvr800(((ChannelListRequest)obj.getRequestBody()).getChannelCode());
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.ABILITY_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            TreeMap<String, List<String>> resultMap = new TreeMap<String, List<String>>();
            JSONObject channelInfoMap = respondNvr800.getData().getJSONObject("channel_info");
            for (String channelCode : channelInfoMap.keySet()) {
                JSONObject channelInfo = channelInfoMap.getJSONObject(channelCode);
                if (!channelInfo.containsKey((Object)"ability")) continue;
                resultMap.put(channelCode, channelInfo.getJSONArray("ability").toJavaList(String.class));
            }
            return resultMap;
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Map<String, Boolean> getAbility(ParamBean<ChannelRequest> obj) {
        String channelCode = ((ChannelRequest)obj.getRequestBody()).getChannelCode();
        ChannelListRequestNvr800 requestNvr800 = new ChannelListRequestNvr800(Arrays.asList(channelCode));
        try {
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.ABILITY_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestNvr800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            JSONObject channelInfoMap = respondNvr800.getData().getJSONObject("channel_info");
            JSONObject channelInfo = channelInfoMap.getJSONObject(channelCode);
            if (channelInfo.containsKey((Object)"ability")) {
                List abilityList = channelInfo.getJSONArray("ability").toJavaList(String.class);
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                for (String key : abilityList) {
                    map.put(key, true);
                }
                return map;
            }
            return new HashMap<String, Boolean>();
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public Map<String, Boolean> getAbilityAuth(ParamBean<ChannelRequest> obj) {
        HashMap<String, Boolean> map;
        block4: {
            map = null;
            try {
                CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Nvr800MsgType.SYSTEM_CONFIG_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                this.checkRespond((BaseRespondNvr800)respondNvr800);
                if (respondNvr800.getData().containsKey((Object)"ai_auth_switch")) {
                    map = new HashMap<String, Boolean>();
                    map.put("targetAbility", respondNvr800.getData().getBoolean("ai_auth_switch"));
                    break block4;
                }
                if (respondNvr800.getData().containsKey((Object)"ai_switch")) {
                    map = new HashMap();
                    map.put("targetAbility", respondNvr800.getData().getBoolean("ai_switch"));
                    break block4;
                }
                throw new InvokeException("500", "cu_device_not_support");
            }
            catch (SDKException e) {
                LOGGER.error("get AbilityAuth config happen exception ", (Throwable)e);
                throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
            }
        }
        return map;
    }

    public Boolean setAbilityAuth(VcmReqBaseInfo vcmInfo, ChannelRequest request) {
        try {
            JSONObject dataObject = new JSONObject();
            JSONObject requestObject = new JSONObject();
            requestObject.put("ai_switch", (Object)request.getTargetAbility());
            requestObject.put("ai_auth_switch", (Object)request.getTargetAbility());
            dataObject.put("data", (Object)requestObject);
            CommonRespondNvr800 respondNvr800 = (CommonRespondNvr800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Nvr800MsgType.SYSTEM_CONFIG_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CommonRespondNvr800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondNvr800)respondNvr800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set AbilityAuth happen exception ", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

