/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.videoProgram.VideoProgramRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.videoProgram.VideoProgramRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoProgramService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VideoProgramIvs1800ServiceImpl
extends AbstractIvs1800Service
implements VideoProgramService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoProgramIvs1800ServiceImpl.class);

    public VideoProgramRespond getVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/record/recordplan/" + requestBody.getCameracode() + "/" + requestBody.getDomaincode() + "/" + requestBody.getRecordmethod() + "/v1.0"), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("getVideoPlan error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond addVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_PROGRAM_LIST_ADD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestBody, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("addVideoPlan error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond updateVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_PROGRAM_LIST_UPDATE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestBody, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("updateVideoPlan error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond deleteVideoPlan(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cameraNum", (Object)requestBody.getCameraNum());
            jsonObject.put("cameraCodeList", (Object)requestBody.getCameraCodeList());
            jsonObject.put("recordMethod", (Object)requestBody.getRecordmethod());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_PROGRAM_LIST_DELETE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("deleteVideoPlan error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond getTemporalStrategy(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/record/recordpolicybytime/" + requestBody.getCameracode() + "/" + requestBody.getDomaincode() + "/v1.0"), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("getTemporalStrategy error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond updateTemporalStrategy(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject jsonObject = new JSONObject();
            JSONObject jsonObject1 = new JSONObject();
            jsonObject1.put("recordMode", (Object)requestBody.getRecordPolicy().getRecordMode());
            jsonObject1.put("time", (Object)requestBody.getRecordPolicy().getTime());
            jsonObject1.put("planStreamType", (Object)requestBody.getRecordPolicy().getPlanStreamType());
            jsonObject1.put("alarmStreamType", (Object)requestBody.getRecordPolicy().getAlarmStreamType());
            jsonObject1.put("alarmRecordTTL", (Object)requestBody.getRecordPolicy().getAlarmRecordTTL());
            jsonObject1.put("manualRecordTTL", (Object)requestBody.getRecordPolicy().getManualRecordTTL());
            jsonObject1.put("preRecord", (Object)requestBody.getRecordPolicy().getPreRecord());
            jsonObject1.put("preRecordTime", (Object)requestBody.getRecordPolicy().getPreRecordTime());
            jsonObject1.put("associatedAudio", (Object)requestBody.getRecordPolicy().getAssociatedAudio());
            jsonObject.put("cameraCode", (Object)requestBody.getCameracode());
            jsonObject.put("recordPolicy", (Object)jsonObject1);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_TIMING_STRATEGY_UPDATE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("updateTemporalStrategy error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond getVideoStatus(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("cameraCode", requestBody.getCameracode());
            httpUrlParam.addParam("domainCode", requestBody.getDomaincode());
            httpUrlParam.addParam("recordMethod", String.valueOf(requestBody.getRecordmethod()));
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.RECORD_STATUS_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("getVideoStatus error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond getVideoMetadata(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("cameraCode", requestBody.getCameracode());
            httpUrlParam.addParam("domainCode", requestBody.getDomaincode());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_METADATA_GET, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("getVideoMetadata error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public VideoProgramRespond setVideoMetadata(ParamBean<VideoProgramRequest> obj) {
        VideoProgramRespond searchRespond;
        try {
            VideoProgramRequest requestBody = (VideoProgramRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cameraCode", (Object)requestBody.getCameracode());
            jsonObject.put("isSaveImage", (Object)requestBody.getIsSaveImage());
            jsonObject.put("metadataTTL", (Object)requestBody.getMetadataTTL());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.VIDEO_METADATA_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VideoProgramRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (VideoProgramRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("setVideoMetadata error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

