/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.bean.RecordBookmarkItem;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.RecordStatusRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoBookMarkRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoListRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoLockInfoListRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoLockInfoRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoStartRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.VideoStopRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RecordStatusRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.VideoBookMarkListRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.VideoBookMarkRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.VideoListRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.VideoLockInfoRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.VideoRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoIvs1800Service")
public class VideoIvs1800ServiceImpl
extends AbstractIvs1800Service
implements VideoService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoIvs1800ServiceImpl.class);

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        String domainCode = vcmInfo.getDomainCode();
        VideoListRequestIvs1800 videoRequestIvs1800 = this.requestToIvs1800(req);
        String urlTemplate = "/platform/recordlist/0/%s/%s/%s/%s/%s/%s";
        String url = String.format(Locale.ENGLISH, urlTemplate, videoRequestIvs1800.getCameraCode(), videoRequestIvs1800.getNvrCode(), videoRequestIvs1800.getStartTime(), videoRequestIvs1800.getEndTime(), videoRequestIvs1800.getFormIndex(), videoRequestIvs1800.getToIndex());
        Ivs1800MsgType videoListIvs1800Uri = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            VideoListRespondIvs1800 videoListRespondIvs1800 = (VideoListRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)videoListIvs1800Uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoListRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)videoListRespondIvs1800);
            VideoRespond result = this.ivs1800ToResult(videoListRespondIvs1800, req.getTypeList(), domainCode, req.getChannelCode());
            VideoLockInfoListRequest videoLockInfoListRequest = new VideoLockInfoListRequest();
            videoLockInfoListRequest.setChannelCode(req.getChannelCode());
            videoLockInfoListRequest.setLockStartTime(this.formatToUTCDate(req.getStartTime()));
            videoLockInfoListRequest.setLockEndTime(this.formatToUTCDate(req.getEndTime()));
            VideoLockInfoListRespond videoLockInfoListRespond = this.getVideoLockInfo(vcmInfo, videoLockInfoListRequest);
            result.setLockInfoList(videoLockInfoListRespond.getLockInfoList());
            return result;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 search video list error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        VideoStartRequestIvs1800 videoStartRequestIvs1800 = new VideoStartRequestIvs1800();
        videoStartRequestIvs1800.setCameraCodeList(req.getChannelCode());
        try {
            VideoRespondIvs1800 videoRespondIvs1800 = (VideoRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_START_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoStartRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)videoRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 video start error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        VideoStopRequestIvs1800 videoStopRequestIvs1800 = new VideoStopRequestIvs1800();
        videoStopRequestIvs1800.setCameraCodeList(req.getChannelCode());
        try {
            VideoRespondIvs1800 videoRespondIvs1800 = (VideoRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_STOP_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoStopRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)videoRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 video stop error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("cameraCode", req.getChannelCode());
        httpUrlParam.addParam("domainCode", req.getDomainCode());
        httpUrlParam.addParam("fromTime", this.convertToUTC(req.getFromTime()));
        httpUrlParam.addParam("toTime", this.convertToUTC(req.getToTime()));
        try {
            VideoBookMarkListRespondIvs1800 respondIvs1800 = (VideoBookMarkListRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_TAG_GET_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkListRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            ArrayList<VideoBookMarkRespond> markRespondList = new ArrayList<VideoBookMarkRespond>();
            JSONArray listArray = respondIvs1800.getRecordBookmarkList();
            for (int i = 0; i < listArray.size(); ++i) {
                JSONObject itemJson = listArray.getJSONObject(i);
                if (itemJson.getString("bookmarkID") == null) continue;
                VideoBookMarkRespond markRespond = new VideoBookMarkRespond();
                markRespond.setId(itemJson.getLong("bookmarkID").longValue());
                markRespond.setCameraCode(itemJson.getString("cameraCode"));
                markRespond.setNvrCode(itemJson.getString("nvrCode"));
                markRespond.setName(itemJson.getString("bookmarkName"));
                markRespond.setTime(this.convertToLocal(itemJson.getString("bookmarkTime")));
                markRespond.setCreatorId(itemJson.getString("creatorID"));
                markRespond.setCreatorName(itemJson.getString("creatorName"));
                markRespond.setCreatorDomain(itemJson.getString("creatorDomain"));
                markRespondList.add(markRespond);
            }
            return markRespondList;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get video book mark error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = this.createTagRequestToIvs1800(req);
        try {
            VideoBookMarkRespondIvs1800 videoBookMarkRespondIvs1800 = (VideoBookMarkRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_TAG_CREATE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoBookMarkRespondIvs1800);
            return String.valueOf(videoBookMarkRespondIvs1800.getBookmarkID());
        }
        catch (SDKException e) {
            LOGGER.error("create video book mark error, IP" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = this.uptTagRequestToIvs1800(req);
        try {
            VideoBookMarkRespondIvs1800 videoBookMarkRespondIvs1800 = (VideoBookMarkRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_TAG_UPT_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoBookMarkRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("update video book mark error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = this.delTagRequestToIvs1800(req);
        try {
            VideoBookMarkRespondIvs1800 videoBookMarkRespondIvs1800 = (VideoBookMarkRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_TAG_DEL_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoBookMarkRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoBookMarkRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoBookMarkRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("del video book mark error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        JSONObject result;
        VideoLockInfoListRespond videoLockInfoListRespond = new VideoLockInfoListRespond();
        VideoLockInfoListRequestIvs1800 videoLockInfoListRequestIvs1800 = this.getLockInfoListRequestToIvs1800(req);
        try {
            result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_LOCK_INFO_GET_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockInfoListRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        videoLockInfoListRespond.setLockInfoList(result.getJSONArray("lockInfoList"));
        return videoLockInfoListRespond;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        VideoLockInfoRespond videoLockInfoRespond = new VideoLockInfoRespond();
        VideoLockInfoRequestIvs1800 videoLockInfoRequestIvs1800 = this.createLockInfoRequestToIvs1800(req);
        try {
            VideoLockInfoRespondIvs1800 videoLockInfoRespondIvs1800 = (VideoLockInfoRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_LOCK_INFO_CREATE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockInfoRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoLockInfoRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoLockInfoRespondIvs1800);
            videoLockInfoRespond.setResultCode(videoLockInfoRespondIvs1800.getResultCode().intValue());
            return videoLockInfoRespond;
        }
        catch (SDKException e) {
            LOGGER.error("create video lock error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        VideoLockInfoRespond videoLockInfoRespond = new VideoLockInfoRespond();
        VideoLockInfoRequestIvs1800 videoLockInfoRequestIvs1800 = this.delLockInfoRequestToIvs1800(req);
        try {
            VideoLockInfoRespondIvs1800 videoLockInfoRespondIvs1800 = (VideoLockInfoRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_LOCK_INFO_DEL_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockInfoRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoLockInfoRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoLockInfoRespondIvs1800);
            return videoLockInfoRespond;
        }
        catch (SDKException e) {
            LOGGER.error("del video lock info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        VideoLockInfoRespond videoLockInfoRespond = new VideoLockInfoRespond();
        VideoLockInfoRequestIvs1800 videoLockInfoRequestIvs1800 = this.uptLockInfoRequestToIvs1800(req);
        try {
            VideoLockInfoRespondIvs1800 videoLockInfoRespondIvs1800 = (VideoLockInfoRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_LOCK_INFO_UPT_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)videoLockInfoRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VideoLockInfoRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)videoLockInfoRespondIvs1800);
            return videoLockInfoRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update video lock info error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        ArrayList<RecordStatusRespond> recordStatusRespondList = new ArrayList<RecordStatusRespond>();
        for (String channelCode : ((ChannelListRequest)obj.getRequestBody()).getChannelCode()) {
            RecordStatusRequestIvs1800 requestIvs1800 = new RecordStatusRequestIvs1800();
            requestIvs1800.setCameraCode(channelCode);
            try {
                String url = String.format("/record/recordStatus/v1.0?cameraCode=%s&recordMethod=0", channelCode);
                RecordStatusRespondIvs1800 respondIvs1800 = (RecordStatusRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RecordStatusRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                this.checkRespond((BaseRespondIvs1800)respondIvs1800);
                TreeSet<RecordTypeEnum> typeList = new TreeSet<RecordTypeEnum>();
                if (Arrays.asList(1, 3, 5, 7).contains(respondIvs1800.getRecordState())) {
                    typeList.add(RecordTypeEnum.MANUAL);
                }
                if (Arrays.asList(2, 3, 6, 7).contains(respondIvs1800.getRecordState())) {
                    typeList.add(RecordTypeEnum.ALARM);
                }
                if (Arrays.asList(4, 5, 6, 7).contains(respondIvs1800.getRecordState())) {
                    typeList.add(RecordTypeEnum.PLAN);
                }
                RecordStatusRespond statusRespond = new RecordStatusRespond();
                statusRespond.setChannelCode(channelCode);
                statusRespond.setType(typeList);
                recordStatusRespondList.add(statusRespond);
            }
            catch (SDKException e) {
                LOGGER.error("IVS 1800 get record status error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
                throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
            }
        }
        return recordStatusRespondList;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    private VideoRespond ivs1800ToResult(VideoListRespondIvs1800 videoRespondIvs1800, List<RecordTypeEnum> targetList, String domainCode, String channelCode) {
        VideoRespond videoRespond = new VideoRespond();
        JSONArray recordInfoList = videoRespondIvs1800.getRecordInfos().getJSONArray("recordInfoList");
        if (null == recordInfoList || recordInfoList.size() == 0) {
            return videoRespond;
        }
        ArrayList<VideoItem> videoItemList = new ArrayList<VideoItem>();
        for (int i = 0; i < recordInfoList.size(); ++i) {
            JSONObject jsonObject = recordInfoList.getJSONObject(i);
            List typeList = this.getTypeList(jsonObject.getIntValue("recordType"));
            for (RecordTypeEnum type : typeList) {
                if (!targetList.contains(type)) continue;
                VideoItem videoItem = new VideoItem();
                videoItem.setType(type);
                videoItem.setRecordFileName(jsonObject.getString("recordFileName"));
                if (jsonObject.getJSONObject("recordTime").size() == 2) {
                    videoItem.setStartTime(this.formatToLocalDate((String)jsonObject.getJSONObject("recordTime").get((Object)"startTime")));
                    videoItem.setEndTime(this.formatToLocalDate((String)jsonObject.getJSONObject("recordTime").get((Object)"endTime")));
                }
                videoItem.setNvrCode(jsonObject.getString("nvrCode"));
                videoItem.setDomainCode(domainCode);
                videoItem.setChannelCode(channelCode);
                videoItemList.add(videoItem);
            }
        }
        videoRespond.setVideoItemList(videoItemList);
        return videoRespond;
    }

    private List<RecordTypeEnum> getTypeList(int type) {
        ArrayList<RecordTypeEnum> typeList = new ArrayList<RecordTypeEnum>();
        String strType = StringUtils.leftPad((String)String.valueOf(type), (int)3, (char)'0');
        char[] array = strType.toCharArray();
        if ('1' == array[0]) {
            typeList.add(RecordTypeEnum.MANUAL);
        }
        if ('1' == array[1]) {
            typeList.add(RecordTypeEnum.PLAN);
        }
        if ('1' == array[2]) {
            typeList.add(RecordTypeEnum.ALARM);
        }
        return typeList;
    }

    private VideoBookMarkRequestIvs1800 createTagRequestToIvs1800(VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = new VideoBookMarkRequestIvs1800();
        RecordBookmarkItem recordBookmarkItem = new RecordBookmarkItem();
        recordBookmarkItem.setBookmarkName(req.getName());
        recordBookmarkItem.setBookmarkTime(this.convertToUTC(req.getTime()));
        recordBookmarkItem.setCameraCode(req.getChannelCode());
        videoBookMarkRequestIvs1800.setRecordBookmark(recordBookmarkItem);
        return videoBookMarkRequestIvs1800;
    }

    private VideoBookMarkRequestIvs1800 uptTagRequestToIvs1800(VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = new VideoBookMarkRequestIvs1800();
        RecordBookmarkItem recordBookmarkItem = new RecordBookmarkItem();
        recordBookmarkItem.setBookmarkName(req.getName());
        recordBookmarkItem.setCameraCode(req.getChannelCode());
        recordBookmarkItem.setBookmarkID(Long.valueOf(req.getId()));
        videoBookMarkRequestIvs1800.setRecordBookmark(recordBookmarkItem);
        return videoBookMarkRequestIvs1800;
    }

    private VideoBookMarkRequestIvs1800 delTagRequestToIvs1800(VideoBookMarkRequest req) {
        VideoBookMarkRequestIvs1800 videoBookMarkRequestIvs1800 = new VideoBookMarkRequestIvs1800();
        videoBookMarkRequestIvs1800.setBookmarkID(Long.valueOf(req.getId()));
        videoBookMarkRequestIvs1800.setCameraCode(req.getChannelCode());
        return videoBookMarkRequestIvs1800;
    }

    private VideoLockInfoListRequestIvs1800 getLockInfoListRequestToIvs1800(VideoLockInfoListRequest req) {
        VideoLockInfoListRequestIvs1800 requestIvs1800 = new VideoLockInfoListRequestIvs1800();
        requestIvs1800.setCameraCode(req.getChannelCode());
        requestIvs1800.setLockDesc(req.getLockDesc());
        requestIvs1800.setLockTime(req.getLockTime());
        requestIvs1800.setLockStartTime(req.getLockStartTime());
        requestIvs1800.setLockEndTime(req.getLockEndTime());
        return requestIvs1800;
    }

    private VideoLockInfoRequestIvs1800 createLockInfoRequestToIvs1800(VideoLockInfoRequest req) {
        VideoLockInfoRequestIvs1800 requestIvs1800 = new VideoLockInfoRequestIvs1800();
        requestIvs1800.setCameraCode(req.getChannelCode());
        requestIvs1800.setLockDesc(req.getLockDesc());
        requestIvs1800.setLockStartTime(this.convertToUTC(req.getLockStartTime()));
        requestIvs1800.setLockEndTime(this.convertToUTC(req.getLockEndTime()));
        requestIvs1800.setLockName(req.getLockName());
        requestIvs1800.setLockDuration(req.getLockDuration());
        return requestIvs1800;
    }

    private VideoLockInfoRequestIvs1800 delLockInfoRequestToIvs1800(VideoLockInfoRequest req) {
        VideoLockInfoRequestIvs1800 requestIvs1800 = new VideoLockInfoRequestIvs1800();
        requestIvs1800.setLockID(req.getLockID());
        requestIvs1800.setCameraCode(req.getChannelCode());
        requestIvs1800.setLockName(req.getLockName());
        requestIvs1800.setNvrCode(req.getNvrCode());
        return requestIvs1800;
    }

    private VideoLockInfoRequestIvs1800 uptLockInfoRequestToIvs1800(VideoLockInfoRequest req) {
        VideoLockInfoRequestIvs1800 requestIvs1800 = new VideoLockInfoRequestIvs1800();
        requestIvs1800.setCameraCode(req.getChannelCode());
        requestIvs1800.setLockDuration(req.getLockDuration());
        requestIvs1800.setNvrCode(req.getNvrCode());
        requestIvs1800.setLockID(req.getLockID());
        requestIvs1800.setLockDesc(req.getLockDesc());
        requestIvs1800.setLockName(req.getLockName());
        return requestIvs1800;
    }

    private Map<String, Integer> pageInfoWorker(int pageNum, int pageSize) {
        int toIndex;
        int fromIndex;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (pageNum == 1) {
            fromIndex = 1;
            toIndex = pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize + 1;
            toIndex = pageNum * pageSize;
        }
        map.put("fromIndex", fromIndex);
        map.put("toIndex", toIndex);
        return map;
    }

    private String convertToLocal(String strDate) {
        Date date;
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
        sdf.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
        return sdf.format(date);
    }

    private String convertToUTC(String strDate) {
        Date date;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    private String formatToUTCDate(String strDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
        try {
            Date date = sdf.parse(strDate);
            SimpleDateFormat sdfUTC = new SimpleDateFormat("yyyyMMddHHmmss");
            sdfUTC.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdfUTC.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
    }

    private String formatToLocalDate(String strDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = sdf.parse(strDate);
            SimpleDateFormat sdfLocal = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdfLocal.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
            return sdfLocal.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
    }

    private VideoListRequestIvs1800 requestToIvs1800(VideoListRequest req) {
        VideoListRequestIvs1800 videoListRequestIvs1800 = new VideoListRequestIvs1800();
        videoListRequestIvs1800.setCameraCode(req.getChannelCode());
        videoListRequestIvs1800.setNvrCode(req.getNvrCode());
        Map pageMap = this.pageInfoWorker(req.getPageNum(), req.getPageSize());
        videoListRequestIvs1800.setStartTime(this.formatToUTCDate(req.getStartTime()));
        videoListRequestIvs1800.setEndTime(this.formatToUTCDate(req.getEndTime()));
        videoListRequestIvs1800.setFormIndex(((Integer)pageMap.get("fromIndex")).intValue());
        videoListRequestIvs1800.setToIndex(((Integer)pageMap.get("toIndex")).intValue());
        return videoListRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

