/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.RestResult;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryDelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositoryGroup;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.vehicleRepository.VehicleRepositoryAddRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.vehicleRepository.VehicleRepositoryDelRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.vehicleRepository.VehicleRepositorySearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.vehicleRepository.VehicleRepositoryUpdateRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.vehicleRepository.VehicleRetrievalRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VehicleRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service(value="vehicleRepository1800ServiceImpl")
public class VehicleRepository1800ServiceImpl
extends AbstractIvs1800Service
implements VehicleRepositoryManagementService<IServerType.IVS1800> {
    private static final Logger log = LoggerFactory.getLogger(VehicleRepository1800ServiceImpl.class);

    public VehicleRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositorySearchRespond searchRespond;
        try {
            VehicleRepositorySearchRespondIvs1800 rsp = this.searchCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            searchRespond = new VehicleRepositorySearchRespond();
            searchRespond.setTotal(rsp.getTotal());
            if (!CollectionUtils.isEmpty((Collection)rsp.getGrouplist())) {
                rsp.getGrouplist().forEach(vehicleRepository -> {
                    VehicleRepository repository = new VehicleRepository();
                    repository.setGroupId(vehicleRepository.getGroupId());
                    repository.setName(vehicleRepository.getName());
                    repository.setStatus(vehicleRepository.getStatus());
                    repository.setCreateTime(vehicleRepository.getCreateTime());
                    repository.setOwner("true");
                    searchRespond.getVehicleRepositories().add(repository);
                });
            }
        }
        catch (SDKException e) {
            log.error("search vehicle repository error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    private VehicleRepositorySearchRespondIvs1800 searchCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject pageObject = new JSONObject();
        pageObject.put("no", (Object)"1");
        pageObject.put("pageSize", (Object)"1000");
        pageObject.put("sort", (Object)"asc");
        pageObject.put("orderName", (Object)"name");
        JSONObject dataObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            dataObject.put("name", (Object)request.getName());
        }
        dataObject.put("page", (Object)pageObject);
        if (StringUtils.isNotBlank((CharSequence)request.getRepositoryId())) {
            dataObject.put("groupid", (Object)request.getRepositoryId());
        }
        VehicleRepositorySearchRespondIvs1800 rsp = (VehicleRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_SEARCH_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public VehicleRepositoryAddRespond addVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositoryAddRespond addRespond;
        try {
            VehicleRepositoryAddRespondIvs1800 rsp = this.addCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            addRespond = new VehicleRepositoryAddRespond();
            addRespond.setGroupId(rsp.getGroupId());
        }
        catch (SDKException e) {
            log.error("addVehicleListLibrary error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return addRespond;
    }

    private VehicleRepositoryAddRespondIvs1800 addCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject dataObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)request.getName())) {
            dataObject.put("name", (Object)request.getName());
            dataObject.put("description", (Object)request.getDescription());
            dataObject.put("groupStrId", (Object)request.getRepositoryId());
            dataObject.put("scheme", (Object)request.getScheme());
        }
        VehicleRepositoryAddRespondIvs1800 rsp = (VehicleRepositoryAddRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_ADD_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositoryAddRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public VehicleRepositoryDelRespond delVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositoryDelRespond delRespond;
        try {
            VehicleRepositoryDelRespondIvs1800 rsp = this.delCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            delRespond = new VehicleRepositoryDelRespond();
            if (!CollectionUtils.isEmpty((Collection)rsp.getGroupList())) {
                rsp.getGroupList().forEach(list -> {
                    VehicleRepository repository = new VehicleRepository();
                    repository.setGroupId(list.getGroupId());
                    delRespond.getGroupList().add(repository);
                });
            }
        }
        catch (SDKException e) {
            log.error("delVehicleListLibrary error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return delRespond;
    }

    private VehicleRepositoryDelRespondIvs1800 delCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject jsonObject = new JSONObject();
        JSONArray dataArray = new JSONArray();
        JSONObject groupObject = new JSONObject();
        if (!CollectionUtils.isEmpty((Collection)request.getGroupList())) {
            request.getGroupList().forEach(list -> {
                jsonObject.put("groupid", (Object)list.getGroupId());
                jsonObject.put("groupStrId", (Object)list.getRepositoryId());
            });
            dataArray.add((Object)jsonObject);
            groupObject.put("grouplist", (Object)dataArray);
        }
        VehicleRepositoryDelRespondIvs1800 rsp = (VehicleRepositoryDelRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_DEl_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)groupObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositoryDelRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public RestResult updateVehicleListLibrary(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        RestResult result;
        try {
            BaseRespondIvs1800 rsp = this.updateCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            result = new RestResult();
            result.setCode(String.valueOf(rsp.getResultCode()));
        }
        catch (SDKException e) {
            log.error("updateVehicleListLibrary error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return result;
    }

    private BaseRespondIvs1800 updateCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject dataObject = new JSONObject();
        dataObject.put("groupid", (Object)request.getGroupId());
        dataObject.put("name", (Object)request.getName());
        dataObject.put("description", (Object)request.getDescription());
        dataObject.put("groupStrId", (Object)request.getRepositoryId());
        BaseRespondIvs1800 rsp = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_UPDATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond(rsp);
        return rsp;
    }

    public VehicleRepositoryAddRespond addVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositoryAddRespond addRespond;
        try {
            VehicleRepositoryAddRespondIvs1800 rsp = this.addInfoCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            addRespond = new VehicleRepositoryAddRespond();
            if (!CollectionUtils.isEmpty((Collection)rsp.getPlateList())) {
                rsp.getPlateList().forEach(list -> {
                    VehicleRepository repository = new VehicleRepository();
                    repository.setPlateId(list.getPlateId());
                    repository.setLpn(list.getLpn());
                    repository.setResult(list.getResult());
                    addRespond.getPlateList().add(repository);
                });
            }
        }
        catch (SDKException e) {
            log.error("addVehicleInformation error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return addRespond;
    }

    private VehicleRepositoryAddRespondIvs1800 addInfoCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        VehicleRepositoryAddRespondIvs1800 rsp;
        JSONObject dataObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)request.getRepositoryId())) {
            dataObject.put("duplicate", (Object)request.getDuplicate());
            if (!CollectionUtils.isEmpty((Collection)request.getPlateList())) {
                JSONArray dataArray = new JSONArray();
                request.getPlateList().forEach(list -> {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("lpn", (Object)list.getLpn());
                    jsonObject.put("description", (Object)list.getDescription());
                    jsonObject.put("ownerId", (Object)list.getOwnerId());
                    jsonObject.put("ownerName", (Object)list.getOwnerName());
                    jsonObject.put("plateColor", (Object)list.getPlateColor());
                    jsonObject.put("plateUse", (Object)list.getPlateUse());
                    jsonObject.put("vehicleColor", (Object)list.getVehicleColor());
                    jsonObject.put("carType", (Object)list.getCarType());
                    jsonObject.put("vehicleBrand", (Object)list.getVehicleBrand());
                    jsonObject.put("vehicleSub", (Object)list.getVehicleSub());
                    jsonObject.put("vehicleYear", (Object)list.getVehicleYear());
                    jsonObject.put("fileIdList", (Object)list.getFileIdList());
                    jsonObject.put("strId", (Object)list.getStrId());
                    jsonObject.put("pictures", (Object)list.getPictures());
                    dataArray.add((Object)jsonObject);
                });
                dataObject.put("plateList", (Object)dataArray);
            }
        }
        if ((rsp = (VehicleRepositoryAddRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_POST, "/sdk_service/rest/platerepositories/" + request.getRepositoryId() + "/plates"), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositoryAddRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo))).getResultCode() != 911000031 && rsp.getResultCode() != 911000032) {
            this.checkRespond((BaseRespondIvs1800)rsp);
        }
        return rsp;
    }

    public VehicleRepositoryDelRespond delVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositoryDelRespond delRespond;
        try {
            VehicleRepositoryDelRespondIvs1800 rsp = this.delInfoCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            delRespond = new VehicleRepositoryDelRespond();
            if (!CollectionUtils.isEmpty((Collection)rsp.getPlateList())) {
                rsp.getPlateList().forEach(list -> {
                    VehicleRepository repository = new VehicleRepository();
                    repository.setPlateId(list.getPlateId());
                    repository.setLpn(list.getLpn());
                    delRespond.getPlateList().add(repository);
                });
            }
        }
        catch (SDKException e) {
            log.error("delVehicleInformation error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return delRespond;
    }

    private VehicleRepositoryDelRespondIvs1800 delInfoCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject dataObject = new JSONObject();
        JSONArray dataArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)request.getDeleteType()) && !CollectionUtils.isEmpty((Collection)request.getPlateLists())) {
            dataArray.addAll((Collection)request.getPlateLists());
            dataObject.put("deleteType", (Object)request.getDeleteType());
            dataObject.put("plateList", (Object)dataArray);
        }
        VehicleRepositoryDelRespondIvs1800 rsp = (VehicleRepositoryDelRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_DEL_PLATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositoryDelRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public JSONObject updateVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        JSONObject jsonObject = new JSONObject();
        JSONObject plateObject = new JSONObject();
        try {
            VehicleRepositoryUpdateRespondIvs1800 rsp = this.updateInfoCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            jsonObject.put("lpn", (Object)rsp.getPlate().getLpn());
            jsonObject.put("plateId", (Object)rsp.getPlate().getPlateId());
            plateObject.put("plate", (Object)jsonObject);
        }
        catch (SDKException e) {
            log.error("updateVehicleListLibrary error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return plateObject;
    }

    private VehicleRepositoryUpdateRespondIvs1800 updateInfoCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject dataObject = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)request.getRepositoryId()) && Objects.nonNull(request.getPlate())) {
            jsonObject.put("lpn", (Object)request.getPlate().getLpn());
            jsonObject.put("description", (Object)request.getPlate().getDescription());
            jsonObject.put("ownerId", (Object)request.getPlate().getOwnerId());
            jsonObject.put("ownerName", (Object)request.getPlate().getOwnerName());
            jsonObject.put("plateColor", (Object)request.getPlate().getPlateColor());
            jsonObject.put("plateUse", (Object)request.getPlate().getPlateUse());
            jsonObject.put("vehicleColor", (Object)request.getPlate().getVehicleColor());
            jsonObject.put("carType", (Object)request.getPlate().getCarType());
            jsonObject.put("vehicleBrand", (Object)request.getPlate().getVehicleBrand());
            jsonObject.put("vehicleSub", (Object)request.getPlate().getVehicleSub());
            jsonObject.put("vehicleYear", (Object)request.getPlate().getVehicleYear());
            jsonObject.put("fileIdList", (Object)request.getPlate().getFileIdList());
            jsonObject.put("pictures", (Object)request.getPlate().getPictures());
            dataObject.put("plate", (Object)jsonObject);
        }
        VehicleRepositoryUpdateRespondIvs1800 rsp = (VehicleRepositoryUpdateRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PATCH, "/sdk_service/rest/platerepositories/" + request.getRepositoryId() + "/plates/" + request.getPlateId()), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositoryUpdateRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public VehicleRepositorySearchRespond searchVehicleInformation(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositorySearchRespond searchRespond;
        try {
            VehicleRepositorySearchRespondIvs1800 rsp = this.searchInfoCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            searchRespond = new VehicleRepositorySearchRespond();
            searchRespond.setNumber(rsp.getNumber());
            if (!CollectionUtils.isEmpty((Collection)rsp.getPlateList())) {
                rsp.getPlateList().forEach(list -> {
                    VehicleRepository repository = new VehicleRepository();
                    repository.setPlateId(list.getPlateId());
                    repository.setBrandType(list.getBrandType());
                    repository.setLpn(list.getLpn());
                    repository.setDescription(list.getDescription());
                    repository.setOwnerId(list.getOwnerId());
                    repository.setOwnerName(list.getOwnerName());
                    repository.setVehiclebrand(list.getVehiclebrand());
                    repository.setVehicleSub(list.getVehicleSub());
                    repository.setPlateColor(list.getPlateColor());
                    repository.setPlateUse(list.getPlateUse());
                    repository.setVehicleColor(list.getVehicleColor());
                    repository.setCarType(list.getCarType());
                    repository.setYear(list.getYear());
                    repository.setCreator(list.getCreator());
                    repository.setCreateTime(list.getCreateTime());
                    repository.setUpdateTime(list.getUpdateTime());
                    VehicleRepositoryGroup group = new VehicleRepositoryGroup();
                    group.setGroupid(list.getGroup().getGroupid());
                    group.setGroupname(list.getGroup().getGroupname());
                    group.setOwner(list.getGroup().getOwner());
                    list.getPictures().forEach(id -> group.setFileId(id.getFileId()));
                    repository.setGroup(group);
                    searchRespond.getPlateList().add(repository);
                });
            }
        }
        catch (SDKException e) {
            log.error("searchVehicleInformation error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    private VehicleRepositorySearchRespondIvs1800 searchInfoCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject pageObject = new JSONObject();
        JSONObject dataObject = new JSONObject();
        pageObject.put("page", request.getPageCondition().get((Object)"page"));
        pageObject.put("limit", request.getPageCondition().get((Object)"limit"));
        JSONObject jsonObject = new JSONObject();
        if (Objects.nonNull(request.getPlate())) {
            jsonObject.put("plateId", (Object)request.getPlate().getPlateId());
            jsonObject.put("groupid", (Object)request.getPlate().getRepositoryId());
            jsonObject.put("lpn", (Object)request.getPlate().getLpn());
            jsonObject.put("ownerId", (Object)request.getPlate().getOwnerId());
            jsonObject.put("ownerName", (Object)request.getPlate().getOwnerName());
            jsonObject.put("plateColor", (Object)request.getPlate().getPlateColor());
            jsonObject.put("plateUse", (Object)request.getPlate().getPlateUse());
            jsonObject.put("vehicleColor", (Object)request.getPlate().getVehicleColor());
            jsonObject.put("carType", (Object)request.getPlate().getCarType());
            jsonObject.put("vehicleBrand", (Object)request.getPlate().getVehicleBrand());
            jsonObject.put("vehicleSub", (Object)request.getPlate().getVehicleSub());
            jsonObject.put("year", (Object)request.getPlate().getVehicleYear());
            jsonObject.put("startTime", (Object)request.getPlate().getStartTime());
            jsonObject.put("endTime", (Object)request.getPlate().getEndTime());
            dataObject.put("plate", (Object)jsonObject);
        }
        dataObject.put("condition", (Object)pageObject);
        VehicleRepositorySearchRespondIvs1800 rsp = (VehicleRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_SEARCH_PLATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public VehicleRepositorySearchRespond vehicleDynamicRetrieval(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        VehicleRepositorySearchRespond searchRespond;
        try {
            VehicleRetrievalRespondIvs1800 rsp = this.retrievalCommon(vcmReqBaseInfo, vehicleRepositoryRequest);
            searchRespond = new VehicleRepositorySearchRespond();
            List vehicleList = rsp.getVehicleList();
            if (!CollectionUtils.isEmpty((Collection)vehicleList)) {
                vehicleList.forEach(vehicleList1 -> vehicleList1.setDomainCode(vcmReqBaseInfo.getDomainCode()));
            }
            searchRespond.setVehicleList(vehicleList);
            searchRespond.setPage(rsp.getPage());
        }
        catch (SDKException e) {
            log.error("vehicleDynamicRetrieval error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    private VehicleRetrievalRespondIvs1800 retrievalCommon(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest request) throws SDKException {
        JSONObject dataObject = new JSONObject();
        dataObject.put("condition", (Object)request.getCondition());
        dataObject.put("page", (Object)request.getPage());
        VehicleRetrievalRespondIvs1800 rsp = (VehicleRetrievalRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_DYNAMIC_DATABASE_RETRIEVAL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, VehicleRetrievalRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public JSONObject dynamicLibraryPictureDownload(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        String content;
        CloseableHttpResponse result;
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("pictureid", (Object)vehicleRepositoryRequest.getPictureid());
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DYNAMIC_LIBRARY_PICTURES_DOWNLOAD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), response -> (CloseableHttpResponse)response);
        }
        catch (SDKException e) {
            log.error("IVS1800 dynamicLibraryPictureDownload error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        try (InputStream inputStream = result.getEntity().getContent();){
            content = this.getContentFromInputStream(inputStream, result);
        }
        catch (IOException e) {
            log.error("stream failed", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        if (content.contains("resultCode")) {
            Optional baseRespondIvs1800 = JsonUtil.convertJsonToBean((String)content, BaseRespondIvs1800.class);
            if (baseRespondIvs1800.isPresent()) {
                throw new InvokeException("500", (Object)content, Ivs1800Utils.get((int)((BaseRespondIvs1800)baseRespondIvs1800.get()).getResultCode()));
            }
            throw new InvokeException("500", (Object)content, "unknown_error");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("vehicleImage", (Object)content);
        return jsonObject;
    }

    public Boolean batchChangePlateList(VcmReqBaseInfo vcmReqBaseInfo, VehicleRepositoryRequest vehicleRepositoryRequest) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("groupid", (Object)vehicleRepositoryRequest.getRepositoryId());
            jsonObject.put("plateList", (Object)vehicleRepositoryRequest.getPlateLists());
            BaseRespondIvs1800 rsp = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_GROUP_BATCH_UPDATE_PLATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(rsp);
        }
        catch (SDKException e) {
            log.error("batchChangePlateList error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromInputStream(InputStream in, CloseableHttpResponse result) {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        try {
            int rc;
            byte[] buffer = new byte[1024];
            while ((rc = in.read(buffer)) != -1) {
                swapStream.write(buffer, 0, rc);
            }
            byte[] data = swapStream.toByteArray();
            if ("application/json".equalsIgnoreCase(result.getHeader("Content-Type").getValue())) {
                String string = new String(data);
                return string;
            }
            String string = new BASE64Encoder().encode(data);
            return string;
        }
        catch (IOException | ProtocolException e) {
            log.error(" deal resources", e);
            String string = "";
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("resources close failed", (Throwable)e);
                }
            }
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

