/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserTokenRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.UserRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.DeviceManageIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.HttpRequestUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userManageIvs1800Service")
public class UserManageIvs1800ServiceImpl
extends AbstractIvs1800Service
implements UserManageService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManageIvs1800ServiceImpl.class);
    @Autowired
    private DeviceManageIvs1800ServiceImpl deviceConfigManageIvs1800Service;
    @Autowired
    WebSocketService webSocketService;
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;

    public boolean firstLogin(ParamBean<EmptyRequest> obj) {
        return false;
    }

    public String getModel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public LoginRespond login(ParamBean<LoginRequest> obj) {
        String cookie;
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        String ivs1800WebLoginUrl = String.format("https://%s:%s/loginInfo/login/v1.0", vcmReqBaseInfo.getVcmIp(), vcmReqBaseInfo.getVcmPort());
        LoginRequest loginRequest = (LoginRequest)obj.getRequestBody();
        JSONObject requestObject = JSON.parseObject((String)JSON.toJSONString((Object)loginRequest));
        requestObject.put("timeout", (Object)180);
        try {
            cookie = HttpRequestUtils.httpsSendLogin((String)ivs1800WebLoginUrl, (String)JsonUtil.convertBeanToJSON((Object)requestObject));
        }
        catch (InvokeException e) {
            if ("119101308".equals(e.getMessage())) {
                String cookie2 = e.getOriginalValue().toString();
                vcmReqBaseInfo.setVcmSession(cookie2);
                if (loginRequest.getIsFirstLogin() == 0) {
                    this.logout(vcmReqBaseInfo);
                }
            }
            throw e;
        }
        LoginRespond loginRespond = new LoginRespond();
        loginRespond.setVmSession(cookie);
        vcmReqBaseInfo.setVcmSession(cookie);
        DeviceInfoRespond respond = this.deviceConfigManageIvs1800Service.getDeviceInfo(vcmReqBaseInfo);
        UserInfoRequest request = new UserInfoRequest();
        request.setDomainCode("1");
        this.getUserInfo(vcmReqBaseInfo, request);
        loginRespond.setDeviceVersion(respond.getDeviceVersion());
        loginRespond.setModel(respond.getModel());
        loginRespond.setAiPower(respond.getAiPower());
        loginRespond.setMaxChannelNumber(respond.getMaxChannelNumber());
        loginRespond.setIntelliTask(respond.getIntelliTask());
        loginRespond.setTargetMaskTempPlatformAlarm(respond.getTargetMaskTempPlatformAlarm());
        loginRespond.setStandardRTSPForNat(respond.getStandardRTSPForNat());
        if (StringUtils.isNotBlank((CharSequence)respond.getDeviceModel())) {
            loginRespond.setDeviceModel(respond.getDeviceModel());
        }
        return loginRespond;
    }

    public boolean logout(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            BaseRespondIvs1800 baseRespondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LOGOUT_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class));
            this.checkRespond(baseRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("logout error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean keepAlive(ParamBean<EmptyRequest> obj) {
        try {
            return this.sendKeepAlive(obj);
        }
        catch (Exception e) {
            LOGGER.error("keep alive fail,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            CompletableFuture.runAsync(() -> {
                AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
                GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
                generalBusinessBean.setSnapshot("");
                generalBusinessBean.setPanorama("");
                alarmEventRespond.setType(EventTypeEnum.ALARM);
                alarmEventRespond.setTime(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
                alarmEventRespond.setDomainCode(obj.getVcmInfo().getDomainCode());
                alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
                alarmEventRespond.setStatus(1);
                alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
                alarmEventRespond.setCode("ALARM_DEVICE_OFFLINE");
                alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                alarmEventRespond.setId(UUID.randomUUID().toString());
                alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
                alarmEventRespond.setFilterName(alarmEventRespond.getCode());
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            });
            throw new InvokeException("500", e.getMessage());
        }
    }

    private boolean sendKeepAlive(ParamBean<EmptyRequest> obj) throws SDKException {
        BaseRespondIvs1800 baseRespondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.KEEPALIVE_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class));
        this.checkRespond(baseRespondIvs1800);
        return true;
    }

    public boolean firstChange(ParamBean<ChangePasswordRequest> obj) {
        LoginRespond loginRespond;
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setUserName(((ChangePasswordRequest)obj.getRequestBody()).getUserName());
        loginRequest.setPassword(((ChangePasswordRequest)obj.getRequestBody()).getOldPassword());
        loginRequest.setIsFirstLogin(Integer.valueOf(1));
        ParamBean loginRequestParamBean = new ParamBean();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        loginRequestParamBean.setRequestBody((Object)loginRequest);
        loginRequestParamBean.setVcmInfo(vcmReqBaseInfo);
        try {
            loginRespond = this.login(loginRequestParamBean);
        }
        catch (InvokeException e) {
            loginRespond = new LoginRespond();
            if (!"119101308".equals(e.getMessage())) {
                throw e;
            }
            loginRespond.setVmSession(e.getOriginalValue().toString());
        }
        try {
            vcmReqBaseInfo.setVcmSession(loginRespond.getVmSession());
            JSONObject dataObject = new JSONObject();
            dataObject.put("newPassword", (Object)((ChangePasswordRequest)obj.getRequestBody()).getNewPassword());
            dataObject.put("oldPassword", (Object)((ChangePasswordRequest)obj.getRequestBody()).getOldPassword());
            BaseRespondIvs1800 baseRespondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.USER_SET_PASSWORD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class));
            this.checkRespond(baseRespondIvs1800);
            boolean bl = true;
            return bl;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 change password error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        finally {
            try {
                this.logout(vcmReqBaseInfo);
            }
            catch (Exception e) {
                LOGGER.error("IVS 1800 first change password logout error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        }
    }

    public UserRespond getUserInfo(VcmReqBaseInfo vcmInfo, UserInfoRequest request) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/users/userinfo/" + request.getDomainCode()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            UserRespond userInfo = (UserRespond)JsonUtil.convertJsonToBean((String)rsp.getJSONObject("userInfo").toJSONString(), UserRespond.class).get();
            if (userInfo.getRoleId() == 3 || userInfo.getRoleId() == 6 || userInfo.getRoleId() == 7) {
                this.logout(vcmInfo);
                throw new InvokeException("500", "user_no_permission");
            }
            return userInfo;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getUserInformation error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public UserRespond getToken(ParamBean<UserTokenRequest> obj) {
        CloseableHttpResponse result;
        UserRespond respond = new UserRespond();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        String token = "";
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.USER_GET_TOKEN, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            respond.setToken(rsp.getString("token"));
            if (rsp.containsKey((Object)"portalInfo")) {
                respond.setIp(rsp.getJSONObject("portalInfo").getString("ip"));
                respond.setPort(rsp.getJSONObject("portalInfo").getString("port"));
            } else {
                respond.setPort("8443");
            }
            if (!StringUtils.equals((CharSequence)((UserTokenRequest)obj.getRequestBody()).getNeedCookie(), (CharSequence)"1")) {
                return respond;
            }
            vcmReqBaseInfo.setVcmPort(respond.getPort());
            ArrayList<VcmReqBaseInfo.Header> headers = new ArrayList<VcmReqBaseInfo.Header>();
            VcmReqBaseInfo.Header header = new VcmReqBaseInfo.Header();
            header.setKey("token");
            header.setValue(respond.getToken());
            headers.add(header);
            vcmReqBaseInfo.setHeaders(headers);
            JSONObject dataObject = new JSONObject();
            dataObject.put("token", (Object)rsp.getString("token"));
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.USER_TOKEN_LOGIN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), response -> (CloseableHttpResponse)response, (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get token error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        if (Objects.nonNull(result)) {
            try (InputStream inputStream = result.getEntity().getContent();){
                if (result.getCode() == 502) {
                    throw new InvokeException("500", (Object)"502", "cu_interface_502");
                }
                String ret = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                LOGGER.info("IVS1800 cookie data:{}", (Object)ret);
                BaseRespondIvs1800 baseRespondIvs1800 = (BaseRespondIvs1800)JsonUtil.convertJsonToBean((String)ret, BaseRespondIvs1800.class).orElseThrow(() -> new InvokeException("500", (Object)ret, "login_fail"));
                this.checkRespond(baseRespondIvs1800);
                for (Header header : result.getHeaders()) {
                    if (!"Set-Cookie".equalsIgnoreCase(header.getName()) || !StringUtils.isNotBlank((CharSequence)header.getValue())) continue;
                    token = token + header.getValue().split(";")[0] + ";";
                }
            }
            catch (IOException e) {
                LOGGER.error("IVS1800 token login get cookie IOException error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        }
        respond.setToken(token);
        return respond;
    }

    public UserRespond getTokenByPwd(ParamBean<UserTokenRequest> obj) {
        CloseableHttpResponse result;
        UserRespond respond = new UserRespond();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        String token = "";
        try {
            vcmReqBaseInfo.setVcmPort("8443");
            JSONObject dataObject = new JSONObject();
            dataObject.put("LoginName", (Object)((UserTokenRequest)obj.getRequestBody()).getUserName());
            dataObject.put("LoginPwd", (Object)((UserTokenRequest)obj.getRequestBody()).getPassWord());
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.USER_PWD_LOGIN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), response -> (CloseableHttpResponse)response, (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get token error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        if (Objects.nonNull(result)) {
            try (InputStream inputStream = result.getEntity().getContent();){
                if (result.getCode() == 502) {
                    throw new InvokeException("500", (Object)"502", "cu_interface_502");
                }
                String ret = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                LOGGER.info("IVS1800 cookie data:{}", (Object)ret);
                BaseRespondIvs1800 baseRespondIvs1800 = (BaseRespondIvs1800)JsonUtil.convertJsonToBean((String)ret, BaseRespondIvs1800.class).orElseThrow(() -> new InvokeException("500", (Object)ret, "login_fail"));
                this.checkWebRespond(JSON.parseObject((String)String.valueOf(ret)));
                for (Header header : result.getHeaders()) {
                    if (!"Set-Cookie".equalsIgnoreCase(header.getName()) || !StringUtils.isNotBlank((CharSequence)header.getValue())) continue;
                    token = header.getValue();
                }
            }
            catch (IOException e) {
                LOGGER.error("IVS1800 token login get cookie IOException error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        }
        respond.setToken(token);
        return respond;
    }

    public UserRespond getSDCWebToken(ParamBean<ChannelRequest> obj) {
        PenetrateRequest request = new PenetrateRequest();
        request.setRequestMethod("GET");
        request.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
        request.setRequestUrl(SdcMsgType.GET_WEB_TOKEN.getUri());
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        paramBean.setRequestBody((Object)request);
        JSONObject respond = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data");
        UserRespond userRespond = new UserRespond();
        userRespond.setToken(respond.getString("WebToken"));
        return userRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

