/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.thirdAlgorithm.InstallAlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.thirdAlgorithm.ThirdAlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.BaseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.Algorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.AlgorithmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.AlgorithmSpaceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.DeviceAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.InstallAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.InstallLicenseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.ThirdAlgorithmService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ThirdAlgorithmIvs1800ServiceImpl")
public class ThirdAlgorithmIvs1800ServiceImpl
extends AbstractIvs1800Service
implements ThirdAlgorithmService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAlgorithmIvs1800ServiceImpl.class);

    public PageRespond<DeviceAlgorithmRespond> getDeviceAlgorithm(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_GET_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new JSONObject(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)40);
            this.checkWebRespond(rsp);
            PageRespond respond = new PageRespond();
            JSONArray algorithmArray = rsp.getJSONObject("pluginList").getJSONArray("list");
            ArrayList<DeviceAlgorithmRespond> algorithmRespondList = new ArrayList<DeviceAlgorithmRespond>();
            if (!CollectionUtils.isEmpty((Collection)algorithmArray)) {
                for (int i = 0; i < algorithmArray.size(); ++i) {
                    JSONObject algorithmObject = algorithmArray.getJSONObject(i);
                    DeviceAlgorithmRespond algorithmRespond = new DeviceAlgorithmRespond();
                    algorithmRespond.setAlgorithmType(algorithmObject.getString("PluginTypes"));
                    algorithmRespond.setAlgorithmVersion(algorithmObject.getString("PluginVersion"));
                    algorithmRespond.setAlgorithmId(algorithmObject.getString("plugin_id"));
                    algorithmRespond.setAlgorithmTypeDesc(algorithmObject.getString("PluginTypesDesc"));
                    algorithmRespond.setAlgorithmName(algorithmObject.getString("pluginName"));
                    algorithmRespond.setSourceType(algorithmObject.getString("source_type"));
                    algorithmRespond.setStopStatus(algorithmObject.getString("isStop"));
                    algorithmRespond.setAlgorithmState(StringUtils.equals((CharSequence)algorithmObject.getString("install_status"), (CharSequence)"2"));
                    if (StringUtils.equals((CharSequence)algorithmRespond.getStopStatus(), (CharSequence)"0")) {
                        algorithmRespond.setAlgorithmState(false);
                    }
                    algorithmRespond.setGroupName(algorithmObject.getString("GroupName"));
                    algorithmRespondList.add(algorithmRespond);
                }
            }
            respond.setData(algorithmRespondList);
            respond.setTotal(algorithmRespondList.size());
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get device algorithm list error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public InstallAlgorithmRespond uploadDeviceAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, String fileName, String fileSize, String currentChunk, String totalChunk, String timestamp, File algorithmFile) {
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("file", (ContentBody)new FileBody(algorithmFile));
            builder.addTextBody("file_name", fileName);
            builder.addTextBody("blob_num", currentChunk);
            builder.addTextBody("total_blob_num", totalChunk);
            builder.addTextBody("file_size", fileSize);
            builder.addTextBody("type", "0");
            builder.addTextBody("timestamp", timestamp);
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestForm((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_UPLOAD_PACKAGE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo), (HttpEntity)builder.build(), (int)60);
            respond.setResultCode(rsp.getString("resultCode"));
            respond.setMsg(rsp.getString("msg"));
            if ("Relogin".equalsIgnoreCase(respond.getMsg())) {
                respond.setResultCode("session_expired");
            }
        }
        catch (SDKException e) {
            LOGGER.error("upload algorithm error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(Ivs1800Utils.reasonHelper((SDKException)e));
        }
        catch (InvokeException e) {
            if ("500".equals(e.getCode())) {
                respond.setResultCode(e.getMessage());
            }
            respond.setResultCode(e.getCode());
        }
        return respond;
    }

    public InstallAlgorithmRespond replaceDeviceAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, String fileName, String fileSize, String currentChunk, String totalChunk, String timestamp, String algorithmName, String algorithmStatus, File algorithmFile) {
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("file", (ContentBody)new FileBody(algorithmFile));
            builder.addTextBody("file_name", fileName);
            builder.addTextBody("blob_num", currentChunk);
            builder.addTextBody("total_blob_num", totalChunk);
            builder.addTextBody("file_size", fileSize);
            builder.addTextBody("type", "0");
            builder.addTextBody("timestamp", timestamp);
            builder.addTextBody("PluginName", algorithmName);
            builder.addTextBody("PluginStatus", algorithmStatus);
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestForm((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_REPLACE_PACKAGE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo), (HttpEntity)builder.build(), (int)60);
            respond.setResultCode(rsp.getString("resultCode"));
            respond.setMsg(rsp.getString("msg"));
            if ("Relogin".equalsIgnoreCase(respond.getMsg())) {
                respond.setResultCode("session_expired");
            }
        }
        catch (SDKException e) {
            LOGGER.error("replace algorithm error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(Ivs1800Utils.reasonHelper((SDKException)e));
        }
        catch (InvokeException e) {
            if ("500".equals(e.getCode())) {
                respond.setResultCode(e.getMessage());
            }
            respond.setResultCode(e.getCode());
        }
        return respond;
    }

    public InstallAlgorithmRespond installAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("PluginType", (Object)request.getAlgorithmType());
            dataObject.put("PluginName", (Object)request.getAlgorithmName());
            dataObject.put("sourceType", (Object)request.getSourceType());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_INSTALL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)30);
            this.checkJsonRespond(rsp);
            respond.setResultCode(rsp.getString("resultCode"));
            respond.setMsg(rsp.getString("msg"));
            respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
            respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        }
        catch (SDKException e) {
            LOGGER.error("install algorithm error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public Boolean uninstallAlgorithm(VcmReqBaseInfo vcmInfo, ThirdAlgorithmRequest request) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("PluginType", (Object)request.getAlgorithmType());
        dataObject.put("PluginName", (Object)request.getAlgorithmName());
        dataObject.put("sourceType", (Object)request.getSourceType());
        dataObject.put("IsForce", (Object)request.getIsForce());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ALGORITHM_UNINSTALL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo), (int)30);
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("uninstall algorithm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean operateAlgorithm(VcmReqBaseInfo vcmInfo, ThirdAlgorithmRequest request) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("groupName", (Object)"others");
        dataObject.put("appName", (Object)request.getAlgorithmName());
        dataObject.put("operation", (Object)(request.getAlgorithmStatus() != false ? 0 : 1));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ALGORITHM_OPERATE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 operate algorithm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public InstallLicenseRespond uploadDeviceLicense(VcmReqBaseInfo vcmReqBaseInfo, String fileName, String fileSize, String algorithmName, File licenseFile) {
        InstallLicenseRespond respond = new InstallLicenseRespond();
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        try {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addPart("file", (ContentBody)new FileBody(licenseFile));
            builder.addTextBody("PluginName", algorithmName);
            builder.addTextBody("IsFriendly", "Y");
            builder.addTextBody("timestamp", String.valueOf(System.currentTimeMillis()));
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestForm((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LICENSE_UPLOAD_PACKAGE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmReqBaseInfo), (HttpEntity)builder.build());
            respond.setResultCode(rsp.getString("resultCode"));
            respond.setMsg(rsp.getString("msg"));
            if ("Relogin".equalsIgnoreCase(respond.getMsg())) {
                respond.setResultCode("session_expired");
            }
        }
        catch (SDKException e) {
            LOGGER.error("upload algorithm error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(Ivs1800Utils.reasonHelper((SDKException)e));
        }
        catch (InvokeException e) {
            if ("500".equals(e.getCode())) {
                respond.setResultCode(e.getMessage());
            }
            respond.setResultCode(e.getCode());
        }
        return respond;
    }

    public BaseRespond getUploadResult(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        BaseRespond respond = new BaseRespond();
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("fileName", (Object)request.getAlgorithmName());
            dataObject.put("timestamp", (Object)System.currentTimeMillis());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_UPLOAD_RESULT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)30);
            if (Objects.nonNull(rsp)) {
                respond.setResultCode(rsp.getString("resultCode"));
            } else {
                respond.setResultCode("cu_device_not_return");
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS1800 get upload result,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(e.getErrorCode());
        }
        return respond;
    }

    public Boolean deleteDeviceAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("PluginType", request.getAlgorithmType());
        httpUrlParam.addParam("PluginName", request.getAlgorithmName());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_DELETE_PACKAGE, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (int)30);
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 delete algorithm package error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        catch (InvokeException e) {
            LOGGER.error("IVS 1800 delete algorithm package error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public InstallAlgorithmRespond uploadSdcAlgorithmPackage(VcmReqBaseInfo vcmReqBaseInfo, InstallAlgorithmRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InstallAlgorithmRespond installSdcAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, InstallAlgorithmRequest request) {
        JSONObject data = new JSONObject();
        data.put("deviceCode", (Object)request.getCameraCode());
        data.put("fileID", (Object)request.getFileId());
        data.put("maxCPU", (Object)0);
        data.put("maxMem", (Object)0);
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_INSTALL_ALGORITHM, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.nonNull(result)) {
                respond.setResultCode(result.getString("resultCode"));
            } else {
                respond.setResultCode("cu_device_not_return");
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 install sdc algorithm error", (Throwable)e);
            respond.setResultCode(e.getErrorCode());
        }
        return respond;
    }

    public InstallAlgorithmRespond operateSdcAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, InstallAlgorithmRequest request) {
        JSONObject data = new JSONObject();
        data.put("actionType", (Object)Integer.parseInt(request.getActionType()));
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        Ivs1800MsgType msgType = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PUT, String.format("/device/thirdalgorithm/%s/app/%s", request.getCameraCode(), request.getAlgorithmName()));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)30);
            if (Objects.nonNull(rsp)) {
                respond.setResultCode(rsp.getString("resultCode"));
            } else {
                respond.setResultCode("cu_device_not_return");
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 operate algorithm error, ip:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(e.getErrorCode());
        }
        return respond;
    }

    public InstallAlgorithmRespond clearSpace(VcmReqBaseInfo vcmReqBaseInfo, InstallAlgorithmRequest request) {
        InstallAlgorithmRespond respond = new InstallAlgorithmRespond();
        String url = "/device/thirdalgorithm-space/" + request.getCameraCode();
        Ivs1800MsgType msgType = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, url);
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)msgType, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.nonNull(result)) {
                respond.setResultCode(result.getString("resultCode"));
            } else {
                respond.setResultCode("cu_device_not_return");
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 install sdc algorithm error", (Throwable)e);
            respond.setResultCode(e.getErrorCode());
        }
        return respond;
    }

    public AlgorithmConfigRespond getAlgorithmLang(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        JSONObject data = new JSONObject();
        data.put("groupName", (Object)"others");
        data.put("appName", (Object)request.getAlgorithmName());
        data.put("language", (Object)request.getLanguage());
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_ALGORITHM_LANG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            AlgorithmConfigRespond respond = new AlgorithmConfigRespond();
            respond.setDesc(result.getString("desc"));
            for (int i = 0; i < result.getJSONArray("appParam").size(); ++i) {
                JSONObject param = result.getJSONArray("appParam").getJSONObject(i);
                AlgorithmConfigRespond.AppParam appParam = new AlgorithmConfigRespond.AppParam();
                appParam.setKey(param.getString("key"));
                appParam.setValue(param.getString("value"));
                respond.getAppParams().add(appParam);
            }
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get algorithm config error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public AlgorithmConfigRespond getThirdWebInfo(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.THIRD_WEB_INFO_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(result);
            ArrayList<AlgorithmConfigRespond.AppWebInfo> appWebInfos = new ArrayList<AlgorithmConfigRespond.AppWebInfo>();
            if (result.containsKey((Object)"appWebInfoList")) {
                for (int i = 0; i < result.getJSONArray("appWebInfoList").size(); ++i) {
                    JSONObject appWebInfo = result.getJSONArray("appWebInfoList").getJSONObject(i);
                    AlgorithmConfigRespond.AppWebInfo webInfo = new AlgorithmConfigRespond.AppWebInfo();
                    webInfo.setAppName(appWebInfo.getString("appName").replaceAll("\r", ""));
                    webInfo.setDesc(appWebInfo.getString("desc").replaceAll("\r", ""));
                    webInfo.setFullUrl(appWebInfo.getString("fullUri").replaceAll("\r", ""));
                    webInfo.setIndexHtmlPath(appWebInfo.getString("indexHtmlPath").replaceAll("\r", ""));
                    appWebInfos.add(webInfo);
                }
            }
            AlgorithmConfigRespond respond = new AlgorithmConfigRespond();
            respond.setAppWebInfoList(appWebInfos);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get Third Web Info error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public AlgorithmSpaceRespond getAlgorithmSpace(VcmReqBaseInfo vcmReqBaseInfo) {
        AlgorithmSpaceRespond respond = new AlgorithmSpaceRespond();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_GET_SPACE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            respond.setResultCode(rsp.getString("resultCode"));
            respond.setTotalSize(rsp.getInteger("totalSize"));
            respond.setAvailableSize(rsp.getInteger("availableSize"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get algorithm space error", (Throwable)e);
            respond.setResultCode(Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public BaseRespond clearAlgorithmSpace(VcmReqBaseInfo vcmReqBaseInfo) {
        BaseRespond respond = new BaseRespond();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALGORITHM_CLEAR_SPACE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            respond.setResultCode(rsp.getString("resultCode"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get algorithm space error", (Throwable)e);
            respond.setResultCode(Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public AlgorithmRespond syncAlgorithmName(VcmReqBaseInfo vcmReqBaseInfo, AlgorithmRequest request) {
        AlgorithmRespond respond = new AlgorithmRespond();
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(request.getCameraCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET /SDCAPI/V1.0/AlarmPaas/AppResourceFile?Language=" + ("zh_CN".equals(request.getLanguage()) ? "ZH" : "EN"));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            JSONObject ret = JSONArray.parseArray((String)respondIvs1800.getResultInfo()).getJSONObject(0).getJSONObject("Data");
            ArrayList<Algorithm> algorithmList = new ArrayList<Algorithm>();
            for (Map.Entry entry : ret.entrySet()) {
                JSONObject algorithmObject;
                if ("utilIaas".equals(entry.getKey()) || "itgtSaas".equals(entry.getKey()) || !(algorithmObject = (JSONObject)entry.getValue()).containsKey(entry.getKey())) continue;
                Algorithm algorithm = new Algorithm();
                algorithm.setName(algorithmObject.getString((String)entry.getKey()));
                algorithm.setCode((String)entry.getKey());
                algorithmList.add(algorithm);
            }
            respond.setAlgorithms(algorithmList);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 sync camera algorithm name error, IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

