/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.taskManagement.TaskManagementRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligentAnalysis.AlgorithmRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.Algorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmAblility;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.taskManagement.ActionAnalysisInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.taskManagement.TaskManagementSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.TaskManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="taskManagement1800ServiceImpl")
public class TaskManagement1800ServiceImpl
extends AbstractIvs1800Service
implements TaskManagementService<IServerType.IVS1800> {
    private static final Logger log = LoggerFactory.getLogger(TaskManagement1800ServiceImpl.class);

    public TaskManagementSearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            JSONObject item = taskManagementRequest.getCondition();
            if (Objects.isNull(item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.QUERY_INTELLIGENT_ANALYSIS_TASK_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)item, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
            searchRespond.getTask_list().stream().forEach(taskList -> {
                if (taskList.getVideoType() == 0 && taskList.getActionAnalysis().getRepeatTimeList().size() == 0) {
                    ActionAnalysisInfo.RepeatTimeListInfo repeatTimeListInfo = new ActionAnalysisInfo.RepeatTimeListInfo();
                    ActionAnalysisInfo.RepeatTimeListInfo.RepeatTimeInfo repeatTimeInfo = new ActionAnalysisInfo.RepeatTimeListInfo.RepeatTimeInfo();
                    repeatTimeInfo.setStartTimestamp("00:00");
                    repeatTimeInfo.setEndTimestamp("24:00");
                    repeatTimeListInfo.setRepeatTime(repeatTimeInfo);
                    taskList.getActionAnalysis().getRepeatTimeList().add(repeatTimeListInfo);
                }
            });
        }
        catch (SDKException e) {
            log.error("TaskManagement search error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond add(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            JSONObject item = taskManagementRequest.getCondition();
            if (Objects.isNull(item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ADD_INTELLIGENT_ANALYSIS_TASK_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)item, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement add error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond batchAddition(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond = new TaskManagementSearchRespond();
        JSONObject item = taskManagementRequest.getCondition();
        if (Objects.isNull(item)) {
            throw new InvokeException("500", "param_error");
        }
        JSONArray tasks = item.getJSONArray("tasks");
        if (tasks.size() > 10) {
            List partition = ListUtils.partition((List)tasks, (int)10);
            for (int i = 0; i < partition.size(); ++i) {
                item.put("tasks", partition.get(i));
                TaskManagementSearchRespond searchTask = this.additionTask(vcmReqBaseInfo, item);
                if (i == 0) {
                    searchRespond = searchTask;
                    continue;
                }
                searchRespond.getTasks().addAll(searchTask.getTasks());
            }
        } else {
            searchRespond = this.additionTask(vcmReqBaseInfo, item);
        }
        return searchRespond;
    }

    private TaskManagementSearchRespond additionTask(VcmReqBaseInfo vcmReqBaseInfo, JSONObject item) {
        TaskManagementSearchRespond searchRespond;
        try {
            if (Objects.isNull(item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.BATCH_ADD_INTELLIGENT_ANALYSIS_TASK_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)item, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)20);
            if (null == rsp) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement batchAddition error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond delete(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            String item = taskManagementRequest.getTaskId();
            if (StringUtils.isBlank((CharSequence)item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/sdk_service/rest/video-analysis/delete_intelligent_analysis?taskId=" + item + ""), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement delete error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond stop(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            String item = taskManagementRequest.getTaskId();
            if (StringUtils.isBlank((CharSequence)item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/sdk_service/rest/video-analysis/stop_intelligent_by_taskid?taskid=" + item + ""), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement stop error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond restart(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            String item = taskManagementRequest.getTaskId();
            if (StringUtils.isBlank((CharSequence)item)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/sdk_service/rest/video-analysis/restart_intelligent_analysis?taskId=" + item + ""), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement restart error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public TaskManagementSearchRespond update(VcmReqBaseInfo vcmReqBaseInfo, TaskManagementRequest taskManagementRequest) {
        TaskManagementSearchRespond searchRespond;
        try {
            if (Objects.isNull(taskManagementRequest)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.UPDATE_INTELLIGENT_ANALYSIS_TASK_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)taskManagementRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), TaskManagementSearchRespond.class);
            this.checkJsonRespond(rsp);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (TaskManagementSearchRespond)operateBean.get();
        }
        catch (SDKException e) {
            log.error("TaskManagement restart update", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlgorithmRespond loadAlgorithm(VcmReqBaseInfo vcmInfo, AlgorithmRequest request) {
        AlgorithmRespond respond = new AlgorithmRespond();
        ArrayList<Algorithm> algorithmList = new ArrayList<Algorithm>();
        AlgorithmRequestIvs1800 requestIvs1800 = new AlgorithmRequestIvs1800();
        requestIvs1800.setType(request.getType());
        requestIvs1800.setLanguage(request.getLanguage());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_LOAD_ALGORITHM, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray algorithmArray = rsp.getJSONArray("algorithms");
            if (!CollectionUtils.isEmpty((Collection)algorithmArray)) {
                for (int i = 0; i < algorithmArray.size(); ++i) {
                    Algorithm algorithm = new Algorithm();
                    JSONObject algorithmObject = algorithmArray.getJSONObject(i);
                    algorithm.setCode(algorithmObject.getString("code"));
                    algorithm.setName(algorithmObject.getString("name"));
                    algorithm.setType(algorithmObject.getString("type"));
                    algorithm.setInstallDate(algorithmObject.getString("installDate"));
                    algorithm.setStatus(algorithmObject.getString("status"));
                    algorithm.setInitParam(algorithmObject.getString("initParam"));
                    algorithm.setChlParam(algorithmObject.getString("chlParam"));
                    algorithm.setSupplier(algorithmObject.getString("supplier"));
                    algorithm.setVersion(algorithmObject.getString("version"));
                    algorithm.setCpu(algorithmObject.getInteger("cpu"));
                    algorithm.setMem(algorithmObject.getInteger("mem"));
                    algorithm.setDisk(algorithmObject.getInteger("disk"));
                    algorithm.setModeType(algorithmObject.getString("modeType"));
                    algorithm.setDockerState(algorithmObject.getInteger("dockerState"));
                    algorithm.setMgrEnabled(algorithmObject.getInteger("mgrEnabled"));
                    JSONObject capabilities = algorithmObject.getJSONObject("capabilities");
                    if (ObjectUtils.isNotEmpty((Object)capabilities)) {
                        Optional optional = JsonUtil.convertJsonToBean((String)capabilities.toJSONString(), AlgorithmAblility.class);
                        algorithm.setCapabilities((AlgorithmAblility)optional.get());
                    }
                    algorithmList.add(algorithm);
                }
            }
            respond.setPower(this.getDeviceInfo(vcmInfo).getJSONObject("configItem").getJSONObject("deviceBaseInfo").getString("AIPower"));
        }
        catch (SDKException e) {
            log.error("IVS 1800 load algorithm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        respond.setAlgorithms(algorithmList);
        respond.setSize(algorithmList.size());
        return respond;
    }

    public JSONObject getDeviceInfo(VcmReqBaseInfo vcmInfo) {
        JSONObject rsp;
        JSONObject dataObject = new JSONObject();
        dataObject.put("configType", (Object)2);
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            log.error("IVS 1800 get device error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

