/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.SystemConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.TimeConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.TimeConfigGetRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.TimeConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.ConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.nvr800.SystemConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SystemConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="systemConfigIvs1800Service")
public class SystemConfig1800ServiceImpl
extends AbstractIvs1800Service
implements SystemConfigService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfig1800ServiceImpl.class);

    public boolean setTimeConfig(ParamBean<TimeConfigRequest> obj) {
        return false;
    }

    public TimeConfigRespond getDateConfig(ParamBean<EmptyRequest> obj) {
        try {
            ConfigRespondIvs1800 respondIvs1800 = (ConfigRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new TimeConfigGetRequestIvs1800(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ConfigRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            JSONObject timeConfigJson = respondIvs1800.getConfigItem().getJSONObject("deviceTimeConfig");
            TimeConfigRespond respond = new TimeConfigRespond();
            respond.setEnableNTP(timeConfigJson.getInteger("enableNTP") == 1);
            if (respond.isEnableNTP()) {
                respond.setNtpServer(timeConfigJson.getJSONObject("ntp").getJSONObject("ntpServerIP").getString("ip"));
            }
            int iZone = timeConfigJson.getIntValue("timezone");
            int h = iZone / 3600;
            int m = iZone % 3600 / 3600 * 60;
            StringBuilder sb = new StringBuilder("GMT");
            if (h > 0) {
                sb.append("+");
            }
            sb.append(Math.abs(h)).append(":");
            if (m < 10) {
                sb.append("0");
            }
            sb.append(m);
            respond.setTimezone(sb.toString());
            return respond;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setSystemConfig(ParamBean<SystemConfigRequest> obj) {
        return false;
    }

    public SystemConfigRespond getSystemConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

