/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.CcStatisticsRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.statistics.CcStatisticsRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.statistics.HeatMapStatisticsRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.service.StatisticsService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="statisticsIVS1800Service")
public class StatisticsIvs1800ServiceImpl
extends AbstractIvs1800Service
implements StatisticsService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsIvs1800ServiceImpl.class);
    @Autowired
    private SnapshotService<IServerType.IVS1800> ivs1800SnapshotService;

    public JSONObject getCc(VcmReqBaseInfo vcmInfo, CcStatisticsRequest ccStatisticsRequest) {
        CcStatisticsRequestIvs1800 ccStatisticsRequestIvs1800 = new CcStatisticsRequestIvs1800();
        ccStatisticsRequestIvs1800.setDate(this.getIvs1800Date(ccStatisticsRequest.getDate()));
        ccStatisticsRequestIvs1800.setReportPeriod(this.getIvs1800ReportPeriod(ccStatisticsRequest.getReportType()));
        ccStatisticsRequestIvs1800.setDirection(this.getIvs1800Direction(ccStatisticsRequest.getDetectType()));
        ccStatisticsRequestIvs1800.setDeviceCode(ccStatisticsRequest.getChannelCode());
        JSONObject retJson = new JSONObject();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.CC_STATISTICS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ccStatisticsRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(result);
            if (result.getJSONArray("records") != null) {
                retJson.put("Count", (Object)result.getJSONArray("records"));
                retJson.put("Result", (Object)result.getString("resultCode"));
                return retJson;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject getHeatMap(VcmReqBaseInfo vcmInfo, HeatMapRequest heatMapRequest) {
        HeatMapStatisticsRequestIvs1800 heatMapStatisticsRequestIvs1800 = new HeatMapStatisticsRequestIvs1800();
        heatMapStatisticsRequestIvs1800.setDate(this.getIvs1800Date(heatMapRequest.getDate()));
        heatMapStatisticsRequestIvs1800.setDeviceCode(heatMapRequest.getChannelCode());
        heatMapStatisticsRequestIvs1800.setReportType(Integer.valueOf(heatMapRequest.getGetSpaceMap() == 0 ? 1 : 0));
        heatMapStatisticsRequestIvs1800.setReportPeriod(this.getIvs1800ReportPeriod(heatMapRequest.getReportType()));
        JSONObject retJson = new JSONObject();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.HEAT_MAP_STATISTICS_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)heatMapStatisticsRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo), (int)20);
            this.checkJsonRespond(result);
            if ("0".equals(result.getString("resultCode"))) {
                if (heatMapStatisticsRequestIvs1800.getReportType() == 0 && StringUtils.isNotBlank((CharSequence)result.getString("image"))) {
                    SnapshotRequest snapshotRequest = new SnapshotRequest();
                    snapshotRequest.setChannelCode(heatMapRequest.getChannelCode());
                    SnapshotRespond snapshotRespond = this.ivs1800SnapshotService.createSnapshot(vcmInfo, snapshotRequest);
                    retJson.put("backgroundImage", (Object)snapshotRespond.getImgBase64Str());
                    retJson.put("HeatMapWidth", (Object)result.getString("heatMapWidth"));
                    retJson.put("heatMapHeight", (Object)result.getString("heatMapHeight"));
                    retJson.put("Image", (Object)result.getString("image"));
                }
                retJson.put("TimeHeatMap", (Object)result.getJSONArray("records"));
                retJson.put("Result", (Object)result.getString("resultCode"));
                return retJson;
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private String getIvs1800Date(String oldDate) {
        Date parse = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            parse = sdf.parse(oldDate);
        }
        catch (ParseException e) {
            LOGGER.error("IVS 1800 statistics parse date error", (Throwable)e);
        }
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
        String newDate = sdf1.format(parse);
        return newDate;
    }

    private Integer getIvs1800ReportPeriod(String oldReportType) {
        Integer newReportPeriod = null;
        switch (oldReportType) {
            case "day": {
                newReportPeriod = 0;
                break;
            }
            case "week": {
                newReportPeriod = 1;
                break;
            }
            case "month": {
                newReportPeriod = 2;
                break;
            }
            case "year": {
                newReportPeriod = 3;
                break;
            }
        }
        return newReportPeriod;
    }

    private Integer getIvs1800Direction(String oldDetectType) {
        Integer newDetectType = null;
        switch (oldDetectType) {
            case "enter": {
                newDetectType = 0;
                break;
            }
            case "exit": {
                newDetectType = 1;
                break;
            }
        }
        return newDetectType;
    }
}

