/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.SnapshotRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotIvs1800Service")
public class SnapshotIvs1800ServiceImpl
implements SnapshotService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotIvs1800ServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmInfo, SnapshotRequest req) {
        String content;
        CloseableHttpResponse result;
        SnapshotRequestIvs1800 snapshotRequestIvs1800 = this.requestToIvs1800(req);
        try {
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.SNAPSHOT_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)snapshotRequestIvs1800, false), response -> (CloseableHttpResponse)response);
        }
        catch (SDKException e) {
            LOGGER.error("IVS1800 createSnapshot error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        try (InputStream inputStream = result.getEntity().getContent();){
            content = FileUtil.getContentFromInputStream((InputStream)inputStream, (CloseableHttpResponse)result);
        }
        catch (IOException e) {
            LOGGER.error("stream failed", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        if (content.contains("resultCode")) {
            Optional baseRespondIvs1800 = JsonUtil.convertJsonToBean((String)content, BaseRespondIvs1800.class);
            if (baseRespondIvs1800.isPresent()) {
                throw new InvokeException("500", (Object)content, String.valueOf(((BaseRespondIvs1800)baseRespondIvs1800.get()).getResultCode()));
            }
            throw new InvokeException("500", (Object)content, "unknown_error");
        }
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        snapshotRespond.setImgBase64Str(content);
        return snapshotRespond;
    }

    private SnapshotRequestIvs1800 requestToIvs1800(SnapshotRequest req) {
        SnapshotRequestIvs1800 snapshotRequestIvs1800 = new SnapshotRequestIvs1800();
        snapshotRequestIvs1800.setCameraCode(req.getChannelCode());
        return snapshotRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

