/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.smartdatasubscribes.SmartDataSubscribesRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.smartdatasubscribes.SmartDataSubscribesAddOrUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.smartdatasubscribes.SmartDataSubscribesDeleteRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.smartdatasubscribes.SmartDataSubscribesRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmLinkInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AreaBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.DetectObjectBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.FaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.LineBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.MetaEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.NonVehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.PersonBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.PointBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.VehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.smartdatasubscribes.SubscribesBaseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.smartdatasubscribes.SubscribesRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.MetaTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDataSubscribesService;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EventNameHelper;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ReflectionUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="smartDataSubscribesServiceIvs1800Impl")
public class SmartDataSubscribesServiceIvs1800Impl
implements SmartDataSubscribesService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartDataSubscribesServiceIvs1800Impl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;

    public SubscribesBaseRespond addOrUpdateAll(ParamBean<SubscriptionRequest> obj, List<String> alarmCode) {
        String callBackUrl = "https://%s:%s/rest/ics/v1/zk/subscribes/push/%s";
        SubscriptionRequest request = (SubscriptionRequest)obj.getRequestBody();
        SmartDataSubscribesRequest metaRequest = new SmartDataSubscribesRequest();
        metaRequest.setSubscribeId(request.getSubscribeId());
        metaRequest.setSubscribeDetail("0");
        String ipByParentDeviceId = ConfigHolder.getIpByParentDeviceId((String)obj.getVcmInfo().getParentDeviceId());
        String ip = StringUtils.isEmpty((CharSequence)ipByParentDeviceId) ? ConfigHolder.getIp() : ipByParentDeviceId.split("_")[0];
        metaRequest.setReceiveAddr(String.format(callBackUrl, ip, ConfigHolder.getPort(), ((SubscriptionRequest)obj.getRequestBody()).getDomainCode()));
        if (!CollectionUtils.isEmpty(alarmCode)) {
            String resourceURI = StringUtils.join(alarmCode, (String)",");
            metaRequest.setResourceURI(resourceURI);
        } else {
            metaRequest.setResourceURI("");
        }
        return this.addOrUpdate(obj.getVcmInfo(), metaRequest);
    }

    public SubscribesBaseRespond addOrUpdate(VcmReqBaseInfo vcmReqBaseInfo, SmartDataSubscribesRequest subscribes) {
        SubscribesBaseRespond subscribesBaseRespond = new SubscribesBaseRespond();
        subscribesBaseRespond.setVcmInfo(vcmReqBaseInfo);
        try {
            SmartDataSubscribesRequestIvs1800 smartDataSubscribesRequestIvs1800 = this.subScribesConverter(subscribes);
            SmartDataSubscribesAddOrUpdateRequest req = new SmartDataSubscribesAddOrUpdateRequest();
            req.getSubscribeListObject().getSubscribeObject().add(smartDataSubscribesRequestIvs1800);
            SubscribesRespondIvs1800 rsp = (SubscribesRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.UPDATE_SMART_DATA_SUBSCRIBES_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, SubscribesRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (!"0".equals(rsp.getResultCode())) {
                LOGGER.warn(vcmReqBaseInfo.getVcmIp() + " subscribe1 error,code=" + rsp.getResultCode());
                throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)rsp), rsp.getResultCode());
            }
            if (!"0".equals(String.valueOf(((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult()))) {
                LOGGER.warn(vcmReqBaseInfo.getVcmIp() + " subscribe2 error,code=" + ((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult());
                throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)rsp), Ivs1800Utils.get((int)((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult()));
            }
            subscribesBaseRespond.setSuccess(true);
            subscribesBaseRespond.setSubscribeId(((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getSubscribeId());
        }
        catch (SDKException e) {
            LOGGER.error("addOrUpdate happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return subscribesBaseRespond;
    }

    public SubscribesBaseRespond delete(VcmReqBaseInfo vcmReqBaseInfo, SmartDataSubscribesRequest subscribes) {
        SubscribesBaseRespond subscribesBaseRespond = new SubscribesBaseRespond();
        subscribesBaseRespond.setVcmInfo(vcmReqBaseInfo);
        try {
            SmartDataSubscribesDeleteRequest req = new SmartDataSubscribesDeleteRequest();
            SmartDataSubscribesDeleteRequest.SubscribeInfo subscribeInfo = new SmartDataSubscribesDeleteRequest.SubscribeInfo();
            subscribeInfo.setSubscribeId(subscribes.getSubscribeId());
            req.getSubscribeIdList().add(subscribeInfo);
            SubscribesRespondIvs1800 rsp = (SubscribesRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DELETE_SMART_DATA_SUBSCRIBES_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, SubscribesRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (rsp.getResultInfoList().size() > 0 && !"0".equals(String.valueOf(((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult()))) {
                throw new InvokeException("500", ((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult(), Ivs1800Utils.get((int)((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getResult()));
            }
            if (!rsp.getResultCode().equals("0")) {
                throw new InvokeException("500", (Object)JsonUtil.convertBeanToJSON((Object)rsp), rsp.getResultCode());
            }
            subscribesBaseRespond.setSuccess(true);
            subscribesBaseRespond.setSubscribeId(((SubscribesRespondIvs1800.ResultInfo)rsp.getResultInfoList().get(0)).getSubscribeId());
            return subscribesBaseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("searchFaceRepository happen exception ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public void push(JSONObject data, String domainCode) {
        VcmReqBaseInfo vcmReqBaseInfo;
        if (ConfigHolder.isDebugLog()) {
            LOGGER.info("receive message: {}", (Object)data.toJSONString());
        }
        if ((vcmReqBaseInfo = this.subscriptionHelp.get(domainCode)) == null) {
            LOGGER.info("Ignore IVS1800 push subscribe data, domainCode:{} ", (Object)domainCode);
            return;
        }
        if (data.getJSONObject("SubscribeNotificationListObject") != null) {
            JSONObject notificationObject = data.getJSONObject("SubscribeNotificationListObject").getJSONArray("SubscribeNotificationObject").getJSONObject(0);
            String dataType = notificationObject.getString("InfoIDs");
            if ("Face".equals(dataType)) {
                this.pushFace(notificationObject, EventTypeEnum.META_DATA, domainCode, vcmReqBaseInfo);
            } else if ("Person".equals(dataType)) {
                this.pushPerson(notificationObject, EventTypeEnum.META_DATA, domainCode, vcmReqBaseInfo);
            } else if ("MotorVehicle".equals(dataType)) {
                this.pushVehicle(notificationObject, EventTypeEnum.META_DATA, domainCode, vcmReqBaseInfo);
            } else if ("NonMotorVehicle".equals(dataType)) {
                this.pushNonMotorVehicle(notificationObject, EventTypeEnum.META_DATA, domainCode, vcmReqBaseInfo);
            }
        } else if (data.getJSONObject("DispositionNotificationListObject") != null) {
            JSONObject notificationObject = data.getJSONObject("DispositionNotificationListObject").getJSONArray("DispositionNotificationObject").getJSONObject(0);
            int alarmRuleType = notificationObject.getIntValue("AlarmRuleType");
            if (16 == alarmRuleType) {
                this.pushFace(notificationObject, EventTypeEnum.ALARM, domainCode, vcmReqBaseInfo);
            } else if (17 == alarmRuleType) {
                this.pushVehicle(notificationObject, EventTypeEnum.ALARM, domainCode, vcmReqBaseInfo);
            } else if (99 == alarmRuleType) {
                this.pushBehavior(notificationObject, domainCode, vcmReqBaseInfo);
            } else if (notificationObject.getJSONObject("ThirdAlgorithmResultObject") != null) {
                this.pushThirdAlarm(notificationObject, domainCode, vcmReqBaseInfo);
            }
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public SmartDataSubscribesRequestIvs1800 subScribesConverter(SmartDataSubscribesRequest subscribes) {
        SmartDataSubscribesRequestIvs1800 requestIvs1800 = new SmartDataSubscribesRequestIvs1800();
        requestIvs1800.setSubscribeId(subscribes.getSubscribeId());
        requestIvs1800.setSubscribeDetail(subscribes.getSubscribeDetail());
        requestIvs1800.setResourceURI(subscribes.getResourceURI());
        requestIvs1800.setReceiveAddr(subscribes.getReceiveAddr());
        requestIvs1800.setCodeType("1");
        requestIvs1800.setResultImgType(3);
        requestIvs1800.setResultFeatureDeclare(1);
        return requestIvs1800;
    }

    public void pushFace(JSONObject notificationObject, EventTypeEnum type, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject faceInfo = EventTypeEnum.META_DATA.equals((Object)type) ? notificationObject.getJSONObject("FaceObjectList").getJSONArray("FaceObject").getJSONObject(0) : notificationObject.getJSONObject("FaceObject");
        FaceBean faceBean = new FaceBean();
        faceBean.setGenderCode(faceInfo.getString("GenderCode"));
        faceBean.setLeftTopX(faceInfo.getInteger("LeftTopX").intValue());
        faceBean.setLeftTopY(faceInfo.getInteger("LeftTopY").intValue());
        faceBean.setRightBtmX(faceInfo.getInteger("RightBtmX").intValue());
        faceBean.setRightBtmY(faceInfo.getInteger("RightBtmY").intValue());
        ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
        DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)faceBean);
        faceDetectObject.add(detectObject);
        faceBean.setDetectObject(faceDetectObject);
        if (faceInfo.containsKey((Object)"SubImageList")) {
            JSONArray imageArray = faceInfo.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject");
            if (imageArray.size() > 0) {
                faceBean.setSnapshot(imageArray.getJSONObject(0).getString("Data"));
            }
            if (imageArray.size() > 1) {
                faceBean.setPanorama(imageArray.getJSONObject(1).getString("Data"));
            }
        }
        faceBean.setHair(Objects.nonNull(faceInfo.getString("HairStyle")) ? faceInfo.getString("HairStyle") : "0");
        faceBean.setHat(Objects.nonNull(faceInfo.getString("CapStyle")) ? faceInfo.getString("CapStyle") : "0");
        faceBean.setGlassType(this.getGlassInfo(faceInfo.getInteger("HWEyeGlass").intValue()));
        faceBean.setMouthMask(StringUtils.isNotBlank((CharSequence)faceInfo.getString("HWMouthmask")) ? faceInfo.getString("HWMouthmask") : "0");
        faceBean.setMustache(Objects.nonNull(faceInfo.getString("MustacheStyle")) ? faceInfo.getString("MustacheStyle") : "0");
        faceBean.setExpression(StringUtils.isNotBlank((CharSequence)faceInfo.getString("HWExpression")) ? faceInfo.getString("HWExpression") : "0");
        faceBean.setAgeGroup(faceInfo.getInteger("HWAgeSeg").intValue());
        faceBean.setAge(faceInfo.getInteger("HWAgeSeg").intValue());
        faceBean.setAlarmMatch(notificationObject.getIntValue("AlarmMatch"));
        if (faceInfo.containsKey((Object)"HWMouthmaskStandard")) {
            faceBean.setMouthMaskStandard(faceInfo.getInteger("HWMouthmaskStandard"));
        }
        String shotTime = faceInfo.getString("ShotTime");
        if (EventTypeEnum.META_DATA.equals((Object)type)) {
            MetaEventRespond metaEventRespond = this.metaCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            metaEventRespond.setMetaType(MetaTypeEnum.FACE);
            metaEventRespond.setChannelCode(faceInfo.getString("DeviceID"));
            metaEventRespond.setFaceBean(faceBean);
            if (StringUtils.isNotBlank((CharSequence)shotTime)) {
                metaEventRespond.setTime(shotTime);
            }
            this.webSocketService.send((BaseEventRespond)metaEventRespond);
        } else {
            String[] alarmDetailReasons;
            String groupId = notificationObject.getString("GroupID");
            String peopleId = notificationObject.getString("TargetID");
            AlarmEventRespond alarmEventRespond = this.alarmCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            alarmEventRespond.setMetaType(MetaTypeEnum.FACE);
            alarmEventRespond.setChannelCode(faceInfo.getString("DeviceID"));
            if (StringUtils.isNotBlank((CharSequence)shotTime)) {
                alarmEventRespond.setTime(shotTime);
            }
            if (faceBean.getAlarmMatch() == 1 && StringUtils.isNotBlank((CharSequence)groupId) && StringUtils.isNotBlank((CharSequence)peopleId)) {
                People target = this.smartDaraHelpService.getTargetInfo(domainCode, groupId, peopleId);
                FaceRepositoryIvs1800 targetGroupInfo = this.smartDaraHelpService.getTargetGroupInfo(domainCode, groupId);
                faceBean.setTargetId(target.getId());
                faceBean.setTargetName(target.getName());
                faceBean.setTargetCredentialNumber(target.getCredentialNumber());
                faceBean.setMatchedImage(this.smartDaraHelpService.getTargetMatchedImage(vcmReqBaseInfo, Long.valueOf(notificationObject.getString("FileID"))));
                faceBean.setGroupName(targetGroupInfo.getName());
                faceBean.setGroupType(targetGroupInfo.getType());
            }
            faceBean.setSimilarityDegree(faceInfo.getDouble("Similaritydegree") * 100.0);
            for (String alarmDetailReason : alarmDetailReasons = notificationObject.getString("AlarmDetailReason").split(",")) {
                alarmEventRespond.setCode(Ivs1800Utils.getEventCode((String)alarmDetailReason));
                alarmEventRespond.setName(EventNameHelper.getEventName((String)alarmEventRespond.getCode()));
                alarmEventRespond.setFilterName(alarmEventRespond.getCode());
                alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
                if ("Face_Temp".equals(alarmEventRespond.getCode())) {
                    GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
                    generalBusinessBean.setPanorama(faceBean.getPanorama());
                    generalBusinessBean.setSnapshot(faceBean.getSnapshot());
                    ArrayList<DetectObjectBean> detectObjectBeanList = new ArrayList<DetectObjectBean>();
                    DetectObjectBean detectObjectBean = new DetectObjectBean();
                    detectObjectBean.setLeft(Integer.valueOf(faceBean.getRightBtmX()));
                    detectObjectBean.setRight(Integer.valueOf(faceBean.getRightBtmY()));
                    detectObjectBean.setTop(Integer.valueOf(faceBean.getLeftTopX()));
                    detectObjectBean.setBottom(Integer.valueOf(faceBean.getLeftTopY()));
                    detectObjectBeanList.add(detectObjectBean);
                    generalBusinessBean.setTemperatureValue(faceInfo.containsKey((Object)"Temperature") ? String.valueOf(faceInfo.getDoubleValue("Temperature")) : "");
                    generalBusinessBean.setTemperatureUnit("1");
                    generalBusinessBean.setDetectObject(detectObjectBeanList);
                    alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
                    alarmEventRespond.setFaceBean(null);
                } else {
                    alarmEventRespond.setFaceBean(faceBean);
                    alarmEventRespond.setGeneralBusinessBean(null);
                }
                this.webSocketService.send((BaseEventRespond)alarmEventRespond);
            }
        }
    }

    private String getGlassInfo(int glassType) {
        if (glassType == -1) {
            return "-1";
        }
        if (glassType == 0) {
            return "0";
        }
        if (glassType == 1) {
            return "1";
        }
        if (glassType == 2) {
            return "2";
        }
        return String.valueOf(0);
    }

    public void pushPerson(JSONObject notificationObject, EventTypeEnum type, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject bodyInfo = notificationObject.getJSONObject("PersonObjectList").getJSONArray("PersonObject").getJSONObject(0);
        PersonBean personBean = new PersonBean();
        personBean.setGenderCode(bodyInfo.getString("GenderCode"));
        personBean.setAgeGroup(bodyInfo.containsKey((Object)"HWAge") ? bodyInfo.getInteger("HWAge") : 0);
        personBean.setHairStyle(bodyInfo.containsKey((Object)"HairStyle") ? bodyInfo.getInteger("HairStyle") : 0);
        personBean.setHat(bodyInfo.containsKey((Object)"HWHat") ? bodyInfo.getInteger("HWHat") : 0);
        personBean.setMouthmask(bodyInfo.containsKey((Object)"HWMouthMask") ? bodyInfo.getInteger("HWMouthMask") : 0);
        personBean.setShape(bodyInfo.containsKey((Object)"HWBodyType") ? bodyInfo.getInteger("HWBodyType") : 0);
        personBean.setUmbrella(bodyInfo.containsKey((Object)"HWUmbrella") ? bodyInfo.getInteger("HWUmbrella") : 0);
        personBean.setBackpack(bodyInfo.containsKey((Object)"HWBackPack") ? bodyInfo.getInteger("HWBackPack") : 0);
        personBean.setHandbag(bodyInfo.containsKey((Object)"HWHandBag") ? bodyInfo.getInteger("HWHandBag") : 0);
        personBean.setMessengerBag(bodyInfo.containsKey((Object)"HWMessengerBag") ? bodyInfo.getInteger("HWMessengerBag") : 0);
        personBean.setView(bodyInfo.containsKey((Object)"HWView") ? bodyInfo.getInteger("HWView") : 0);
        personBean.setUpperStyle(bodyInfo.containsKey((Object)"HWUpperStyle") ? bodyInfo.getInteger("HWUpperStyle") : 0);
        personBean.setUpperColor(bodyInfo.containsKey((Object)"HWUpperColor") ? bodyInfo.getInteger("HWUpperColor") : 0);
        personBean.setUpperTexture(bodyInfo.containsKey((Object)"HWUpperTexture") ? bodyInfo.getInteger("HWUpperTexture") : 0);
        personBean.setHelmet(bodyInfo.containsKey((Object)"HWHelmet") ? bodyInfo.getInteger("HWHelmet") : 0);
        personBean.setHelmetColor(bodyInfo.containsKey((Object)"HWHelmetColor") ? bodyInfo.getInteger("HWHelmetColor") : 0);
        personBean.setLowerStyle(bodyInfo.containsKey((Object)"HWLowerStyle") ? bodyInfo.getInteger("HWLowerStyle") : 0);
        personBean.setLowerColor(bodyInfo.containsKey((Object)"HWLowerColor") ? bodyInfo.getInteger("HWLowerColor") : 0);
        personBean.setLeftTopX(bodyInfo.getInteger("LeftTopX").intValue());
        personBean.setLeftTopY(bodyInfo.getInteger("LeftTopY").intValue());
        personBean.setRightBtmX(bodyInfo.getInteger("RightBtmX").intValue());
        personBean.setRightBtmY(bodyInfo.getInteger("RightBtmY").intValue());
        JSONArray imageArray = bodyInfo.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject");
        if (imageArray.size() > 0) {
            personBean.setSnapshot(imageArray.getJSONObject(0).getString("Data"));
        }
        if (imageArray.size() > 1) {
            personBean.setPanorama(imageArray.getJSONObject(1).getString("Data"));
        }
        String appearTime = bodyInfo.getString("PersonAppearTime");
        if (EventTypeEnum.META_DATA.equals((Object)type)) {
            MetaEventRespond metaEventRespond = this.metaCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            metaEventRespond.setMetaType(MetaTypeEnum.PERSON);
            metaEventRespond.setChannelCode(bodyInfo.getString("DeviceID"));
            metaEventRespond.setPersonBean(personBean);
            if (StringUtils.isNotBlank((CharSequence)appearTime)) {
                metaEventRespond.setTime(appearTime);
            }
            this.webSocketService.send((BaseEventRespond)metaEventRespond);
        }
    }

    public void pushNonMotorVehicle(JSONObject notificationObject, EventTypeEnum type, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject vehicleInfo = EventTypeEnum.META_DATA.equals((Object)type) ? notificationObject.getJSONObject("NonMotorVehicleObjectList").getJSONArray("NonMotorVehicleObject").getJSONObject(0) : notificationObject.getJSONObject("NonMotorVehicleObject");
        NonVehicleBean nonVehicleBean = new NonVehicleBean();
        nonVehicleBean.setLeftTopX(vehicleInfo.getInteger("LeftTopX").intValue());
        nonVehicleBean.setLeftTopY(vehicleInfo.getInteger("LeftTopY").intValue());
        nonVehicleBean.setRightBtmX(vehicleInfo.getInteger("RightBtmX").intValue());
        nonVehicleBean.setRightBtmY(vehicleInfo.getInteger("RightBtmY").intValue());
        nonVehicleBean.setHelmet(vehicleInfo.containsKey((Object)"HWHelmet") ? vehicleInfo.getInteger("HWHelmet") : 0);
        nonVehicleBean.setHelmetColor(vehicleInfo.containsKey((Object)"HWHelmetColor") ? vehicleInfo.getInteger("HWHelmetColor") : 0);
        nonVehicleBean.setBicycleTricycle(vehicleInfo.containsKey((Object)"HWBicycleTricycle") ? vehicleInfo.getInteger("HWBicycleTricycle") : 0);
        nonVehicleBean.setBicycleHeadLightShape(vehicleInfo.containsKey((Object)"HWHeadLightShape") ? vehicleInfo.getInteger("HWHeadLightShape") : 0);
        nonVehicleBean.setSubBicycleTricycle(vehicleInfo.containsKey((Object)"HWSubBicycleTricycle") ? vehicleInfo.getInteger("HWSubBicycleTricycle") : 0);
        nonVehicleBean.setSunShade(vehicleInfo.containsKey((Object)"HWSunShade") ? vehicleInfo.getInteger("HWSunShade") : 0);
        nonVehicleBean.setSunShadeColor(vehicleInfo.containsKey((Object)"HWSunShadeColor") ? vehicleInfo.getInteger("HWSunShadeColor") : 0);
        nonVehicleBean.setOverload(vehicleInfo.containsKey((Object)"HWOverload") ? vehicleInfo.getInteger("HWOverload") : 0);
        nonVehicleBean.setCarryGoods(vehicleInfo.containsKey((Object)"HWCarryGoods") ? vehicleInfo.getInteger("HWCarryGoods") : 0);
        nonVehicleBean.setRiderManNum(vehicleInfo.containsKey((Object)"HWRiderManNum") ? vehicleInfo.getInteger("HWRiderManNum") : 0);
        nonVehicleBean.setHasPlate(vehicleInfo.getString("HasPlate"));
        nonVehicleBean.setPlateNo(vehicleInfo.getString("PlateNo"));
        nonVehicleBean.setPlateClass(vehicleInfo.getString("PlateClass"));
        nonVehicleBean.setPlateColor(vehicleInfo.getString("PlateColor"));
        nonVehicleBean.setVehicleBrand(vehicleInfo.getString("VehicleBrand"));
        nonVehicleBean.setVehicleClass(vehicleInfo.getString("VehicleClass"));
        nonVehicleBean.setVehicleColor(vehicleInfo.getString("VehicleColor"));
        nonVehicleBean.setVehicleModel(vehicleInfo.getString("VehicleModel"));
        nonVehicleBean.setVehicleStyles(vehicleInfo.getString("VehicleStyles"));
        JSONArray imageArray = vehicleInfo.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject");
        if (!CollectionUtils.isEmpty((Collection)imageArray)) {
            for (int i = 0; i < imageArray.size(); ++i) {
                JSONObject jsonObject = imageArray.getJSONObject(i);
                if ("12".equals(jsonObject.getString("Type"))) {
                    nonVehicleBean.setSnapshot(jsonObject.getString("Data"));
                }
                if (!"14".equals(jsonObject.getString("Type"))) continue;
                nonVehicleBean.setPanorama(jsonObject.getString("Data"));
            }
        }
        String appearTime = vehicleInfo.getString("AppearTime");
        if (EventTypeEnum.META_DATA.equals((Object)type)) {
            MetaEventRespond metaEventRespond = this.metaCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            metaEventRespond.setMetaType(MetaTypeEnum.NON_MOTOR_VEHICLE);
            metaEventRespond.setChannelCode(vehicleInfo.getString("DeviceID"));
            metaEventRespond.setNonVehicleBean(nonVehicleBean);
            if (StringUtils.isNotBlank((CharSequence)appearTime)) {
                metaEventRespond.setTime(appearTime);
            }
            this.webSocketService.send((BaseEventRespond)metaEventRespond);
        }
    }

    public void pushVehicle(JSONObject notificationObject, EventTypeEnum type, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject vehicleInfo = EventTypeEnum.META_DATA.equals((Object)type) ? notificationObject.getJSONObject("MotorVehicleObjectList").getJSONArray("MotorVehicleObject").getJSONObject(0) : notificationObject.getJSONObject("MotorVehicleObject");
        VehicleBean vehicleBean = new VehicleBean();
        vehicleBean.setLeftTopX(vehicleInfo.getInteger("LeftTopX").intValue());
        vehicleBean.setLeftTopY(vehicleInfo.getInteger("LeftTopY").intValue());
        vehicleBean.setRightBtmX(vehicleInfo.getInteger("RightBtmX").intValue());
        vehicleBean.setRightBtmY(vehicleInfo.getInteger("RightBtmY").intValue());
        ArrayList<DetectObjectBean> vehicleDetectObject = new ArrayList<DetectObjectBean>();
        DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)vehicleBean);
        vehicleDetectObject.add(detectObject);
        vehicleBean.setDetectObject(vehicleDetectObject);
        vehicleBean.setHasPlate(vehicleInfo.getString("HasPlate"));
        vehicleBean.setPlateNo(vehicleInfo.getString("PlateNo"));
        vehicleBean.setPlateClass(vehicleInfo.containsKey((Object)"HWPlateType") ? vehicleInfo.getString("HWPlateType") : "0");
        vehicleBean.setPlateColor(vehicleInfo.containsKey((Object)"HWPlateColor") ? vehicleInfo.getString("HWPlateColor") : "9");
        vehicleBean.setVehicleBrand(vehicleInfo.containsKey((Object)"HWBrand") ? vehicleInfo.getString("HWBrand") : "228");
        vehicleBean.setVehicleModel(vehicleInfo.containsKey((Object)"HWSubBrand") ? vehicleInfo.getString("HWSubBrand") : "2043");
        vehicleBean.setVehicleClass(vehicleInfo.containsKey((Object)"HWVehicleType") ? vehicleInfo.getString("HWVehicleType") : "0");
        vehicleBean.setVehicleColor(vehicleInfo.containsKey((Object)"HWVehicleColor") ? vehicleInfo.getString("HWVehicleColor") : "9");
        vehicleBean.setVehicleStyles(vehicleInfo.containsKey((Object)"HWBrandYear") ? vehicleInfo.getString("HWBrandYear") : "");
        vehicleBean.setDrivingDirection(vehicleInfo.containsKey((Object)"HWDirection") ? vehicleInfo.getString("HWDirection") : "0");
        JSONArray imageArray = vehicleInfo.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject");
        if (!CollectionUtils.isEmpty((Collection)imageArray)) {
            for (int i = 0; i < imageArray.size(); ++i) {
                JSONObject jsonObject = imageArray.getJSONObject(i);
                if ("09".equals(jsonObject.getString("Type"))) {
                    vehicleBean.setSnapshot(jsonObject.getString("Data"));
                }
                if (!"01".equals(jsonObject.getString("Type"))) continue;
                vehicleBean.setPanorama(jsonObject.getString("Data"));
            }
        }
        String passTime = vehicleInfo.getString("PassTime");
        if (EventTypeEnum.META_DATA.equals((Object)type)) {
            MetaEventRespond metaEventRespond = this.metaCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            metaEventRespond.setMetaType(MetaTypeEnum.MOTOR_VEHICLE);
            metaEventRespond.setChannelCode(vehicleInfo.getString("DeviceID"));
            metaEventRespond.setVehicleBean(vehicleBean);
            if (StringUtils.isNotBlank((CharSequence)passTime)) {
                metaEventRespond.setTime(passTime);
            }
            this.webSocketService.send((BaseEventRespond)metaEventRespond);
        } else {
            String plate;
            AlarmEventRespond alarmEventRespond = this.alarmCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
            alarmEventRespond.setMetaType(MetaTypeEnum.MOTOR_VEHICLE);
            alarmEventRespond.setChannelCode(vehicleInfo.getString("DeviceID"));
            vehicleBean.setAlarmMatch(notificationObject.getIntValue("AlarmMatch"));
            vehicleBean.setTargetId(notificationObject.getString("TargetID"));
            vehicleBean.setGroupId(notificationObject.getString("GroupID"));
            if (vehicleBean.getAlarmMatch() == 1 && StringUtils.isNotEmpty((CharSequence)vehicleBean.getTargetId()) && StringUtils.isNotEmpty((CharSequence)vehicleBean.getGroupId()) && StringUtils.isNotEmpty((CharSequence)(plate = this.getVehicleFileIdByTargetIdAndGroupId(vcmReqBaseInfo, vehicleBean.getTargetId(), vehicleBean.getGroupId())))) {
                JSONObject plateObject = JSONObject.parseObject((String)plate);
                vehicleBean.setGroupName(plateObject.getJSONObject("group").getString("groupname"));
                vehicleBean.setBlackPlateNo(plateObject.getString("lpn"));
                JSONArray photoArray = plateObject.getJSONArray("pictures");
                if (Objects.nonNull(photoArray) && photoArray.size() > 0) {
                    String fileId = photoArray.getJSONObject(0).getString("fileId");
                    String file = this.smartDaraHelpService.getTargetMatchedImage(this.subscriptionHelp.get(domainCode), Long.valueOf(fileId));
                    vehicleBean.setMatchedImage(file);
                }
            }
            alarmEventRespond.setVehicleBean(vehicleBean);
            if (StringUtils.isNotBlank((CharSequence)passTime)) {
                alarmEventRespond.setTime(passTime);
            }
            this.webSocketService.send((BaseEventRespond)alarmEventRespond);
        }
    }

    private String getVehicleFileIdByTargetIdAndGroupId(VcmReqBaseInfo vcmReqBaseInfo, String targetId, String groupId) {
        try {
            JSONObject data = new JSONObject();
            JSONObject condition = new JSONObject();
            condition.put("page", (Object)1);
            condition.put("limit", (Object)100);
            data.put("condition", (Object)condition);
            JSONObject plateObject = new JSONObject();
            plateObject.put("plateId", (Object)targetId);
            plateObject.put("groupid", (Object)groupId);
            data.put("plate", (Object)plateObject);
            JSONObject resultObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_SEARCH_PLATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (resultObject.getIntValue("resultCode") != 0) {
                LOGGER.error("search vehicle file id error, reason:{}", (Object)resultObject.getString("resultCode"));
                return "";
            }
            JSONArray plateList = resultObject.getJSONArray("plateList");
            if (CollectionUtils.isEmpty((Collection)plateList)) {
                return "";
            }
            return plateList.getJSONObject(0).toJSONString();
        }
        catch (SDKException e) {
            LOGGER.error("get vehicle error", (Throwable)e);
            return "";
        }
    }

    public void pushBehavior(JSONObject notificationObject, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONArray imageArray;
        JSONObject behaviorInfo = notificationObject.getJSONObject("BehaviorAnalysisObject");
        BehaviorBean behaviorBean = new BehaviorBean();
        if (behaviorInfo.containsKey((Object)"SubImageList") && Objects.nonNull(imageArray = behaviorInfo.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject"))) {
            if (imageArray.size() > 0) {
                behaviorBean.setPanorama(imageArray.getJSONObject(0).getString("Data"));
            }
            if (imageArray.size() > 1) {
                behaviorBean.setSnapshot(imageArray.getJSONObject(1).getString("Data"));
            }
            if (StringUtils.isEmpty((CharSequence)behaviorBean.getSnapshot())) {
                behaviorBean.setSnapshot(behaviorBean.getPanorama());
            }
        }
        ArrayList<DetectObjectBean> detectObjectBeanList = new ArrayList<DetectObjectBean>();
        if (behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").containsKey((Object)"detectObject") && behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("detectObject").getIntValue("posNum") > 0) {
            JSONArray detectObjectArray = behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("detectObject").getJSONArray("objPositionInfos");
            for (int i = 0; i < detectObjectArray.size(); ++i) {
                JSONObject detectObject = detectObjectArray.getJSONArray(i).getJSONObject(0);
                DetectObjectBean detectObjectBean = (DetectObjectBean)JSONObject.parseObject((String)detectObject.toJSONString(), DetectObjectBean.class);
                detectObjectBeanList.add(detectObjectBean);
            }
        }
        behaviorBean.setDetectObject(detectObjectBeanList);
        AlarmEventRespond alarmEventRespond = this.alarmCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
        String occuredTime = behaviorInfo.getString("OccuredTime");
        if (StringUtils.isNotBlank((CharSequence)occuredTime)) {
            alarmEventRespond.setTime(occuredTime);
        }
        alarmEventRespond.setCode(this.getBehaviorCode(behaviorInfo.getInteger("RuleType")));
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        if ("ALARM_BEHAVIOR_ANALYSIS_TRIPWIRE".equals(alarmEventRespond.getCode())) {
            behaviorBean.setLineFlag(true);
            LineBean lineBean = new LineBean();
            if (behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("line").getIntValue("lineNum") > 0) {
                JSONObject lineInfo = behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("line").getJSONArray("lineInfos").getJSONObject(0);
                lineBean.setDirect(lineInfo.getIntValue("direct"));
                lineBean.setType(lineInfo.getIntValue("type"));
                PointBean startPoint = new PointBean();
                startPoint.setXValue(lineInfo.getJSONObject("startPoint").getIntValue("x"));
                startPoint.setYValue(lineInfo.getJSONObject("startPoint").getIntValue("y"));
                PointBean endPoint = new PointBean();
                endPoint.setXValue(lineInfo.getJSONObject("endPoint").getIntValue("x"));
                endPoint.setYValue(lineInfo.getJSONObject("endPoint").getIntValue("y"));
                lineBean.setStartPoint(startPoint);
                lineBean.setEndPoint(endPoint);
            }
            behaviorBean.setLineBean(lineBean);
        } else if (behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").containsKey((Object)"detArea")) {
            behaviorBean.setLineFlag(false);
            int count = behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("detArea").getIntValue("areaNum");
            if (count > 0) {
                JSONArray areaInfoArray = behaviorInfo.getJSONObject("metaData").getJSONObject("attributes").getJSONObject("detArea").getJSONArray("areaInfos");
                JSONObject areaInfo = areaInfoArray.get(0) instanceof JSONArray ? areaInfoArray.getJSONArray(0).getJSONObject(0) : areaInfoArray.getJSONObject(0);
                AreaBean areaBean = new AreaBean();
                areaBean.setDirect(areaInfo.getIntValue("direct"));
                areaBean.setType(areaInfo.getIntValue("type"));
                ArrayList<PointBean> pointBeans = new ArrayList<PointBean>();
                for (int i = 0; i < areaInfo.getJSONArray("points").size(); ++i) {
                    PointBean pointBean = new PointBean();
                    pointBean.setXValue(areaInfo.getJSONArray("points").getJSONObject(i).getIntValue("x"));
                    pointBean.setYValue(areaInfo.getJSONArray("points").getJSONObject(i).getIntValue("y"));
                    pointBeans.add(pointBean);
                }
                areaBean.setPointBeans(pointBeans);
                behaviorBean.setAreaBean(areaBean);
            }
        }
        alarmEventRespond.setMetaType(MetaTypeEnum.BEHAVIOR);
        alarmEventRespond.setChannelCode(behaviorInfo.getString("DeviceID"));
        alarmEventRespond.setBehaviorBean(behaviorBean);
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private String getBehaviorCode(Integer ruleType) {
        String code = "";
        switch (ruleType) {
            case 1: {
                code = "ALARM_BEHAVIOR_ANALYSIS_TRIPWIRE";
                break;
            }
            case 8: {
                code = "ALARM_BEHAVIOR_ANALYSIS_INVASION";
                break;
            }
            case 11: {
                code = "ALARM_BEHAVIOR_ANALYSIS_REMOVE";
                break;
            }
            case 12: {
                code = "ALARM_BEHAVIOR_ANALYSIS_LEGACY";
                break;
            }
            case 15: {
                code = "ALARM_BEHAVIOR_ANALYSIS_WANDER";
                break;
            }
            case 33: {
                code = "ALARM_BEHAVIOR_ANALYSIS_FASTMOVE";
                break;
            }
            case 35: {
                code = "ALARM_BEHAVIOR_ANALYSIS_ENTER";
                break;
            }
            case 36: {
                code = "ALARM_BEHAVIOR_ANALYSIS_EXIT";
                break;
            }
            case 37: {
                code = "ALARM_BEHAVIOR_ANALYSIS_FIRE";
                break;
            }
            case 38: {
                code = "ALARM_HUMAN_COUNT";
                break;
            }
            case 39: {
                code = "ALARM_QUEUE_DETECT";
                break;
            }
            case 40: {
                code = "ALARM_CROWD_DENSITY_DETECT";
                break;
            }
            case 41: {
                code = "ALARM_ELE_BICYCLE";
                break;
            }
            case 42: {
                code = "ALARM_BEHAVIOR_ANALYSIS_CARDET";
            }
        }
        return code;
    }

    public void pushThirdAlarm(JSONObject notificationObject, String domainCode, VcmReqBaseInfo vcmReqBaseInfo) {
        JSONArray imageArray;
        JSONObject thirdAlarmObject = notificationObject.getJSONObject("ThirdAlgorithmResultObject");
        ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
        ArrayList alarmInfos = new ArrayList();
        if (thirdAlarmObject.containsKey((Object)"SubImageList") && !CollectionUtils.isEmpty((Collection)thirdAlarmObject.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject")) && !CollectionUtils.isEmpty((Collection)(imageArray = thirdAlarmObject.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject")))) {
            for (int i = 0; i < imageArray.size(); ++i) {
                JSONArray picAttr;
                Iterator picAttrList;
                JSONObject jsonObject = imageArray.getJSONObject(i);
                if ("162".equals(jsonObject.getString("Type"))) {
                    thirdAlgorithmBean.setSnapshot(jsonObject.getString("Data"));
                }
                if ("161".equals(jsonObject.getString("Type"))) {
                    thirdAlgorithmBean.setPanorama(jsonObject.getString("Data"));
                }
                if (!ObjectUtils.isNotEmpty((Object)(picAttrList = jsonObject.getJSONObject("PicAttrList"))) || !CollectionUtils.isNotEmpty((Collection)(picAttr = picAttrList.getJSONArray("PicAttr")))) continue;
                List alarmInfoLsit = JSONObject.parseArray((String)picAttr.toJSONString(), JSONObject.class);
                alarmInfos.addAll(alarmInfoLsit.stream().filter(info -> ObjectUtils.isNotEmpty((Object)info.getInteger("needDisplay")) && info.getInteger("needDisplay") == 1).collect(Collectors.toList()));
            }
        }
        ArrayList detectObjectBeanList = new ArrayList();
        JSONObject ThirdAlgorithmObjectList = thirdAlarmObject.getJSONObject("ThirdAlgorithmObjectList");
        if (Objects.nonNull(ThirdAlgorithmObjectList) && CollectionUtils.isNotEmpty((Collection)ThirdAlgorithmObjectList.getJSONArray("ThirdAlgorithmObject"))) {
            JSONArray thirdAlgorithmObjects = ThirdAlgorithmObjectList.getJSONArray("ThirdAlgorithmObject");
            for (Object o : thirdAlgorithmObjects) {
                JSONObject thirdAlgorithmObject = (JSONObject)o;
                this.createThirdAlgorithmObject(thirdAlgorithmObject, detectObjectBeanList, alarmInfos);
            }
        } else {
            JSONObject thirdAlgorithmObject = thirdAlarmObject.getJSONObject("ThirdAlgorithmObject");
            this.createThirdAlgorithmObject(thirdAlgorithmObject, detectObjectBeanList, alarmInfos);
        }
        thirdAlgorithmBean.setAlarmInfos(JSONArray.parseArray((String)JSON.toJSONString(alarmInfos)));
        thirdAlgorithmBean.setDetectObject(detectObjectBeanList);
        thirdAlgorithmBean.setThirdAlgorithmName(thirdAlarmObject.getString("MetaName"));
        String recordTime = thirdAlarmObject.getString("RecordTime");
        notificationObject.put("AlarmDetailReason", (Object)"ALARM_THIRD_ALGORITHM");
        AlarmEventRespond alarmEventRespond = this.alarmCommon(notificationObject, domainCode, vcmReqBaseInfo.getParentDeviceId());
        alarmEventRespond.setMetaType(MetaTypeEnum.NONE);
        alarmEventRespond.setChannelCode(thirdAlarmObject.getString("DeviceID"));
        alarmEventRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
        alarmEventRespond.setCode(StringUtils.isEmpty((CharSequence)thirdAlarmObject.getString("ThirdAlarmType")) ? "ALARM_THIRD_ALGORITHM" : thirdAlarmObject.getString("ThirdAlarmType"));
        alarmEventRespond.setFilterName(thirdAlarmObject.getString("MetaName"));
        if (StringUtils.isNotBlank((CharSequence)recordTime)) {
            alarmEventRespond.setTime(recordTime);
        }
        this.webSocketService.send((BaseEventRespond)alarmEventRespond);
    }

    private void createThirdAlgorithmObject(JSONObject thirdAlgorithmObject, List<DetectObjectBean> detectObjectBeanList, List<JSONObject> alarmInfos) {
        JSONObject jsonObject;
        JSONArray objAttr;
        if (thirdAlgorithmObject.getJSONObject("ObjPos") != null) {
            JSONObject posObject = thirdAlgorithmObject.getJSONObject("ObjPos");
            DetectObjectBean detectObjectBean = new DetectObjectBean();
            detectObjectBean.setLeft(Integer.valueOf(posObject.getIntValue("X")));
            detectObjectBean.setRight(Integer.valueOf(detectObjectBean.getLeft() + posObject.getIntValue("Width")));
            detectObjectBean.setTop(Integer.valueOf(posObject.getIntValue("Y")));
            detectObjectBean.setBottom(Integer.valueOf(detectObjectBean.getTop() + posObject.getIntValue("Height")));
            detectObjectBeanList.add(detectObjectBean);
        }
        if (thirdAlgorithmObject.getJSONObject("ObjAttrList") != null && !CollectionUtils.isEmpty((Collection)(objAttr = (jsonObject = thirdAlgorithmObject.getJSONObject("ObjAttrList")).getJSONArray("ObjAttr")))) {
            List alarmInfoLsit = JSONObject.parseArray((String)objAttr.toJSONString(), JSONObject.class);
            alarmInfos.addAll(alarmInfoLsit.stream().filter(info -> ObjectUtils.isNotEmpty((Object)info.getInteger("needDisplay")) && info.getInteger("needDisplay") == 1).collect(Collectors.toList()));
        }
    }

    public MetaEventRespond metaCommon(JSONObject notificationObject, String domainCode, String parentDeviceId) {
        MetaEventRespond metaEventRespond = new MetaEventRespond();
        metaEventRespond.setType(EventTypeEnum.META_DATA);
        metaEventRespond.setTime(notificationObject.getString("TriggerTime"));
        metaEventRespond.setDomainCode(domainCode);
        metaEventRespond.setParentDeviceId(parentDeviceId);
        return metaEventRespond;
    }

    public AlarmEventRespond alarmCommon(JSONObject notificationObject, String domainCode, String parentDeviceId) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        alarmEventRespond.setType(EventTypeEnum.ALARM);
        alarmEventRespond.setTime(notificationObject.getString("TriggerTime"));
        alarmEventRespond.setDomainCode(domainCode);
        alarmEventRespond.setId("-1");
        alarmEventRespond.setParentDeviceId(parentDeviceId);
        alarmEventRespond.setNotificationId(!notificationObject.containsKey((Object)"NotificationIDEx") ? notificationObject.getString("NotificationID") : notificationObject.getString("NotificationIDEx"));
        int alarmLevel = notificationObject.getIntValue("AlarmLevel");
        if (1 == alarmLevel) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
        } else if (2 == alarmLevel) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
        } else if (3 == alarmLevel) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.NORMAL);
        } else {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.NOTICE);
        }
        if (notificationObject.containsKey((Object)"IsUserDefined") && notificationObject.getInteger("IsUserDefined") == 1) {
            alarmEventRespond.setAlarmLevelName(notificationObject.getString("AlarmLevelName"));
            alarmEventRespond.setAlarmLevelValue(notificationObject.getInteger("AlarmLevelValue"));
            alarmEventRespond.setAlarmLevelColor(notificationObject.getString("AlarmLevelColor"));
            alarmEventRespond.setAlarmLevelDesc(notificationObject.getString("AlarmLevelDesc"));
            alarmEventRespond.setIsUserDefined(Integer.valueOf(1));
        } else {
            alarmEventRespond.setIsUserDefined(Integer.valueOf(0));
        }
        alarmEventRespond.setCode(Ivs1800Utils.getEventCode((String)notificationObject.getString("AlarmDetailReason")));
        alarmEventRespond.setStatus(0);
        alarmEventRespond.setName(EventNameHelper.getEventName((String)Ivs1800Utils.getEventCode((String)notificationObject.getString("AlarmDetailReason"))));
        alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
        alarmEventRespond.setFilterName(alarmEventRespond.getCode());
        if (ObjectUtils.isNotEmpty((Object)notificationObject.getJSONObject("AlarmLinkageInfo"))) {
            JSONObject alarmLinkageInfoList = notificationObject.getJSONObject("AlarmLinkageInfo");
            JSONArray actionList = alarmLinkageInfoList.getJSONArray("actionList");
            ArrayList<AlarmLinkInfoRespond> alarmLinkInfos = new ArrayList<AlarmLinkInfoRespond>();
            for (int i = 0; i < actionList.size(); ++i) {
                JSONObject action = actionList.getJSONObject(i);
                AlarmLinkInfoRespond infoRespond = new AlarmLinkInfoRespond();
                infoRespond.setActionType(action.getInteger("actionType") + "");
                infoRespond.setActionBranch(action.getInteger("actionBranch") + "");
                ArrayList devList = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)action.getJSONArray("devList"))) {
                    action.getJSONArray("devList").forEach(dev -> {
                        JSONObject devs = (JSONObject)dev;
                        devList.add(devs.getString("devCode"));
                    });
                }
                infoRespond.setDevList(devList);
                infoRespond.setGlobalParam(action.getString("globalParam"));
                alarmLinkInfos.add(infoRespond);
            }
            alarmEventRespond.setAlarmLinkInfos(alarmLinkInfos);
        }
        return alarmEventRespond;
    }
}

