/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.RTSPPlayBackRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.RTSPRealPlayRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.RTSPVideoDownloadRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.video.RTSPVoiceRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RTSPPlayBackRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RTSPRealPlayRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RTSPVideoDownloadIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RTSPVoiceRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspIvs1800Service")
public class RTSPIvs1800ServiceImpl
extends AbstractIvs1800Service
implements RTSPService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPIvs1800ServiceImpl.class);

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        String mainUrl = null;
        String subUrl1 = null;
        String subUrl2 = null;
        if (request.getType() == 0 || request.getType() == 1) {
            RTSPRealPlayRequestIvs1800 requestMain = this.requestToIvs1800(request);
            requestMain.getMediaURLParam().put("streamType", (Object)1);
            mainUrl = this.onlyRealPlay(vcmInfo, requestMain);
        }
        if (request.getType() == 0 || request.getType() == 2) {
            RTSPRealPlayRequestIvs1800 requestSub1 = this.requestToIvs1800(request);
            requestSub1.getMediaURLParam().put("streamType", (Object)2);
            subUrl1 = this.onlyRealPlay(vcmInfo, requestSub1);
        }
        if (request.getType() == 0 || request.getType() == 3) {
            RTSPRealPlayRequestIvs1800 requestSub2 = this.requestToIvs1800(request);
            requestSub2.getMediaURLParam().put("streamType", (Object)3);
            subUrl2 = this.onlyRealPlay(vcmInfo, requestSub2);
        }
        return this.toRealPlayResult(mainUrl, subUrl1, subUrl2);
    }

    private String onlyRealPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequestIvs1800 request) {
        int retryCount = 0;
        while (true) {
            try {
                return this.sendRealPlay(vcmInfo, request);
            }
            catch (SDKException sdkException) {
                LOGGER.error("onlyRealPlay error", (Throwable)sdkException);
                if (++retryCount <= 2) continue;
                throw new InvokeException("500", sdkException.getMessage());
            }
            break;
        }
    }

    private String sendRealPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequestIvs1800 request) throws SDKException {
        RTSPRealPlayRespondIvs1800 rtspRealPlayRespondIvs1800 = (RTSPRealPlayRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.REAL_PLAY_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPRealPlayRespondIvs1800.class));
        this.checkRespond((BaseRespondIvs1800)rtspRealPlayRespondIvs1800);
        return rtspRealPlayRespondIvs1800.getRtspURL();
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        RTSPPlayBackRequestIvs1800 rtspPlayBackRequestIvs1800 = this.requestToIvs1800(request);
        try {
            RTSPPlayBackRespondIvs1800 rtspPlayBackRespondIvs1800 = (RTSPPlayBackRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.REAL_PLAY_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspPlayBackRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPPlayBackRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)rtspPlayBackRespondIvs1800);
            return this.toPlayBackResult(rtspPlayBackRespondIvs1800, request);
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return this.getVoice(vcmInfo, request.getChannelCode(), 5);
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return this.getVoice(vcmInfo, request.getChannelCode(), 6);
    }

    private RTSPVoiceRespond getVoice(VcmReqBaseInfo vcmInfo, String channelCode, int serviceType) {
        RTSPVoiceRequestIvs1800 rtspVoiceRequestIvs1800 = new RTSPVoiceRequestIvs1800(serviceType);
        rtspVoiceRequestIvs1800.setCameraCode(channelCode);
        try {
            RTSPVoiceRespondIvs1800 rtspVoiceRespondIvs1800 = (RTSPVoiceRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VOICE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspVoiceRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPVoiceRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)rtspVoiceRespondIvs1800);
            return this.toVoiceResult(rtspVoiceRespondIvs1800);
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        RTSPVideoDownloadRequestIvs1800 rtspVideoDownloadRequestIvs1800 = this.downloadRequestToIvs1800(request);
        try {
            RTSPVideoDownloadIvs1800 rtspVideoDownloadIvs1800 = (RTSPVideoDownloadIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.VIDEO_DOWNLOAD_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rtspVideoDownloadRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, RTSPVideoDownloadIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)rtspVideoDownloadIvs1800);
            return this.toDownloadResult(rtspVideoDownloadIvs1800);
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private RTSPRealPlayRequestIvs1800 requestToIvs1800(RTSPRealPlayRequest req) {
        RTSPRealPlayRequestIvs1800 rtspRealPlayRequestIvs1800 = new RTSPRealPlayRequestIvs1800();
        rtspRealPlayRequestIvs1800.setCameraCode(req.getChannelCode());
        rtspRealPlayRequestIvs1800.getMediaURLParam().put("serviceType", (Object)1);
        rtspRealPlayRequestIvs1800.getMediaURLParam().put("supportTLS", (Object)(req.isTls() ? 1 : 0));
        rtspRealPlayRequestIvs1800.getMediaURLParam().put("clientType", (Object)(StringUtils.isEmpty((CharSequence)req.getClientType()) ? 0 : Integer.parseInt(req.getClientType())));
        return rtspRealPlayRequestIvs1800;
    }

    private RTSPPlayBackRequestIvs1800 requestToIvs1800(RTSPPlayBackRequest request) {
        RTSPPlayBackRequestIvs1800 rtspPlayBackRequestIvs1800 = new RTSPPlayBackRequestIvs1800();
        rtspPlayBackRequestIvs1800.setCameraCode(request.getChannelCode());
        JSONObject timeSpan = new JSONObject();
        String startDate = request.getStartDate().replace("-", "").replace(":", "").replace(" ", "");
        String endDate = request.getEndDate().replace("-", "").replace(":", "").replace(" ", "");
        timeSpan.put("startTime", (Object)startDate);
        timeSpan.put("endTime", (Object)endDate);
        rtspPlayBackRequestIvs1800.getMediaURLParam().put("timeSpan", (Object)timeSpan);
        rtspPlayBackRequestIvs1800.getMediaURLParam().put("supportTLS", (Object)(request.isTls() ? 1 : 0));
        rtspPlayBackRequestIvs1800.getMediaURLParam().put("clientType", (Object)(StringUtils.isEmpty((CharSequence)request.getClientType()) ? 0 : Integer.parseInt(request.getClientType())));
        return rtspPlayBackRequestIvs1800;
    }

    private RTSPVideoDownloadRequestIvs1800 downloadRequestToIvs1800(RTSPVideoDownloadRequest request) {
        RTSPVideoDownloadRequestIvs1800 rtspVideoDownloadRequestIvs1800 = new RTSPVideoDownloadRequestIvs1800();
        rtspVideoDownloadRequestIvs1800.setCameraCode(request.getChannelCode());
        JSONObject timeSpan = new JSONObject();
        timeSpan.put("startTime", (Object)request.getStartTime());
        timeSpan.put("endTime", (Object)request.getEndTime());
        rtspVideoDownloadRequestIvs1800.getMediaURLParam().put("timeSpan", (Object)timeSpan);
        return rtspVideoDownloadRequestIvs1800;
    }

    private RTSPRealPlayRespond toRealPlayResult(String mainUrl1, String subUrl1, String subUrl2) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (StringUtils.isNotBlank((CharSequence)mainUrl1)) {
            JSONObject urlObj1 = new JSONObject();
            urlObj1.put("type", (Object)1);
            urlObj1.put("rtspUrl", (Object)mainUrl1);
            result.add(urlObj1);
        }
        if (StringUtils.isNotBlank((CharSequence)subUrl1)) {
            JSONObject urlObj2 = new JSONObject();
            urlObj2.put("type", (Object)2);
            urlObj2.put("rtspUrl", (Object)subUrl1);
            result.add(urlObj2);
        }
        if (StringUtils.isNotBlank((CharSequence)subUrl2)) {
            JSONObject urlObj3 = new JSONObject();
            urlObj3.put("type", (Object)3);
            urlObj3.put("rtspUrl", (Object)subUrl2);
            result.add(urlObj3);
        }
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        rtspRealPlayRespond.setRtspUrls(result);
        return rtspRealPlayRespond;
    }

    private RTSPPlayBackRespond toPlayBackResult(RTSPPlayBackRespondIvs1800 rtspPlayBackRespondIvs1800, RTSPPlayBackRequest request) {
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        String url = rtspPlayBackRespondIvs1800.getRtspURL();
        JSONObject urlObj = new JSONObject();
        urlObj.put("type", (Object)request.getType());
        urlObj.put("rtspUrl", (Object)url);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        result.add(urlObj);
        rtspPlayBackRespond.setRtspUrls(result);
        return rtspPlayBackRespond;
    }

    private RTSPVoiceRespond toVoiceResult(RTSPVoiceRespondIvs1800 rtspVoiceRespondIvs1800) {
        RTSPVoiceRespond rtspVoiceRespond = new RTSPVoiceRespond();
        String url = rtspVoiceRespondIvs1800.getRtspURL();
        rtspVoiceRespond.setRtspUrl(url);
        rtspVoiceRespond.setType(Integer.valueOf(1));
        return rtspVoiceRespond;
    }

    private RTSPVideoDownloadRespond toDownloadResult(RTSPVideoDownloadIvs1800 rtspVideoDownloadIvs1800) {
        RTSPVideoDownloadRespond rtspVideoDownloadRespond = new RTSPVideoDownloadRespond();
        String url = rtspVideoDownloadIvs1800.getRtspURL();
        JSONObject urlObj = new JSONObject();
        urlObj.put("type", (Object)1);
        urlObj.put("rtspUrl", (Object)url);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        result.add(urlObj);
        rtspVideoDownloadRespond.setRtspUrls(result);
        return rtspVideoDownloadRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

