/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PresetPositionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.PresetPositionRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PresetPositionRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.PresetPositionRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruisePoint;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PresetPositionService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CruiseIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="presetPositionIvs1800Service")
public class PresetPositionIvs1800ServiceImpl
extends AbstractIvs1800Service
implements PresetPositionService<IServerType.IVS1800> {
    @Autowired
    private CruiseIvs1800ServiceImpl cruiseIvs1800Service;
    private static final Logger LOGGER = LoggerFactory.getLogger(PresetPositionIvs1800ServiceImpl.class);

    public PresetPositionRespond add(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        String cruiseNo = req.getCruiseNo();
        if (StringUtils.isBlank((CharSequence)cruiseNo)) {
            CruiseRequest cruise = new CruiseRequest();
            cruise.setChannelCode(req.getChannelCode());
            cruise.setDomainCode(req.getDomainCode());
            cruise.setName("ZKtecoBiosecurityCurise");
            cruise.setCruiseType(Integer.valueOf(1));
            JSONObject cruiseObject = this.cruiseIvs1800Service.getCruiseNoByCondition(vcmInfo, cruise);
            cruiseNo = cruiseObject.getString("cruiseNo");
        }
        req.setCruiseNo(cruiseNo);
        PresetPositionRespond presetPositionRespond = StringUtils.isNotEmpty((CharSequence)cruiseNo) && this.poisitionExsited(req.getPresetIndex().intValue(), vcmInfo, req) ? this.onlyUpt(vcmInfo, req) : this.onlyAdd(vcmInfo, req);
        CruiseRequest cruiseRequest = this.cruiseRequestHelper(vcmInfo, req, presetPositionRespond, "add");
        if (StringUtils.isNotEmpty((CharSequence)req.getCruiseNo())) {
            this.cruiseIvs1800Service.upt(vcmInfo, cruiseRequest);
        } else {
            this.cruiseIvs1800Service.add(vcmInfo, cruiseRequest);
        }
        return presetPositionRespond;
    }

    private JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        CruiseRequest cruise = new CruiseRequest();
        cruise.setChannelCode(req.getChannelCode());
        cruise.setDomainCode(req.getDomainCode());
        cruise.setName("ZKtecoBiosecurityCurise");
        cruise.setCruiseType(Integer.valueOf(1));
        return this.cruiseIvs1800Service.getCruiseNoByCondition(vcmInfo, cruise);
    }

    private boolean poisitionExsited(int presetIndex, VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        List respondList = this.list(vcmInfo, req);
        for (PresetPositionRespond respond : respondList) {
            if (respond.getPresetIndex() != presetIndex) continue;
            return true;
        }
        return false;
    }

    public PresetPositionRespond del(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        JSONObject cruiseObject = this.getCruiseNo(vcmInfo, req);
        req.setCruiseNo(cruiseObject.getString("cruiseNo"));
        CruiseRequest cruiseRequest = this.cruiseRequestHelper(vcmInfo, req, null, "del");
        if (CollectionUtils.isEmpty((Collection)cruiseRequest.getCruisePoints())) {
            this.cruiseIvs1800Service.del(vcmInfo, cruiseRequest);
        } else {
            this.cruiseIvs1800Service.upt(vcmInfo, cruiseRequest);
        }
        return this.onlyDel(vcmInfo, req);
    }

    public PresetPositionRespond upt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        JSONObject cruiseObject = this.getCruiseNo(vcmInfo, req);
        req.setCruiseNo(cruiseObject.getString("cruiseNo"));
        PresetPositionRespond presetPositionRespond = this.onlyUpt(vcmInfo, req);
        CruiseRequest cruiseRequest = this.cruiseRequestHelper(vcmInfo, req, null, "upt");
        this.cruiseIvs1800Service.upt(vcmInfo, cruiseRequest);
        return presetPositionRespond;
    }

    public List<PresetPositionRespond> list(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        ArrayList<PresetPositionRespond> respondList = new ArrayList<PresetPositionRespond>();
        JSONObject cruiseObject = this.getCruiseNo(vcmInfo, req);
        String cruiseNo = cruiseObject.getString("cruiseNo");
        req.setCruiseNo(cruiseNo);
        if (StringUtils.isEmpty((CharSequence)cruiseNo)) {
            return respondList;
        }
        JSONArray pointListInCruise = this.getCruiseDetail(vcmInfo, req);
        for (int i = 0; i < pointListInCruise.size(); ++i) {
            JSONObject pointInCruise = pointListInCruise.getJSONObject(i);
            PresetPositionRespond respond = new PresetPositionRespond();
            respond.setPresetIndex(pointInCruise.getInteger("presetIndex").intValue());
            respond.setPointCruiseTime(pointInCruise.getInteger("dwellTime").intValue());
            respondList.add(respond);
        }
        return respondList;
    }

    private PresetPositionRespond onlyAdd(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = this.addRequestToIvs1800(req);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_ADD_PRESET_POSITION_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(presetPositionRespondIvs1800.getPresetIndex().intValue());
            presetPositionRespond.setPointCruiseTime(req.getPointCruiseTime().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 add preset position error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private PresetPositionRespond onlyDel(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        String urlTemplate = "/ptz/presetposition/%s/%s/%s/v1.0";
        String url = String.format(Locale.ENGLISH, urlTemplate, req.getChannelCode(), req.getDomainCode(), req.getPresetIndex());
        Ivs1800MsgType uri = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, url);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 del preset position error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private PresetPositionRespond onlyUpt(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        PresetPositionRespond presetPositionRespond = new PresetPositionRespond();
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = this.uptRequestToIvs1800(req);
        try {
            PresetPositionRespondIvs1800 presetPositionRespondIvs1800 = (PresetPositionRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_UPT_PRESET_POSITION_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)presetPositionRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PresetPositionRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)presetPositionRespondIvs1800);
            presetPositionRespond.setPresetIndex(req.getPresetIndex().intValue());
            presetPositionRespond.setPointCruiseTime(req.getPointCruiseTime().intValue());
            return presetPositionRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update preset position error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private PresetPositionRequestIvs1800 addRequestToIvs1800(PresetPositionRequest req) {
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = new PresetPositionRequestIvs1800();
        presetPositionRequestIvs1800.setFocusSwitch(req.getFocusSwitch());
        presetPositionRequestIvs1800.setPresetName(req.getPresetName());
        presetPositionRequestIvs1800.setCameraCode(req.getChannelCode() + "#" + req.getDomainCode());
        return presetPositionRequestIvs1800;
    }

    private PresetPositionRequestIvs1800 uptRequestToIvs1800(PresetPositionRequest req) {
        PresetPositionRequestIvs1800 presetPositionRequestIvs1800 = new PresetPositionRequestIvs1800();
        presetPositionRequestIvs1800.setCameraCode(req.getChannelCode() + "#" + req.getDomainCode());
        JSONObject ptzPresetInfo = new JSONObject();
        ptzPresetInfo.put("presetName", (Object)req.getPresetName());
        ptzPresetInfo.put("presetIndex", (Object)req.getPresetIndex());
        presetPositionRequestIvs1800.setPtzPresetInfo(ptzPresetInfo);
        return presetPositionRequestIvs1800;
    }

    private CruiseRequest cruiseRequestHelper(VcmReqBaseInfo vcmInfo, PresetPositionRequest req, PresetPositionRespond presetPositionRespond, String type) {
        List points;
        CruiseRequest cruiseRequest = new CruiseRequest();
        cruiseRequest.setCruiseNo(req.getCruiseNo());
        cruiseRequest.setChannelCode(req.getChannelCode());
        cruiseRequest.setDomainCode(req.getDomainCode());
        cruiseRequest.setName("ZKtecoBiosecurityCurise");
        cruiseRequest.setCruiseType(Integer.valueOf(1));
        switch (type) {
            case "add": {
                points = this.cruiseAddPointsHelper(vcmInfo, req, presetPositionRespond);
                break;
            }
            case "upt": {
                points = this.cruiseUptPointsHelper(vcmInfo, req);
                break;
            }
            case "del": {
                points = this.cruiseDelPointsHelper(vcmInfo, req);
                break;
            }
            default: {
                points = new ArrayList();
            }
        }
        cruiseRequest.setCruisePoints(points);
        return cruiseRequest;
    }

    private List<CruisePoint> cruiseAddPointsHelper(VcmReqBaseInfo vcmInfo, PresetPositionRequest req, PresetPositionRespond presetPositionRespond) {
        List cruisePointsList = StringUtils.isNotEmpty((CharSequence)req.getCruiseNo()) ? this.getCurrentCruisePoints(vcmInfo, req) : new ArrayList();
        CruisePoint cruisePoint = new CruisePoint();
        cruisePoint.setPresetIndex(Integer.valueOf(presetPositionRespond.getPresetIndex()));
        cruisePoint.setDwellTime(req.getPointCruiseTime());
        cruisePoint.setSpeed(Integer.valueOf(5));
        cruisePointsList.add(cruisePoint);
        return cruisePointsList;
    }

    private List<CruisePoint> cruiseUptPointsHelper(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        List cruisePointsList = this.getCurrentCruisePoints(vcmInfo, req);
        cruisePointsList.forEach(e -> {
            if (e.getPresetIndex().equals(req.getPresetIndex())) {
                e.setDwellTime(req.getPointCruiseTime());
            }
        });
        return cruisePointsList;
    }

    private List<CruisePoint> cruiseDelPointsHelper(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        List cruisePointsList = this.getCurrentCruisePoints(vcmInfo, req);
        ArrayList<CruisePoint> result = new ArrayList<CruisePoint>();
        cruisePointsList.forEach(e -> {
            if (!e.getPresetIndex().equals(req.getPresetIndex())) {
                result.add((CruisePoint)e);
            }
        });
        return result;
    }

    private List<CruisePoint> getCurrentCruisePoints(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        CruiseRequest cruiseRequest = new CruiseRequest();
        cruiseRequest.setCruiseNo(req.getCruiseNo());
        cruiseRequest.setChannelCode(req.getChannelCode());
        cruiseRequest.setDomainCode(req.getDomainCode());
        CruiseDetailRespond detail = this.cruiseIvs1800Service.detail(vcmInfo, cruiseRequest);
        JSONArray cruisePointsArray = detail.getCruiseInfo().getJSONArray("cruisePoints");
        String arrayStr = JSONObject.toJSONString((Object)cruisePointsArray);
        return JSONObject.parseArray((String)arrayStr, CruisePoint.class);
    }

    private JSONArray getCruiseDetail(VcmReqBaseInfo vcmInfo, PresetPositionRequest req) {
        CruiseRequest cruiseRequest = new CruiseRequest();
        cruiseRequest.setCruiseNo(req.getCruiseNo());
        cruiseRequest.setChannelCode(req.getChannelCode());
        cruiseRequest.setDomainCode(req.getDomainCode());
        CruiseDetailRespond detail = this.cruiseIvs1800Service.detail(vcmInfo, cruiseRequest);
        return detail.getCruiseInfo().getJSONArray("cruisePoints");
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

