/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.DataDictionaryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.FaceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.HumanSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.picturesearch.PerInfoSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.DataDictionaryRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.picturesearch.HumanSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PictureSearchService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PictureSearchIvs1800ServiceImpl
extends AbstractIvs1800Service
implements PictureSearchService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureSearchIvs1800ServiceImpl.class);

    public JSONObject getPerInfoByBase64(ParamBean<PerInfoSearchRequest> obj) {
        JSONObject request = this.buildPerInfoByBase64RquestBody((PerInfoSearchRequest)obj.getRequestBody());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.GET_PERS_BY_BASE64, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("getPerInfoByBase64 happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject buildPerInfoByBase64RquestBody(PerInfoSearchRequest requestBody) {
        JSONObject request = new JSONObject();
        request.put("groupids", (Object)requestBody.getGroupIds());
        request.put("algorithmCode", (Object)requestBody.getAlgorithmCode());
        request.put("similarityThreshold", (Object)requestBody.getSimilarityThreshold());
        request.put("base64", (Object)requestBody.getBase64());
        return request;
    }

    public HumanSearchRespond humanDynamicRetrieval(ParamBean<HumanSearchRequest> obj) {
        HumanSearchRespond ret;
        try {
            HumanSearchRequest object = (HumanSearchRequest)obj.getRequestBody();
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.HUMAN_DYNAMIC_DATABASE_RETRIEVAL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)object, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), HumanSearchRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            ret = (HumanSearchRespond)operateBean.get();
            if (!CollectionUtils.isEmpty((Collection)ret.getPeoplepass())) {
                ret.getPeoplepass().forEach(peoplePassInfo2 -> peoplePassInfo2.setDomainCode(obj.getVcmInfo().getDomainCode()));
            }
        }
        catch (SDKException e) {
            LOGGER.error("humanDynamicRetrieval happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return ret;
    }

    public JSONObject getFaceToFace(ParamBean<FaceSearchRequest> obj) {
        JSONObject rsp;
        try {
            JSONObject jsonObject = new JSONObject();
            JSONObject item = ((FaceSearchRequest)obj.getRequestBody()).getRequest();
            for (String key : item.keySet()) {
                if (!Objects.nonNull(item.get((Object)"image1")) || !Objects.nonNull(item.get((Object)"image2"))) {
                    throw new InvokeException("500", "param_error");
                }
                jsonObject.put(key, item.get((Object)key));
            }
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.FACE_TO_FACE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("getFaceToFace happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public DataDictionaryRespond getVehicleData(ParamBean<DataDictionaryRequest> obj) {
        DataDictionaryRespond dataDictionaryRespond;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("typeCodes", (Object)((DataDictionaryRequest)obj.getRequestBody()).getTypeCodes());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_POST, "/sdk_service/rest/video-analysis/get-datadictionary?language=" + ((DataDictionaryRequest)obj.getRequestBody()).getLanguage() + ""), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), DataDictionaryRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            dataDictionaryRespond = (DataDictionaryRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("getVehicleData happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return dataDictionaryRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

