/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.bean.PTZCmdInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.GuardPointSetRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.PTZControlRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.GuardPointRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.PTZControlRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.PTZService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CruiseIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ptzIvs1800Service")
public class PTZIvs1800ServiceImpl
extends AbstractIvs1800Service
implements PTZService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PTZIvs1800ServiceImpl.class);
    @Autowired
    private CruiseIvs1800ServiceImpl cruiseIvs1800Service;

    public PTZControlRespond control(VcmReqBaseInfo vcmInfo, PTZControlRequest request) {
        PTZControlRequestIvs1800 ptzControlRequestIvs1800;
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        if (PTZCmdEnum.PTZ_FAST_LOCATE.equals((Object)request.getPtzCmdEnum())) {
            ptzControlRequestIvs1800 = new PTZControlRequestIvs1800();
            if (StringUtils.isBlank((CharSequence)request.getDomainCode())) {
                ptzControlRequestIvs1800.setCameraCode(request.getChannelCode());
            } else {
                ptzControlRequestIvs1800.setCameraCode(request.getChannelCode() + "#" + request.getDomainCode());
            }
            ptzControlRequestIvs1800.setControlCode(Integer.valueOf(31));
            ptzControlRequestIvs1800.setControlPara1(request.getX1() + "," + request.getY1());
            ptzControlRequestIvs1800.setControlPara2(request.getX2() + "," + request.getY2());
        } else {
            JSONObject cruise;
            String cruiseNo;
            ptzControlRequestIvs1800 = this.requestToIvs1800(request);
            if ("PTZ_CRUISE".equalsIgnoreCase(request.getPtzCmdEnum().toString()) && StringUtils.isNotEmpty((CharSequence)(cruiseNo = (cruise = this.getCruiseNo(vcmInfo, request)).getString("cruiseNo")))) {
                ptzControlRequestIvs1800.setControlPara1(cruiseNo);
            }
        }
        LOGGER.info("ptz control data:{}", (Object)JsonUtil.convertBeanToJSON((Object)ptzControlRequestIvs1800));
        try {
            PTZControlRespondIvs1800 ptzControlRespondIvs1800 = (PTZControlRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_CONTROL_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)ptzControlRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PTZControlRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)ptzControlRespondIvs1800);
            ptzControlRespond.setLockStatus(ptzControlRespondIvs1800.getLockStatus());
            return ptzControlRespond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        GuardPointSetRequestIvs1800 requestIvs1800 = new GuardPointSetRequestIvs1800((GuardPointSetRequest)obj.getRequestBody());
        try {
            PTZControlRespondIvs1800 ptzControlRespondIvs1800 = (PTZControlRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.GUARD_POINT_SET_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, PTZControlRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)ptzControlRespondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Set guard point fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        try {
            ChannelRequest request = (ChannelRequest)obj.getRequestBody();
            String url = String.format("/ptz/guardposition/%s/%s/v1.0", request.getChannelCode(), request.getDomainCode());
            Ivs1800MsgType ivs1800MsgType = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
            GuardPointRespondIvs1800 respondIvs1800 = (GuardPointRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ivs1800MsgType, (MsgToObjectConvertor)this.msgToObjectConvertor(null, GuardPointRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            GuardPointRespond respond = new GuardPointRespond();
            respond.setChannelCode(request.getChannelCode());
            respond.setPresetIndex(respondIvs1800.getGuardPosInfo().getIntValue("presetIndex"));
            respond.setWaitSeconds(respondIvs1800.getGuardPosInfo().getIntValue("waitTime"));
            respond.setEnable(respondIvs1800.getGuardPosInfo().getIntValue("enableGuardPosition") != 0);
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("get guard point fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private PTZControlRequestIvs1800 requestToIvs1800(PTZControlRequest req) {
        PTZControlRequestIvs1800 ptzControlRequestIvs1800 = new PTZControlRequestIvs1800();
        PTZCmdInfoIvs1800 ptzCmdInfoIvs1800 = new PTZCmdInfoIvs1800();
        Map cmdInfo = ptzCmdInfoIvs1800.getCmdInfoMap(req.getPtzCmdEnum().toString());
        if (null != req.getSpeed()) {
            cmdInfo.put("controlPara2", String.valueOf(req.getSpeed()));
        }
        if (StringUtils.isNotBlank((CharSequence)req.getMoveMode())) {
            cmdInfo.put("controlPara1", req.getMoveMode());
        } else if (null != req.getPresetIndex()) {
            cmdInfo.put("controlPara1", String.valueOf(req.getPresetIndex()));
        } else if (StringUtils.isNotBlank((CharSequence)req.getCruiseNo())) {
            cmdInfo.put("controlPara1", req.getCruiseNo());
        }
        ptzControlRequestIvs1800.setControlPara1((String)cmdInfo.get("controlPara1"));
        ptzControlRequestIvs1800.setControlPara2((String)cmdInfo.get("controlPara2"));
        if (StringUtils.isBlank((CharSequence)req.getDomainCode())) {
            ptzControlRequestIvs1800.setCameraCode(req.getChannelCode());
        } else {
            ptzControlRequestIvs1800.setCameraCode(req.getChannelCode() + "#" + req.getDomainCode());
        }
        ptzControlRequestIvs1800.setControlCode((Integer)cmdInfo.get("controlCode"));
        return ptzControlRequestIvs1800;
    }

    private JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, PTZControlRequest req) {
        CruiseRequest cruise = new CruiseRequest();
        cruise.setChannelCode(req.getChannelCode());
        cruise.setDomainCode(req.getDomainCode());
        cruise.setName("ZKtecoBiosecurityCurise");
        cruise.setCruiseType(Integer.valueOf(1));
        return this.cruiseIvs1800Service.getCruiseNoByCondition(vcmInfo, cruise);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

