/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorAreaItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.HeatMapConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.MotionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.NormalIntelligentRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.OcclusionConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.QueueDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.RepeatVisitorRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.SoundDetectionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.TargetRecognitionRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VideoCoverRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligent.FaceCaptureConfigRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligent.QueueDetectionRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.AreaList;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcHeatMapConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcMotionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmAudioAndLight;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.OsdLocation;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.PointItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraModeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorAlarmPlanItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorLineItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.FaceCaptureRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MaskAlarmItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.MotionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionChannelConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.OcclusionConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.Rect;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.RepeatVisitorGetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SdcQueueDetectConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SituationalConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.SoundDetectionConfig;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.VideoCoverRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.ZoneInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.ConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.LeaveDetectRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.DetectArea;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.intelligent.LeaveDetectConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.intelligent.MotionConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.intelligent.NormallConfigRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.intelligent.OcclusionConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.intelligent.QueueDetectRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.bean.SdcAreanBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.intelligent.SdcCrossCountingConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.NormalIntelligentService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.DeviceConfigManageIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NormalIntelligentIVS1800ServiceImpl
extends AbstractIvs1800Service
implements NormalIntelligentService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalIntelligentIVS1800ServiceImpl.class);
    @Autowired
    private DeviceConfigManageIvs1800ServiceImpl deviceConfigManageIvs1800Service;
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;
    private static final String ALARM_PASS_ALARM_URI = SdcMsgType.ALARM_PASS_ALARM_PARAM.getUri() + "?AppName=itgtSaas&Name=";

    public MotionConfigRespond getMotionConfig(ParamBean<MotionConfigRequest> obj) {
        MotionConfigRespond motionConfigRespond = new MotionConfigRespond();
        JSONObject config = this.getSdcConfig(obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.COMMONITGT_MOTIONDETECT_GET.getUri());
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.toString(), SdcMotionConfigRespond.class);
        SdcMotionConfigRespond motionSdcConfigRespond = (SdcMotionConfigRespond)operateBean.get();
        SdcMotionConfigRespond.MotionDetectPara motionDetectPara = motionSdcConfigRespond.getMotionDetectPara();
        MotionChannelConfig motionChannelConfig = new MotionChannelConfig();
        motionChannelConfig.setEnable(Boolean.valueOf(motionDetectPara.getEnable() == 1));
        motionChannelConfig.setSensitivity(motionDetectPara.getSensitivity());
        ArrayList<Rect> rects = new ArrayList<Rect>();
        if (!Objects.isNull(motionDetectPara.getArea().getRectPoint())) {
            for (SdcMotionConfigRespond.MotionDetectPara.AreaBean.RectPointBean rectDetection : motionDetectPara.getArea().getRectPoint()) {
                Rect rect = new Rect();
                rect.setLeft(rectDetection.getX1() * 2);
                rect.setTop(rectDetection.getY1() * 2);
                rect.setWidth((rectDetection.getX2() - rectDetection.getX1()) * 2);
                rect.setHeight((rectDetection.getY2() - rectDetection.getY1()) * 2);
                rects.add(rect);
            }
        }
        motionChannelConfig.setRects(rects);
        JSONObject alarmPlan = this.getSdcConfig(obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_URI + "action_motionDetection");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        motionChannelConfig.setIntervals(((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getSourceParam().getTime().intValue());
        motionChannelConfig.setAlarmPlanList(this.getBehaviorAlarmPlan(alarmConfigRespond));
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(obj.getVcmInfo(), ((MotionConfigRequest)obj.getRequestBody()).getChannelCode(), alarmPlan);
        motionChannelConfig.setAudioEnable(audioAndLightAbility.getAudioEnable());
        motionChannelConfig.setAudioFile(audioAndLightAbility.getAudioFile());
        motionChannelConfig.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        motionChannelConfig.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        motionChannelConfig.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        motionChannelConfig.setFlashDuration(audioAndLightAbility.getFlashDuration());
        motionConfigRespond.setChannelConfig(motionChannelConfig);
        return motionConfigRespond;
    }

    public boolean setMotionConfig(ParamBean<MotionConfigRequest> obj) {
        MotionConfigRequest requestBody = (MotionConfigRequest)obj.getRequestBody();
        MotionChannelConfig config = requestBody.getChannelConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        audioAndLight.setAlarmInterval(Integer.valueOf(config.getIntervals()));
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        this.updateAlarmPlanTime(obj.getVcmInfo(), requestBody.getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "action_motionDetection");
        SdcMotionConfigRespond sdcConfig = this.changeMotionConfig(requestBody);
        JSONObject UUIDJson = this.getSdcConfig(obj.getVcmInfo(), requestBody.getChannelCode(), SdcMsgType.CNS_PAAS_GET.getUri());
        JSONArray cnsChnParam = UUIDJson.getJSONArray("CnsChnParam");
        JSONObject UUID2 = (JSONObject)cnsChnParam.get(0);
        sdcConfig.setUUID(UUID2.getString("uuid"));
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.COMMONITGT_MOTIONDETECT_SET.getUri());
        info.setParam(JSON.toJSONString((Object)sdcConfig));
        passThrouthRequestIvs1800.setInfo(info);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800);
    }

    private SdcMotionConfigRespond changeMotionConfig(MotionConfigRequest requestBody) {
        MotionChannelConfig channelConfig = requestBody.getChannelConfig();
        SdcMotionConfigRespond sdcMotionConfigRespond = new SdcMotionConfigRespond();
        SdcMotionConfigRespond.MotionDetectPara motionDetectPara = new SdcMotionConfigRespond.MotionDetectPara();
        motionDetectPara.setEnable(channelConfig.getEnable() != false ? 1 : 0);
        motionDetectPara.setSensitivity(channelConfig.getSensitivity());
        SdcMotionConfigRespond.MotionDetectPara.AreaBean area = new SdcMotionConfigRespond.MotionDetectPara.AreaBean();
        ArrayList<SdcMotionConfigRespond.MotionDetectPara.AreaBean.RectPointBean> rectPoint = new ArrayList<SdcMotionConfigRespond.MotionDetectPara.AreaBean.RectPointBean>();
        if (!CollectionUtils.isEmpty((Collection)channelConfig.getRects())) {
            for (Rect rect : channelConfig.getRects()) {
                SdcMotionConfigRespond.MotionDetectPara.AreaBean.RectPointBean rectPointBean = new SdcMotionConfigRespond.MotionDetectPara.AreaBean.RectPointBean();
                rectPointBean.setX1(rect.getLeft() / 2);
                rectPointBean.setY1(rect.getTop() / 2);
                rectPointBean.setX2((rect.getWidth() + rect.getLeft()) / 2);
                rectPointBean.setY2((rect.getHeight() + rect.getTop()) / 2);
                rectPoint.add(rectPointBean);
            }
            area.setRectPoint(rectPoint);
        }
        motionDetectPara.setArea(area);
        sdcMotionConfigRespond.setMotionDetectPara(motionDetectPara);
        return sdcMotionConfigRespond;
    }

    private NormallConfigRequestIvs1800 changeMotionParameter(MotionConfigRequest requestBody) {
        NormallConfigRequestIvs1800 configRequestIvs1800 = new NormallConfigRequestIvs1800();
        MotionChannelConfig channelConfig = requestBody.getChannelConfig();
        NormallConfigRequestIvs1800.NormalDetectionInfo configItem = new NormallConfigRequestIvs1800.NormalDetectionInfo();
        MotionConfigRespondIvs1800 motionDetection = new MotionConfigRespondIvs1800();
        motionDetection.setAutoClearAlarmTime(Integer.valueOf(channelConfig.getIntervals()));
        motionDetection.setDetectInterval(channelConfig.getDetectInterval());
        motionDetection.setMotionDetectionEnable(Integer.valueOf(channelConfig.getEnable() != false ? 1 : 0));
        motionDetection.setPlatformMotionDetection(channelConfig.getPlatformMotionDetection());
        motionDetection.setRectNum(Integer.valueOf(channelConfig.getMaxRect()));
        motionDetection.setSensitivity(Integer.valueOf(channelConfig.getSensitivity()));
        ArrayList<MotionConfigRespondIvs1800.RectDetectionListBean> rectDetectionList = new ArrayList<MotionConfigRespondIvs1800.RectDetectionListBean>();
        for (Rect rect : channelConfig.getRects()) {
            MotionConfigRespondIvs1800.RectDetectionListBean rectDetection = new MotionConfigRespondIvs1800.RectDetectionListBean();
            rectDetection.setLeft(new BigDecimal(rect.getLeft()).divide(new BigDecimal(704), 6, 4).doubleValue());
            rectDetection.setTop(new BigDecimal(rect.getTop()).divide(new BigDecimal(576), 6, 4).doubleValue());
            BigDecimal right = new BigDecimal(rect.getWidth()).add(new BigDecimal(rect.getLeft())).divide(new BigDecimal(704), 6, 4);
            rectDetection.setRight(right.doubleValue());
            BigDecimal bottom = new BigDecimal(rect.getHeight()).add(new BigDecimal(rect.getTop())).divide(new BigDecimal(576), 6, 4);
            rectDetection.setBottom(bottom.doubleValue());
            rectDetectionList.add(rectDetection);
        }
        motionDetection.setRectDetectionList(rectDetectionList);
        configItem.setMotionDetection(motionDetection);
        configRequestIvs1800.setConfigItem(configItem);
        configRequestIvs1800.setDeviceCode(requestBody.getChannelCode());
        configRequestIvs1800.setConfigType(Integer.valueOf(9));
        return configRequestIvs1800;
    }

    public VideoCoverRespond getVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), obj.getVcmInfo().getDomainCode(), 11);
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("videoMask");
        VideoCoverRespond respond = new VideoCoverRespond();
        respond.setCurNum(configObject.getIntValue("areaNum"));
        if (configObject.getInteger("enableVideoMask") == 1) {
            respond.setEnable(Boolean.valueOf(true));
        } else {
            respond.setEnable(Boolean.valueOf(false));
        }
        respond.setMaxNum(10);
        JSONArray zoneArray = configObject.getJSONArray("trapeziformList");
        if (!CollectionUtils.isEmpty((Collection)zoneArray)) {
            for (int i = 0; i < zoneArray.size(); ++i) {
                JSONObject zoneObject = zoneArray.getJSONObject(i);
                ZoneInfo zoneInfo = new ZoneInfo();
                zoneInfo.setNo(i + 1);
                Point point = new Point();
                point.setLeft(Math.round(zoneObject.getFloatValue("x1") * 704.0f));
                point.setTop(Math.round(zoneObject.getFloatValue("y1") * 576.0f));
                zoneInfo.getPoints().add(point);
                point = new Point();
                point.setLeft(Math.round(zoneObject.getFloatValue("x2") * 704.0f));
                point.setTop(Math.round(zoneObject.getFloatValue("y2") * 576.0f));
                zoneInfo.getPoints().add(point);
                point = new Point();
                point.setLeft(Math.round(zoneObject.getFloatValue("x3") * 704.0f));
                point.setTop(Math.round(zoneObject.getFloatValue("y3") * 576.0f));
                zoneInfo.getPoints().add(point);
                point = new Point();
                point.setLeft(Math.round(zoneObject.getFloatValue("x4") * 704.0f));
                point.setTop(Math.round(zoneObject.getFloatValue("y4") * 576.0f));
                zoneInfo.getPoints().add(point);
                respond.getZones().add(zoneInfo);
            }
        }
        try {
            JSONObject UUIDJson = this.getSdcConfig(obj.getVcmInfo(), ((VideoCoverRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.CNS_PAAS_GET.getUri());
            JSONArray cnsChnParam = UUIDJson.getJSONArray("CnsChnParam");
            JSONObject UUID2 = (JSONObject)cnsChnParam.get(0);
            PenetrateRequest penetrateRequest = new PenetrateRequest();
            penetrateRequest.setRequestMethod("GET");
            penetrateRequest.setChannelCode(((VideoCoverRequest)obj.getRequestBody()).getChannelCode() + "#" + obj.getVcmInfo().getDomainCode());
            ParamBean paramBean = new ParamBean();
            paramBean.setVcmInfo(obj.getVcmInfo());
            penetrateRequest.setRequestUrl(SdcMsgType.CHANNEL_GET_REGION.getUri() + "?UUID=" + UUID2.getString("uuid"));
            paramBean.setRequestBody((Object)penetrateRequest);
            JSONObject result = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data").getJSONArray("regionIaasCapability").getJSONObject(0);
            if (result.getJSONObject("privacy").containsKey((Object)"polygon")) {
                respond.setPolygon(Boolean.valueOf(result.getJSONObject("privacy").getBooleanValue("polygon")));
            } else {
                respond.setPolygon(Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            LOGGER.error("IVS1800 get RegionIaas error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            respond.setPolygon(Boolean.valueOf(true));
        }
        return respond;
    }

    public boolean setVideoCoverConfig(ParamBean<VideoCoverRequest> obj) {
        VideoCoverRequest request = (VideoCoverRequest)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        if (request.getConfig().getEnable().booleanValue()) {
            configObject.put("enableVideoMask", (Object)1);
        } else {
            configObject.put("enableVideoMask", (Object)0);
        }
        configObject.put("reserve", (Object)"");
        JSONArray zoneArray = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)request.getConfig().getZones())) {
            for (int i = 0; i < request.getConfig().getZones().size(); ++i) {
                ZoneInfo zoneInfo = (ZoneInfo)request.getConfig().getZones().get(i);
                JSONObject zoneObject = new JSONObject();
                zoneObject.put("x1", (Object)((double)((Point)zoneInfo.getPoints().get(0)).getLeft() / 704.0));
                zoneObject.put("y1", (Object)((double)((Point)zoneInfo.getPoints().get(0)).getTop() / 576.0));
                zoneObject.put("x2", (Object)((double)((Point)zoneInfo.getPoints().get(1)).getLeft() / 704.0));
                zoneObject.put("y2", (Object)((double)((Point)zoneInfo.getPoints().get(1)).getTop() / 576.0));
                zoneObject.put("x3", (Object)((double)((Point)zoneInfo.getPoints().get(2)).getLeft() / 704.0));
                zoneObject.put("y3", (Object)((double)((Point)zoneInfo.getPoints().get(2)).getTop() / 576.0));
                zoneObject.put("x4", (Object)((double)((Point)zoneInfo.getPoints().get(3)).getLeft() / 704.0));
                zoneObject.put("y4", (Object)((double)((Point)zoneInfo.getPoints().get(3)).getTop() / 576.0));
                zoneArray.add((Object)zoneObject);
            }
        }
        configObject.put("trapeziformList", (Object)zoneArray);
        configObject.put("areaNum", (Object)zoneArray.size());
        JSONObject dataObject = new JSONObject();
        dataObject.put("videoMask", (Object)configObject);
        return this.deviceConfigManageIvs1800Service.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(11), dataObject, request.getChannelCode());
    }

    public OcclusionConfigRespond getOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        OcclusionConfigRespond occlusionConfigRespond = new OcclusionConfigRespond();
        ConfigRespondIvs1800 config = this.getConfig(obj.getVcmInfo(), ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), ((OcclusionConfigRequest)obj.getRequestBody()).getNvrCode(), 10);
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.getConfigItem().getJSONObject("videoHideAlarm").toString(), OcclusionConfigRespondIvs1800.class);
        OcclusionConfigRespondIvs1800 occlusionConfigIvs1800 = (OcclusionConfigRespondIvs1800)operateBean.get();
        OcclusionChannelConfig channelConfig = new OcclusionChannelConfig();
        channelConfig.setEnable(Boolean.valueOf(occlusionConfigIvs1800.getEnableVideoHide() == 1));
        channelConfig.setSensitivity(occlusionConfigIvs1800.getSensitivity().intValue());
        channelConfig.setIntervals(occlusionConfigIvs1800.getAutoClearAlarmTime().intValue());
        JSONObject alarmPlan = this.getSdcConfig(obj.getVcmInfo(), ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_URI + "action_videoBlockDetection");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        channelConfig.setAlarmPlanList(this.getBehaviorAlarmPlan(alarmConfigRespond));
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(obj.getVcmInfo(), ((OcclusionConfigRequest)obj.getRequestBody()).getChannelCode(), alarmPlan);
        channelConfig.setAudioEnable(audioAndLightAbility.getAudioEnable());
        channelConfig.setAudioFile(audioAndLightAbility.getAudioFile());
        channelConfig.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        channelConfig.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        channelConfig.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        channelConfig.setFlashDuration(audioAndLightAbility.getFlashDuration());
        occlusionConfigRespond.setChannelConfig(channelConfig);
        return occlusionConfigRespond;
    }

    public boolean setOcclusionConfig(ParamBean<OcclusionConfigRequest> obj) {
        JSONObject jsonObject;
        OcclusionConfigRequest requestBody = (OcclusionConfigRequest)obj.getRequestBody();
        NormallConfigRequestIvs1800 configRequestIvs1800 = this.changeOcclusionParameter(requestBody);
        OcclusionChannelConfig config = requestBody.getChannelConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        audioAndLight.setAlarmInterval(Integer.valueOf(config.getIntervals()));
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        try {
            jsonObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SET_DEVICE_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)configRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("Set occlusion config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.updateAlarmPlanTime(obj.getVcmInfo(), requestBody.getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "action_videoBlockDetection");
        this.checkJsonRespond(jsonObject);
        return true;
    }

    private NormallConfigRequestIvs1800 changeOcclusionParameter(OcclusionConfigRequest requestBody) {
        NormallConfigRequestIvs1800 configRequestIvs1800 = new NormallConfigRequestIvs1800();
        configRequestIvs1800.setConfigType(Integer.valueOf(10));
        configRequestIvs1800.setDeviceCode(requestBody.getChannelCode());
        OcclusionConfigRespondIvs1800 videoHideAlarm = new OcclusionConfigRespondIvs1800();
        videoHideAlarm.setAutoClearAlarmTime(Integer.valueOf(requestBody.getChannelConfig().getIntervals()));
        videoHideAlarm.setAreaNum(Integer.valueOf(1));
        videoHideAlarm.setEnableVideoHide(Integer.valueOf(requestBody.getChannelConfig().getEnable() != false ? 1 : 0));
        videoHideAlarm.setSensitivity(Integer.valueOf(requestBody.getChannelConfig().getSensitivity()));
        ArrayList<OcclusionConfigRespondIvs1800.RectDetectionRespondIvs1800> rectAreaList = new ArrayList<OcclusionConfigRespondIvs1800.RectDetectionRespondIvs1800>();
        OcclusionConfigRespondIvs1800.RectDetectionRespondIvs1800 detectionRespondIvs1800 = new OcclusionConfigRespondIvs1800.RectDetectionRespondIvs1800();
        detectionRespondIvs1800.setLeft(0.0);
        detectionRespondIvs1800.setTop(0.0);
        detectionRespondIvs1800.setBottom(1.0);
        detectionRespondIvs1800.setRight(1.0);
        rectAreaList.add(detectionRespondIvs1800);
        videoHideAlarm.setRectAreaList(rectAreaList);
        NormallConfigRequestIvs1800.NormalDetectionInfo configItem = new NormallConfigRequestIvs1800.NormalDetectionInfo();
        configItem.setVideoHideAlarm(videoHideAlarm);
        configRequestIvs1800.setConfigItem(configItem);
        return configRequestIvs1800;
    }

    public FaceCaptureRespond getPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject faceCapture = this.getFaceCapture(obj, SdcMsgType.FACE_PERIMETER_CONFIG_GET);
        JSONObject faceAttribute = this.getFaceCapture(obj, SdcMsgType.FACEATTRIBUTE_GET_SET);
        Optional operateBean = JsonUtil.convertJsonToBean((String)faceCapture.toJSONString(), FaceCaptureConfigRequestIvs1800.class);
        if (!operateBean.isPresent()) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        FaceCaptureConfigRequestIvs1800 faceCaptureConfig = (FaceCaptureConfigRequestIvs1800)operateBean.get();
        FaceCaptureRespond faceCaptureRespond = new FaceCaptureRespond();
        FaceCaptureRespond.Config config = new FaceCaptureRespond.Config();
        config.setFaceImgQuality(faceCaptureConfig.getFaceProcessPara().getFaceImgQuality());
        config.setFaceCapMode(faceCaptureConfig.getFacedetectPara().getFaceCapMode());
        config.setTimeCapture(faceCaptureConfig.getFacedetectPara().getTimedCapture());
        config.setFaceEnhancement(Boolean.valueOf(faceCaptureConfig.getFaceProcessPara().getFaceEnhancement() == 1));
        config.setFaceAttrSwitch(Boolean.valueOf(faceAttribute.getInteger("enableFaceAttri") == 1));
        config.setFaceDetectMode(faceCaptureConfig.getFacedetectPara().getMode());
        ArrayList areaList = new ArrayList();
        FaceCaptureRespond.Config.AreaList area = new FaceCaptureRespond.Config.AreaList();
        FaceCaptureRespond.Config.AreaList area1 = new FaceCaptureRespond.Config.AreaList();
        faceCaptureConfig.getGuardAreaList().getArea().forEach(e -> {
            area.setPointList(this.getCoordinate(e.getPoint()));
            area.setPointNum(e.getPointNum());
            area.setEnable(Boolean.valueOf(e.getEnable() == 1));
            area.setIndex(1);
            areaList.add(area);
        });
        faceCaptureConfig.getUnGuardAreaList().getArea().forEach(e -> {
            area1.setPointList(this.getCoordinate(e.getPoint()));
            area1.setPointNum(e.getPointNum());
            area1.setEnable(Boolean.valueOf(e.getEnable() == 1));
            area1.setIndex(2);
            areaList.add(area1);
        });
        config.setAreaList(areaList);
        config.setSendBodyNum(faceCaptureConfig.getFaceProcessPara().getSendBodyImgNum());
        config.setFaceExposure(Boolean.valueOf(faceCaptureConfig.getFacedetectPara().getFaceExposure() == 1));
        config.setSwitchIn(Boolean.valueOf(faceCaptureConfig.getFacedetectPara().getEnable() == 1));
        config.setSendBodyImg(Boolean.valueOf(faceCaptureConfig.getFaceProcessPara().getSendBodyImg() == 1));
        config.setFaceCapSensitivity(faceCaptureConfig.getFacedetectPara().getFaceCapSensitivity());
        config.setMaxPixel(faceCaptureConfig.getFacedetectPara().getMaxPupilDist());
        config.setMinPixel(faceCaptureConfig.getFacedetectPara().getMinPupilDist());
        config.setSendFaceImg(Boolean.valueOf(faceCaptureConfig.getFaceProcessPara().getSendFaceImg() == 1));
        config.setBodyImgQuality(faceCaptureConfig.getFaceProcessPara().getBodyImgQuality());
        config.setFaceSensitivity(faceCaptureConfig.getFacedetectPara().getFaceSensitivity());
        config.setSendFaceNum(faceCaptureConfig.getFaceProcessPara().getSendFaceImgNum());
        config.setBodySensitivity(faceCaptureConfig.getFacedetectPara().getBodySensitivity());
        config.setFaceExposureTime(faceCaptureConfig.getFacedetectPara().getFaceExposureTime());
        config.setRoiMeterLevel(faceCaptureConfig.getFacedetectPara().getRoiMeterLevel());
        config.setPanoramaImgQuality(faceCaptureConfig.getFaceProcessPara().getPanoramaImgQuality());
        config.setSendPanorama(Boolean.valueOf(faceCaptureConfig.getFaceProcessPara().getSendPanorama() == 1));
        JSONObject alarmPlan = this.getSdcConfig(obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_URI + "recognition_faceDetection");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        JSONObject alarmInterval = (JSONObject)alarmPlan.getJSONArray("alarmParam").get(0);
        config.setAlarmInterval(alarmInterval.getJSONObject("sourceParam").getInteger("time").intValue());
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmConfigRespond);
        config.setAlarmPlanList(alarmPlanList);
        faceCaptureRespond.setConfig(config);
        return faceCaptureRespond;
    }

    private JSONObject getFaceCapture(ParamBean<NormalIntelligentRequest> obj, SdcMsgType configSdcType) {
        String channelCode = ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode();
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + configSdcType.getUri());
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                return returnJson.getJSONObject("Data");
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("getFaceCapture error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONObject setPerimeterFaceConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject config = ((NormalIntelligentRequest)obj.getRequestBody()).getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAlarmPlanList(JSONObject.parseArray((String)config.getJSONArray("alarm_plan_list").toJSONString(), BehaviorAlarmPlanItemRespond.class));
        audioAndLight.setAlarmInterval(config.getInteger("alarm_interval"));
        this.updateAlarmPlanTime(obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "recognition_faceDetection");
        return this.setFaceCapture(obj, SdcMsgType.FACE_PERIMETER_CONFIG_SET);
    }

    private JSONObject setFaceCapture(ParamBean<NormalIntelligentRequest> obj, SdcMsgType configSdcType) {
        String channelCode = ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode();
        JSONObject config = ((NormalIntelligentRequest)obj.getRequestBody()).getConfig();
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.toJSONString(), FaceCaptureRespond.Config.class);
        if (!operateBean.isPresent()) {
            throw new InvokeException("500", "param_error");
        }
        FaceCaptureRespond.Config request = (FaceCaptureRespond.Config)operateBean.get();
        FaceCaptureConfigRequestIvs1800.FacedetectPara facedetectPara = new FaceCaptureConfigRequestIvs1800.FacedetectPara();
        facedetectPara.setFaceCapMode(request.getFaceCapMode());
        facedetectPara.setTimedCapture(request.getTimeCapture());
        facedetectPara.setMode(request.getFaceDetectMode());
        facedetectPara.setFaceExposure(request.getFaceExposure() != false ? 1 : 0);
        facedetectPara.setEnable(request.getSwitchIn() != false ? 1 : 0);
        facedetectPara.setFaceCapSensitivity(request.getFaceCapSensitivity());
        facedetectPara.setAlarmTime(request.getAlarmInterval());
        facedetectPara.setMaxPupilDist(request.getMaxPixel());
        facedetectPara.setMinPupilDist(request.getMinPixel());
        facedetectPara.setFaceSensitivity(request.getFaceSensitivity());
        facedetectPara.setBodySensitivity(request.getBodySensitivity());
        facedetectPara.setFaceExposureTime(request.getFaceExposureTime());
        if (request.getBodyKpsSensitivity() == 0 && request.getFaceKpsSensitivity() == 0) {
            facedetectPara.setBodyKpsSensitivity(request.getBodySensitivity());
            facedetectPara.setFaceKpsSensitivity(request.getFaceSensitivity());
        } else {
            facedetectPara.setBodyKpsSensitivity(request.getBodyKpsSensitivity());
            facedetectPara.setFaceKpsSensitivity(request.getFaceKpsSensitivity());
        }
        facedetectPara.setRoiMeterLevel(request.getRoiMeterLevel());
        FaceCaptureConfigRequestIvs1800.FaceProcessPara faceProcessPara = new FaceCaptureConfigRequestIvs1800.FaceProcessPara();
        faceProcessPara.setFaceImgQuality(request.getFaceImgQuality());
        faceProcessPara.setFaceEnhancement(request.getFaceEnhancement() != false ? 1 : 0);
        faceProcessPara.setSendBodyImgNum(request.getSendBodyNum());
        faceProcessPara.setSendBodyImg(request.getSendBodyImg() != false ? 1 : 0);
        faceProcessPara.setSendFaceImg(request.getSendFaceImg() != false ? 1 : 0);
        faceProcessPara.setBodyImgQuality(request.getBodyImgQuality());
        faceProcessPara.setSendFaceImgNum(request.getSendFaceNum());
        faceProcessPara.setPanoramaImgQuality(request.getPanoramaImgQuality());
        faceProcessPara.setSendPanorama(request.getSendPanorama() != false ? 1 : 0);
        ArrayList areaList = new ArrayList();
        ArrayList areaListUn = new ArrayList();
        request.getAreaList().forEach(e -> {
            FaceCaptureConfigRequestIvs1800.GuardAreaList.Area area = new FaceCaptureConfigRequestIvs1800.GuardAreaList.Area();
            area.setPoint(this.setCoordinate(e.getPointList()));
            area.setPointNum(e.getPointNum());
            area.setEnable(e.getEnable() != false ? 1 : 0);
            if (e.getIndex() == 1) {
                area.setAreaName("GuardArea 1");
                area.setIndex(e.getIndex());
                areaList.add(area);
            } else if (e.getIndex() == 2) {
                area.setAreaName("unGuardArea 1");
                area.setIndex(1);
                areaListUn.add(area);
            }
        });
        FaceCaptureConfigRequestIvs1800.GuardAreaList guardAreaList = new FaceCaptureConfigRequestIvs1800.GuardAreaList();
        FaceCaptureConfigRequestIvs1800.GuardAreaList unGuardAreaList = new FaceCaptureConfigRequestIvs1800.GuardAreaList();
        guardAreaList.setArea(areaList);
        unGuardAreaList.setArea(areaListUn);
        FaceCaptureConfigRequestIvs1800 faceCaptureConfig = new FaceCaptureConfigRequestIvs1800();
        faceCaptureConfig.setFaceProcessPara(faceProcessPara);
        faceCaptureConfig.setFacedetectPara(facedetectPara);
        faceCaptureConfig.setGuardAreaList(guardAreaList);
        faceCaptureConfig.setUnGuardAreaList(unGuardAreaList);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + configSdcType.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)faceCaptureConfig));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        CameraPassThrouthRequestIvs1800 passThrouthRequest = new CameraPassThrouthRequestIvs1800();
        passThrouthRequest.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        this.cameraPass(obj, passThrouthRequestIvs1800);
        JSONObject requestObject = new JSONObject();
        requestObject.put("enableFaceAttri", (Object)(request.getFaceAttrSwitch() != false ? 1 : 0));
        requestObject.put("enableBodyAttri", (Object)0);
        info.setRequestUrl("PUT /SDCAPI/V1.0/FaceApp/FaceAttribute");
        info.setParam(requestObject.toJSONString());
        passThrouthRequest.setInfo(info);
        return this.cameraPass(obj, passThrouthRequest);
    }

    private JSONObject cameraPass(ParamBean<NormalIntelligentRequest> obj, CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)20);
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            JSONObject responseStatus = returnJson.getJSONObject("Data").getJSONObject("ResponseStatus");
            if (returnJson.getInteger("RspCode") == 0 && responseStatus.getInteger("StatusCode") == 0) {
                LOGGER.debug("setCameraPass end..");
                return responseStatus;
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("setCameraPass error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CameraModeRespond getCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        CameraModeRespond modeRespond = new CameraModeRespond();
        modeRespond.setConfig(this.getCameraMode(obj));
        modeRespond.setCameraModeList(this.getCameraModeList(obj));
        return modeRespond;
    }

    private List<String> getCameraModeList(ParamBean<NormalIntelligentRequest> obj) {
        CameraPassThrouthRequestIvs1800 requestIvs1800 = new CameraPassThrouthRequestIvs1800();
        requestIvs1800.setCameraCode(((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("GET " + SdcMsgType.ABILITY_GET.getUri());
        requestIvs1800.setInfo(info);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("get ability from sdk is end.");
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                SdcAbilityRespond ability = (SdcAbilityRespond)JsonUtil.convertJsonToBean((String)returnJson.getJSONObject("Data").toJSONString(), SdcAbilityRespond.class).get();
                ArrayList<String> cameraModeList = new ArrayList<String>();
                if (ability.isMultiMode()) {
                    SdcAbilityRespond.MultiModeListBean multiModeList = ability.getMultiModeList();
                    if (multiModeList.isFaceMode()) {
                        cameraModeList.add("FaceCardMode");
                    }
                    if (multiModeList.isVlprMode()) {
                        cameraModeList.add("MicroCardMode");
                    }
                    if (multiModeList.isVaMode()) {
                        cameraModeList.add("BehaviorAnalyseMode");
                    }
                }
                return cameraModeList;
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONObject getCameraMode(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject config;
        Ivs1800MsgType ivs1800MsgType = new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, Ivs1800MsgType.SYSTEM_ITGEMODE_GET_URI.getUri() + "/" + ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        try {
            config = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)ivs1800MsgType, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkJsonRespond(config);
        return this.changeCameraMode(config.getInteger("ITGEMode"));
    }

    private JSONObject changeCameraMode(Integer itgeMode) {
        String itgeModeStr = null;
        switch (itgeMode) {
            case 1: {
                itgeModeStr = "FaceCardMode";
                break;
            }
            case 4: {
                itgeModeStr = "MicroCardMode";
                break;
            }
            case 7: {
                itgeModeStr = "BehaviorAnalyseMode";
            }
        }
        JSONObject jsonObject = new JSONObject();
        if (itgeModeStr != null) {
            jsonObject.put("camera_mode", (Object)itgeModeStr);
        }
        return jsonObject;
    }

    public boolean setCameraModeConfig(ParamBean<NormalIntelligentRequest> obj) {
        CameraPassThrouthRespondIvs1800 respondIvs1800;
        JSONObject jsonpObject = new JSONObject();
        jsonpObject.put("deviceCode", (Object)((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode());
        jsonpObject.put("ITGEMode", (Object)this.changeCameraModeToInt(((NormalIntelligentRequest)obj.getRequestBody()).getConfig().getString("camera_mode")));
        try {
            respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SYSTEM_ITGEMODE_PUT_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonpObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        return true;
    }

    private Integer changeCameraModeToInt(String cameraMode) {
        Integer itgeMode = null;
        switch (cameraMode) {
            case "FaceCardMode": {
                itgeMode = 1;
                break;
            }
            case "MicroCardMode": {
                itgeMode = 4;
                break;
            }
            case "BehaviorAnalyseMode": {
                itgeMode = 7;
            }
        }
        return itgeMode;
    }

    public MaskAlarmItemRespond getMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject faceRecognition = this.getFaceCapture(obj, SdcMsgType.FACE_MASKALARM_GET);
        MaskAlarmItemRespond maskAlarmItemRespond = new MaskAlarmItemRespond();
        MaskAlarmItemRespond.MaskAlarmItem maskAlarmItem = new MaskAlarmItemRespond.MaskAlarmItem();
        if (Objects.nonNull(faceRecognition)) {
            if (faceRecognition.getInteger("alarmType") == 0 && faceRecognition.getInteger("enable") == 1) {
                maskAlarmItem.setAlarmType("None");
            } else if (faceRecognition.getInteger("alarmType") == 1 && faceRecognition.getInteger("enable") == 1) {
                maskAlarmItem.setAlarmType("Exist");
            } else if (faceRecognition.getInteger("enable") == 0) {
                maskAlarmItem.setAlarmType("Close");
            }
            if (faceRecognition.getInteger("standardMask") == 0) {
                maskAlarmItem.setStandardMask(Boolean.valueOf(false));
            } else if (faceRecognition.getInteger("standardMask") == 1) {
                maskAlarmItem.setStandardMask(Boolean.valueOf(true));
            } else {
                maskAlarmItem.setStandardMask(null);
            }
        } else {
            throw new InvokeException("500", "cu_device_not_return");
        }
        JSONObject alarmPlan = this.getSdcConfig(obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_URI + "recognition_faceMaskAlarm");
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(obj.getVcmInfo(), ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode(), alarmPlan);
        maskAlarmItem.setAudioEnable(audioAndLightAbility.getAudioEnable());
        maskAlarmItem.setAudioFile(audioAndLightAbility.getAudioFile());
        maskAlarmItem.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        maskAlarmItem.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        maskAlarmItem.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        maskAlarmItem.setFlashDuration(audioAndLightAbility.getFlashDuration());
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmConfigRespond);
        maskAlarmItem.setAlarmPlanList(alarmPlanList);
        maskAlarmItemRespond.setConfig(maskAlarmItem);
        return maskAlarmItemRespond;
    }

    public boolean setMaskAlarmConfig(ParamBean<NormalIntelligentRequest> obj) {
        String channelCode = ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode();
        JSONObject config = ((NormalIntelligentRequest)obj.getRequestBody()).getConfig();
        JSONObject maskAlarm = new JSONObject();
        if ("None".equals(config.getString("alarm_type"))) {
            maskAlarm.put("alarmType", (Object)0);
            maskAlarm.put("enable", (Object)1);
        } else if ("Exist".equals(config.getString("alarm_type"))) {
            maskAlarm.put("alarmType", (Object)1);
            maskAlarm.put("enable", (Object)1);
        } else if ("Close".equals(config.getString("alarm_type"))) {
            maskAlarm.put("enable", (Object)0);
        }
        if (!config.getBooleanValue("standardMask")) {
            maskAlarm.put("standardMask", (Object)0);
        } else if (config.getBooleanValue("standardMask")) {
            maskAlarm.put("standardMask", (Object)1);
        }
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAudioEnable(config.getBoolean("audio_enable"));
        audioAndLight.setAudioFile(config.getString("audio_file"));
        audioAndLight.setAudioPlaybackTimes(config.getInteger("audio_playback_times"));
        audioAndLight.setWhiteLightIllumEnable(config.getBoolean("white_light_illuminator_enable"));
        audioAndLight.setWhiteLightIlluminator(config.getString("white_light_illuminator"));
        audioAndLight.setFlashDuration(config.getInteger("flash_duration"));
        JSONArray alarmPlanList = config.getJSONArray("alarm_plan_list");
        audioAndLight.setAlarmPlanList(JSONObject.parseArray((String)alarmPlanList.toJSONString(), BehaviorAlarmPlanItemRespond.class));
        this.updateAlarmPlanTime(obj.getVcmInfo(), channelCode, audioAndLight, ALARM_PASS_ALARM_URI + "recognition_faceMaskAlarm");
        CameraPassThrouthRequestIvs1800 passMaskAlarm = new CameraPassThrouthRequestIvs1800();
        passMaskAlarm.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoFeatureSynergy = new CameraPassThroughInfoIvs1800();
        infoFeatureSynergy.setRequestUrl("PUT " + SdcMsgType.FACE_MASKALARM_SET.getUri());
        infoFeatureSynergy.setParam(maskAlarm.toJSONString());
        passMaskAlarm.setInfo(infoFeatureSynergy);
        this.cameraPass(obj, passMaskAlarm);
        return true;
    }

    public JSONObject getFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        JSONObject nextObject = new JSONObject();
        JSONObject faceRecognition = this.getFaceCapture(obj, SdcMsgType.FACE_RECOGNITION_CONFIG_GET);
        JSONObject faceLibs = this.getFaceCapture(obj, SdcMsgType.ITGT_ALGINFO);
        JSONArray igtAlthmInfo = faceLibs.getJSONArray("igtAlthmInfo");
        for (int i = 0; i < igtAlthmInfo.size(); ++i) {
            JSONObject jsonObject = igtAlthmInfo.getJSONObject(i);
            if (jsonObject.getInteger("althmType") == 1) {
                nextObject.put("face_detect_module", (Object)jsonObject.getString("althmVer"));
            }
            if (jsonObject.getInteger("althmType") != 2) continue;
            nextObject.put("face_recognize_module", (Object)jsonObject.getString("althmVer"));
        }
        JSONObject featureSynergy = this.getFaceCapture(obj, SdcMsgType.FACE_FEATURESYNERGY_GET);
        nextObject.put("switch", (Object)(faceRecognition.getInteger("enable") == 1 ? 1 : 0));
        nextObject.put("alarmTime", (Object)faceRecognition.getInteger("alarmTime"));
        boolean isSupportSynergy = false;
        if (featureSynergy.containsKey((Object)"featureSynergyMode")) {
            isSupportSynergy = true;
        }
        nextObject.put("is_support_synergy", (Object)isSupportSynergy);
        nextObject.put("feature_usage_mode", (Object)featureSynergy.getInteger("featureSynergyMode"));
        JSONObject configRsp = new JSONObject();
        configRsp.put("config", (Object)nextObject);
        return configRsp;
    }

    public boolean setFaceRecognitionConfig(ParamBean<NormalIntelligentRequest> obj) {
        String channelCode = ((NormalIntelligentRequest)obj.getRequestBody()).getChannelCode();
        JSONObject config = ((NormalIntelligentRequest)obj.getRequestBody()).getConfig();
        JSONObject faceRecognition = new JSONObject();
        JSONObject featureSynergy = new JSONObject();
        faceRecognition.put("enable", (Object)(config.getBoolean("switch") != false ? 1 : 0));
        faceRecognition.put("alarmTime", (Object)1);
        featureSynergy.put("featureSynergyMode", (Object)config.getInteger("feature_usage_mode"));
        featureSynergy.put("featureSynergyEnable", (Object)(config.getBoolean("switch") != false ? 1 : 0));
        CameraPassThrouthRequestIvs1800 passFaceRecognition = new CameraPassThrouthRequestIvs1800();
        passFaceRecognition.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.FACE_RECOGNITION_CONFIG_SET.getUri());
        info.setParam(faceRecognition.toJSONString());
        passFaceRecognition.setInfo(info);
        CameraPassThrouthRequestIvs1800 passFeatureSynergy = new CameraPassThrouthRequestIvs1800();
        passFeatureSynergy.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoFeatureSynergy = new CameraPassThroughInfoIvs1800();
        infoFeatureSynergy.setRequestUrl("PUT " + SdcMsgType.FACE_FEATURESYNERGY_SET.getUri());
        infoFeatureSynergy.setParam(featureSynergy.toJSONString());
        passFeatureSynergy.setInfo(infoFeatureSynergy);
        this.cameraPass(obj, passFaceRecognition);
        this.cameraPass(obj, passFeatureSynergy);
        return true;
    }

    private JSONArray getCoordinate(JSONArray array) {
        JSONArray array1 = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject aObject = new JSONObject();
            JSONObject jsonObject = array.getJSONObject(i);
            aObject.put("x", (Object)(jsonObject.getInteger("x") * 2));
            aObject.put("y", (Object)(jsonObject.getInteger("y") * 2));
            array1.add((Object)aObject);
        }
        return array1;
    }

    private JSONArray setCoordinate(JSONArray array) {
        JSONArray array1 = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject aObject = new JSONObject();
            JSONObject jsonObject = array.getJSONObject(i);
            aObject.put("x", (Object)(jsonObject.getInteger("x") / 2));
            aObject.put("y", (Object)(jsonObject.getInteger("y") / 2));
            array1.add((Object)aObject);
        }
        return array1;
    }

    public SoundDetectionConfig get(VcmReqBaseInfo vcmInfo, SoundDetectionRequest soundDetectionRequest) {
        SoundDetectionConfig soundConfigConfig = new SoundDetectionConfig();
        JSONObject riseSwitchConfig = this.getConfigJson(vcmInfo, soundDetectionRequest.getChannelCode(), soundDetectionRequest.getNvrCode(), 100);
        JSONObject cameraAudioUpConfig = riseSwitchConfig.getJSONObject("cameraAudioUpConfig");
        soundConfigConfig.setRiseSwitch(Boolean.valueOf(cameraAudioUpConfig.getIntValue("enableAudioUp") == 1));
        soundConfigConfig.setRiseSensitivity(cameraAudioUpConfig.getIntValue("sensitivity"));
        JSONObject riseSwitchAlarmPlan = this.getSdcConfig(vcmInfo, soundDetectionRequest.getChannelCode(), ALARM_PASS_ALARM_URI + "audio_audioUp");
        SdcAlarmConfigRespond riseSwitchRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)riseSwitchAlarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List riseSwitchAlarmList = this.getBehaviorAlarmPlan(riseSwitchRespond);
        soundConfigConfig.setRiseAlarmPlanList(riseSwitchAlarmList);
        AlarmAudioAndLight riseAudioAndLight = this.getAudioAndLightAbility(vcmInfo, soundDetectionRequest.getChannelCode(), riseSwitchAlarmPlan);
        soundConfigConfig.setRiseAudioEnable(riseAudioAndLight.getAudioEnable());
        soundConfigConfig.setRiseAudioFile(riseAudioAndLight.getAudioFile());
        soundConfigConfig.setRiseAudioPlaybackTimes(riseAudioAndLight.getAudioPlaybackTimes());
        soundConfigConfig.setRiseWhiteLightIlluminatorEnable(riseAudioAndLight.getWhiteLightIllumEnable());
        soundConfigConfig.setRiseWhiteLightIlluminator(riseAudioAndLight.getWhiteLightIlluminator());
        soundConfigConfig.setRiseFlashDuration(riseAudioAndLight.getFlashDuration());
        JSONObject declineConfig = this.getConfigJson(vcmInfo, soundDetectionRequest.getChannelCode(), soundDetectionRequest.getNvrCode(), 101);
        JSONObject cameraAudioDownConfig = declineConfig.getJSONObject("cameraAudioDownConfig");
        soundConfigConfig.setDeclineSwitch(Boolean.valueOf(cameraAudioDownConfig.getIntValue("enableAudioDown") == 1));
        soundConfigConfig.setDeclineSensitivity(cameraAudioDownConfig.getIntValue("sensitivity"));
        JSONObject declineAlarmPlan = this.getSdcConfig(vcmInfo, soundDetectionRequest.getChannelCode(), ALARM_PASS_ALARM_URI + "audio_audioDown");
        SdcAlarmConfigRespond declineRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)declineAlarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List declineAlarmList = this.getBehaviorAlarmPlan(declineRespond);
        soundConfigConfig.setDeclineAlarmPlanList(declineAlarmList);
        AlarmAudioAndLight declineAudioAndLight = this.getAudioAndLightAbility(vcmInfo, soundDetectionRequest.getChannelCode(), declineAlarmPlan);
        soundConfigConfig.setDeclineAudioEnable(declineAudioAndLight.getAudioEnable());
        soundConfigConfig.setDeclineAudioFile(declineAudioAndLight.getAudioFile());
        soundConfigConfig.setDeclineAudioPlaybackTimes(declineAudioAndLight.getAudioPlaybackTimes());
        soundConfigConfig.setDeclineWhiteLightIlluminatorEnable(declineAudioAndLight.getWhiteLightIllumEnable());
        soundConfigConfig.setDeclineWhiteLightIlluminator(declineAudioAndLight.getWhiteLightIlluminator());
        soundConfigConfig.setDeclineFlashDuration(declineAudioAndLight.getFlashDuration());
        return soundConfigConfig;
    }

    public Boolean set(ParamBean<SoundDetectionRequest> obj) {
        SoundDetectionConfig config = ((SoundDetectionRequest)obj.getRequestBody()).getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAudioEnable(config.getRiseAudioEnable());
        audioAndLight.setAudioFile(config.getRiseAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getRiseAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getRiseWhiteLightIlluminatorEnable());
        audioAndLight.setWhiteLightIlluminator(config.getRiseWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getRiseFlashDuration());
        audioAndLight.setAlarmPlanList(config.getRiseAlarmPlanList());
        this.updateAlarmPlanTime(obj.getVcmInfo(), ((SoundDetectionRequest)obj.getRequestBody()).getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "audio_audioUp");
        audioAndLight.setAudioEnable(config.getDeclineAudioEnable());
        audioAndLight.setAudioFile(config.getDeclineAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getDeclineAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getDeclineWhiteLightIlluminatorEnable());
        audioAndLight.setWhiteLightIlluminator(config.getDeclineWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getDeclineFlashDuration());
        audioAndLight.setAlarmPlanList(config.getDeclineAlarmPlanList());
        this.updateAlarmPlanTime(obj.getVcmInfo(), ((SoundDetectionRequest)obj.getRequestBody()).getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "audio_audioDown");
        NormallConfigRequestIvs1800 normallConfigRequestIvs1800 = new NormallConfigRequestIvs1800();
        normallConfigRequestIvs1800.setDeviceCode(((SoundDetectionRequest)obj.getRequestBody()).getChannelCode());
        Boolean result = false;
        normallConfigRequestIvs1800.setConfigType(Integer.valueOf(100));
        NormallConfigRequestIvs1800.NormalDetectionInfo riseSwitchConfigInfo = new NormallConfigRequestIvs1800.NormalDetectionInfo();
        JSONObject riseSwitchConfig = new JSONObject();
        riseSwitchConfig.put("enableAudioUp", (Object)(config.getRiseSwitch() != false ? 1 : 0));
        riseSwitchConfig.put("sensitivity", (Object)config.getRiseSensitivity());
        riseSwitchConfigInfo.setCameraAudioUpConfig(riseSwitchConfig);
        normallConfigRequestIvs1800.setConfigItem(riseSwitchConfigInfo);
        Boolean bBoolean = this.setSoundDetection(obj, normallConfigRequestIvs1800);
        if (bBoolean.booleanValue()) {
            normallConfigRequestIvs1800.setConfigType(Integer.valueOf(101));
            NormallConfigRequestIvs1800.NormalDetectionInfo declineConfigInfo = new NormallConfigRequestIvs1800.NormalDetectionInfo();
            JSONObject declineConfig = new JSONObject();
            declineConfig.put("enableAudioDown", (Object)(config.getDeclineSwitch() != false ? 1 : 0));
            declineConfig.put("sensitivity", (Object)config.getDeclineSensitivity());
            declineConfigInfo.setCameraAudioDownConfig(declineConfig);
            normallConfigRequestIvs1800.setConfigItem(declineConfigInfo);
            result = this.setSoundDetection(obj, normallConfigRequestIvs1800);
        }
        return result;
    }

    private Boolean setSoundDetection(ParamBean<SoundDetectionRequest> obj, NormallConfigRequestIvs1800 request) {
        JSONObject jsonObject;
        try {
            jsonObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SET_DEVICE_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkJsonRespond(jsonObject);
        return true;
    }

    public SituationalConfigRespond getQueueDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        SituationalConfigRespond detectRespond = new SituationalConfigRespond();
        JSONObject config = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.CROWD_SITUATION_APP_GET.getUri());
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.toJSONString(), SdcQueueDetectConfigRespond.class);
        SdcQueueDetectConfigRespond sdcQueueDetectConfig = (SdcQueueDetectConfigRespond)operateBean.get();
        SdcQueueDetectConfigRespond.QueueDetectParamBean queueIvs1800 = sdcQueueDetectConfig.getQueueDetectParam();
        detectRespond.setAlarmThreshold(queueIvs1800.getTimeThreshold());
        detectRespond.setEnable(Boolean.valueOf(queueIvs1800.getEnable() == 1));
        detectRespond.setSensitivity(queueIvs1800.getSensitivity());
        detectRespond.setStayTime(queueIvs1800.getAverTimePerCapita());
        detectRespond.setTimingReportEnable(queueIvs1800.getTimingReportEnable());
        detectRespond.setTimingReportInterval(queueIvs1800.getReportTime());
        if (!CollectionUtils.isEmpty((Collection)queueIvs1800.getGuardAreaList().getArea())) {
            ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
            for (SdcAreanBean.AreaBean detectAreaInfo : queueIvs1800.getGuardAreaList().getArea()) {
                BehaviorAreaItemRespond areaItemRespond = new BehaviorAreaItemRespond();
                areaItemRespond.setPointNum(detectAreaInfo.getPointNum());
                detectAreaInfo.getPoint().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() * 2);
                    pointItem.setPointY(pointItem.getPointY() * 2);
                });
                areaItemRespond.setPointList(detectAreaInfo.getPoint());
                areaList.add(areaItemRespond);
            }
            detectRespond.setAreaList(areaList);
        }
        JSONObject alarmPlan = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), ALARM_PASS_ALARM_URI + "statistics_queueDetect");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmConfigRespond);
        detectRespond.setAlarmPlanList(alarmPlanList);
        detectRespond.setAlarmInterval(((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getSourceParam().getTime());
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(vcmInfo, queueDetectionRequest.getChannelCode(), alarmPlan);
        detectRespond.setAudioEnable(audioAndLightAbility.getAudioEnable());
        detectRespond.setAudioFile(audioAndLightAbility.getAudioFile());
        detectRespond.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        detectRespond.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        detectRespond.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        detectRespond.setFlashDuration(audioAndLightAbility.getFlashDuration());
        return detectRespond;
    }

    public Boolean setQueueDetect(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionRequest requestBody = (QueueDetectionRequest)obj.getRequestBody();
        SituationalConfigRespond config = requestBody.getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAlarmInterval(config.getAlarmInterval());
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        this.updateAlarmPlanTime(obj.getVcmInfo(), requestBody.getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "statistics_queueDetect");
        SdcQueueDetectConfigRespond sdcConfig = this.changeQueueDetectParameter(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.CROWD_SITUATION_APP_SET.getUri());
        info.setParam(JSON.toJSONString((Object)sdcConfig));
        passThrouthRequestIvs1800.setInfo(info);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800);
    }

    private SdcQueueDetectConfigRespond changeQueueDetectParameter(QueueDetectionRequest requestBody) {
        SituationalConfigRespond config = requestBody.getConfig();
        SdcQueueDetectConfigRespond queueDetectConfig = new SdcQueueDetectConfigRespond();
        SdcQueueDetectConfigRespond.QueueDetectParamBean queueDetectParam = new SdcQueueDetectConfigRespond.QueueDetectParamBean();
        queueDetectParam.setTimeThreshold(config.getAlarmThreshold());
        queueDetectParam.setEnable(Integer.valueOf(config.getEnable() != false ? 1 : 0));
        queueDetectParam.setSensitivity(config.getSensitivity());
        queueDetectParam.setAverTimePerCapita(config.getStayTime());
        queueDetectParam.setTimingReportEnable(config.getTimingReportEnable());
        queueDetectParam.setReportTime(config.getTimingReportInterval());
        SdcAreanBean guardAreaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)config.getAreaList())) {
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (BehaviorAreaItemRespond areaItem : config.getAreaList()) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaBean.setAreaName(areaItem.getAreaName());
                areaBean.setPointNum(Integer.valueOf(areaItem.getPointList().size()));
                areaItem.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItem.getPointList());
                area.add(areaBean);
            }
            guardAreaList.setArea(area);
        }
        queueDetectParam.setGuardAreaList(guardAreaList);
        queueDetectConfig.setQueueDetectParam(queueDetectParam);
        return queueDetectConfig;
    }

    private QueueDetectionRequestIvs1800 changeQueueDetectionParameter(QueueDetectionRequest requestBody) {
        QueueDetectionRequestIvs1800 requestIvs1800 = new QueueDetectionRequestIvs1800();
        SituationalConfigRespond config = requestBody.getConfig();
        requestIvs1800.setConfigType(Integer.valueOf(121));
        requestIvs1800.setDeviceCode(requestBody.getChannelCode());
        QueueDetectRespondIvs1800 respondIvs1800 = new QueueDetectRespondIvs1800();
        respondIvs1800.setTimingReportEnable(config.getTimingReportEnable().intValue());
        respondIvs1800.setTimingReportInterval(config.getTimingReportInterval().intValue());
        respondIvs1800.setEnableQD(config.getEnable() != false ? 1 : 0);
        respondIvs1800.setSensitivity(config.getSensitivity().intValue());
        respondIvs1800.setAlarmThreshold(config.getAlarmThreshold().intValue());
        respondIvs1800.setAverQueueTime(config.getStayTime().intValue());
        ArrayList<DetectArea> detectAreaInfos = new ArrayList<DetectArea>();
        if (!CollectionUtils.isEmpty((Collection)config.getAreaList())) {
            for (BehaviorAreaItemRespond areaItemRespond : config.getAreaList()) {
                DetectArea detectArea = new DetectArea();
                detectArea.setAreaName(areaItemRespond.getAreaName());
                detectArea.setEnable(0);
                detectArea.setPointsNum(areaItemRespond.getPointList().size());
                areaItemRespond.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                detectArea.setPoints(areaItemRespond.getPointList());
                detectAreaInfos.add(detectArea);
            }
            respondIvs1800.setDetectAreaNum(config.getAreaList().size());
        }
        respondIvs1800.setDetectAreaInfos(detectAreaInfos);
        requestIvs1800.setConfigItem(respondIvs1800);
        return requestIvs1800;
    }

    public SituationalConfigRespond getCrowdDensity(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        SituationalConfigRespond detectRespond = new SituationalConfigRespond();
        JSONObject config = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.CROWD_DENSITY_GET.getUri());
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.toJSONString(), SdcQueueDetectConfigRespond.class);
        SdcQueueDetectConfigRespond sdcConfig = (SdcQueueDetectConfigRespond)operateBean.get();
        SdcQueueDetectConfigRespond.QueueDetectParamBean queueIvs1800 = sdcConfig.getCrowdDensityParam();
        detectRespond.setAlarmThreshold(queueIvs1800.getPeopleNumThreshold());
        detectRespond.setEnable(Boolean.valueOf(queueIvs1800.getEnable() == 1));
        detectRespond.setSensitivity(queueIvs1800.getSensitivity());
        detectRespond.setTimingReportEnable(queueIvs1800.getTimingReportEnable());
        detectRespond.setTimingReportInterval(queueIvs1800.getReportTime());
        if (!CollectionUtils.isEmpty((Collection)queueIvs1800.getGuardAreaList().getArea())) {
            ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
            for (SdcAreanBean.AreaBean detectAreaInfo : queueIvs1800.getGuardAreaList().getArea()) {
                BehaviorAreaItemRespond areaItemRespond = new BehaviorAreaItemRespond();
                areaItemRespond.setPointNum(detectAreaInfo.getPointNum());
                detectAreaInfo.getPoint().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() * 2);
                    pointItem.setPointY(pointItem.getPointY() * 2);
                });
                areaItemRespond.setPointList(detectAreaInfo.getPoint());
                areaList.add(areaItemRespond);
            }
            detectRespond.setAreaList(areaList);
        }
        JSONObject alarmPlan = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), ALARM_PASS_ALARM_URI + "statistics_crowdDensity");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmConfigRespond);
        detectRespond.setAlarmPlanList(alarmPlanList);
        detectRespond.setAlarmInterval(((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getSourceParam().getTime());
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(vcmInfo, queueDetectionRequest.getChannelCode(), alarmPlan);
        detectRespond.setAudioEnable(audioAndLightAbility.getAudioEnable());
        detectRespond.setAudioFile(audioAndLightAbility.getAudioFile());
        detectRespond.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        detectRespond.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        detectRespond.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        detectRespond.setFlashDuration(audioAndLightAbility.getFlashDuration());
        return detectRespond;
    }

    public Boolean setCrowdDensity(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionRequest requestBody = (QueueDetectionRequest)obj.getRequestBody();
        SituationalConfigRespond config = requestBody.getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAlarmInterval(config.getAlarmInterval());
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        this.updateAlarmPlanTime(obj.getVcmInfo(), requestBody.getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "statistics_crowdDensity");
        SdcQueueDetectConfigRespond sdcConfig = this.changeCrowdDensityParameter(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.CROWD_DENSITY_SET.getUri());
        info.setParam(JSON.toJSONString((Object)sdcConfig));
        passThrouthRequestIvs1800.setInfo(info);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800);
    }

    private SdcQueueDetectConfigRespond changeCrowdDensityParameter(QueueDetectionRequest requestBody) {
        SituationalConfigRespond config = requestBody.getConfig();
        SdcQueueDetectConfigRespond sdcConfig = new SdcQueueDetectConfigRespond();
        SdcQueueDetectConfigRespond.QueueDetectParamBean crowdDensityParam = new SdcQueueDetectConfigRespond.QueueDetectParamBean();
        crowdDensityParam.setEnable(Integer.valueOf(config.getEnable() != false ? 1 : 0));
        crowdDensityParam.setPeopleNumThreshold(config.getAlarmThreshold());
        crowdDensityParam.setSensitivity(config.getSensitivity());
        crowdDensityParam.setTimingReportEnable(config.getTimingReportEnable());
        crowdDensityParam.setReportTime(config.getTimingReportInterval());
        SdcAreanBean guardAreaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)config.getAreaList())) {
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (BehaviorAreaItemRespond areaItem : config.getAreaList()) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaBean.setPointNum(Integer.valueOf(areaItem.getPointList().size()));
                areaItem.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItem.getPointList());
                areaBean.setAreaName(areaItem.getAreaName());
                area.add(areaBean);
            }
            guardAreaList.setArea(area);
        }
        crowdDensityParam.setGuardAreaList(guardAreaList);
        sdcConfig.setCrowdDensityParam(crowdDensityParam);
        return sdcConfig;
    }

    public JSONObject getThirdPartyAlgorithm(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        return null;
    }

    public Boolean setThirdPartyAlgorithm(ParamBean<QueueDetectionRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        SituationalConfigRespond situationalConfigRespond = new SituationalConfigRespond();
        JSONObject config = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.CROWD_SITUATION_CROSS_COUNTING_GET.getUri());
        Optional operateBean = JsonUtil.convertJsonToBean((String)config.toJSONString(), SdcCrossCountingConfigRespond.class);
        SdcCrossCountingConfigRespond sdcRespond = (SdcCrossCountingConfigRespond)operateBean.get();
        SdcCrossCountingConfigRespond.AlgParamsBean algParams = sdcRespond.getAlgParams();
        situationalConfigRespond.setAlarmInterval(algParams.getAutoClearAlarmTime());
        situationalConfigRespond.setClearAtZero(Boolean.valueOf(algParams.getClearAtZero() == 1));
        situationalConfigRespond.setAlarmHumanNumber(algParams.getAlarmTargetNum());
        situationalConfigRespond.setEnable(Boolean.valueOf(algParams.getEnable() == 1));
        situationalConfigRespond.setTimingReportEnable(algParams.getTimingReportEnable());
        situationalConfigRespond.setTimingReportInterval(algParams.getReportTime());
        situationalConfigRespond.setSensitivity(algParams.getSensitivity());
        ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
        if (sdcRespond.getGuardAreaList().getAreaNum() != 0) {
            SdcAreanBean guardAreaList = sdcRespond.getGuardAreaList();
            for (SdcAreanBean.AreaBean sdcAreaBean : guardAreaList.getArea()) {
                BehaviorAreaItemRespond areaItem = new BehaviorAreaItemRespond();
                areaItem.setPointNum(sdcAreaBean.getPointNum());
                sdcAreaBean.getPoint().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() * 2);
                    pointItem.setPointY(pointItem.getPointY() * 2);
                });
                areaItem.setPointList(sdcAreaBean.getPoint());
                areaList.add(areaItem);
            }
        }
        situationalConfigRespond.setAreaList(areaList);
        ArrayList<BehaviorLineItemRespond> lineList = new ArrayList<BehaviorLineItemRespond>();
        SdcCrossCountingConfigRespond.AlgParamsBean.RefLineBean refLine = sdcRespond.getAlgParams().getRefLine();
        if (refLine.getStartPoint().getPosX() != 0 && refLine.getStartPoint().getPosY() != 0 && refLine.getEndPoint().getPosX() != 0 && refLine.getEndPoint().getPosY() != 0) {
            BehaviorLineItemRespond behaviorLineItemRespond = new BehaviorLineItemRespond();
            behaviorLineItemRespond.setX1(refLine.getStartPoint().getPosX() * 2);
            behaviorLineItemRespond.setY1(refLine.getStartPoint().getPosY() * 2);
            behaviorLineItemRespond.setX2(refLine.getEndPoint().getPosX() * 2);
            behaviorLineItemRespond.setY2(refLine.getEndPoint().getPosY() * 2);
            behaviorLineItemRespond.setRuleType(this.changeRuleType(algParams.getInDirection()));
            lineList.add(behaviorLineItemRespond);
        }
        situationalConfigRespond.setLineList(lineList);
        JSONObject alarmPlan = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), ALARM_PASS_ALARM_URI + "statistics_humanCount");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmConfigRespond);
        situationalConfigRespond.setAlarmPlanList(alarmPlanList);
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(vcmInfo, queueDetectionRequest.getChannelCode(), alarmPlan);
        situationalConfigRespond.setAudioEnable(audioAndLightAbility.getAudioEnable());
        situationalConfigRespond.setAudioFile(audioAndLightAbility.getAudioFile());
        situationalConfigRespond.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        situationalConfigRespond.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        situationalConfigRespond.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        situationalConfigRespond.setFlashDuration(audioAndLightAbility.getFlashDuration());
        return situationalConfigRespond;
    }

    private AlarmAudioAndLight getAudioAndLightAbility(VcmReqBaseInfo vcmInfo, String channelCode, JSONObject alarmPlan) {
        List linkageStrategiesList;
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        JSONObject audio = this.getSdcConfig(vcmInfo, channelCode, SdcMsgType.AUDIO_IAAS_CAPABILITY.getUri());
        JSONObject light = this.getSdcConfig(vcmInfo, channelCode, SdcMsgType.ALARM_PASS.getUri());
        JSONObject action = light.getJSONObject("action");
        boolean isHavaAudio = false;
        boolean isHavaLight = false;
        if (audio.containsKey((Object)"isSupportAudioFile") && audio.getBoolean("isSupportAudioFile").booleanValue()) {
            if (((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction() != null) {
                linkageStrategiesList = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
                for (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies linkageStrategies : linkageStrategiesList) {
                    if ("audios".equals(linkageStrategies.getName())) {
                        isHavaAudio = true;
                    }
                    if (!"twinkle".equals(linkageStrategies.getName())) continue;
                    isHavaLight = true;
                }
                if (isHavaAudio) {
                    SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies strategies = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)linkageStrategiesList.stream().filter(audioParam -> "audios".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                    audioAndLight.setAudioEnable(Boolean.valueOf(true));
                    audioAndLight.setAudioFile(this.getAudioStringInfo(strategies.getParam().getParam(), Integer.valueOf(0)));
                    audioAndLight.setAudioPlaybackTimes(Integer.valueOf(this.getAudioStringInfo(strategies.getParam().getParam(), Integer.valueOf(1))));
                } else {
                    audioAndLight.setAudioEnable(Boolean.valueOf(false));
                }
            } else {
                audioAndLight.setAudioEnable(Boolean.valueOf(false));
            }
        }
        if (action.containsKey((Object)"isSupportTwinkleaction") && action.getBoolean("isSupportTwinkleaction").booleanValue()) {
            if (((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction() != null) {
                linkageStrategiesList = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
                if (isHavaLight) {
                    SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies twinkle = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)linkageStrategiesList.stream().filter(audioParam -> "twinkle".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                    audioAndLight.setWhiteLightIllumEnable(Boolean.valueOf(true));
                    audioAndLight.setWhiteLightIlluminator(this.changeLightIlluminator(twinkle.getParam().getName()));
                    audioAndLight.setFlashDuration(Integer.valueOf(this.getLightStringInfo(twinkle.getParam().getParam())));
                } else {
                    audioAndLight.setWhiteLightIllumEnable(Boolean.valueOf(false));
                }
            } else {
                audioAndLight.setWhiteLightIllumEnable(Boolean.valueOf(false));
            }
        }
        return audioAndLight;
    }

    private String getAudioStringInfo(String param, Integer index) {
        String[] split = param.split(";");
        String[] split1 = split[index].split("=");
        String audio = split1[1];
        Base64.Decoder decoder = Base64.getDecoder();
        return new String(decoder.decode(audio), StandardCharsets.UTF_8);
    }

    private String getLightStringInfo(String param) {
        String[] split1 = param.split("=");
        String light = split1[1];
        Base64.Decoder decoder = Base64.getDecoder();
        return new String(decoder.decode(light), StandardCharsets.UTF_8);
    }

    private String changeLightIlluminator(String param) {
        String Nvr800 = null;
        switch (param) {
            case "lowfre": {
                Nvr800 = "Low";
                break;
            }
            case "midfre": {
                Nvr800 = "Medium";
                break;
            }
            case "highfre": {
                Nvr800 = "High";
                break;
            }
            case "lightfre": {
                Nvr800 = "Steady on";
            }
        }
        return Nvr800;
    }

    private List<BehaviorAlarmPlanItemRespond> getBehaviorAlarmPlan(SdcAlarmConfigRespond alarmConfigRespond) {
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam;
        ArrayList<BehaviorAlarmPlanItemRespond> behaviorAlarmPlanItemResponds = new ArrayList<BehaviorAlarmPlanItemRespond>();
        List alarmParam = alarmConfigRespond.getAlarmParam();
        if (!CollectionUtils.isEmpty((Collection)alarmParam) && !CollectionUtils.isEmpty((Collection)(sdcAlarmParam = (SdcAlarmConfigRespond.SdcAlarmParam)alarmParam.get(0)).getGuardTime())) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            for (SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardAlarmTime : sdcAlarmParam.getGuardTime()) {
                BehaviorAlarmPlanItemRespond behaviorAlarmPlanItem = new BehaviorAlarmPlanItemRespond();
                behaviorAlarmPlanItem.setStartTime(format.format(guardAlarmTime.getStartTime() * 1000));
                behaviorAlarmPlanItem.setEndTime(format.format((guardAlarmTime.getEndTime() == 86400 ? 86399 : guardAlarmTime.getEndTime()) * 1000));
                behaviorAlarmPlanItem.setCycleType(guardAlarmTime.getCycle().intValue());
                Integer newPeriod = this.changePeriod(guardAlarmTime.getPeriod());
                behaviorAlarmPlanItem.setPeriod(newPeriod == null ? 0 : newPeriod);
                behaviorAlarmPlanItem.setStartDate(LocalDate.now() + "");
                behaviorAlarmPlanItemResponds.add(behaviorAlarmPlanItem);
            }
            return behaviorAlarmPlanItemResponds;
        }
        return new ArrayList<BehaviorAlarmPlanItemRespond>();
    }

    private JSONObject getSdcConfig(VcmReqBaseInfo vcmInfo, String channelCode, String configSdcType) {
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + configSdcType);
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthInfo(vcmInfo, passThrouthRequestIvs1800);
    }

    private JSONObject cameraPassThrouthInfo(VcmReqBaseInfo vcmInfo, CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getString("Data").startsWith("[")) {
                return (JSONObject)returnJson.getJSONArray("Data").get(0);
            }
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                return returnJson.getJSONObject("Data");
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private boolean cameraPassThrouthResult(VcmReqBaseInfo vcmInfo, CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (jsonArray.get(0) == null) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            LOGGER.debug("set config from sdk is end.");
            if (returnJson.getInteger("RspCode") == 0 && returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 0) {
                LOGGER.debug("set config end..");
                return true;
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean setCrossCounting(ParamBean<QueueDetectionRequest> obj) {
        QueueDetectionRequest requestBody = (QueueDetectionRequest)obj.getRequestBody();
        SituationalConfigRespond config = requestBody.getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAlarmInterval(config.getAlarmInterval());
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        this.updateAlarmPlanTime(obj.getVcmInfo(), ((QueueDetectionRequest)obj.getRequestBody()).getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "statistics_humanCount");
        SdcCrossCountingConfigRespond sdcConfig = this.changeCrossCountingParameter(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.CROWD_SITUATION_CROSS_COUNTING_SET.getUri());
        info.setParam(JSON.toJSONString((Object)sdcConfig));
        passThrouthRequestIvs1800.setInfo(info);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800);
    }

    private boolean updateAlarmPlanTime(VcmReqBaseInfo vcmReqBaseInfom, String channelCode, AlarmAudioAndLight requestBody, String uri) {
        SdcAlarmConfigRespond sdcAlarmConfigRespond = new SdcAlarmConfigRespond();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam> alarmParam = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam>();
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam = new SdcAlarmConfigRespond.SdcAlarmParam();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime> guardTimes = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime>();
        if (!CollectionUtils.isEmpty((Collection)requestBody.getAlarmPlanList())) {
            for (BehaviorAlarmPlanItemRespond alarmPlanItem : requestBody.getAlarmPlanList()) {
                SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardTime = new SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime();
                guardTime.setStartTime(this.changeTimeToInteger(alarmPlanItem.getStartTime()));
                guardTime.setEndTime(this.changeTimeToInteger(alarmPlanItem.getEndTime()));
                guardTime.setCycle(Integer.valueOf(alarmPlanItem.getCycleType()));
                Integer period = alarmPlanItem.getPeriod();
                guardTime.setPeriod(this.changePeriodToIvs(period));
                guardTime.setEnable(Integer.valueOf(1));
                guardTimes.add(guardTime);
            }
        }
        boolean isAlarmAction = false;
        boolean isHavaAudio = false;
        boolean isHavaLight = false;
        JSONObject alarmPlan = this.getSdcConfig(vcmReqBaseInfom, channelCode, uri);
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List<Object> action = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction())) {
            isAlarmAction = true;
        } else {
            action = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
            for (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies linkageStrategies : action) {
                if ("audios".equals(linkageStrategies.getName())) {
                    isHavaAudio = true;
                }
                if (!"twinkle".equals(linkageStrategies.getName())) continue;
                isHavaLight = true;
            }
        }
        if (requestBody.getAudioEnable() != null && requestBody.getAudioEnable().booleanValue()) {
            SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies audio;
            if (isAlarmAction) {
                audio = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                audio.setDesc("");
                audio.setName("audios");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
                paramBean.setName("audios");
                audio.setParam(paramBean);
                action.add(audio);
            } else if (isHavaAudio) {
                audio = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)action.stream().filter(audioParam -> "audios".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                audio.getParam().setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
            } else {
                audio = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                audio.setDesc("");
                audio.setName("audios");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
                paramBean.setName("audios");
                audio.setParam(paramBean);
                action.add(audio);
            }
        } else if (isHavaAudio) {
            action = action.stream().filter(audioParam -> !"audios".equals(audioParam.getName())).collect(Collectors.toList());
        }
        if (requestBody.getWhiteLightIllumEnable() != null && requestBody.getWhiteLightIllumEnable().booleanValue()) {
            SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies light;
            if (isAlarmAction) {
                light = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                light.setName("twinkle");
                light.setDesc("");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                paramBean.setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
                light.setParam(paramBean);
                action.add(light);
            } else if (isHavaLight) {
                light = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)action.stream().filter(audioParam -> "twinkle".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                light.getParam().setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                light.getParam().setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
            } else {
                light = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                light.setName("twinkle");
                light.setDesc("");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                paramBean.setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
                light.setParam(paramBean);
                action.add(light);
            }
        } else if (isHavaLight) {
            action = action.stream().filter(audioParam -> !"twinkle".equals(audioParam.getName())).collect(Collectors.toList());
        }
        sdcAlarmParam.setAction(action);
        SdcAlarmConfigRespond.SdcAlarmParam.SourceParam sourceParam = new SdcAlarmConfigRespond.SdcAlarmParam.SourceParam();
        sourceParam.setTime(requestBody.getAlarmInterval());
        sdcAlarmParam.setSourceParam(sourceParam);
        sdcAlarmParam.setGuardTime(guardTimes);
        alarmParam.add(sdcAlarmParam);
        sdcAlarmConfigRespond.setAlarmParam(alarmParam);
        CameraPassThrouthRequestIvs1800 cameraPassThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        cameraPassThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + uri);
        infoIvs1800.setParam(JSON.toJSONString((Object)sdcAlarmConfigRespond));
        cameraPassThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(vcmReqBaseInfom, cameraPassThrouthRequestIvs1800);
    }

    private String getAudioBase64(String audioFile, String audioPlaybackTimes) {
        StringBuilder param = new StringBuilder();
        String audioFileBase64 = Base64.getEncoder().encodeToString(audioFile.getBytes(StandardCharsets.UTF_8));
        String audioPlaybackTimesBase64 = Base64.getEncoder().encodeToString(audioPlaybackTimes.getBytes(StandardCharsets.UTF_8));
        param.append("audios=").append(audioFileBase64).append(";").append("audiocount=").append(audioPlaybackTimesBase64);
        return param.toString();
    }

    private String getLightBase64(String audioFile) {
        StringBuilder param = new StringBuilder();
        String audioFileBase64 = Base64.getEncoder().encodeToString(audioFile.getBytes(StandardCharsets.UTF_8));
        param.append("time=").append(audioFileBase64);
        return param.toString();
    }

    private String changeLightIlluminatorToSdc(String param) {
        String SdcParam = null;
        switch (param) {
            case "Low": {
                SdcParam = "lowfre";
                break;
            }
            case "Medium": {
                SdcParam = "midfre";
                break;
            }
            case "High": {
                SdcParam = "highfre";
                break;
            }
            case "Steady on": {
                SdcParam = "lightfre";
            }
        }
        return SdcParam;
    }

    private Integer changePeriod(Integer period) {
        Integer newPeriod = null;
        switch (period) {
            case 127: {
                newPeriod = 0;
                break;
            }
            case 1: {
                newPeriod = 1;
                break;
            }
            case 2: {
                newPeriod = 2;
                break;
            }
            case 4: {
                newPeriod = 3;
                break;
            }
            case 8: {
                newPeriod = 4;
                break;
            }
            case 16: {
                newPeriod = 5;
                break;
            }
            case 32: {
                newPeriod = 6;
                break;
            }
            case 64: {
                newPeriod = 7;
            }
        }
        return newPeriod;
    }

    private String changeRuleType(Integer inDirection) {
        String ruleType = null;
        switch (inDirection) {
            case 0: {
                ruleType = "B->A";
                break;
            }
            case 1: {
                ruleType = "A->B";
            }
        }
        return ruleType;
    }

    private Integer changeRuleTypeToInt(String inDirection) {
        Integer ruleType = null;
        switch (inDirection) {
            case "B->A": {
                ruleType = 0;
                break;
            }
            case "A->B": {
                ruleType = 1;
            }
        }
        return ruleType;
    }

    private Integer changeTimeToInteger(String startTime) {
        String[] split = startTime.split(":");
        Integer integer = Integer.parseInt(split[0]) * 3600;
        integer = integer + Integer.parseInt(split[1]) * 60;
        integer = integer + Integer.parseInt(split[2]);
        return integer;
    }

    private Integer changePeriodToIvs(Integer period) {
        Integer newPeriod = null;
        switch (period) {
            case 0: {
                newPeriod = 127;
                break;
            }
            case 1: {
                newPeriod = 1;
                break;
            }
            case 2: {
                newPeriod = 2;
                break;
            }
            case 3: {
                newPeriod = 4;
                break;
            }
            case 4: {
                newPeriod = 8;
                break;
            }
            case 5: {
                newPeriod = 16;
                break;
            }
            case 6: {
                newPeriod = 32;
                break;
            }
            case 7: {
                newPeriod = 64;
            }
        }
        return newPeriod;
    }

    public Boolean setHeatMapConfig(ParamBean<HeatMapConfigRequest> obj) {
        HeatMapConfigRequest requestBody = (HeatMapConfigRequest)obj.getRequestBody();
        HeatMapConfigRespond config = requestBody.getConfig();
        JSONObject UUIDJson = this.getSdcConfig(obj.getVcmInfo(), requestBody.getChannelCode(), SdcMsgType.CNS_PAAS_GET.getUri());
        JSONArray cnsChnParam = UUIDJson.getJSONArray("CnsChnParam");
        JSONObject UUID2 = (JSONObject)cnsChnParam.get(0);
        String uuid = UUID2.getString("uuid");
        JSONObject ptzLocation = this.getSdcConfig(obj.getVcmInfo(), ((HeatMapConfigRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.HEAT_MAP_GET.getUri() + "?UUID=" + UUID2.getString("uuid"));
        Optional operateBean = JsonUtil.convertJsonToBean((String)ptzLocation.toJSONString(), SdcHeatMapConfigRespond.class);
        SdcHeatMapConfigRespond sdcHeatMapConfigRespond = (SdcHeatMapConfigRespond)operateBean.get();
        sdcHeatMapConfigRespond.setUUID(uuid);
        SdcHeatMapConfigRespond sdcConfig = this.changeHeatMapParameter(requestBody, sdcHeatMapConfigRespond);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + SdcMsgType.HEAT_MAP_SET.getUri());
        info.setParam(JSON.toJSONString((Object)sdcConfig));
        passThrouthRequestIvs1800.setInfo(info);
        this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800);
        if (config.getEnable().booleanValue()) {
            this.updateHeatMapTime(obj.getVcmInfo(), ((HeatMapConfigRequest)obj.getRequestBody()).getChannelCode(), config, uuid, SdcMsgType.HEAT_MAP_GUARD_PLAN_SET.getUri());
        }
        return true;
    }

    private boolean updateHeatMapTime(VcmReqBaseInfo vcmInfo, String channelCode, HeatMapConfigRespond config, String uuid, String heatMapGuardPlanSet) {
        SdcHeatMapConfigRespond heatMapConfigRespond = new SdcHeatMapConfigRespond();
        heatMapConfigRespond.setUUID(uuid);
        ArrayList<SdcHeatMapConfigRespond.HotMapTimes> heatMapGuardPlan = new ArrayList<SdcHeatMapConfigRespond.HotMapTimes>();
        if (!CollectionUtils.isEmpty((Collection)config.getAlarmPlanList())) {
            int i = 0;
            for (Object o : config.getAlarmPlanList()) {
                JSONArray alamPlan = JSON.parseArray((String)JSONObject.toJSONString(o));
                SdcHeatMapConfigRespond.HotMapTimes hotMapTimes = new SdcHeatMapConfigRespond.HotMapTimes();
                hotMapTimes.setWeekDay(i++);
                if (alamPlan != null) {
                    ArrayList<SdcHeatMapConfigRespond.HotMapTimes.DayPlans> dayPlans = new ArrayList<SdcHeatMapConfigRespond.HotMapTimes.DayPlans>();
                    for (Object o1 : alamPlan) {
                        JSONObject time = (JSONObject)o1;
                        SdcHeatMapConfigRespond.HotMapTimes.DayPlans dayPlan = new SdcHeatMapConfigRespond.HotMapTimes.DayPlans();
                        dayPlan.setStartTime(time.getInteger("start_time"));
                        dayPlan.setEndTime(time.getInteger("end_time"));
                        dayPlans.add(dayPlan);
                    }
                    hotMapTimes.setTimePlanPerDay(dayPlans);
                }
                heatMapGuardPlan.add(hotMapTimes);
            }
        }
        heatMapConfigRespond.setHeatMapGuardPlan(heatMapGuardPlan);
        CameraPassThrouthRequestIvs1800 requestIvs1800 = new CameraPassThrouthRequestIvs1800();
        requestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 info = new CameraPassThroughInfoIvs1800();
        info.setRequestUrl("PUT " + heatMapGuardPlanSet);
        info.setParam(JSON.toJSONString((Object)heatMapConfigRespond));
        requestIvs1800.setInfo(info);
        return this.cameraPassThrouthResult(vcmInfo, requestIvs1800);
    }

    private SdcHeatMapConfigRespond changeHeatMapParameter(HeatMapConfigRequest requestBody, SdcHeatMapConfigRespond sdcConfig) {
        HeatMapConfigRespond config = requestBody.getConfig();
        SdcHeatMapConfigRespond heatMapConfigRespond = new SdcHeatMapConfigRespond();
        heatMapConfigRespond.setUUID(sdcConfig.getUUID());
        SdcHeatMapConfigRespond.HeatMapParaBean heatMapPara = new SdcHeatMapConfigRespond.HeatMapParaBean();
        heatMapPara.setPtzLocation(sdcConfig.getHeatMapPara().getPtzLocation());
        heatMapPara.setEnable(config.getEnable() != false ? 1 : 0);
        heatMapPara.setIsSendMeta(config.getMetaDataSwitch() != false ? 1 : 0);
        SdcAreanBean guardAreaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)config.getAreaList())) {
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (BehaviorAreaItemRespond areaItem : config.getAreaList()) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaBean.setIndex(areaItem.getIndex());
                areaBean.setEnable(Integer.valueOf(1));
                areaBean.setAreaName(areaItem.getAreaName());
                areaItem.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItem.getPointList());
                areaBean.setPointNum(Integer.valueOf(areaItem.getPointList().size()));
                area.add(areaBean);
            }
            guardAreaList.setArea(area);
        }
        heatMapPara.setGuardAreaList(guardAreaList);
        heatMapConfigRespond.setHeatMapPara(heatMapPara);
        return heatMapConfigRespond;
    }

    private SdcCrossCountingConfigRespond changeCrossCountingParameter(QueueDetectionRequest requestBody) {
        SituationalConfigRespond config = requestBody.getConfig();
        SdcCrossCountingConfigRespond configRequestIvs1800 = new SdcCrossCountingConfigRespond();
        SdcCrossCountingConfigRespond.AlgParamsBean algParam = new SdcCrossCountingConfigRespond.AlgParamsBean();
        algParam.setEnable(Integer.valueOf(config.getEnable() != false ? 1 : 0));
        algParam.setClearAtZero(Integer.valueOf(config.getClearAtZero() != false ? 1 : 0));
        algParam.setSensitivity(config.getSensitivity());
        algParam.setAutoClearAlarmTime(config.getAlarmInterval());
        algParam.setAlarmTargetNum(config.getAlarmHumanNumber());
        SdcCrossCountingConfigRespond.AlgParamsBean.RefLineBean refLine = new SdcCrossCountingConfigRespond.AlgParamsBean.RefLineBean();
        if (!CollectionUtils.isEmpty((Collection)config.getLineList())) {
            for (BehaviorLineItemRespond lineItemRespond : config.getLineList()) {
                algParam.setInDirection(this.changeRuleTypeToInt(lineItemRespond.getRuleType()));
                OsdLocation pointItemStart = new OsdLocation();
                pointItemStart.setPosX(lineItemRespond.getX1() / 2);
                pointItemStart.setPosY(lineItemRespond.getY1() / 2);
                refLine.setStartPoint(pointItemStart);
                OsdLocation pointItemEnd = new OsdLocation();
                pointItemEnd.setPosX(lineItemRespond.getX2() / 2);
                pointItemEnd.setPosY(lineItemRespond.getY2() / 2);
                refLine.setEndPoint(pointItemEnd);
            }
        }
        algParam.setRefLine(refLine);
        algParam.setTimingReportEnable(config.getTimingReportEnable());
        algParam.setReportTime(config.getTimingReportInterval());
        configRequestIvs1800.setAlgParams(algParam);
        SdcAreanBean guardAreaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)config.getAreaList())) {
            guardAreaList.setAreaNum(Integer.valueOf(config.getAreaList().size()));
            List areaList = config.getAreaList();
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (BehaviorAreaItemRespond areaItemRespond : areaList) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaItemRespond.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItemRespond.getPointList());
                area.add(areaBean);
            }
            guardAreaList.setArea(area);
        }
        configRequestIvs1800.setGuardAreaList(guardAreaList);
        return configRequestIvs1800;
    }

    public JSONObject clearCrossCounting(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        JSONObject object = new JSONObject();
        object.put("deviceCode", (Object)queueDetectionRequest.getChannelCode());
        try {
            JSONObject jsonObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.CLEAR_HUMANCOUNT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)object, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (jsonObject.getInteger("resultCode") == 0) {
                JSONObject retJson = new JSONObject();
                retJson.put("result", (Object)"success");
                return retJson;
            }
        }
        catch (SDKException e) {
            LOGGER.error("Clear CrossCounting fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return null;
    }

    public HeatMapConfigRespond getHeatMapConfig(VcmReqBaseInfo vcmInfo, QueueDetectionRequest queueDetectionRequest) {
        JSONObject UUIDJson = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.CNS_PAAS_GET.getUri());
        JSONArray cnsChnParam = UUIDJson.getJSONArray("CnsChnParam");
        JSONObject UUID2 = (JSONObject)cnsChnParam.get(0);
        JSONObject sdcConfig = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.HEAT_MAP_GET.getUri() + "?UUID=" + UUID2.getString("uuid"));
        Optional operateBean = JsonUtil.convertJsonToBean((String)sdcConfig.toJSONString(), SdcHeatMapConfigRespond.class);
        SdcHeatMapConfigRespond heatMapConfig1800 = (SdcHeatMapConfigRespond)operateBean.get();
        SdcHeatMapConfigRespond.HeatMapParaBean heatMapPara = heatMapConfig1800.getHeatMapPara();
        HeatMapConfigRespond heatMapConfigRespond = new HeatMapConfigRespond();
        heatMapConfigRespond.setEnable(Boolean.valueOf(heatMapPara.getEnable() == 1));
        heatMapConfigRespond.setMetaDataSwitch(Boolean.valueOf(heatMapPara.getIsSendMeta() == 1));
        ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)heatMapPara.getGuardAreaList().getArea())) {
            for (SdcAreanBean.AreaBean detectAreaInfo : heatMapPara.getGuardAreaList().getArea()) {
                BehaviorAreaItemRespond areaItemRespond = new BehaviorAreaItemRespond();
                areaItemRespond.setIndex(detectAreaInfo.getIndex());
                areaItemRespond.setPointNum(detectAreaInfo.getPointNum());
                areaItemRespond.setEnable(Boolean.valueOf(detectAreaInfo.getEnable() == 1));
                areaItemRespond.setAreaName(detectAreaInfo.getAreaName());
                ArrayList<PointItem> pointList = new ArrayList<PointItem>();
                for (PointItem point : detectAreaInfo.getPoint()) {
                    PointItem pointItem = new PointItem();
                    pointItem.setPointX(point.getPointX() * 2);
                    pointItem.setPointY(point.getPointY() * 2);
                    pointList.add(pointItem);
                }
                areaItemRespond.setPointList(pointList);
                areaList.add(areaItemRespond);
            }
        }
        heatMapConfigRespond.setAreaList(areaList);
        JSONObject sdcHeatMapConfig = this.getSdcConfig(vcmInfo, queueDetectionRequest.getChannelCode(), SdcMsgType.HEAT_MAP_GUARD_PLAN_GET.getUri() + "?UUID=" + UUID2.getString("uuid"));
        Optional optional = JsonUtil.convertJsonToBean((String)sdcHeatMapConfig.toJSONString(), SdcHeatMapConfigRespond.class);
        SdcHeatMapConfigRespond sdcHeatMapConfigRespond = (SdcHeatMapConfigRespond)optional.get();
        ArrayList hotMapTimeList = new ArrayList(7);
        for (int i = 0; i < 7; ++i) {
            hotMapTimeList.add(i, new ArrayList());
        }
        if (!CollectionUtils.isEmpty((Collection)sdcHeatMapConfigRespond.getHeatMapGuardPlan())) {
            for (SdcHeatMapConfigRespond.HotMapTimes hotMapTime : sdcHeatMapConfigRespond.getHeatMapGuardPlan()) {
                ArrayList<JSONObject> dayPlans = new ArrayList<JSONObject>();
                if (CollectionUtils.isEmpty((Collection)hotMapTime.getTimePlanPerDay())) continue;
                for (SdcHeatMapConfigRespond.HotMapTimes.DayPlans dayPlan : hotMapTime.getTimePlanPerDay()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("start_time", (Object)dayPlan.getStartTime());
                    jsonObject.put("end_time", (Object)dayPlan.getEndTime());
                    dayPlans.add(jsonObject);
                }
                hotMapTimeList.set(hotMapTime.getWeekDay(), dayPlans);
            }
            heatMapConfigRespond.setAlarmPlanList(JSONArray.parseArray((String)JSON.toJSONString(hotMapTimeList)));
        }
        return heatMapConfigRespond;
    }

    private JSONObject getConfigJson(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode, String nvrCode, int type) {
        JSONObject respondIvs1800;
        String url = "/device/deviceconfig/" + type + "/" + cameraCode + "/" + nvrCode;
        try {
            respondIvs1800 = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkJsonRespond(respondIvs1800);
        return respondIvs1800;
    }

    private ConfigRespondIvs1800 getConfig(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode, String nvrCode, int type) {
        ConfigRespondIvs1800 respondIvs1800;
        String url = "/device/deviceconfig/" + type + "/" + cameraCode + "/" + nvrCode;
        try {
            respondIvs1800 = (ConfigRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ConfigRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        return respondIvs1800;
    }

    public RepeatVisitorGetRespond getRepeatVisitor(ParamBean<RepeatVisitorRequest> obj) {
        return null;
    }

    public SituationalConfigRespond getLeaveDetect(VcmReqBaseInfo vcmInfo, QueueDetectionRequest requestBody) {
        SituationalConfigRespond leaveDetectRespond = new SituationalConfigRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("cameraCode", requestBody.getChannelCode());
        JSONObject situationalConfig = this.getConfigJson(vcmInfo, requestBody.getChannelCode(), null, 123);
        Optional operateBean = JsonUtil.convertJsonToBean((String)situationalConfig.getJSONObject("configItem").getJSONObject("cameraLeaveDetectConfig").toJSONString(), LeaveDetectRespondIvs1800.class);
        if (!operateBean.isPresent()) {
            throw new InvokeException("500", "cu_device_not_return");
        }
        LeaveDetectRespondIvs1800 respond = (LeaveDetectRespondIvs1800)operateBean.get();
        leaveDetectRespond.setLeavetime(respond.getLeaveDurationTime());
        leaveDetectRespond.setEnable(Boolean.valueOf(respond.getEnable() == 1));
        leaveDetectRespond.setAlarmOsdEnable(Boolean.valueOf(respond.getAlarmOsdEnable() == 1));
        leaveDetectRespond.setOnDutyNum(respond.getOnDutyNum());
        if (Objects.nonNull(respond.getGuardAreaList())) {
            ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
            if (!CollectionUtils.isEmpty((Collection)respond.getGuardAreaList().getArea())) {
                for (AreaList.Area areaBean : respond.getGuardAreaList().getArea()) {
                    BehaviorAreaItemRespond areaItem = new BehaviorAreaItemRespond();
                    ArrayList pointList = new ArrayList();
                    areaBean.getPoint().forEach(a -> {
                        PointItem pointItem = new PointItem();
                        pointItem.setPointX(a.getPointX() * 2);
                        pointItem.setPointY(a.getPointY() * 2);
                        pointList.add(pointItem);
                    });
                    areaItem.setIndex(areaBean.getIndex());
                    areaItem.setPointList(pointList);
                    areaItem.setAreaName(areaBean.getAreaName());
                    areaItem.setEnable(Boolean.valueOf(areaBean.getEnable() == 1));
                    areaItem.setPointNum(Integer.valueOf(areaBean.getPoint().size()));
                    areaList.add(areaItem);
                }
            }
            leaveDetectRespond.setAreaList(areaList);
        }
        JSONObject alarmPlan = this.getSdcConfig(vcmInfo, requestBody.getChannelCode(), ALARM_PASS_ALARM_URI + "statistics_leaveDetect");
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        leaveDetectRespond.setAlarmInterval(((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getSourceParam().getTime());
        leaveDetectRespond.setAlarmPlanList(this.getBehaviorAlarmPlan(alarmConfigRespond));
        AlarmAudioAndLight audioAndLightAbility = this.getAudioAndLightAbility(vcmInfo, requestBody.getChannelCode(), alarmPlan);
        leaveDetectRespond.setAudioEnable(audioAndLightAbility.getAudioEnable());
        leaveDetectRespond.setAudioFile(audioAndLightAbility.getAudioFile());
        leaveDetectRespond.setAudioPlaybackTimes(audioAndLightAbility.getAudioPlaybackTimes());
        leaveDetectRespond.setWhiteLightIlluminator(audioAndLightAbility.getWhiteLightIlluminator());
        leaveDetectRespond.setWhiteLightIllumEnable(audioAndLightAbility.getWhiteLightIllumEnable());
        leaveDetectRespond.setFlashDuration(audioAndLightAbility.getFlashDuration());
        return leaveDetectRespond;
    }

    public Boolean setLeaveDetect(ParamBean<QueueDetectionRequest> obj) {
        JSONObject jsonObject;
        QueueDetectionRequest requestBody = (QueueDetectionRequest)obj.getRequestBody();
        NormallConfigRequestIvs1800 configRequestIvs1800 = this.changeLeaveDetectParameter(requestBody);
        SituationalConfigRespond config = requestBody.getConfig();
        AlarmAudioAndLight audioAndLight = new AlarmAudioAndLight();
        audioAndLight.setAudioEnable(config.getAudioEnable());
        audioAndLight.setAudioFile(config.getAudioFile());
        audioAndLight.setAudioPlaybackTimes(config.getAudioPlaybackTimes());
        audioAndLight.setWhiteLightIllumEnable(config.getWhiteLightIllumEnable());
        audioAndLight.setWhiteLightIlluminator(config.getWhiteLightIlluminator());
        audioAndLight.setFlashDuration(config.getFlashDuration());
        audioAndLight.setAlarmInterval(config.getAlarmInterval());
        audioAndLight.setAlarmPlanList(config.getAlarmPlanList());
        try {
            jsonObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SET_DEVICE_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)configRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
        }
        catch (SDKException e) {
            LOGGER.error("Set leaveDetect config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.updateAlarmPlanTime(obj.getVcmInfo(), requestBody.getChannelCode(), audioAndLight, ALARM_PASS_ALARM_URI + "statistics_leaveDetect");
        this.checkJsonRespond(jsonObject);
        return true;
    }

    public JSONObject getTargetAuth(ParamBean<ChannelListRequest> obj) {
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("deviceList", (Object)((ChannelListRequest)obj.getRequestBody()).getChannelCode());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_ABILITY_AUTH_POST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            JSONObject channelObject = new JSONObject();
            for (int i = 0; i < rsp.getJSONArray("resultInfo").size(); ++i) {
                JSONObject resultInfo = rsp.getJSONArray("resultInfo").getJSONObject(i);
                if (resultInfo.getInteger("resultCode") == 0) {
                    channelObject.put(resultInfo.getString("devCode"), (Object)(resultInfo.getIntValue("targetAbility") == 1 ? 1 : 0));
                    continue;
                }
                channelObject.put(resultInfo.getString("devCode"), null);
            }
            return channelObject;
        }
        catch (SDKException e) {
            LOGGER.error("get targetAuth error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            if ("400".equals(e.getErrorCode())) {
                throw new InvokeException("500", "cu_device_not_support");
            }
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public JSONArray setTargetAuth(ParamBean<TargetRecognitionRequest> obj) {
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("deviceList", (Object)((TargetRecognitionRequest)obj.getRequestBody()).getChannelCode());
            dataObject.put("targetAbility", (Object)(((TargetRecognitionRequest)obj.getRequestBody()).getTargetAbility() != false ? 1 : 0));
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_ABILITY_AUTH_PUT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            JSONArray respond = new JSONArray();
            for (int i = 0; i < rsp.getJSONArray("resultInfo").size(); ++i) {
                JSONObject resultInfo = rsp.getJSONArray("resultInfo").getJSONObject(i);
                JSONObject channelObject = new JSONObject();
                if (resultInfo.getInteger("resultCode") == 0) {
                    channelObject.put("result", (Object)true);
                    channelObject.put("channelCode", (Object)resultInfo.getString("devCode"));
                    respond.add((Object)channelObject);
                    continue;
                }
                channelObject.put("result", (Object)false);
                channelObject.put("channelCode", (Object)resultInfo.getString("devCode"));
                if ("189310005".equals(resultInfo.getString("resultCode"))) {
                    channelObject.put("reason", (Object)"no_support");
                } else {
                    channelObject.put("reason", (Object)resultInfo.getString("resultCode"));
                }
                respond.add((Object)channelObject);
            }
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("set targetAuth error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private NormallConfigRequestIvs1800 changeLeaveDetectParameter(QueueDetectionRequest requestBody) {
        NormallConfigRequestIvs1800 configRequestIvs1800 = new NormallConfigRequestIvs1800();
        configRequestIvs1800.setConfigType(Integer.valueOf(123));
        configRequestIvs1800.setDeviceCode(requestBody.getChannelCode());
        LeaveDetectConfigRespondIvs1800 leaveDetectConfig = new LeaveDetectConfigRespondIvs1800();
        leaveDetectConfig.setEnable(Integer.valueOf(requestBody.getConfig().getEnable() != false ? 1 : 0));
        leaveDetectConfig.setOnDutyNum(requestBody.getConfig().getOnDutyNum());
        leaveDetectConfig.setAlarmOsdEnable(Integer.valueOf(requestBody.getConfig().getAlarmOsdEnable() != false ? 1 : 0));
        leaveDetectConfig.setLeaveDurationTime(requestBody.getConfig().getLeavetime());
        LeaveDetectConfigRespondIvs1800.GuardAreaList guardAreaList = new LeaveDetectConfigRespondIvs1800.GuardAreaList();
        ArrayList Area2 = new ArrayList();
        requestBody.getConfig().getAreaList().stream().forEach(a -> {
            LeaveDetectConfigRespondIvs1800.GuardAreaList.Area area = new LeaveDetectConfigRespondIvs1800.GuardAreaList.Area();
            area.setAreaName(a.getAreaName());
            area.setEnable(Integer.valueOf(a.getEnable() != false ? 1 : 0));
            area.setIndex(a.getIndex());
            List pointList = a.getPointList();
            for (PointItem pointItem : pointList) {
                pointItem.setPointX(pointItem.getPointX() / 2);
                pointItem.setPointY(pointItem.getPointY() / 2);
            }
            area.setPoint(pointList);
            area.setPointNum(Integer.valueOf(pointList.size()));
            LeaveDetectConfigRespondIvs1800.GuardAreaList.Area.Location location = new LeaveDetectConfigRespondIvs1800.GuardAreaList.Area.Location();
            area.setLocation(location);
            Area2.add(area);
        });
        guardAreaList.setArea(Area2);
        leaveDetectConfig.setGuardAreaList(guardAreaList);
        NormallConfigRequestIvs1800.NormalDetectionInfo configItem = new NormallConfigRequestIvs1800.NormalDetectionInfo();
        configItem.setCameraLeaveDetectConfig(leaveDetectConfig);
        configRequestIvs1800.setConfigItem(configItem);
        return configRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

