/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.IntelligentAnalysisBulkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.IntelligentAnalysisListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.IntelligentAnalysisRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligentAnalysis.AlgorithmRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligentAnalysis.IntelligentAnalysisBulkRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligentAnalysis.IntelligentAnalysisListRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligentAnalysis.IntelligentAnalysisRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.Algorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.IntelligentAnalysisBulkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.IntelligentAnalysisListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.IntelligentAnalysisRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.IntelligentAnalysisBulkRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.IntelligentAnalysisListRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.IntelligentAnalysisRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.IntelligentAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="intelligentAnalysis1800Service")
public class IntelligentAnalysis1800ServiceImpl
extends AbstractIvs1800Service
implements IntelligentAnalysisService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntelligentAnalysis1800ServiceImpl.class);

    public IntelligentAnalysisListRespond list(VcmReqBaseInfo vcmInfo, IntelligentAnalysisListRequest req) {
        IntelligentAnalysisListRespond intelligentAnalysisListRespond = new IntelligentAnalysisListRespond();
        IntelligentAnalysisListRequestIvs1800 intelligentAnalysisListRequestIvs1800 = this.listRequestToIvs1800(req);
        try {
            IntelligentAnalysisListRespondIvs1800 intelligentAnalysisListRespondIvs1800 = (IntelligentAnalysisListRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_LIST_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)intelligentAnalysisListRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisListRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisListRespondIvs1800);
            intelligentAnalysisListRespond.setPage(intelligentAnalysisListRespondIvs1800.getPage());
            intelligentAnalysisListRespond.setResultCode(intelligentAnalysisListRespondIvs1800.getResultCode());
            intelligentAnalysisListRespond.setTaskList(intelligentAnalysisListRespondIvs1800.getTask_list());
            return intelligentAnalysisListRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 list intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public IntelligentAnalysisRespond stop(VcmReqBaseInfo vcmInfo, IntelligentAnalysisRequest req) {
        IntelligentAnalysisRespond intelligentAnalysisRespond = new IntelligentAnalysisRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("taskid", req.getTaskId());
        try {
            IntelligentAnalysisRespondIvs1800 intelligentAnalysisRespondIvs1800 = (IntelligentAnalysisRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_STOP_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisRespondIvs1800);
            intelligentAnalysisRespond.setResultCode(intelligentAnalysisRespondIvs1800.getResultCode());
            intelligentAnalysisRespond.setResultMsg(intelligentAnalysisRespondIvs1800.getResultMsg());
            return intelligentAnalysisRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 stop intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public IntelligentAnalysisRespond restart(VcmReqBaseInfo vcmInfo, IntelligentAnalysisRequest req) {
        IntelligentAnalysisRespond intelligentAnalysisRespond = new IntelligentAnalysisRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("taskId", req.getTaskId());
        try {
            IntelligentAnalysisRespondIvs1800 intelligentAnalysisRespondIvs1800 = (IntelligentAnalysisRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_RESTART_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisRespondIvs1800);
            intelligentAnalysisRespond.setResultCode(intelligentAnalysisRespondIvs1800.getResultCode());
            intelligentAnalysisRespond.setResultMsg(intelligentAnalysisRespondIvs1800.getResultMsg());
            return intelligentAnalysisRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 restart intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public IntelligentAnalysisRespond del(VcmReqBaseInfo vcmInfo, IntelligentAnalysisRequest req) {
        IntelligentAnalysisRespond intelligentAnalysisRespond = new IntelligentAnalysisRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("taskId", req.getTaskId());
        try {
            IntelligentAnalysisRespondIvs1800 intelligentAnalysisRespondIvs1800 = (IntelligentAnalysisRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_DEL_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisRespondIvs1800);
            intelligentAnalysisRespond.setResultCode(intelligentAnalysisRespondIvs1800.getResultCode());
            intelligentAnalysisRespond.setResultMsg(intelligentAnalysisRespondIvs1800.getResultMsg());
            return intelligentAnalysisRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 del intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public IntelligentAnalysisRespond create(VcmReqBaseInfo vcmInfo, IntelligentAnalysisRequest req) {
        IntelligentAnalysisRespond intelligentAnalysisRespond = new IntelligentAnalysisRespond();
        IntelligentAnalysisRequestIvs1800 intelligentAnalysisRequestIvs1800 = this.createRequestToIvs1800(req);
        try {
            IntelligentAnalysisRespondIvs1800 intelligentAnalysisRespondIvs1800 = (IntelligentAnalysisRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_CREAT_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)intelligentAnalysisRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisRespondIvs1800);
            intelligentAnalysisRespond.setResultCode(intelligentAnalysisRespondIvs1800.getResultCode());
            intelligentAnalysisRespond.setResultMsg(intelligentAnalysisRespondIvs1800.getResultMsg());
            intelligentAnalysisRespond.setTaskId(intelligentAnalysisRespondIvs1800.getTaskId());
            return intelligentAnalysisRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 create intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public IntelligentAnalysisBulkRespond bulkCreate(VcmReqBaseInfo vcmInfo, IntelligentAnalysisBulkRequest req) {
        IntelligentAnalysisBulkRespond intelligentAnalysisBulkRespond = new IntelligentAnalysisBulkRespond();
        IntelligentAnalysisBulkRequestIvs1800 request = this.bulkCreateRequestToIvs1800(req);
        try {
            IntelligentAnalysisBulkRespondIvs1800 intelligentAnalysisBulkRespondIvs1800 = (IntelligentAnalysisBulkRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_BULK_CREAT_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, IntelligentAnalysisBulkRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)intelligentAnalysisBulkRespondIvs1800);
            intelligentAnalysisBulkRespond.setResultCode(intelligentAnalysisBulkRespondIvs1800.getResultCode());
            intelligentAnalysisBulkRespond.setResultMsg(intelligentAnalysisBulkRespondIvs1800.getResultMsg());
            intelligentAnalysisBulkRespond.setTasks(intelligentAnalysisBulkRespondIvs1800.getTasks());
            return intelligentAnalysisBulkRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 batch create intelligent analysis error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public AlgorithmRespond loadAlgorithm(VcmReqBaseInfo vcmInfo, AlgorithmRequest request) {
        AlgorithmRespond respond = new AlgorithmRespond();
        ArrayList<Algorithm> algorithmList = new ArrayList<Algorithm>();
        AlgorithmRequestIvs1800 requestIvs1800 = new AlgorithmRequestIvs1800();
        requestIvs1800.setType(request.getType());
        requestIvs1800.setLanguage(request.getLanguage());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_ANALYSIS_LOAD_ALGORITHM, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray algorithmArray = rsp.getJSONArray("algorithms");
            if (!CollectionUtils.isEmpty((Collection)algorithmArray)) {
                for (int i = 0; i < algorithmArray.size(); ++i) {
                    Algorithm algorithm = new Algorithm();
                    JSONObject algorithmObject = algorithmArray.getJSONObject(i);
                    algorithm.setCode(algorithmObject.getString("code"));
                    algorithm.setName(algorithmObject.getString("name"));
                    algorithm.setType(algorithmObject.getString("type"));
                    algorithmList.add(algorithm);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 load algorithm error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        respond.setAlgorithms(algorithmList);
        respond.setSize(algorithmList.size());
        return respond;
    }

    private IntelligentAnalysisListRequestIvs1800 listRequestToIvs1800(IntelligentAnalysisListRequest req) {
        IntelligentAnalysisListRequestIvs1800 intelligentAnalysisListRequestIvs1800 = new IntelligentAnalysisListRequestIvs1800();
        intelligentAnalysisListRequestIvs1800.setCameraCode(req.getChannelCode());
        intelligentAnalysisListRequestIvs1800.setCreateTimeStart(req.getCreateTimeStart());
        intelligentAnalysisListRequestIvs1800.setCreateTimeEnd(req.getCreateTimeEnd());
        intelligentAnalysisListRequestIvs1800.setCreateUser(req.getCreateUser());
        intelligentAnalysisListRequestIvs1800.setIntelligentStatus(req.getIntelligentStatus());
        intelligentAnalysisListRequestIvs1800.setIntelligentType(req.getIntelligentType());
        intelligentAnalysisListRequestIvs1800.setTaskId(req.getTaskId());
        intelligentAnalysisListRequestIvs1800.setVideoType(req.getVideoType());
        intelligentAnalysisListRequestIvs1800.setTaskName(req.getTaskName());
        JSONObject page = new JSONObject();
        page.put("no", (Object)req.getNo());
        page.put("pageSize", (Object)req.getPageSize());
        page.put("pageSort", (Object)req.getPageSort());
        page.put("sortName", (Object)req.getSortName());
        intelligentAnalysisListRequestIvs1800.setPage(page);
        return intelligentAnalysisListRequestIvs1800;
    }

    private IntelligentAnalysisRequestIvs1800 createRequestToIvs1800(IntelligentAnalysisRequest req) {
        IntelligentAnalysisRequestIvs1800 intelligentAnalysisRequestIvs1800 = new IntelligentAnalysisRequestIvs1800();
        intelligentAnalysisRequestIvs1800.setTask_name(req.getTaskName());
        intelligentAnalysisRequestIvs1800.setCameraCode(req.getChannelCode());
        intelligentAnalysisRequestIvs1800.setType(req.getType());
        intelligentAnalysisRequestIvs1800.setStream_type(req.getStreamType());
        intelligentAnalysisRequestIvs1800.setRecord_Starttime(req.getRecordStartTime());
        intelligentAnalysisRequestIvs1800.setRecord_Endtime(req.getRecordEndTime());
        intelligentAnalysisRequestIvs1800.setRepeat_time_list(req.getRepeatTimeList());
        intelligentAnalysisRequestIvs1800.setStart_time(req.getStartTime());
        intelligentAnalysisRequestIvs1800.setEnd_time(req.getEndTime());
        intelligentAnalysisRequestIvs1800.setRun_extradata(req.getRunExtraData());
        intelligentAnalysisRequestIvs1800.setAlgorithms(req.getAlgorithms());
        intelligentAnalysisRequestIvs1800.setAnalyzeMode(req.getAnalyzeMode());
        intelligentAnalysisRequestIvs1800.setDevList(req.getDevList());
        return intelligentAnalysisRequestIvs1800;
    }

    private IntelligentAnalysisBulkRequestIvs1800 bulkCreateRequestToIvs1800(IntelligentAnalysisBulkRequest req) {
        IntelligentAnalysisBulkRequestIvs1800 requestIvs1800 = new IntelligentAnalysisBulkRequestIvs1800();
        List intelligentAnalysisBulkRequests = req.getTasks();
        ArrayList<IntelligentAnalysisRequestIvs1800> list = new ArrayList<IntelligentAnalysisRequestIvs1800>();
        for (IntelligentAnalysisRequest ele : intelligentAnalysisBulkRequests) {
            IntelligentAnalysisRequestIvs1800 obj = new IntelligentAnalysisRequestIvs1800();
            obj.setTask_name(ele.getTaskName());
            obj.setCameraCode(ele.getChannelCode());
            obj.setType(ele.getType());
            obj.setStream_type(ele.getStreamType());
            obj.setRecord_Starttime(ele.getRecordStartTime());
            obj.setRecord_Endtime(ele.getRecordEndTime());
            obj.setRepeat_time_list(ele.getRepeatTimeList());
            obj.setStart_time(ele.getStartTime());
            obj.setEnd_time(ele.getEndTime());
            obj.setRun_extradata(ele.getRunExtraData());
            obj.setAlgorithms(ele.getAlgorithms());
            obj.setAnalyzeMode(ele.getAnalyzeMode());
            obj.setDevList(ele.getDevList());
            list.add(obj);
        }
        requestIvs1800.setTasks(list);
        return requestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

