/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.CommonResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.common.Page;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.PeopleRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.FaceRepositoryRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.FaceRepositoryUpdatePeopleRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.FaceSearchReportRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.MachineSearchRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.PeopleAddRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.PeopleRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.PeopleSearchRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.facerepository.PeopleUpdateRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceInfoSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.PeopleSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositorySearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.PeopleDelRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.PeopleIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.PeopleRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.PeopleSearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.SDKClientApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="faceRepositoryServiceIvs1800")
public class FaceRepositoryServiceIvs1800Impl
extends AbstractIvs1800Service
implements FaceRepositoryManagementService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRepositoryServiceIvs1800Impl.class);

    public boolean add(VcmReqBaseInfo vcmInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmInfo, faceRepository);
            if (!CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                return true;
            }
            FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = this.requestConverter(faceRepository);
            FaceRepositoryRespondIvs1800 rsp = (FaceRepositoryRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ADD_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)faceRepositoryRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(CommonResponse.class, FaceRepositoryRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
            if (StringUtils.isNotBlank((CharSequence)rsp.getGroupId()) && "1718503712".equals(rsp.getGroupId())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_EXIST);
            }
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("add face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean update(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = this.requestConverter(faceRepository);
            faceRepositoryRequestIvs1800.setName(faceRepository.getNewName());
            BaseRespondIvs1800 updateResponse = (BaseRespondIvs1800)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PATCH, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId()), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)faceRepositoryRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(updateResponse);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("update FaceRepository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean delete(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                return true;
            }
            BaseRespondIvs1800 delResponse = (BaseRespondIvs1800)SDKClientApi.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId()), (HttpUrlParam)null, (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(delResponse);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("delete face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public FaceRepositorySearchRespond search(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) {
        FaceRepositorySearchRespond faceRepositorySearchRespond;
        try {
            FaceRepositorySearchRespondIvs1800 rsp = this.searchCommon(vcmReqBaseInfo, faceRepository);
            faceRepositorySearchRespond = this.searchRespondConvert(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("search face repository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return faceRepositorySearchRespond;
    }

    public boolean addPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        this.checkParam(people);
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, people.getFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            PeopleRequestIvs1800 peopleRequestIvs1800 = this.peopleRequestConverter(people);
            PeopleAddRequestIvs1800 peopleAddRequestIvs1800 = new PeopleAddRequestIvs1800();
            peopleAddRequestIvs1800.getPeopleList().add(peopleRequestIvs1800);
            PeopleRespondIvs1800 addRsp = (PeopleRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_POST, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId() + "/peoples"), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)peopleAddRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(CommonResponse.class, PeopleRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (!CollectionUtils.isEmpty((Collection)addRsp.getIds())) {
                this.checkRespond((BaseRespondIvs1800)addRsp.getIds().get(0));
            }
            this.checkRespond((BaseRespondIvs1800)addRsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("add people happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean deletePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        this.checkParam(people);
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, people.getFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            PeopleSearchRequestIvs1800 peopleSearchRequestIvs1800 = new PeopleSearchRequestIvs1800();
            peopleSearchRequestIvs1800.setTag(people.getId());
            peopleSearchRequestIvs1800.setGroupids(((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId());
            PeopleSearchRespondIvs1800 peopleRespond = this.peopleCommonSearch(vcmReqBaseInfo, peopleSearchRequestIvs1800);
            if (!CollectionUtils.isEmpty((Collection)peopleRespond.getPeopleList())) {
                StringBuilder peopleIds = new StringBuilder();
                for (PeopleIvs1800 p : peopleRespond.getPeopleList()) {
                    if (StringUtils.isBlank((CharSequence)peopleIds.toString())) {
                        peopleIds.append(p.getPeopleId());
                        continue;
                    }
                    peopleIds.append(",").append(p.getPeopleId());
                }
                HttpUrlParam param = new HttpUrlParam();
                param.addParam("ids", peopleIds.toString());
                PeopleDelRespondIvs1800 delResponse = (PeopleDelRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_DELETE, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId() + "/peoples"), (HttpUrlParam)param, (MsgToObjectConvertor)this.msgToObjectConvertor(PeopleDelRespondIvs1800.class, PeopleDelRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                this.checkRespond((BaseRespondIvs1800)delResponse);
                this.checkRespond((BaseRespondIvs1800)delResponse.getPeopleList().get(0));
            }
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("delete people happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean updatePeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        this.checkParam(people);
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, people.getFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            PeopleSearchRequestIvs1800 peopleSearchRequestIvs1800 = new PeopleSearchRequestIvs1800();
            peopleSearchRequestIvs1800.setTag(people.getId());
            peopleSearchRequestIvs1800.setGroupids(((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId());
            PeopleSearchRespondIvs1800 peopleRespond = this.peopleCommonSearch(vcmReqBaseInfo, peopleSearchRequestIvs1800);
            if (CollectionUtils.isEmpty((Collection)peopleRespond.getPeopleList())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_NOT_EXIST);
            }
            String peopleId = ((PeopleIvs1800)peopleRespond.getPeopleList().get(0)).getPeopleId();
            PeopleUpdateRequestIvs1800 peopleUpdateRequestIvs1800 = this.peopleUpdateRequestConverter(people);
            BaseRespondIvs1800 updateResponse = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PATCH, "/sdk_service/rest/facerepositories/" + ((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId() + "/peoples/" + peopleId), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)peopleUpdateRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(updateResponse);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("update people happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public PeopleSearchRespond searchPeople(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        PeopleSearchRespond peopleSearchRespond;
        if (people.getFaceRepositoryInfo() == null) {
            throw new InvokeException("500", "param_error");
        }
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, people.getFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", Nvr800Utils.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            PeopleSearchRequestIvs1800 peopleSearchRequestIvs1800 = new PeopleSearchRequestIvs1800();
            peopleSearchRequestIvs1800.setGroupids(((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId());
            peopleSearchRequestIvs1800.setPage(people.getPage());
            peopleSearchRequestIvs1800.setCredentialNumber(people.getId());
            peopleSearchRequestIvs1800.setTag(people.getId());
            PeopleSearchRespondIvs1800 rspPeople = this.peopleCommonSearch(vcmReqBaseInfo, peopleSearchRequestIvs1800);
            peopleSearchRespond = this.searchPeopleRespondConvert(rspPeople);
        }
        catch (SDKException e) {
            LOGGER.error("search people happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return peopleSearchRespond;
    }

    public boolean repositoryUpdatePeopleBatch(VcmReqBaseInfo vcmReqBaseInfo, PeopleRequest people) {
        try {
            FaceRepositorySearchRespondIvs1800 searchRsp = this.searchCommon(vcmReqBaseInfo, people.getFaceRepositoryInfo());
            if (CollectionUtils.isEmpty((Collection)searchRsp.getRepositories())) {
                throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
            }
            ArrayList peopleIds = new ArrayList();
            PeopleSearchRequestIvs1800 peopleSearchRequestIvs1800 = new PeopleSearchRequestIvs1800();
            peopleSearchRequestIvs1800.setGroupids(((FaceRepositoryIvs1800)searchRsp.getRepositories().get(0)).getId());
            if (!CollectionUtils.isEmpty((Collection)people.getPeopleIds()) && people.getPeopleIds().size() < 100) {
                people.getPeopleIds().forEach(id -> {
                    peopleSearchRequestIvs1800.setTag(id);
                    PeopleSearchRespondIvs1800 peopleRespond = null;
                    try {
                        peopleRespond = this.peopleCommonSearch(vcmReqBaseInfo, peopleSearchRequestIvs1800);
                    }
                    catch (SDKException e) {
                        LOGGER.error("update people repository happen exception", (Throwable)e);
                    }
                    if (CollectionUtils.isEmpty((Collection)peopleRespond.getPeopleList())) {
                        throw new InvokeException("500", DeviceUtil.CU_FACE_NOT_EXIST);
                    }
                    peopleIds.add(((PeopleIvs1800)peopleRespond.getPeopleList().get(0)).getPeopleId());
                });
                if (!CollectionUtils.isEmpty(peopleIds)) {
                    FaceRepositorySearchRespondIvs1800 newRsp = this.searchCommon(vcmReqBaseInfo, people.getNewFaceRepositoryInfo());
                    if (CollectionUtils.isEmpty((Collection)newRsp.getRepositories())) {
                        throw new InvokeException("500", DeviceUtil.CU_FACE_REPOSITORY_NOT_EXIST);
                    }
                    FaceRepositoryUpdatePeopleRequestIvs1800 req = new FaceRepositoryUpdatePeopleRequestIvs1800();
                    req.setGroupId(((FaceRepositoryIvs1800)newRsp.getRepositories().get(0)).getId());
                    req.setPeopleIdList(peopleIds);
                    BaseRespondIvs1800 updateRsp = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.BATCH_UPDATE_FACE_REPOSITORY_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)req, false), (MsgToObjectConvertor)this.msgToObjectConvertor(BaseRespondIvs1800.class, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    this.checkRespond(updateRsp);
                    return true;
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("update people repository happen exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return false;
    }

    public FaceInfoSearchRespond faceStatisticalInfoSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        FaceInfoSearchRespond searchRespond = new FaceInfoSearchRespond();
        FaceSearchReportRequestIvs1800 searchRequestIvs1800 = new FaceSearchReportRequestIvs1800();
        searchRequestIvs1800.setDate(request.getStartTime().split(" ")[0].replaceAll("-", ""));
        searchRequestIvs1800.setDeviceCodes(request.getChannel());
        searchRequestIvs1800.setReportPeriod(this.changeReportPeriod(request.getStatisticsType()));
        searchRequestIvs1800.setType(Integer.valueOf(0));
        JSONObject faceInfoReport = this.getFaceInfoReport(vcmReqBaseInfo, searchRequestIvs1800);
        Integer length = faceInfoReport.getInteger("recordNum");
        FaceRepositorySearchRespondIvs1800 faceRepositorySearchRespond = this.searchCommon(vcmReqBaseInfo);
        List itemList = faceRepositorySearchRespond.getRepositories();
        JSONObject nameObject = new JSONObject();
        for (Object item : itemList) {
            nameObject.put(item.getId(), (Object)item.getName());
        }
        ArrayList groupRecords = new ArrayList();
        for (String key : nameObject.keySet()) {
            request.getGroupName().forEach(e -> {
                if (e.equals(nameObject.getString(key))) {
                    FaceInfoSearchRespond.GroupRecords groupRecord = new FaceInfoSearchRespond.GroupRecords();
                    groupRecord.setName((String)e);
                    groupRecord.setType("bar");
                    groupRecord.setGroupId(key);
                    groupRecord.setData(new ArrayList<Integer>(Collections.nCopies(length, 0)));
                    groupRecords.add(groupRecord);
                }
            });
        }
        ArrayList<Integer> strangerList = new ArrayList<Integer>(Collections.nCopies(length, 0));
        JSONArray recordList = faceInfoReport.getJSONArray("recordList");
        Integer strangerTotal = 0;
        Integer total = 0;
        for (int i = 0; i < recordList.size(); ++i) {
            JSONObject recordData = (JSONObject)recordList.get(i);
            JSONArray groupRecordList = recordData.getJSONArray("groupRecords");
            Integer strangerNum = recordData.getInteger("strangerNum");
            strangerTotal = strangerTotal + strangerNum;
            strangerList.set(i, strangerNum);
            total = total + strangerNum;
            if (groupRecordList.get(0) == null) continue;
            for (Object o : groupRecordList) {
                JSONObject data = (JSONObject)o;
                for (FaceInfoSearchRespond.GroupRecords record : groupRecords) {
                    if (!record.getGroupId().equals(data.getString("groupId"))) continue;
                    Integer num = data.getInteger("num");
                    record.getData().set(i, num);
                    record.setTotal(Integer.valueOf(record.getTotal() + num));
                    total = total + num;
                }
            }
        }
        searchRespond.setStrangerList(strangerList);
        searchRespond.setGroupRecords(groupRecords);
        searchRespond.setTotal(total + "");
        return searchRespond;
    }

    public FaceRepositorySearchRespondIvs1800 searchCommon(VcmReqBaseInfo vcmReqBaseInfo) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("size", "1000");
        httpUrlParam.addParam("no", "1");
        httpUrlParam.addParam("ordername", "name");
        httpUrlParam.addParam("sort", "asc");
        FaceRepositorySearchRespondIvs1800 rsp = null;
        try {
            rsp = (FaceRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_FACE_REPOSITORY_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(FaceRepositorySearchRespondIvs1800.class, FaceRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
        }
        catch (SDKException e) {
            LOGGER.error("faceSearch repositories happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public FaceInfoSearchRespond faceReportDataSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        FaceInfoSearchRespond searchRespond = new FaceInfoSearchRespond();
        FaceSearchReportRequestIvs1800 searchRequestIvs1800 = new FaceSearchReportRequestIvs1800();
        searchRequestIvs1800.setDate(request.getDate().split(" ")[0].replaceAll("-", ""));
        searchRequestIvs1800.setDeviceCodes(request.getChannel());
        searchRequestIvs1800.setReportPeriod(this.changeReportPeriod(request.getStatisticsType()));
        searchRequestIvs1800.setType(Integer.valueOf(1));
        JSONObject faceInfoReport = this.getFaceInfoReport(vcmReqBaseInfo, searchRequestIvs1800);
        searchRespond.setResult(faceInfoReport.getInteger("resultCode").intValue());
        List ageRecords = JSON.parseArray((String)faceInfoReport.getJSONArray("ageRecords").toJSONString(), Integer.class);
        searchRespond.setAgeInfo(ageRecords);
        searchRespond.setGenderInfo(JSON.parseArray((String)faceInfoReport.getJSONArray("sexRecords").toJSONString(), Integer.class));
        return searchRespond;
    }

    private JSONObject getFaceInfoReport(VcmReqBaseInfo vcmReqBaseInfo, FaceSearchReportRequestIvs1800 request) {
        JSONObject rsp;
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.FACE_REPORT_INFO_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)300);
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("faceSearchReport happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public FaceInfoSearchRespond machineInfoSearch(VcmReqBaseInfo vcmReqBaseInfo, FaceInfoRequest request) {
        FaceInfoSearchRespond searchRespond = new FaceInfoSearchRespond();
        MachineSearchRequestIvs1800 machineSearchRequest = new MachineSearchRequestIvs1800();
        machineSearchRequest.setDate(request.getDate().split(" ")[0].replaceAll("-", ""));
        machineSearchRequest.setDeviceCodes(request.getChannel());
        machineSearchRequest.setReportPeriod(this.changeReportPeriod(request.getStatisticsType()));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.MACHINE_INFO_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)machineSearchRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)300);
            searchRespond.setCount(rsp.getJSONArray("records"));
            searchRespond.setTotalCount(rsp.getJSONArray("totalCount"));
        }
        catch (SDKException e) {
            LOGGER.error("machineInfoSearch happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    private Integer changeReportPeriod(String statisticsType) {
        Integer reportPeriod = null;
        switch (statisticsType) {
            case "day": {
                reportPeriod = 0;
                break;
            }
            case "week": {
                reportPeriod = 1;
                break;
            }
            case "month": {
                reportPeriod = 2;
                break;
            }
            case "quarter": {
                reportPeriod = 3;
                break;
            }
            case "year": {
                reportPeriod = 4;
                break;
            }
        }
        return reportPeriod;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public FaceRepositoryRequestIvs1800 requestConverter(FaceRepositoryRequest faceRepositoryRequest) {
        FaceRepositoryRequestIvs1800 faceRepositoryRequestIvs1800 = new FaceRepositoryRequestIvs1800();
        faceRepositoryRequestIvs1800.setName(faceRepositoryRequest.getName());
        faceRepositoryRequestIvs1800.setType(faceRepositoryRequest.getType());
        faceRepositoryRequestIvs1800.setGroupStrId(faceRepositoryRequest.getGroupStrId());
        return faceRepositoryRequestIvs1800;
    }

    public FaceRepositorySearchRespond searchRespondConvert(FaceRepositorySearchRespondIvs1800 repositorySearchRespondIvs1800) {
        FaceRepositorySearchRespond faceRepositorySearchRespond = new FaceRepositorySearchRespond();
        faceRepositorySearchRespond.setTotal(repositorySearchRespondIvs1800.getTotal());
        if (!CollectionUtils.isEmpty((Collection)repositorySearchRespondIvs1800.getRepositories())) {
            repositorySearchRespondIvs1800.getRepositories().forEach(res -> {
                FaceRepository faceRepository = new FaceRepository();
                faceRepository.setGroupId(res.getId());
                faceRepository.setType(res.getType());
                faceRepository.setName(res.getName());
                faceRepositorySearchRespond.getRepositories().add(faceRepository);
            });
        }
        return faceRepositorySearchRespond;
    }

    public FaceRepositorySearchRespondIvs1800 searchCommon(VcmReqBaseInfo vcmReqBaseInfo, FaceRepositoryRequest faceRepository) throws SDKException {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("size", "1000");
        httpUrlParam.addParam("no", "1");
        httpUrlParam.addParam("ordername", "name");
        httpUrlParam.addParam("sort", "asc");
        if (faceRepository != null) {
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getType())) {
                httpUrlParam.addParam("type", faceRepository.getType());
            }
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getName())) {
                httpUrlParam.addParam("name", faceRepository.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)faceRepository.getRepositoryId())) {
                httpUrlParam.addParam("groupid", faceRepository.getRepositoryId());
            }
        }
        FaceRepositorySearchRespondIvs1800 rsp = (FaceRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_FACE_REPOSITORY_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(FaceRepositorySearchRespondIvs1800.class, FaceRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public PeopleSearchRespondIvs1800 peopleCommonSearch(VcmReqBaseInfo vcmReqBaseInfo, PeopleSearchRequestIvs1800 peopleSearchRequestIvs1800) throws SDKException {
        if (peopleSearchRequestIvs1800.getPage() == null) {
            Page page = new Page();
            page.setSize("1000");
            page.setNo("1");
            peopleSearchRequestIvs1800.setPage(page);
        }
        if ("0".equals(peopleSearchRequestIvs1800.getPage().getNo())) {
            peopleSearchRequestIvs1800.getPage().setNo("1");
        }
        peopleSearchRequestIvs1800.getPage().setOrderName("name");
        peopleSearchRequestIvs1800.getPage().setSort("asc");
        PeopleSearchRespondIvs1800 rsp = (PeopleSearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)peopleSearchRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(CommonResponse.class, PeopleSearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkRespond((BaseRespondIvs1800)rsp);
        return rsp;
    }

    public PeopleSearchRespond searchPeopleRespondConvert(PeopleSearchRespondIvs1800 peopleSearchRespondIvs1800) {
        PeopleSearchRespond peopleSearchRespond = new PeopleSearchRespond();
        peopleSearchRespond.setTotal(peopleSearchRespondIvs1800.getTotal());
        if (!CollectionUtils.isEmpty((Collection)peopleSearchRespondIvs1800.getPeopleList())) {
            peopleSearchRespondIvs1800.getPeopleList().forEach(res -> {
                People people = new People();
                people.setId(res.getTag());
                people.setName(res.getName());
                people.setGender(res.getGender());
                people.setNationality(res.getNationality());
                people.setOccupation(res.getOccupation());
                people.setCredentialType(res.getCredentialType());
                people.setCredentialNumber(res.getCredentialNumber());
                people.setCountry(res.getCountry());
                people.setBornTime(res.getBornTime());
                people.setDescription(res.getDescription());
                peopleSearchRespond.getPeopleList().add(people);
            });
        }
        return peopleSearchRespond;
    }

    private PeopleRequestIvs1800 peopleRequestConverter(PeopleRequest people) {
        PeopleRequestIvs1800 peopleRequestIvs1800 = new PeopleRequestIvs1800();
        peopleRequestIvs1800.setIndex(people.getId());
        peopleRequestIvs1800.setTag(people.getId());
        peopleRequestIvs1800.setName(people.getName());
        peopleRequestIvs1800.setGender(people.getGender());
        peopleRequestIvs1800.setNationality(people.getNationality());
        peopleRequestIvs1800.setOccupation(people.getOccupation());
        peopleRequestIvs1800.setCredentialType(people.getCredentialType());
        peopleRequestIvs1800.setCredentialNumber(people.getId());
        peopleRequestIvs1800.setCountry(people.getCountry());
        peopleRequestIvs1800.setBornTime(people.getBornTime());
        peopleRequestIvs1800.setDescription(people.getDescription());
        peopleRequestIvs1800.setPictures(people.getPictures());
        peopleRequestIvs1800.setStrId("pin" + people.getId());
        return peopleRequestIvs1800;
    }

    private PeopleUpdateRequestIvs1800 peopleUpdateRequestConverter(PeopleRequest people) {
        PeopleUpdateRequestIvs1800 peopleRequestIvs1800 = new PeopleUpdateRequestIvs1800();
        peopleRequestIvs1800.getPeople().setName(people.getName());
        peopleRequestIvs1800.getPeople().setGender(people.getGender());
        peopleRequestIvs1800.getPeople().setNationality(people.getNationality());
        peopleRequestIvs1800.getPeople().setOccupation(people.getOccupation());
        peopleRequestIvs1800.getPeople().setCredentialType(people.getCredentialType());
        peopleRequestIvs1800.getPeople().setCredentialNumber(people.getId());
        peopleRequestIvs1800.getPeople().setCountry(people.getCountry());
        peopleRequestIvs1800.getPeople().setBornTime(people.getBornTime());
        peopleRequestIvs1800.getPeople().setDescription(people.getDescription());
        peopleRequestIvs1800.getPeople().setPictures(people.getPictures());
        return peopleRequestIvs1800;
    }

    public void checkParam(PeopleRequest people) {
        if (StringUtils.isEmpty((CharSequence)people.getId()) || people.getFaceRepositoryInfo() == null) {
            throw new InvokeException("500", "param_error");
        }
    }
}

