/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.AlarmSourceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraValidRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligentAnalysis.AlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.InitPasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.CameraAddRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.CameraRebootRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.CameraRemoveRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.device.CameraUpdatePasswordRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.AlarmSourceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAndChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceRouteRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ParentDeviceStateRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.AlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.CameraAddRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.CameraRemoveRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.DeviceRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.SubDeviceRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AlarmIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.IntelligentAnalysis1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Nvr800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceManageIvs1800ServiceImpl
extends AbstractIvs1800Service
implements DeviceManageService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageIvs1800ServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private AlarmIvs1800ServiceImpl alarmIvs1800Service;
    @Autowired
    private WebSocketService webSocketService;
    @Autowired
    private IntelligentAnalysis1800ServiceImpl intelligentAnalysis1800Service;

    public CameraAndChannelRespond listCamerasAndChannels(VcmReqBaseInfo vcmInfo) {
        CameraAndChannelRespond cameraAndChannelRespond = new CameraAndChannelRespond();
        cameraAndChannelRespond.setIp(vcmInfo.getVcmIp());
        cameraAndChannelRespond.setType(vcmInfo.getVcmType());
        List cameraResponds = this.listCamera(vcmInfo);
        List channelResponds = this.listChannel(vcmInfo);
        cameraResponds.stream().forEach(cameraRespond -> cameraRespond.setChannelResponds(channelResponds.stream().collect(Collectors.groupingBy(ChannelRespond::getParentCode)).get(cameraRespond.getCameraCode())));
        cameraAndChannelRespond.setCameras(cameraResponds);
        return cameraAndChannelRespond;
    }

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> cameraRespondList = new ArrayList<CameraRespond>();
        Map deviceMap = this.getMainDeviceList(vcmReqBaseInfo);
        for (Map.Entry entry : deviceMap.entrySet()) {
            JSONObject deviceObj = (JSONObject)entry.getValue();
            JSONObject basicObj = deviceObj.getJSONObject("deviceBasicInfo");
            JSONObject ipObj = basicObj.getJSONObject("ipInfo");
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(basicObj.getString("code"));
            cameraRespond.setCameraName(basicObj.getString("name"));
            cameraRespond.setConnectCode(basicObj.getString("connectCode"));
            cameraRespond.setDomainCode(basicObj.getString("domainCode"));
            cameraRespond.setIp(ipObj.getString("ip"));
            cameraRespond.setIpType(ipObj.getIntValue("ipType"));
            cameraRespond.setPort(ipObj.getIntValue("port"));
            cameraRespond.setModel(basicObj.getString("model"));
            cameraRespond.setSerialNumber(basicObj.getString("serialNumber"));
            cameraRespond.setFormType(basicObj.getIntValue("type"));
            String vendorType = StringUtils.isNotBlank((CharSequence)basicObj.getString("vendorType")) ? basicObj.getString("vendorType").toUpperCase() : "";
            cameraRespond.setVendor(vendorType);
            cameraRespond.setProtocolType(deviceObj.getString("protocolType"));
            cameraRespond.setLoginType(deviceObj.getIntValue("loginType"));
            cameraRespond.setEnableSchedule(deviceObj.getIntValue("enableSchedule"));
            cameraRespond.setOfflineReason(deviceObj.getString("registerErr"));
            cameraRespond.setSoftwareVersion(basicObj.getString("softwareVersion"));
            if ("HUAWEI".equalsIgnoreCase(cameraRespond.getVendor())) {
                cameraRespond.setVendor("HW");
            }
            switch (deviceObj.getIntValue("status")) {
                case 0: {
                    cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
                    break;
                }
                case 1: {
                    cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
                    break;
                }
                case 2: {
                    cameraRespond.setStatus(ChannelStatusEnum.SLEEP);
                    break;
                }
                default: {
                    cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
                }
            }
            cameraRespond.setImgType(3);
            cameraRespondList.add(cameraRespond);
        }
        return cameraRespondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<ChannelRespond> channelRespondList = new ArrayList<ChannelRespond>();
        JSONArray channelArray = this.getCameraArray(vcmReqBaseInfo);
        if (!CollectionUtils.isEmpty((Collection)channelArray)) {
            for (int i = 0; i < channelArray.size(); ++i) {
                String vendorType;
                JSONObject channelObject = channelArray.getJSONObject(i);
                ChannelRespond channelRespond = new ChannelRespond();
                channelRespond.setCategory(DeviceTypeEnum.IVS1800.val());
                channelRespond.setChannel(i + 1);
                channelRespond.setChannelCode(channelObject.getString("code"));
                channelRespond.setStatus(this.getNewChannelStatus(channelObject.getInteger("status")));
                channelRespond.setParentCode(channelObject.getString("parentCode"));
                channelRespond.setNvrCode(channelObject.getString("nvrCode"));
                channelRespond.setFormType(channelObject.getIntValue("deviceFormType"));
                channelRespond.setNetType(channelObject.getIntValue("netType"));
                channelRespond.setIntelligent(channelObject.getIntValue("isSupportIntelligent") == 1);
                channelRespond.setVoiceInEnable(channelObject.getIntValue("enableVoice") == 1);
                channelRespond.setExDomain(channelObject.getIntValue("isExDomain") == 1);
                channelRespond.setCreateTime(channelObject.getString("deviceCreateTime"));
                channelRespond.setLocation(channelObject.getString("cameraLocation"));
                channelRespond.setLongitude(channelObject.getString("longitude"));
                channelRespond.setLatitude(channelObject.getString("latitude"));
                channelRespond.setHeight(channelObject.getString("height"));
                channelRespond.setType(channelObject.getIntValue("type"));
                channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)channelRespond.getType()));
                channelRespond.setCameraName(channelObject.getString("name"));
                channelRespond.setModel(channelObject.getString("deviceModelType"));
                channelRespond.setIp(channelObject.getString("deviceIP"));
                String string = vendorType = StringUtils.isNotBlank((CharSequence)channelObject.getString("vendorType")) ? channelObject.getString("vendorType").toUpperCase() : "";
                if ("HUAWEI".equalsIgnoreCase(vendorType)) {
                    vendorType = "HW";
                }
                channelRespond.setVendor(vendorType);
                channelRespondList.add(channelRespond);
            }
        }
        return channelRespondList;
    }

    private ChannelStatusEnum getNewChannelStatus(Integer status) {
        if (status == null) {
            return ChannelStatusEnum.OFFLINE;
        }
        if (status == 0) {
            return ChannelStatusEnum.OFFLINE;
        }
        if (status == 1) {
            return ChannelStatusEnum.ONLINE;
        }
        if (status == 2) {
            return ChannelStatusEnum.SLEEP;
        }
        return ChannelStatusEnum.NOT_CONFIGURED;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        List channelRespondList = this.listChannel(obj.getVcmInfo());
        for (ChannelRespond channelRespond : channelRespondList) {
            if (!channelRespond.getChannelCode().equals(((ChannelRequest)obj.getRequestBody()).getChannelCode())) continue;
            return channelRespond;
        }
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        ChannelUpdateRequest request = (ChannelUpdateRequest)obj.getRequestBody();
        JSONObject dataObject = new JSONObject();
        dataObject.put("deviceCode", (Object)request.getChannelCode());
        dataObject.put("newDeviceName", (Object)request.getName());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_MODIFY_NAME, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update channel error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        List channelRespondList = this.listChannel(vcmReqBaseInfo);
        ArrayList<ChannelRespond> resultList = new ArrayList<ChannelRespond>();
        channelRespondList.forEach(channelRespond -> {
            if (cameraCode.equals(channelRespond.getParentCode())) {
                resultList.add((ChannelRespond)channelRespond);
            }
        });
        return resultList;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        CameraAddRequest addRequest = (CameraAddRequest)obj.getRequestBody();
        CameraAddRequestIvs1800 requestCameraAdd = this.buildCameraAddRespondIvs1800(addRequest);
        try {
            CameraAddRespondIvs1800 respondIvs1800 = (CameraAddRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_ADD_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestCameraAdd, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraAddRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            JSONObject resultObj = respondIvs1800.getDeviceOperResultInfos().getJSONArray("deviceOperResultList").getJSONObject(0);
            if (!"0".equals(resultObj.getString("result"))) {
                throw new InvokeException("500", resultObj.getString("result"));
            }
            CameraAddRespond cameraAddRespond = new CameraAddRespond();
            cameraAddRespond.setCameraCode(resultObj.getString("deviceCode"));
            cameraAddRespond.setNvrCode(resultObj.getString("nvrCode"));
            cameraAddRespond.setSequence(resultObj.getIntValue("sequence"));
            return cameraAddRespond;
        }
        catch (SDKException e) {
            LOGGER.error("Add camera fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return new ArrayList<String>();
    }

    private CameraAddRequestIvs1800 buildCameraAddRespondIvs1800(CameraAddRequest addRequest) {
        CameraAddRequestIvs1800 requestCameraAdd = new CameraAddRequestIvs1800();
        requestCameraAdd.setDeviceOperInfos(new JSONObject());
        JSONArray deviceOperInfoArray = new JSONArray();
        requestCameraAdd.getDeviceOperInfos().put("deviceOperInfo", (Object)deviceOperInfoArray);
        JSONObject deviceOperInfoObj = new JSONObject();
        deviceOperInfoArray.add((Object)deviceOperInfoObj);
        deviceOperInfoObj.put("sequence", (Object)1);
        JSONObject deviceConfigObj = new JSONObject();
        deviceOperInfoObj.put("deviceConfig", (Object)deviceConfigObj);
        deviceConfigObj.put("protocolType", (Object)addRequest.getProtocol());
        deviceConfigObj.put("loginType", (Object)addRequest.getLoginType());
        deviceConfigObj.put("enableAlarm", (Object)addRequest.getEnableAlarm());
        deviceConfigObj.put("directConnectFirst", (Object)addRequest.getDirectConnectFirst());
        deviceConfigObj.put("deviceUser", (Object)addRequest.getDeviceUser());
        deviceConfigObj.put("devicePassword", (Object)addRequest.getDevicePassword());
        deviceConfigObj.put("deviceRegPassword", (Object)addRequest.getDeviceRegPassword());
        if (StringUtils.isNotBlank((CharSequence)addRequest.getRtspPort())) {
            deviceConfigObj.put("rtspPort", (Object)Integer.valueOf(addRequest.getRtspPort()));
        }
        JSONObject deviceBasicInfoObj = new JSONObject();
        deviceConfigObj.put("deviceBasicInfo", (Object)deviceBasicInfoObj);
        deviceBasicInfoObj.put("type", (Object)addRequest.getType());
        deviceBasicInfoObj.put("name", (Object)addRequest.getName());
        if ("T28181".equals(addRequest.getProtocol())) {
            deviceBasicInfoObj.put("port", (Object)0);
        } else {
            deviceBasicInfoObj.put("port", (Object)Integer.valueOf(addRequest.getPort()));
        }
        deviceBasicInfoObj.put("connectCode", (Object)addRequest.getConnectCode());
        if (StringUtils.isNotBlank((CharSequence)addRequest.getVendorType())) {
            deviceBasicInfoObj.put("vendorType", (Object)addRequest.getVendorType());
        }
        JSONObject ipInfoObj = new JSONObject();
        deviceBasicInfoObj.put("ipInfo", (Object)ipInfoObj);
        ipInfoObj.put("ipType", (Object)0);
        ipInfoObj.put("ip", (Object)addRequest.getIp());
        return requestCameraAdd;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        try {
            CameraRemoveRequestIvs1800 removeRequestIvs1800 = new CameraRemoveRequestIvs1800();
            removeRequestIvs1800.addCode(((CameraRemoveRequest)obj.getRequestBody()).getCameraCode());
            CameraRemoveRespondIvs1800 respondIvs1800 = (CameraRemoveRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_REMOVE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)removeRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraRemoveRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Remove camera fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        PasswordUpdateRequest updateRequest = (PasswordUpdateRequest)obj.getRequestBody();
        try {
            CameraUpdatePasswordRequestIvs1800 requestIvs1800 = new CameraUpdatePasswordRequestIvs1800();
            requestIvs1800.setDevCode(updateRequest.getCameraCode());
            if (("HWSDK".equals(updateRequest.getProtocolType()) || "T28181".equals(updateRequest.getProtocolType())) && "0".equals(updateRequest.getBlanceSupport())) {
                requestIvs1800.setDevRegPWD(updateRequest.getNewPassword());
            } else {
                requestIvs1800.setDevPWD(updateRequest.getNewPassword());
            }
            requestIvs1800.setDevUserName(updateRequest.getUserName());
            if (updateRequest.getModifyAllPwd() != null && updateRequest.getModifyAllPwd().booleanValue()) {
                requestIvs1800.setModuleType("all");
            }
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_UPDATE_PASSWORD_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Update password fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean updateOfflinePassword(ParamBean<CameraAddRequest> obj) {
        ParamBean paramBean = new ParamBean();
        PasswordUpdateRequest request = new PasswordUpdateRequest();
        request.setNewPassword(((CameraAddRequest)obj.getRequestBody()).getDevicePassword());
        request.setCameraCode(((CameraAddRequest)obj.getRequestBody()).getChannelCode());
        request.setUserName(((CameraAddRequest)obj.getRequestBody()).getDeviceUser());
        request.setBlanceSupport(((CameraAddRequest)obj.getRequestBody()).getBlanceSupport());
        request.setProtocolType(((CameraAddRequest)obj.getRequestBody()).getProtocolType());
        paramBean.setRequestBody((Object)request);
        paramBean.setVcmInfo(obj.getVcmInfo());
        return this.updatePassword(paramBean);
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        try {
            CameraRebootRequestIvs1800 rebootRequestIvs1800 = new CameraRebootRequestIvs1800();
            rebootRequestIvs1800.setDeviceCode(((CameraRebootRequest)obj.getRequestBody()).getCameraCode());
            rebootRequestIvs1800.setRebootType(rebootRequestIvs1800.getRebootType());
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_REBOOT_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)rebootRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Reboot camera fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private Map<String, JSONObject> getMainDeviceList(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("fromIndex", "1");
            httpUrlParam.addParam("toIndex", "1000");
            httpUrlParam.addParam("deviceType", "1");
            DeviceRespondIvs1800 respondIvs1800 = (DeviceRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LIST_MAIN_DEVICE_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, DeviceRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            HashMap<String, JSONObject> map = new HashMap<String, JSONObject>();
            JSONArray deviceArray = respondIvs1800.getDeviceBriefInfos().getJSONArray("deviceBriefInfo");
            for (int i = 0; i < deviceArray.size(); ++i) {
                JSONObject jsonObject = deviceArray.getJSONObject(i).getJSONObject("deviceBasicInfo");
                map.put(jsonObject.getString("code"), deviceArray.getJSONObject(i));
            }
            return map;
        }
        catch (SDKException e) {
            LOGGER.error("getMainDeviceList", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private JSONArray getCameraArray(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("fromIndex", "1");
            httpUrlParam.addParam("toIndex", "1000");
            httpUrlParam.addParam("deviceType", "2");
            SubDeviceRespondIvs1800 respondIvs1800 = (SubDeviceRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LIST_SUB_DEVICE_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, SubDeviceRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            return respondIvs1800.getCameraBriefInfos().getJSONArray("cameraBriefInfoList");
        }
        catch (SDKException e) {
            LOGGER.error("getCameraArray", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public DeviceInfoRespond getDeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        JSONObject dataObject = new JSONObject();
        dataObject.put("configType", (Object)2);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if ("2130000000".equals(rsp.getString("resultCode"))) {
                DeviceInfoRespond deviceInfo = this.get8_1DeviceInfo(vcmInfo);
                return deviceInfo;
            }
            this.checkJsonRespond(rsp);
            JSONObject configObject = rsp.getJSONObject("configItem").getJSONObject("deviceBaseInfo");
            respond.setModel(configObject.getString("deviceType"));
            respond.setDeviceVersion(configObject.getString("version"));
            if (configObject.containsKey((Object)"deviceModel")) {
                respond.setDeviceModel(configObject.getString("deviceModel"));
            }
            respond.setProductName(configObject.getString("deviceType"));
            respond.setAiPower(configObject.getString("AIPower"));
            respond.setMaxChannelNumber(configObject.getInteger("channelNum"));
            respond.setIntelliTask(configObject.getJSONObject("capabilityInfo").getBoolean("IntelliTask"));
            respond.setTargetMaskTempPlatformAlarm(configObject.getJSONObject("capabilityInfo").getBoolean("targetMaskTempPlatformAlarm"));
            respond.setStandardRTSPForNat(configObject.getJSONObject("capabilityInfo").getBoolean("standardRTSPForNat"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get device error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    private DeviceInfoRespond get8_1DeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        JSONObject dataObject = new JSONObject();
        dataObject.put("configType", (Object)1);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject configObject = rsp.getJSONObject("configItem").getJSONObject("deviceVersionInfo");
            if ("A".equals(configObject.getString("model"))) {
                respond.setModel("IVS1800");
            } else {
                respond.setModel(configObject.getString("model"));
            }
            respond.setDeviceVersion(configObject.getString("version"));
            respond.setProductName(configObject.getString("productName"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get8_1 device error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public List<DeviceRouteRespond> getDeviceRoute(VcmReqBaseInfo vcmInfo) {
        ArrayList<DeviceRouteRespond> respondList = new ArrayList<DeviceRouteRespond>();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_ROUTE_INFO, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray routeArray = rsp.getJSONObject("domainRouteInfos").getJSONObject("domainRouteList").getJSONArray("domainRoute");
            if (!CollectionUtils.isEmpty((Collection)routeArray)) {
                for (int i = 0; i < routeArray.size(); ++i) {
                    JSONObject routeObject = routeArray.getJSONObject(i);
                    DeviceRouteRespond respond = new DeviceRouteRespond();
                    respond.setDomainCode(routeObject.getString("domainCode"));
                    respond.setIp(routeObject.getJSONObject("domainIPInfo").getString("ip"));
                    respondList.add(respond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get device route error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    public Boolean stopSearch(VcmReqBaseInfo vcmInfo, CameraValidRequest request) {
        Document document = DocumentHelper.createDocument();
        Element content = document.addElement("Content");
        Element serverCode = content.addElement("ServerCode");
        serverCode.setText(request.getDomainCode());
        String requestXml = document.getRootElement().asXML();
        JSONObject dataObject = new JSONObject();
        dataObject.put("searchInfo", (Object)requestXml);
        dataObject.put("domainCode", (Object)request.getDomainCode());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_STOP_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 stop search error,IP" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Nvr800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    public DeviceRouteRespond getDeviceVersion(VcmReqBaseInfo vcmInfo) {
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_ROUTE_INFO, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONArray routeArray = rsp.getJSONObject("domainRouteInfos").getJSONObject("domainRouteList").getJSONArray("domainRoute");
            DeviceInfoRespond deviceInfo = this.getDeviceInfo(vcmInfo);
            DeviceRouteRespond respond = new DeviceRouteRespond();
            if (!CollectionUtils.isEmpty((Collection)routeArray)) {
                for (int i = 0; i < routeArray.size(); ++i) {
                    JSONObject routeObject = routeArray.getJSONObject(i);
                    respond = new DeviceRouteRespond();
                    respond.setDomainCode(routeObject.getString("domainCode"));
                    respond.setIp(routeObject.getJSONObject("domainIPInfo").getString("ip"));
                    respond.setDeviceVersion(deviceInfo.getDeviceVersion());
                    respond.setModel(deviceInfo.getModel());
                    respond.setProductName(deviceInfo.getProductName());
                }
            }
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get device route error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public List<AlarmSourceRespond> getAlarmSource(ParamBean<AlarmSourceRequest> obj) {
        ArrayList<AlarmSourceRespond> respondList = new ArrayList<AlarmSourceRespond>();
        try {
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("fromIndex", "1");
            httpUrlParam.addParam("toIndex", "1000");
            httpUrlParam.addParam("deviceType", "4");
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.LIST_SUB_DEVICE_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(rsp);
            JSONObject res = this.getAlarmIODevice(obj.getVcmInfo());
            JSONArray alarmIOOutputList = res.getJSONArray("alarmIOOutputList");
            JSONArray alarmIOInputList = res.getJSONArray("alarmIOInputList");
            JSONArray alarmArray = rsp.getJSONObject("alarmBriefInfos").getJSONArray("alarmBriefInfos");
            String deviceGroupCode = null;
            String isExDomain = null;
            String parentCode = null;
            if (!CollectionUtils.isEmpty((Collection)alarmArray)) {
                for (int i = 0; i < alarmArray.size(); ++i) {
                    JSONObject alarmObject = alarmArray.getJSONObject(i);
                    Optional respond = JsonUtil.convertJsonToBean((String)alarmObject.toJSONString(), AlarmSourceRespond.class);
                    respond.ifPresent(respondList::add);
                    deviceGroupCode = alarmObject.getString("deviceGroupCode");
                    isExDomain = alarmObject.getString("isExDomain");
                    parentCode = alarmObject.getString("parentCode");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)alarmIOOutputList)) {
                for (int j = 0; j < alarmIOOutputList.size(); ++j) {
                    JSONObject alarmIOOutput = alarmIOOutputList.getJSONObject(j);
                    AlarmSourceRespond alarmSourceRespond = new AlarmSourceRespond();
                    alarmSourceRespond.setAlarmName(alarmIOOutput.getString("Name"));
                    alarmSourceRespond.setAlarmCode(alarmIOOutput.getString("ID"));
                    alarmSourceRespond.setDomainCode(alarmIOOutput.getString("NVRCode"));
                    alarmSourceRespond.setParentCode(alarmSourceRespond.getAlarmCode());
                    alarmSourceRespond.setDeviceGroupCode(deviceGroupCode);
                    alarmSourceRespond.setIsExDomain(isExDomain);
                    alarmSourceRespond.setChannelType(Integer.valueOf(1));
                    respondList.add(alarmSourceRespond);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)alarmIOInputList)) {
                for (int j = 0; j < alarmIOInputList.size(); ++j) {
                    JSONObject alarmIOInput = alarmIOInputList.getJSONObject(j);
                    AlarmSourceRespond alarmSourceRespond = new AlarmSourceRespond();
                    alarmSourceRespond.setAlarmName(alarmIOInput.getString("Name"));
                    alarmSourceRespond.setAlarmCode(alarmIOInput.getString("ID") + "#" + alarmIOInput.getString("NVRCode"));
                    alarmSourceRespond.setDomainCode(alarmIOInput.getString("NVRCode"));
                    alarmSourceRespond.setParentCode(alarmSourceRespond.getAlarmCode());
                    alarmSourceRespond.setDeviceGroupCode(deviceGroupCode);
                    alarmSourceRespond.setIsExDomain(isExDomain);
                    alarmSourceRespond.setChannelType(Integer.valueOf(0));
                    respondList.add(alarmSourceRespond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getSubDeviceList error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    public JSONObject getAlarmIODevice(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject rsp;
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LIST_ALARM_IO_DEVICE_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getAlarmIODevice error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return rsp;
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmReqBaseInfo, CameraSearchRequest request) {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.subscriptionHelp.get(request.getDomainCode()) == null) {
                    vcmReqBaseInfo.setDomainCode(vcmReqBaseInfo.getDomainCode());
                    this.alarmIvs1800Service.register(vcmReqBaseInfo, DeviceUtil.getCallBackUrl((VcmReqBaseInfo)vcmReqBaseInfo));
                }
                Document document = DocumentHelper.createDocument();
                Element content = document.addElement("Content");
                Element searchInfo = content.addElement("SearchInfo");
                Element protocolType = searchInfo.addElement("ProtocolType");
                Element serverCode = searchInfo.addElement("ServerCode");
                serverCode.setText(request.getDomainCode());
                if ("0".equals(request.getProtocolType())) {
                    protocolType.setText("ONVIF");
                } else {
                    protocolType.setText("HWSDK");
                }
                Element ipList = searchInfo.addElement("IPList");
                if (!CollectionUtils.isEmpty((Collection)request.getIpList())) {
                    for (CameraSearchRequest.IpInfo ip : request.getIpList()) {
                        Element ipInfo = ipList.addElement("IPInfo");
                        Element startIp = ipInfo.addElement("DevIPFrom");
                        startIp.setText(ip.getStartIp());
                        Element endIp = ipInfo.addElement("DevIPTo");
                        endIp.setText(ip.getEndIp());
                        Element element = ipInfo.addElement("DevPort");
                    }
                }
                String requestXml = document.getRootElement().asXML();
                JSONObject dataObject = new JSONObject();
                dataObject.put("searchInfo", (Object)requestXml);
                BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_CAMERA_SEARCH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                this.checkRespond(respondIvs1800);
            }
            catch (Exception e) {
                LOGGER.error("IVS 1800 search camera error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
                DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
                deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
                deviceEventRespond.setDomainCode(request.getDomainCode());
                deviceEventRespond.setPercent("100");
                deviceEventRespond.setSubtype("searchCamera");
                this.webSocketService.send((BaseEventRespond)deviceEventRespond);
            }
        });
        return new ArrayList<CameraSearchRespond>();
    }

    public CameraSearchRespond validCamera(VcmReqBaseInfo vcmInfo, CameraValidRequest request) {
        CameraSearchRespond cameraSearchRespond = new CameraSearchRespond();
        Document document = DocumentHelper.createDocument();
        Element content = document.addElement("Content");
        Element validInfo = content.addElement("ValidateInfo");
        Element serverCode = validInfo.addElement("ServerCode");
        serverCode.setText(request.getDomainCode());
        Element protocolType = validInfo.addElement("ProtocolType");
        protocolType.setText(request.getProtocolType());
        Element ip = validInfo.addElement("DevIP");
        ip.setText(request.getIp());
        Element port = validInfo.addElement("DevPort");
        port.setText(request.getPort());
        Element user = validInfo.addElement("DevUser");
        user.setText(request.getDeviceUser());
        Element password = validInfo.addElement("DevPWD");
        password.setText(request.getDevicePassword());
        String requestXml = document.getRootElement().asXML();
        JSONObject dataObject = new JSONObject();
        dataObject.put("verifyInfo", (Object)requestXml);
        dataObject.put("domainCode", (Object)request.getDomainCode());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.DEVICE_CAMERA_VALID, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            if (Objects.nonNull(rsp) && StringUtils.isNotBlank((CharSequence)rsp.getString("resultCode")) && "189108068".equals(rsp.getString("resultCode"))) {
                cameraSearchRespond.setResultCode(rsp.getString("resultCode"));
            } else {
                this.checkJsonRespond(rsp);
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 valid camera error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return cameraSearchRespond;
    }

    public boolean modifyDevicePassword(ParamBean<InitPasswordUpdateRequest> obj) {
        InitPasswordUpdateRequest updateRequest = (InitPasswordUpdateRequest)obj.getRequestBody();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_MODIFY_PASSWORD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)updateRequest, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()), (int)40);
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Modify DevicePassword fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public ParentDeviceStateRespond getParentDeviceState(VcmReqBaseInfo vcmReqBaseInfo) {
        ParentDeviceStateRespond respond = new ParentDeviceStateRespond();
        respond.setResultCode("0");
        respond.setParentDeviceId(vcmReqBaseInfo.getParentDeviceId());
        respond.setDomainCode(vcmReqBaseInfo.getDomainCode());
        if (StringUtils.isBlank((CharSequence)vcmReqBaseInfo.getVcmSession())) {
            return respond;
        }
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.PARENT_DEVICE_STATE, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(rsp);
            JSONObject config = rsp.getJSONObject("performance");
            respond.setCpuRate(config.getIntValue("cpuRate"));
            respond.setMemUsed(config.getFloatValue("memUsed"));
            respond.setMemTotal(config.getFloatValue("memTotal"));
            respond.setAiRate(config.getIntValue("aiRate"));
            respond.setBkpUsed(config.getFloatValue("bkpUsed"));
            respond.setBkpTotal(config.getFloatValue("bkpTotal"));
            respond.setAppUsed(config.getFloatValue("appUsed"));
            respond.setAppTotal(config.getFloatValue("appTotal"));
            respond.setDataUsed(config.getFloatValue("dataUsed"));
            respond.setDataTotal(config.getFloatValue("dataTotal"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get parent device state error,IP" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            respond.setResultCode(e.getErrorCode());
        }
        catch (InvokeException e) {
            respond.setResultCode(e.getCode());
        }
        try {
            AlgorithmRequest algorithmRequest = new AlgorithmRequest();
            algorithmRequest.setType("12");
            algorithmRequest.setLanguage("zh_CN");
            AlgorithmRespond algorithmRespond = this.intelligentAnalysis1800Service.loadAlgorithm(vcmReqBaseInfo, algorithmRequest);
            if (CollectionUtils.isEmpty((Collection)algorithmRespond.getAlgorithms())) {
                respond.setAlgorithmNumber(0);
            } else {
                respond.setAlgorithmNumber(algorithmRespond.getAlgorithms().size());
            }
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 get parent device state get algorithm number error,IP" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        respond.setSn(this.getDeviceSn(vcmReqBaseInfo));
        return respond;
    }

    private String getDeviceSn(VcmReqBaseInfo vcmReqBaseInfo) {
        String sn = "";
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("configType", (Object)4);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_GET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(rsp);
            sn = rsp.getJSONObject("configItem").getJSONObject("deviceCodeInfo").getString("serialNumber");
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 get device sn error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return sn;
    }

    public JSONObject removeCameras(ParamBean<CameraRemoveRequest> obj) {
        try {
            JSONObject devCodes = new JSONObject();
            devCodes.put("deviceCode", (Object)((CameraRemoveRequest)obj.getRequestBody()).getCameraCodes());
            JSONObject dataObject = new JSONObject();
            dataObject.put("deviceCodeList", (Object)devCodes);
            dataObject.put("deviceNum", (Object)((CameraRemoveRequest)obj.getRequestBody()).getCameraCodes().size());
            CameraRemoveRespondIvs1800 respondIvs1800 = (CameraRemoveRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.CAMERA_REMOVE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraRemoveRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            JSONObject rsp = new JSONObject();
            rsp.put("result", JSON.toJSON((Object)respondIvs1800));
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("IVS1800 remove cameras fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public Boolean autoCaptureSet(ParamBean<EmptyRequest> obj) {
        try {
            JSONObject enableSwitch = new JSONObject();
            enableSwitch.put("enable", (Object)1);
            JSONObject autoSnapshotConfig = new JSONObject();
            autoSnapshotConfig.put("autoSnapshotConfig", (Object)enableSwitch);
            JSONObject dataObject = new JSONObject();
            dataObject.put("configType", (Object)100);
            dataObject.put("configItem", (Object)autoSnapshotConfig);
            CameraRemoveRespondIvs1800 respondIvs1800 = (CameraRemoveRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SYSTEM_CONFIG_SET_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraRemoveRespondIvs1800.class));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 auto Capture Set error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
        }
        return true;
    }

    public DeviceInfoRespond getCameraInfo(ParamBean<CameraRequest> obj) {
        JSONObject infoObject = new JSONObject();
        infoObject.put("requestUrl", (Object)"GET /SDCAPI/V1.0/MiscIaas/System");
        JSONObject data = new JSONObject();
        data.put("info", (Object)infoObject);
        data.put("cameraCode", (Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(result);
            String ret = result.getString("resultInfo").replaceAll("\n", "").replaceAll("\\\\", "");
            LOGGER.info("IVS 1800 get camera info data: {}", (Object)ret);
            JSONObject deviceData = JSONArray.parseArray((String)ret).getJSONObject(0).getJSONObject("Data");
            respond.setHardwareId(deviceData.getString("drvCode"));
            respond.setCpuOccupyRate(Integer.valueOf((int)(deviceData.getFloat("cpuOccupyRate").floatValue() * 100.0f)));
            respond.setFreeMem(deviceData.getJSONObject("memInfo").getJSONObject("osMemInfo").getInteger("freeMem"));
            respond.setTotalMem(deviceData.getJSONObject("memInfo").getJSONObject("osMemInfo").getInteger("totalMem"));
            respond.setFlashFreeMem(deviceData.getJSONObject("flashInfo").getInteger("freeFlashSize"));
            respond.setFlashTotalMem(deviceData.getJSONObject("flashInfo").getInteger("totalFlashSize"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get camera info error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public List<CameraThirdAlgorithmRespond> getCameraThirdAlgorithm(ParamBean<CameraRequest> obj) {
        ArrayList<CameraThirdAlgorithmRespond> respondList = new ArrayList<CameraThirdAlgorithmRespond>();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/device/thirdalgorithm/" + ((CameraRequest)obj.getRequestBody()).getCameraCode()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(result);
            if (result.getJSONObject("configItem").getJSONArray("thirdAlgorithmList") != null) {
                for (int i = 0; i < result.getJSONObject("configItem").getJSONArray("thirdAlgorithmList").size(); ++i) {
                    CameraThirdAlgorithmRespond respond = new CameraThirdAlgorithmRespond();
                    JSONObject algorithm = result.getJSONObject("configItem").getJSONArray("thirdAlgorithmList").getJSONObject(i);
                    respond.setDesc(algorithm.getString("appDesc"));
                    respond.setName(algorithm.getString("appName"));
                    respond.setNameEn(algorithm.getString("appName_en"));
                    respond.setState(algorithm.getString("appMgrStat"));
                    respond.setRunState(algorithm.getString("appRunStat"));
                    respond.setVersion(algorithm.getString("appVersion"));
                    respond.setImage(algorithm.getString("normalImage"));
                    respondList.add(respond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get camera third algorithm error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    public DeviceInfoRespond getLicenseStatus(ParamBean<CameraRequest> obj) {
        JSONObject infoObject = new JSONObject();
        infoObject.put("requestUrl", (Object)"GET /SDCAPI/V1.0/App/AppList?Image=0");
        JSONObject data = new JSONObject();
        data.put("info", (Object)infoObject);
        data.put("cameraCode", (Object)((CameraRequest)obj.getRequestBody()).getCameraCode());
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            JSONObject result = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(result);
            String ret = result.getString("resultInfo").replaceAll("\n", "").replaceAll("\\\\", "");
            LOGGER.info("IVS 1800 get License Status data: {}", (Object)ret);
            ArrayList<DeviceInfoRespond.AppParam> appParam = new ArrayList<DeviceInfoRespond.AppParam>();
            JSONObject deviceData = JSONArray.parseArray((String)ret).getJSONObject(0).getJSONObject("Data");
            if (Objects.nonNull(deviceData) && deviceData.containsKey((Object)"apps")) {
                JSONArray apps = deviceData.getJSONArray("apps");
                for (int i = 0; i < apps.size(); ++i) {
                    DeviceInfoRespond.AppParam appParamObj = new DeviceInfoRespond.AppParam();
                    JSONObject appLicense = apps.getJSONObject(i).getJSONObject("appLicense");
                    appParamObj.setAppName(apps.getJSONObject(i).getString("appName"));
                    appParamObj.setAppVersion(apps.getJSONObject(i).getString("appVersion"));
                    appParamObj.setExpiredDay(appLicense.getString("expiredDay"));
                    appParamObj.setLicenseType(appLicense.getString("licenseType"));
                    appParamObj.setRemainTime(appLicense.getString("remainTime"));
                    appParamObj.setStartDate(appLicense.getString("startDate"));
                    appParam.add(appParamObj);
                }
            }
            respond.setApps(appParam);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get License Status error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

