/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.ColorConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.DateTimeRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.deviceconfig.OsdConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.ColorConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.DateTimeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.deviceconfig.OsdConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.ConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceInfoConfigService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.DeviceConfigManageIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceInfoConfigIvs1800ServiceImpl
extends AbstractIvs1800Service
implements DeviceInfoConfigService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceInfoConfigIvs1800ServiceImpl.class);
    @Autowired
    private DeviceConfigManageIvs1800ServiceImpl deviceConfigManageIvs1800Service;

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public DateTimeRespond getTimeConfig(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean setTimeConfig(ParamBean<DateTimeRequest> obj) {
        return false;
    }

    public OsdConfigRespond getOsdConfig(ParamBean<OsdConfigRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((OsdConfigRequest)obj.getRequestBody()).getChannelCode(), obj.getVcmInfo().getDomainCode(), 8);
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("cameraOSDConfig");
        OsdConfigRespond respond = new OsdConfigRespond();
        respond.getTime().setShow(Boolean.valueOf(configObject.getJSONObject("osdTime").getBooleanValue("enableOSDTime")));
        respond.getTime().getPos().setTextX(String.valueOf(Math.round(configObject.getJSONObject("osdTime").getFloatValue("timeX") * 704.0f)));
        respond.getTime().getPos().setTextY(String.valueOf(Math.round(configObject.getJSONObject("osdTime").getFloatValue("timeY") * 576.0f)));
        JSONArray osdNameArray = configObject.getJSONArray("osdNameList");
        if (!CollectionUtils.isEmpty((Collection)osdNameArray)) {
            for (int i = 0; i < osdNameArray.size(); ++i) {
                OsdConfigRespond.OsdName osdName = new OsdConfigRespond.OsdName();
                JSONObject osdNameObject = osdNameArray.getJSONObject(i);
                osdName.setShow(Boolean.valueOf(osdNameObject.getIntValue("enableOSDName") == 1));
                osdName.getPos().setTextX(String.valueOf(Math.round(osdNameObject.getJSONObject("rectText").getFloatValue("left") * 704.0f)));
                osdName.getPos().setTextY(String.valueOf(Math.round(osdNameObject.getJSONObject("rectText").getFloatValue("top") * 576.0f)));
                osdName.setText(osdNameObject.getString("osdNameText"));
                respond.getTexts().add(osdName);
            }
        }
        return respond;
    }

    public boolean setOsdConfig(ParamBean<OsdConfigRequest> obj) {
        OsdConfigRequest request = (OsdConfigRequest)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("enableOSD", (Object)1);
        JSONObject osdTimeObject = new JSONObject();
        osdTimeObject.put("enableOSDTime", (Object)(request.getOsdConfig().getTime().getShow() != false ? 1 : 0));
        osdTimeObject.put("timeFormat", (Object)1);
        osdTimeObject.put("timeX", (Object)Float.valueOf(Float.parseFloat(request.getOsdConfig().getTime().getPos().getTextX()) / 704.0f));
        osdTimeObject.put("timeY", (Object)Float.valueOf(Float.parseFloat(request.getOsdConfig().getTime().getPos().getTextY()) / 576.0f));
        osdTimeObject.put("reserve", (Object)"");
        configObject.put("osdTime", (Object)osdTimeObject);
        JSONArray osdNameArray = new JSONArray();
        if (!CollectionUtils.isEmpty((Collection)request.getOsdConfig().getTexts())) {
            for (int i = 0; i < request.getOsdConfig().getTexts().size(); ++i) {
                JSONObject osdNameObject = new JSONObject();
                OsdConfigRespond.OsdName osdName = (OsdConfigRespond.OsdName)request.getOsdConfig().getTexts().get(i);
                osdNameObject.put("enableOSDName", (Object)(osdName.getShow() != false ? 1 : 0));
                osdNameObject.put("osdNameText", (Object)osdName.getText());
                JSONObject namePositionObject = new JSONObject();
                namePositionObject.put("left", (Object)Float.valueOf(Float.parseFloat(osdName.getPos().getTextX()) / 704.0f));
                namePositionObject.put("top", (Object)Float.valueOf(Float.parseFloat(osdName.getPos().getTextY()) / 576.0f));
                osdNameObject.put("rectText", (Object)namePositionObject);
                osdNameObject.put("enableSwitch", (Object)0);
                osdNameObject.put("switchInterval", (Object)0);
                osdNameObject.put("enableTextBlink", (Object)0);
                osdNameObject.put("enableTextTranslucent", (Object)0);
                osdNameObject.put("textTranslucentPercent", (Object)100);
                osdNameObject.put("reserve", (Object)"");
                osdNameArray.add((Object)osdNameObject);
            }
        }
        configObject.put("osdNameList", (Object)osdNameArray);
        configObject.put("reserve", (Object)"");
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraOSDConfig", (Object)configObject);
        return this.deviceConfigManageIvs1800Service.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(8), dataObject, request.getChannelCode());
    }

    public ColorConfigRespond getColorConfig(ParamBean<ColorConfigRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((ColorConfigRequest)obj.getRequestBody()).getChannelCode(), obj.getVcmInfo().getDomainCode(), 6);
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("cameraDisplayConfig");
        ColorConfigRespond configRespond = new ColorConfigRespond();
        configRespond.setHue(configObject.getIntValue("hue"));
        configRespond.setBright(configObject.getIntValue("brightness"));
        configRespond.setContrast(configObject.getIntValue("contrast"));
        configRespond.setSaturation(configObject.getIntValue("saturation"));
        ColorConfigRespond.ColorRange colorRange = new ColorConfigRespond.ColorRange();
        colorRange.setHueMin(0);
        colorRange.setHueMax(255);
        colorRange.setContrastMin(0);
        colorRange.setContrastMax(255);
        colorRange.setBrightMin(0);
        colorRange.setBrightMax(255);
        colorRange.setSaturationMin(0);
        colorRange.setSaturationMax(255);
        colorRange.setSharpnessMin(0);
        if (configObject.containsKey((Object)"sharp")) {
            configRespond.setSharpness(configObject.getIntValue("sharp"));
            colorRange.setSharpnessMax(255);
        } else {
            configRespond.setSharpness(0);
            colorRange.setSharpnessMax(0);
        }
        configRespond.setRange(colorRange);
        return configRespond;
    }

    public boolean setColorConfig(ParamBean<ColorConfigRequest> obj) {
        ColorConfigRequest request = (ColorConfigRequest)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("hue", (Object)request.getColorConfig().getHue());
        configObject.put("brightness", (Object)request.getColorConfig().getBright());
        configObject.put("contrast", (Object)request.getColorConfig().getContrast());
        configObject.put("saturation", (Object)request.getColorConfig().getSaturation());
        configObject.put("sharp", (Object)request.getColorConfig().getSharpness());
        configObject.put("reserve", (Object)"");
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraDisplayConfig", (Object)configObject);
        return this.deviceConfigManageIvs1800Service.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(6), dataObject, request.getChannelCode());
    }

    private ConfigRespondIvs1800 getConfig(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode, String domainCode, int type) {
        ConfigRespondIvs1800 respondIvs1800;
        String url = "/device/deviceconfig/" + type + "/" + cameraCode + "/" + domainCode;
        try {
            respondIvs1800 = (ConfigRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ConfigRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        return respondIvs1800;
    }
}

