/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.StreamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraExtendConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraExtendConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.ConfigRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.request.cu.device.CameraV2Request;
import com.zkteco.zkbiosecurity.cuserver.dto.v2.respond.cu.device.CameraV2Respond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceConfigManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceConfigManageIvs1800ServiceImpl
extends AbstractIvs1800Service
implements DeviceConfigManageService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceConfigManageIvs1800ServiceImpl.class);
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;

    public CameraV2Respond getBaseConfig(ParamBean<CameraRequest> obj) {
        JSONObject authAbility;
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 1);
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("deviceConfig");
        JSONObject deviceObject = configObject.getJSONObject("deviceBasicInfo");
        CameraV2Respond respond = new CameraV2Respond();
        respond.setCameraCode(deviceObject.getString("code"));
        respond.setCameraName(deviceObject.getString("name"));
        respond.setConnectCode(deviceObject.getString("code"));
        respond.setDomainCode(deviceObject.getString("domainCode"));
        respond.setIp(deviceObject.getJSONObject("ipInfo").getString("ip"));
        respond.setPort(deviceObject.getString("port"));
        respond.setModel(deviceObject.getString("model"));
        respond.setVendor(deviceObject.getString("vendorType"));
        respond.setProtocolType(configObject.getString("protocolType"));
        respond.setUserName(configObject.getString("deviceUser"));
        respond.setSerialNumber(deviceObject.getString("serialNumber"));
        respond.setCategory(Integer.valueOf(DeviceTypeEnum.IVS1800.val()));
        respond.setFormType(deviceObject.getInteger("type").intValue());
        respond.setEnableAlarm(configObject.getInteger("enableAlarm"));
        respond.setReserve(configObject);
        if ("HUAWEI".equalsIgnoreCase(respond.getVendor())) {
            respond.setVendor("HW");
        }
        if (Objects.nonNull(authAbility = this.getAuthAbility(obj))) {
            respond.setModifyAllPwd(Boolean.valueOf(authAbility.getBooleanValue("supportModifyAllPwd")));
        } else {
            respond.setModifyAllPwd(null);
        }
        return respond;
    }

    private JSONObject getAuthAbility(ParamBean<CameraRequest> obj) {
        try {
            ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 930);
            return respondIvs1800.getConfigItem();
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 get AuthAbility error,IP:" + obj.getVcmInfo(), (Throwable)e);
            return null;
        }
    }

    public JSONObject getTimeConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 3);
        return respondIvs1800.getConfigItem().getJSONObject("deviceTimeConfig");
    }

    public CameraV2Respond getCameraBaseConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 4);
        CameraV2Respond respond = new CameraV2Respond();
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("cameraConfig");
        respond.setVideoChannel(configObject.getInteger("videoChannel"));
        respond.setCameraCode(configObject.getString("cameraCode"));
        respond.setCameraName(configObject.getString("cameraName"));
        respond.setCameraPosition(configObject.getJSONObject("cameraPosition"));
        respond.setBroadcastInfo(configObject.getJSONObject("broadcastInfo"));
        respond.setVoiceOutCode(configObject.getString("voiceOutCode"));
        respond.setDomainCode(((CameraRequest)obj.getRequestBody()).getDomainCode());
        respond.setCameraType(configObject.getString("cameraType"));
        respond.setImgType(configObject.getIntValue("imgType"));
        respond.setParentCode(configObject.getString("parentCode"));
        respond.setComposeImg(configObject.getInteger("isComposeImg"));
        respond.setWithCarCode(configObject.getInteger("isWithCarCode"));
        return respond;
    }

    public Boolean setCameraBaseConfig(ParamBean<CameraV2Request> obj) {
        CameraV2Request request = (CameraV2Request)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("videoChannel", (Object)request.getVideoChannel());
        configObject.put("cameraCode", (Object)request.getCameraCode());
        configObject.put("cameraName", (Object)request.getCameraName());
        configObject.put("cameraPosition", (Object)request.getCameraPosition());
        configObject.put("isSupportBroadcast", (Object)0);
        configObject.put("broadcastInfo", (Object)request.getBroadcastInfo());
        configObject.put("enableVoice", (Object)0);
        configObject.put("voiceOutCode", (Object)request.getVoiceOutCode());
        configObject.put("parentCode", (Object)request.getParentCode());
        configObject.put("nvrCode", (Object)request.getDomainCode());
        configObject.put("cameraType", (Object)Integer.parseInt(request.getCameraType()));
        configObject.put("cameraStatus", (Object)1);
        configObject.put("reserve", (Object)"");
        configObject.put("imgType", (Object)request.getImgType());
        if (Objects.nonNull(request.getComposeImg())) {
            configObject.put("isComposeImg", (Object)request.getComposeImg());
        }
        if (Objects.nonNull(request.getWithCarCode())) {
            configObject.put("isWithCarCode", (Object)request.getWithCarCode());
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraConfig", (Object)configObject);
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(4), dataObject, request.getCameraCode());
    }

    public Boolean setMainBaseConfig(ParamBean<CameraV2Request> obj) {
        CameraV2Request request = (CameraV2Request)obj.getRequestBody();
        JSONObject reserve = request.getReserve();
        reserve.put("enableAlarm", (Object)request.getEnableAlarm());
        reserve.getJSONObject("deviceBasicInfo").put("name", (Object)request.getCameraName());
        JSONObject dataObject = new JSONObject();
        dataObject.put("deviceConfig", (Object)reserve);
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(1), dataObject, request.getCameraCode());
    }

    public JSONObject getCameraStreamConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 5);
        return respondIvs1800.getConfigItem().getJSONObject("cameraStreamConfig");
    }

    public JSONObject getCameraOSDConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 8);
        return respondIvs1800.getConfigItem().getJSONObject("cameraOSDConfig");
    }

    public JSONObject getCameraAudioConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 12);
        return respondIvs1800.getConfigItem().getJSONObject("alarmInConfig");
    }

    public JSONObject getCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 14);
        return respondIvs1800.getConfigItem().getJSONObject("alarmInConfig");
    }

    public Boolean setCameraAlarmInConfig(ParamBean<CameraRequest> obj) {
        CameraRequest request = (CameraRequest)obj.getRequestBody();
        JSONObject dataObject = new JSONObject();
        dataObject.put("alarmInConfig", (Object)request.getAlarmInConfig());
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(14), dataObject, request.getCameraCode());
    }

    public JSONObject getCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((CameraRequest)obj.getRequestBody()).getCameraCode(), obj.getVcmInfo().getDomainCode(), 15);
        return respondIvs1800.getConfigItem().getJSONObject("alarmOutConfig");
    }

    public Boolean setCameraAlarmOutConfig(ParamBean<CameraRequest> obj) {
        CameraRequest request = (CameraRequest)obj.getRequestBody();
        JSONObject dataObject = new JSONObject();
        dataObject.put("alarmOutConfig", (Object)request.getAlarmOutConfig());
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(15), dataObject, request.getCameraCode());
    }

    public StreamBean getMainStreamConfig(ParamBean<ChannelRequest> obj) {
        StreamBean streamBean = new StreamBean();
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((ChannelRequest)obj.getRequestBody()).getChannelCode(), obj.getVcmInfo().getDomainCode(), 5);
        JSONArray configArray = respondIvs1800.getConfigItem().getJSONObject("cameraStreamConfig").getJSONArray("streamInfoList");
        streamBean.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
        JSONObject fullFrameRate = null;
        if ("S100".equals(((ChannelRequest)obj.getRequestBody()).getClientType())) {
            fullFrameRate = this.getFullFrameRate(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 0);
        }
        if (!CollectionUtils.isEmpty((Collection)configArray)) {
            for (int i = 0; i < configArray.size(); ++i) {
                JSONObject configObject = configArray.getJSONObject(i);
                if (configObject.getIntValue("streamType") != 1) continue;
                streamBean.setMaxFrameRae(configObject.getIntValue("bitRate"));
                if (Objects.nonNull(fullFrameRate)) {
                    streamBean.setResolution(fullFrameRate.getString("resolution"));
                    streamBean.setFps(fullFrameRate.getIntValue("frameRate"));
                } else {
                    streamBean.setResolution(configObject.getString("resolution"));
                    streamBean.setFps(configObject.getIntValue("frameRate"));
                }
                streamBean.setBitrate(configObject.getIntValue("bitRate"));
                streamBean.setCustomBitrate(configObject.getIntValue("bitRate"));
                streamBean.setTransProtocol(configObject.getInteger("transProtocol").intValue());
                if ("0".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("H.265");
                } else if ("1".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("H.264");
                } else if ("2".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MJPEG");
                } else if ("3".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MPEG4");
                } else if ("4".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MPEG2");
                } else if ("5".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("AVS");
                }
                if ("0".equals(configObject.getString("picQuality"))) {
                    streamBean.setVideoQuality("Higher");
                } else if ("1".equals(configObject.getString("picQuality"))) {
                    streamBean.setVideoQuality("Medium");
                } else {
                    streamBean.setVideoQuality("Low");
                }
                streamBean.setBitrateMode(configObject.getString("bitRateType"));
                streamBean.setIFrameInterval(configObject.getIntValue("frameInterval"));
                if ("0".equals(configObject.getString("bitRateType"))) {
                    streamBean.setBitrateControl("CBR");
                    continue;
                }
                streamBean.setBitrateControl("VBR");
            }
        }
        if (Objects.nonNull(fullFrameRate)) {
            streamBean.setRange(this.getStreamRange(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 0, fullFrameRate.getIntValue("fullFrameRate")));
        } else {
            streamBean.setRange(this.getStreamRange(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 0, -1));
        }
        return streamBean;
    }

    private JSONObject getFullFrameRate(VcmReqBaseInfo vcmInfo, ChannelRequest request, int streamType) {
        PenetrateRequest penetrateRequest = new PenetrateRequest();
        penetrateRequest.setRequestMethod("GET");
        penetrateRequest.setChannelCode(request.getChannelCode() + "#" + request.getDomainCode());
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(vcmInfo);
        penetrateRequest.setRequestUrl(SdcMsgType.CHANNELS_CFG.getUri());
        paramBean.setRequestBody((Object)penetrateRequest);
        JSONObject FRObject = new JSONObject();
        JSONObject channelsCfg = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data");
        FRObject.put("fullFrameRate", (Object)channelsCfg.getIntValue("fullFrameRate"));
        JSONArray frameRate = channelsCfg.getJSONArray("streamInfo");
        if (!CollectionUtils.isEmpty((Collection)frameRate)) {
            for (int i = 0; i < frameRate.size(); ++i) {
                JSONObject frameRateObject = frameRate.getJSONObject(i);
                if (frameRateObject.getIntValue("streamType") != streamType) continue;
                FRObject.put("resolution", (Object)frameRateObject.getString("resolution"));
                FRObject.put("frameRate", (Object)frameRateObject.getIntValue("frameRate"));
            }
        }
        return FRObject;
    }

    private StreamBean.StreamRange getStreamRange(VcmReqBaseInfo vcmInfo, ChannelRequest request, int streamType, int fullFrameRate) {
        StreamBean.StreamRange streamRange = new StreamBean.StreamRange();
        ArrayList<Integer> bitRateRangeList = new ArrayList<Integer>();
        ArrayList<String> resolutionRangeList = new ArrayList<String>();
        ArrayList<String> videoEncodeTypeRangeList = new ArrayList<String>();
        ArrayList<Integer> fpsRangeList = new ArrayList<Integer>();
        try {
            JSONArray fullFrameRateArray;
            PenetrateRequest penetrateRequest = new PenetrateRequest();
            penetrateRequest.setRequestMethod("GET");
            penetrateRequest.setChannelCode(request.getChannelCode() + "#" + request.getDomainCode());
            ParamBean paramBean = new ParamBean();
            penetrateRequest.setRequestUrl(SdcMsgType.VIDEO_ABILITY.getUri());
            paramBean.setVcmInfo(vcmInfo);
            paramBean.setRequestBody((Object)penetrateRequest);
            JSONObject rangeConfig = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data");
            if (rangeConfig.containsKey((Object)"H264Info")) {
                videoEncodeTypeRangeList.add("H.264");
            }
            if (rangeConfig.containsKey((Object)"H265Info")) {
                videoEncodeTypeRangeList.add("H.265");
            }
            if (rangeConfig.containsKey((Object)"MJPEGInfo")) {
                videoEncodeTypeRangeList.add("MJPEG");
            }
            if (!CollectionUtils.isEmpty((Collection)(fullFrameRateArray = rangeConfig.getJSONArray("fullFrameRate")))) {
                String[] bitRateArray;
                String bitRateBegin = "";
                String bitRateEnd = "";
                String bitRateRange = DeviceUtil.CAMERA_BIT_RANGE;
                JSONArray frameRateArray = null;
                for (int i = 0; i < fullFrameRateArray.size(); ++i) {
                    JSONArray rangeArray;
                    JSONObject streamObject = fullFrameRateArray.getJSONObject(i);
                    if (fullFrameRate != -1 && streamObject.getIntValue("maxFrameRate") != fullFrameRate || CollectionUtils.isEmpty((Collection)(rangeArray = streamObject.getJSONArray("streamInfo")))) continue;
                    for (int j = 0; j < rangeArray.size(); ++j) {
                        JSONObject rangeObject = rangeArray.getJSONObject(j);
                        if (rangeObject.getIntValue("streamType") != streamType) continue;
                        for (int k = 0; k < rangeObject.getJSONArray("encodeMode").size(); ++k) {
                            JSONObject encodeModeObject = rangeObject.getJSONArray("encodeMode").getJSONObject(k);
                            for (int l = 0; l < encodeModeObject.getJSONArray("resolution").size(); ++l) {
                                JSONObject resolutionObject = encodeModeObject.getJSONArray("resolution").getJSONObject(l);
                                if (!resolutionRangeList.contains(resolutionObject.getString("type"))) {
                                    resolutionRangeList.add(resolutionObject.getString("type"));
                                }
                                if (resolutionObject.getJSONObject("bitRate").getBoolean("support").booleanValue()) {
                                    bitRateBegin = resolutionObject.getJSONObject("bitRate").getString("begin");
                                    bitRateEnd = resolutionObject.getJSONObject("bitRate").getString("end");
                                }
                                if (frameRateArray != null) continue;
                                frameRateArray = resolutionObject.getJSONArray("frameRate");
                            }
                        }
                    }
                }
                int start = Math.max(bitRateRange.indexOf("," + bitRateBegin + ","), 0);
                int end = bitRateRange.indexOf("," + bitRateEnd + ",") > 0 ? bitRateRange.indexOf(bitRateEnd) : bitRateRange.length();
                bitRateRange = bitRateBegin + "," + bitRateRange.substring(start, end) + "," + bitRateEnd;
                LOGGER.info("IVS 1800 bitRateRange:{},bitRateBegin:{},bitRateEnd:{}", new Object[]{bitRateRange, start, end});
                for (String s : bitRateArray = bitRateRange.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                    bitRateRangeList.add(Integer.parseInt(s.trim()));
                }
                if (!CollectionUtils.isEmpty((Collection)frameRateArray)) {
                    for (int i = 0; i < frameRateArray.size(); ++i) {
                        fpsRangeList.add(frameRateArray.getIntValue(i));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 get stream error", (Throwable)e);
            resolutionRangeList.add("720*576");
            resolutionRangeList.add("1280*720");
            resolutionRangeList.add("1920*1080");
            fpsRangeList.add(15);
            fpsRangeList.add(20);
            fpsRangeList.add(25);
            bitRateRangeList.add(512);
            bitRateRangeList.add(1024);
            bitRateRangeList.add(2048);
            videoEncodeTypeRangeList.add("H.264");
            videoEncodeTypeRangeList.add("H.265");
        }
        streamRange.setBitRateRange(bitRateRangeList);
        streamRange.setResolutionRange(resolutionRangeList);
        streamRange.setFpsRange(fpsRangeList);
        streamRange.setVideoEncodeTypeRange(videoEncodeTypeRangeList);
        return streamRange;
    }

    public boolean setMainStreamConfig(ParamBean<StreamBean> obj) {
        StreamBean request = (StreamBean)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("streamInfoNum", (Object)1);
        configObject.put("reserve", (Object)"");
        JSONObject streamObject = new JSONObject();
        streamObject.put("streamType", (Object)1);
        int encodeType = 0;
        if ("H.264".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 1;
        } else if ("MJPEG".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 2;
        } else if ("MPEG4".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 3;
        } else if ("MPEG2".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 4;
        } else if ("AVS".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 5;
        }
        streamObject.put("encodeType", (Object)encodeType);
        streamObject.put("profile", (Object)1);
        streamObject.put("frameInterval", (Object)request.getIFrameInterval());
        streamObject.put("resolution", (Object)request.getResolution().replaceAll("\\s*", "").replace("x", "*"));
        int videoQuality = 0;
        if ("Medium".equalsIgnoreCase(request.getVideoQuality())) {
            videoQuality = 1;
        } else if ("Lower".equalsIgnoreCase(request.getVideoQuality()) || "Low".equalsIgnoreCase(request.getVideoQuality()) || "Lowest".equalsIgnoreCase(request.getVideoQuality())) {
            videoQuality = 2;
        }
        streamObject.put("picQuality", (Object)videoQuality);
        streamObject.put("transProtocol", (Object)request.getTransProtocol());
        streamObject.put("pktProtocol", (Object)1);
        streamObject.put("bitRateType", (Object)("CBR".equalsIgnoreCase(request.getBitrateControl()) ? 0 : 1));
        streamObject.put("bitRate", (Object)request.getBitrate());
        streamObject.put("frameRate", (Object)request.getFps());
        streamObject.put("reserve", (Object)"");
        JSONArray streamArray = new JSONArray();
        streamArray.add((Object)streamObject);
        configObject.put("streamInfoList", (Object)streamArray);
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraStreamConfig", (Object)configObject);
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(5), dataObject, request.getChannelCode());
    }

    public StreamBean getSubStreamConfig(ParamBean<ChannelRequest> obj) {
        StreamBean streamBean = new StreamBean();
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(obj.getVcmInfo(), ((ChannelRequest)obj.getRequestBody()).getChannelCode(), obj.getVcmInfo().getDomainCode(), 5);
        JSONArray configArray = respondIvs1800.getConfigItem().getJSONObject("cameraStreamConfig").getJSONArray("streamInfoList");
        streamBean.setChannelCode(((ChannelRequest)obj.getRequestBody()).getChannelCode());
        JSONObject fullFrameRate = null;
        if ("S100".equals(((ChannelRequest)obj.getRequestBody()).getClientType())) {
            fullFrameRate = this.getFullFrameRate(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 1);
        }
        if (!CollectionUtils.isEmpty((Collection)configArray)) {
            for (int i = 0; i < configArray.size(); ++i) {
                JSONObject configObject = configArray.getJSONObject(i);
                if (configObject.getInteger("streamType") != 2) continue;
                streamBean.setMaxFrameRae(configObject.getIntValue("bitRate"));
                if (Objects.nonNull(fullFrameRate)) {
                    streamBean.setResolution(fullFrameRate.getString("resolution"));
                    streamBean.setFps(fullFrameRate.getIntValue("frameRate"));
                } else {
                    streamBean.setResolution(configObject.getString("resolution"));
                    streamBean.setFps(configObject.getIntValue("frameRate"));
                }
                streamBean.setBitrate(configObject.getIntValue("bitRate"));
                streamBean.setCustomBitrate(configObject.getIntValue("bitRate"));
                streamBean.setTransProtocol(configObject.getInteger("transProtocol").intValue());
                if ("0".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("H.265");
                } else if ("1".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("H.264");
                } else if ("2".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MJPEG");
                } else if ("3".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MPEG4");
                } else if ("4".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("MPEG2");
                } else if ("5".equals(configObject.getString("encodeType"))) {
                    streamBean.setVideoEncodeType("AVS");
                }
                if ("0".equals(configObject.getString("picQuality"))) {
                    streamBean.setVideoQuality("Higher");
                } else if ("1".equals(configObject.getString("picQuality"))) {
                    streamBean.setVideoQuality("Medium");
                } else {
                    streamBean.setVideoQuality("Low");
                }
                streamBean.setBitrateMode(configObject.getString("bitRateType"));
                streamBean.setIFrameInterval(configObject.getIntValue("frameInterval"));
                if ("0".equals(configObject.getString("bitRateType"))) {
                    streamBean.setBitrateControl("CBR");
                    continue;
                }
                streamBean.setBitrateControl("VBR");
            }
        }
        if (Objects.nonNull(fullFrameRate)) {
            streamBean.setRange(this.getStreamRange(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 1, fullFrameRate.getIntValue("fullFrameRate")));
        } else {
            streamBean.setRange(this.getStreamRange(obj.getVcmInfo(), (ChannelRequest)obj.getRequestBody(), 1, -1));
        }
        return streamBean;
    }

    public boolean setSubStreamConfig(ParamBean<StreamBean> obj) {
        StreamBean request = (StreamBean)obj.getRequestBody();
        JSONObject configObject = new JSONObject();
        configObject.put("streamInfoNum", (Object)1);
        configObject.put("reserve", (Object)"");
        JSONObject streamObject = new JSONObject();
        streamObject.put("streamType", (Object)2);
        int encodeType = 0;
        if ("H.264".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 1;
        } else if ("MJPEG".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 2;
        } else if ("MPEG4".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 3;
        } else if ("MPEG2".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 4;
        } else if ("AVS".equalsIgnoreCase(request.getVideoEncodeType())) {
            encodeType = 5;
        }
        streamObject.put("encodeType", (Object)encodeType);
        streamObject.put("profile", (Object)1);
        streamObject.put("frameInterval", (Object)request.getIFrameInterval());
        streamObject.put("resolution", (Object)request.getResolution().replaceAll("\\s*", "").replace("x", "*"));
        int videoQuality = 0;
        if ("Medium".equalsIgnoreCase(request.getVideoQuality())) {
            videoQuality = 1;
        } else if ("Lower".equalsIgnoreCase(request.getVideoQuality()) || "Low".equalsIgnoreCase(request.getVideoQuality()) || "Lowest".equalsIgnoreCase(request.getVideoQuality())) {
            videoQuality = 2;
        }
        streamObject.put("picQuality", (Object)videoQuality);
        streamObject.put("transProtocol", (Object)request.getTransProtocol());
        streamObject.put("pktProtocol", (Object)1);
        streamObject.put("bitRateType", (Object)("CBR".equalsIgnoreCase(request.getBitrateControl()) ? 0 : 1));
        streamObject.put("bitRate", (Object)request.getBitrate());
        streamObject.put("frameRate", (Object)request.getFps());
        streamObject.put("reserve", (Object)"");
        JSONArray streamArray = new JSONArray();
        streamArray.add((Object)streamObject);
        configObject.put("streamInfoList", (Object)streamArray);
        JSONObject dataObject = new JSONObject();
        dataObject.put("cameraStreamConfig", (Object)configObject);
        return this.setCameraConfig(obj.getVcmInfo(), Integer.valueOf(5), dataObject, request.getChannelCode());
    }

    private ConfigRespondIvs1800 getConfig(VcmReqBaseInfo vcmReqBaseInfo, String channelCode, String domainCode, int type) {
        ConfigRespondIvs1800 respondIvs1800;
        String url = "/device/deviceconfig/" + type + "/" + channelCode + "/" + domainCode;
        try {
            respondIvs1800 = (ConfigRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ConfigRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException e) {
            LOGGER.error("Get base config fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        return respondIvs1800;
    }

    public boolean setCameraConfig(VcmReqBaseInfo vcmInfo, Integer configType, JSONObject configObject, String channelCode) {
        JSONObject dataObject = new JSONObject();
        dataObject.put("deviceCode", (Object)channelCode);
        dataObject.put("configType", (Object)configType);
        dataObject.put("configItem", (Object)configObject);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.CAMERA_SET_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 set camera param error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return true;
    }

    public CameraExtendConfigRespond getExtendConfig(VcmReqBaseInfo vcmInfo, CameraRequest request) {
        ConfigRespondIvs1800 respondIvs1800 = this.getConfig(vcmInfo, request.getCameraCode(), vcmInfo.getDomainCode(), 17);
        JSONObject configObject = respondIvs1800.getConfigItem().getJSONObject("cameraExtendConfig");
        Optional respond = JsonUtil.convertJsonToBean((String)configObject.toJSONString(), CameraExtendConfigRespond.class);
        return (CameraExtendConfigRespond)respond.get();
    }

    public Boolean setExtendConfig(VcmReqBaseInfo vcmInfo, CameraExtendConfigRequest request) {
        JSONObject dataObject = new JSONObject();
        String channelCode = request.getChannelCode();
        dataObject.put("cameraExtendConfig", JSONObject.parse((String)JsonUtil.convertBeanToJSON((Object)request)));
        dataObject.remove((Object)"channelCode");
        return this.setCameraConfig(vcmInfo, Integer.valueOf(17), dataObject, channelCode);
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

