/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.CruiseRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.ptz.CruiseRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseDetailRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.CruiseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.CruiseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.bean.CruiseTrack;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.CruiseService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="cruiseIvs1800Service")
public class CruiseIvs1800ServiceImpl
extends AbstractIvs1800Service
implements CruiseService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CruiseIvs1800ServiceImpl.class);

    public JSONObject getCruiseNo(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("resultCode", (Object)"0");
        jsonObject.put("content", (Object)new JSONObject());
        jsonObject.getJSONObject("content").put("cruiseNo", (Object)"1");
        return jsonObject;
    }

    public JSONObject getCruiseNoByCondition(VcmReqBaseInfo vcmReqBaseInfo, CruiseRequest req) {
        CruiseListRespond cruiseListRespond = this.list(vcmReqBaseInfo, req);
        List cruiseTracks = cruiseListRespond.getCruiseTracks();
        JSONObject result = new JSONObject();
        for (CruiseTrack cruiseTrack : cruiseTracks) {
            String name = cruiseTrack.getName();
            if (!req.getName().equals(name)) continue;
            result.put("cruiseNo", (Object)((CruiseTrack)cruiseTracks.get(0)).getCruiseNo());
        }
        if (result.get((Object)"cruiseNo") == null) {
            req.setCruisePoints(new ArrayList());
            CruiseRespond add = this.add(vcmReqBaseInfo, req);
            result.put("cruiseNo", (Object)add.getCruiseNo());
        }
        return null;
    }

    public CruiseRespond add(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.addRequestToIvs1800(req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_ADD_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(cruiseRespondIvs1800.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("PTZ add error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond upt(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.uptRequestToIvs1800(req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_UPT_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(req.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 update cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseRespond del(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseRespond cruiseRespond = new CruiseRespond();
        CruiseRequestIvs1800 cruiseRequestIvs1800 = this.delRequestToIvs1800(req);
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_DEL_CRUISE_IVS1800_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)cruiseRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseRespond.setCruiseNo(cruiseRespondIvs1800.getCruiseNo());
            return cruiseRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 del cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseListRespond list(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseListRespond cruiseListRespond = new CruiseListRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("domainCode", req.getDomainCode());
        httpUrlParam.addParam("cameraCode", req.getChannelCode());
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_LIST_CRUISE_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            JSONArray cruiseTracks = cruiseRespondIvs1800.getCruiseTrackList().getJSONArray("cruiseTracks");
            cruiseListRespond.setCruiseTracks(JSONObject.parseArray((String)cruiseTracks.toJSONString(), CruiseTrack.class));
            return cruiseListRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 list cruise error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CruiseDetailRespond detail(VcmReqBaseInfo vcmInfo, CruiseRequest req) {
        CruiseDetailRespond cruiseDetailRespond = new CruiseDetailRespond();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("domainCode", req.getDomainCode());
        httpUrlParam.addParam("cameraCode", req.getChannelCode());
        httpUrlParam.addParam("cruiseNo", req.getCruiseNo());
        try {
            CruiseRespondIvs1800 cruiseRespondIvs1800 = (CruiseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.PTZ_DETAIL_CRUISE_IVS1800_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, CruiseRespondIvs1800.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)cruiseRespondIvs1800);
            cruiseDetailRespond.setCruiseInfo(cruiseRespondIvs1800.getCruiseInfo());
            return cruiseDetailRespond;
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    private CruiseRequestIvs1800 addRequestToIvs1800(CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setName(req.getName());
        cruiseRequestIvs1800.setCruisePoints(req.getCruisePoints());
        return cruiseRequestIvs1800;
    }

    private CruiseRequestIvs1800 uptRequestToIvs1800(CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setDomainCode(req.getDomainCode());
        cruiseRequestIvs1800.setName(req.getName());
        cruiseRequestIvs1800.setCruisePoints(req.getCruisePoints());
        cruiseRequestIvs1800.setCruiseNo(req.getCruiseNo());
        return cruiseRequestIvs1800;
    }

    private CruiseRequestIvs1800 delRequestToIvs1800(CruiseRequest req) {
        CruiseRequestIvs1800 cruiseRequestIvs1800 = new CruiseRequestIvs1800();
        cruiseRequestIvs1800.setDomainCode(req.getDomainCode());
        cruiseRequestIvs1800.setCameraCode(req.getChannelCode());
        cruiseRequestIvs1800.setCruiseNo(req.getCruiseNo());
        return cruiseRequestIvs1800;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

