/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.CommonGetImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.penetrate.PenetrateRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleImgUploadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.CommonService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="commonIvs1800ServiceImpl")
public class CommonIvs1800ServiceImpl
extends AbstractIvs1800Service
implements CommonService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonIvs1800ServiceImpl.class);
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public CommonGetImageRespond getImage(ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRequest request = (CommonGetImageRequest)obj.getRequestBody();
        CommonGetImageRespond respond = new CommonGetImageRespond();
        respond.setImageType(request.getImageType());
        String image = "";
        if (StringUtils.isNotBlank((CharSequence)request.getImageType()) && StringUtils.isNotBlank((CharSequence)request.getImageId())) {
            if ("historyAlarmBehaviorImage".equals(request.getImageType()) || "historyAlarmFaceImage".equals(request.getImageType()) || "historyAlarmVehicleImage".equals(request.getImageType()) || "historyAlarmThirdAlgorithmImage".equals(request.getImageType()) || "historyAlarmSituationAnalysisImage".equals(request.getImageType()) || "historyAlarmEquipmentImage".equals(request.getImageType())) {
                image = this.smartDaraHelpService.getDynamicGroupImage(obj.getVcmInfo(), request.getImageId());
            } else if ("listLibraryImage".equals(request.getImageType())) {
                image = this.smartDaraHelpService.getTargetMatchedImage(obj.getVcmInfo(), Long.valueOf(Long.parseLong(request.getImageId())));
            } else if ("faceGroupImage".equals(request.getImageType()) || "vehicleGroupImage".equals(request.getImageType())) {
                image = this.smartDaraHelpService.getTargetMatchedImage(obj.getVcmInfo(), Long.valueOf(Long.parseLong(request.getImageId())));
            }
        }
        respond.setImage(image);
        return respond;
    }

    public PenetrateRespond penetrate(ParamBean<PenetrateRequest> obj) {
        PenetrateRespond respond = new PenetrateRespond();
        PenetrateRequest request = (PenetrateRequest)obj.getRequestBody();
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(((PenetrateRequest)obj.getRequestBody()).getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl(request.getRequestMethod() + " " + request.getRequestUrl());
        if (StringUtils.isNotBlank((CharSequence)request.getRequestParam())) {
            infoIvs1800.setParam(request.getRequestParam());
        }
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            respond.setResultCode(respondIvs1800.getResultCode());
            respond.setResultInfo(respondIvs1800.getResultInfo());
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 penetrate error, IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public CommonGetImageRespond getCaptureByUUId(ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRequest request = (CommonGetImageRequest)obj.getRequestBody();
        CommonGetImageRespond respond = new CommonGetImageRespond();
        String image = this.smartDaraHelpService.getDynamicGroupImage(obj.getVcmInfo(), request.getFileId());
        respond.setBase64(image);
        return respond;
    }

    public VehicleImgUploadRespond imageUploadVehicle(VcmReqBaseInfo vcmInfo, MultipartFile[] images) {
        try {
            VehicleImgUploadRespond respond;
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY);
            builder.setCharset(StandardCharsets.UTF_8);
            for (MultipartFile image : images) {
                File file = FileUtil.saveMultipartFile((String)"upload/hw/vehicle/image/", (String)image.getOriginalFilename(), (MultipartFile)image);
                builder.addPart("imgInput", (ContentBody)new FileBody(file));
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.requestForm((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.IMAGE_LIBRARY_UPLOAD_FILES, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getHeaders(vcmInfo), (HttpEntity)builder.build());
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), VehicleImgUploadRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            VehicleImgUploadRespond vehicleImgUploadRespond = respond = (VehicleImgUploadRespond)operateBean.get();
            return vehicleImgUploadRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 imageUpload error, IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        finally {
            try {
                CompletableFuture.runAsync(() -> {
                    for (MultipartFile image : images) {
                        FileUtil.deleteFileByFilePath((String)FileUtil.getLocalFullPath((String)("upload/hw/vehicle/image/" + image.getOriginalFilename())));
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Failed to delete file", (Throwable)e);
            }
        }
    }
}

