/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorAreaItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorGetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.BehaviorSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.IgtAlarmConfigSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.intelligent.VehicleParameterSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligent.BehaviorSetRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.intelligent.IgtAlarmConfigRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.AreaList;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.Line;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.bean.Point;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcVehicleDetectRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800AlarmPlanItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.Nvr800AreaItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.PointItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithm;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.intelligentAnalysis.VehicleParameterRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorAlarmPlanItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorLineItemRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.BehaviorRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.normalIntelligent.IgtAlarmConfigTargetRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.bean.SdcAreanBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.intelligent.SdcVehicleDetectRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.intelligent.SdcVehicleIllegalAlarmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.sdc.intelligent.SdcVehicleParameterConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.BehaviorAnalysisService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="behaviorAnalysis1800Service")
public class BehaviorAnalysis1800ServiceImpl
extends AbstractIvs1800Service
implements BehaviorAnalysisService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BehaviorAnalysis1800ServiceImpl.class);
    private static final String ALARM_PASS_ALARM_PARAM = SdcMsgType.ALARM_PASS_ALARM_PARAM.getUri() + "?AppName=itgtSaas&Name=";

    public BehaviorRespond getPerimeterZone(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_RANGE_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_intrusionDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    private void getAudioAndLightAbility(ParamBean<BehaviorGetRequest> obj, JSONObject alarmPlan, BehaviorRespond behaviorRespond) {
        List linkageStrategiesList;
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        JSONObject audio = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.AUDIO_IAAS_CAPABILITY.getUri());
        JSONObject light = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.ALARM_PASS.getUri());
        JSONObject action = light.getJSONObject("action");
        boolean isHavaAudio = false;
        boolean isHavaLight = false;
        if (audio.containsKey((Object)"isSupportAudioFile") && audio.getBoolean("isSupportAudioFile").booleanValue()) {
            if (((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction() != null) {
                linkageStrategiesList = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
                for (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies linkageStrategies : linkageStrategiesList) {
                    if ("audios".equals(linkageStrategies.getName())) {
                        isHavaAudio = true;
                    }
                    if (!"twinkle".equals(linkageStrategies.getName())) continue;
                    isHavaLight = true;
                }
                if (isHavaAudio) {
                    SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies strategies = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)linkageStrategiesList.stream().filter(audioParam -> "audios".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                    behaviorRespond.setAudioEnable(Boolean.valueOf(true));
                    behaviorRespond.setAudioFile(this.getAudioStringInfo(strategies.getParam().getParam(), Integer.valueOf(0)));
                    behaviorRespond.setAudioPlaybackTimes(Integer.valueOf(this.getAudioStringInfo(strategies.getParam().getParam(), Integer.valueOf(1))));
                } else {
                    behaviorRespond.setAudioEnable(Boolean.valueOf(false));
                }
            } else {
                behaviorRespond.setAudioEnable(Boolean.valueOf(false));
            }
        }
        if (action.containsKey((Object)"isSupportTwinkleaction") && action.getBoolean("isSupportTwinkleaction").booleanValue()) {
            if (((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction() != null) {
                linkageStrategiesList = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
                if (isHavaLight) {
                    SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies twinkle = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)linkageStrategiesList.stream().filter(audioParam -> "twinkle".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                    behaviorRespond.setWhiteLightIllumEnable(Boolean.valueOf(true));
                    behaviorRespond.setWhiteLightIlluminator(this.changeLightIlluminator(twinkle.getParam().getName()));
                    behaviorRespond.setFlashDuration(Integer.valueOf(this.getLightStringInfo(twinkle.getParam().getParam())));
                } else {
                    behaviorRespond.setWhiteLightIllumEnable(Boolean.valueOf(false));
                }
            } else {
                behaviorRespond.setWhiteLightIllumEnable(Boolean.valueOf(false));
            }
        }
    }

    private String changeLightIlluminator(String param) {
        String Nvr800 = null;
        switch (param) {
            case "lowfre": {
                Nvr800 = "Low";
                break;
            }
            case "midfre": {
                Nvr800 = "Medium";
                break;
            }
            case "highfre": {
                Nvr800 = "High";
                break;
            }
            case "lightfre": {
                Nvr800 = "Steady on";
            }
        }
        return Nvr800;
    }

    private String getAudioStringInfo(String param, Integer index) {
        String[] split = param.split(";");
        String[] split1 = split[index].split("=");
        String audio = split1[1];
        Base64.Decoder decoder = Base64.getDecoder();
        return new String(decoder.decode(audio), StandardCharsets.UTF_8);
    }

    private String getLightStringInfo(String param) {
        String[] split1 = param.split("=");
        String light = split1[1];
        Base64.Decoder decoder = Base64.getDecoder();
        return new String(decoder.decode(light), StandardCharsets.UTF_8);
    }

    public BehaviorRespond getPerimeterLine(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_CROSS_LINE_GET.getUri());
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorSetRequestIvs1800.class);
        BehaviorSetRequestIvs1800 sdcBehavior = (BehaviorSetRequestIvs1800)operateBean.get();
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        behaviorRespond.setSensitivity(sdcBehavior.getSensitivity());
        behaviorRespond.setEnable(Boolean.valueOf(sdcBehavior.getEnable() == 1));
        behaviorRespond.setToleranceTime(sdcBehavior.getUlRemainTime());
        behaviorRespond.setAlarmInterval(sdcBehavior.getAlarmTime());
        behaviorRespond.setDetectType(this.getDetectType(sdcBehavior.getObjFilterFlag()));
        behaviorRespond.setRecognizeMode(this.changeRecongnizeModeToString(sdcBehavior.getTargetRecMode()));
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        ArrayList<BehaviorLineItemRespond> lineitemList = new ArrayList<BehaviorLineItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)sdcBehavior.getLines().getLineList())) {
            for (Line line : sdcBehavior.getLines().getLineList()) {
                BehaviorLineItemRespond lineItem = new BehaviorLineItemRespond();
                lineItem.setLineName(line.getLineName());
                lineItem.setEnable(Boolean.valueOf(line.getEnable() == 1));
                lineItem.setIndex(line.getIndex());
                indexList.add(line.getIndex());
                lineItem.setRuleType(this.changeRuleTypeToString(line.getDirection()));
                lineItem.setX1(line.getPosS().getPointX() * 2);
                lineItem.setY1(line.getPosS().getPointY() * 2);
                lineItem.setX2(line.getPosE().getPointX() * 2);
                lineItem.setY2(line.getPosE().getPointY() * 2);
                lineitemList.add(lineItem);
            }
        }
        behaviorRespond.setIndexList(indexList);
        behaviorRespond.setLineList(lineitemList);
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_tripwireDetection");
        JSONObject alarmInterval = (JSONObject)alarmPlan.getJSONArray("alarmParam").get(0);
        behaviorRespond.setAlarmInterval(alarmInterval.getJSONObject("sourceParam").getInteger("time"));
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmPlan);
        behaviorRespond.setAlarmPlanList(alarmPlanList);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getItemLeave(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_ITEMLEAVE_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_abandonDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getItemMove(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_ITEMMOVE_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_removedDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public VehicleParameterRespond getVehicleIllegal(ParamBean<BehaviorGetRequest> obj) {
        JSONObject config = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.VLPR_APP_ILLEGA_PARKING_GET.getUri());
        VehicleParameterRespond respond = new VehicleParameterRespond();
        Optional optional = JsonUtil.convertJsonToBean((String)config.toJSONString(), SdcVehicleIllegalAlarmRespond.class);
        SdcVehicleIllegalAlarmRespond sdcRespond = (SdcVehicleIllegalAlarmRespond)optional.get();
        respond.setSensitivity(Integer.valueOf(sdcRespond.getVehStopSensitivity()));
        respond.setIllegalParkingTriggerTime(Integer.valueOf(sdcRespond.getParkTime()));
        respond.setEnable(Boolean.valueOf(sdcRespond.getEnable() == 1));
        ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)sdcRespond.getAreaList().getArea())) {
            int index = 1;
            for (SdcAreanBean.AreaBean areaBean : sdcRespond.getAreaList().getArea()) {
                BehaviorAreaItemRespond areaItem = new BehaviorAreaItemRespond();
                areaBean.getPoint().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() * 2);
                    pointItem.setPointY(pointItem.getPointY() * 2);
                });
                areaItem.setIndex(Integer.valueOf(index++));
                areaItem.setPointList(areaBean.getPoint());
                areaItem.setPointNum(Integer.valueOf(areaBean.getPoint().size()));
                areaList.add(areaItem);
            }
        }
        respond.setAreaList(areaList);
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_illegalParking");
        respond.setAlarmPlanList(this.getBehaviorAlarmPlan(alarmPlan));
        JSONObject alarmInterval = (JSONObject)alarmPlan.getJSONArray("alarmParam").get(0);
        respond.setAlarmInterval(alarmInterval.getJSONObject("sourceParam").getInteger("time"));
        return respond;
    }

    public VehicleParameterRespond getVehicleDetect(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.VHD_APP_PARAM_GET.getUri());
        return this.getVehicleDetectRespond(behavior);
    }

    private VehicleParameterRespond getVehicleDetectRespond(JSONObject behavior) {
        VehicleParameterRespond respond = new VehicleParameterRespond();
        Optional optional = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), SdcVehicleDetectRespond.class);
        SdcVehicleDetectRespond vehicleDetect1800 = (SdcVehicleDetectRespond)optional.get();
        respond.setBrightCompensationSwitch(Boolean.valueOf(vehicleDetect1800.getExposureEnable() == 1));
        respond.setCompensationLevel(Integer.valueOf(vehicleDetect1800.getRoiMeterLevel()));
        respond.setPriorityProvinceOrCity("".equals(vehicleDetect1800.getPlateLocalZH()) ? "\u65e0" : vehicleDetect1800.getPlateLocalZH());
        respond.setEnable(Boolean.valueOf(vehicleDetect1800.getEnable() == 1));
        ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)vehicleDetect1800.getAreaList().getArea())) {
            for (AreaList.Area area : vehicleDetect1800.getAreaList().getArea()) {
                BehaviorAreaItemRespond areaItemRespond = new BehaviorAreaItemRespond();
                areaItemRespond.setIndex(area.getIndex());
                areaItemRespond.setAreaName(area.getAreaName());
                areaItemRespond.setPointNum(area.getPointNum());
                ArrayList<PointItem> pointList = new ArrayList<PointItem>();
                if (!CollectionUtils.isEmpty((Collection)area.getPoint())) {
                    for (Point point : area.getPoint()) {
                        PointItem item = new PointItem();
                        item.setPointX(point.getPointX() * 2);
                        item.setPointY(point.getPointY() * 2);
                        pointList.add(item);
                    }
                }
                areaItemRespond.setPointList(pointList);
                areaList.add(areaItemRespond);
            }
        }
        respond.setLane(JSONArray.parseArray((String)JSON.toJSONString((Object)vehicleDetect1800.getLane())));
        respond.setLaneNum(Integer.valueOf(vehicleDetect1800.getLaneNum()));
        respond.setAreaList(areaList);
        return respond;
    }

    public VehicleParameterRespond getVehicleParameter(ParamBean<BehaviorGetRequest> obj) {
        JSONObject object = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.VLPR_APP_PARAM_GET.getUri());
        return this.getVehicleParameterRespond(object);
    }

    private VehicleParameterRespond getVehicleParameterRespond(JSONObject object) {
        Optional optional = JsonUtil.convertJsonToBean((String)object.toJSONString(), SdcVehicleParameterConfigRespond.class);
        SdcVehicleParameterConfigRespond sdcRespond = (SdcVehicleParameterConfigRespond)optional.get();
        VehicleParameterRespond respond = new VehicleParameterRespond();
        respond.setEnable(Boolean.valueOf(sdcRespond.getEnable() == 1));
        respond.setBrightCompensationSwitch(Boolean.valueOf(sdcRespond.getExposureEnable() == 1));
        respond.setPriorityProvinceOrCity("".equals(sdcRespond.getPlateLocalZH()) ? "\u65e0" : sdcRespond.getPlateLocalZH());
        respond.setCompensationLevel(sdcRespond.getRoiMeterLevel());
        if (!CollectionUtils.isEmpty((Collection)sdcRespond.getAreaList().getArea())) {
            ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
            for (SdcAreanBean.AreaBean areaBean : sdcRespond.getAreaList().getArea()) {
                BehaviorAreaItemRespond areaItem = new BehaviorAreaItemRespond();
                areaItem.setAreaName(areaBean.getAreaName());
                areaBean.getPoint().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() * 2);
                    pointItem.setPointY(pointItem.getPointY() * 2);
                });
                areaItem.setPointNum(Integer.valueOf(areaBean.getPoint().size()));
                areaItem.setPointList(areaBean.getPoint());
                areaList.add(areaItem);
            }
            respond.setAreaList(areaList);
        }
        respond.setAlgMode(sdcRespond.getAlgMode());
        respond.setPlateExposureTime(sdcRespond.getPlateExposureTime());
        respond.setEnhanceLevel(sdcRespond.getEnhanceLevel());
        respond.setCampusModePara(JSON.parseObject((String)JSON.toJSONString((Object)sdcRespond.getCampusModePara())));
        respond.setLaneAttr(JSONArray.parseArray((String)JSON.toJSONString((Object)sdcRespond.getLaneAttr())));
        respond.setLaneLineList(JSONArray.parseArray((String)JSON.toJSONString((Object)sdcRespond.getLaneLineList())));
        respond.setTripLaneList(JSONArray.parseArray((String)JSON.toJSONString((Object)sdcRespond.getTripLaneList())));
        respond.setSdcVehicleParameterConfig(sdcRespond);
        return respond;
    }

    public BehaviorRespond getElectroMobile(ParamBean<BehaviorGetRequest> obj) {
        JSONObject alarmPlan;
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_ELECTRO_MOBILE_GET.getUri());
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_motorBikeDetection"));
        if (Objects.nonNull(behaviorRespond.getFilterSensitivity())) {
            CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
            passThrouthRequestIvs1800.setCameraCode(((BehaviorGetRequest)obj.getRequestBody()).getChannelCode());
            CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
            infoIvs1800.setRequestUrl("GET /SDCAPI/V1.0/ElectroMobileInvadeElevator");
            passThrouthRequestIvs1800.setInfo(infoIvs1800);
            try {
                CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
                JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
                if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                    throw new InvokeException("500", "param_error");
                }
                JSONObject returnJson = (JSONObject)jsonArray.get(0);
                LOGGER.info("returnJson data: {}", (Object)returnJson.toJSONString());
                behaviorRespond.setEleSwitch(Boolean.valueOf(returnJson.getJSONObject("Data").getIntValue("enable") == 1));
            }
            catch (SDKException e) {
                LOGGER.error("error", (Throwable)e);
                throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
            }
        }
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getAreaEnter(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_AREA_ENTER_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_enteringDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getAreaExit(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_AREA_EXIT_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_exitingDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getLoitering(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_LOITERING_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_wanderDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public BehaviorRespond getFastMovement(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_FAST_MOVEMENT_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_fastMovingDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public IgtAlarmConfigRespond getIgtAlarmConfig(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_GET.getUri());
        if (behavior == null) {
            return new IgtAlarmConfigRespond();
        }
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), IgtAlarmConfigRequestIvs1800.class);
        IgtAlarmConfigRequestIvs1800 igtAlarmConfigIvs1800 = (IgtAlarmConfigRequestIvs1800)operateBean.get();
        IgtAlarmConfigRespond alarmConfigRespond = new IgtAlarmConfigRespond();
        alarmConfigRespond.setEnable(Boolean.valueOf(igtAlarmConfigIvs1800.getEnable() == 1));
        alarmConfigRespond.setSendMetadataSwitch(Boolean.valueOf(igtAlarmConfigIvs1800.getSendMetaEnable() == 1));
        IgtAlarmConfigRequestIvs1800.VideoAnalyseParaBean videoAnalysePara = igtAlarmConfigIvs1800.getVideoAnalysePara();
        alarmConfigRespond.setBackgroundUpdateRate(this.changeBgUpdateRateToString(Integer.valueOf(videoAnalysePara.getBgUpdateRate())));
        alarmConfigRespond.setShadowMode(this.changeshadowModeToString(Integer.valueOf(videoAnalysePara.getShadowMode())));
        alarmConfigRespond.setDetectionSensitivity(this.changedetectionSensitivityToString(Integer.valueOf(videoAnalysePara.getDetSensitivity())));
        alarmConfigRespond.setMaxTargetSize(new IgtAlarmConfigTargetRespond(videoAnalysePara.getMaxSize().getWidth(), videoAnalysePara.getMaxSize().getHeight()));
        alarmConfigRespond.setMinTargetSize(new IgtAlarmConfigTargetRespond(videoAnalysePara.getMinSize().getWidth(), videoAnalysePara.getMinSize().getHeight()));
        alarmConfigRespond.setMaxTargetNum(videoAnalysePara.getMaxTargetNum());
        alarmConfigRespond.setTrackEnable(videoAnalysePara.getTrackEnable());
        alarmConfigRespond.setFieldType(videoAnalysePara.getFiledType());
        alarmConfigRespond.setTrackSensitivity(videoAnalysePara.getTrackSensitivity());
        alarmConfigRespond.setTwoBg(videoAnalysePara.getTwoBg());
        alarmConfigRespond.setInsensitiveObject(videoAnalysePara.getInsensitiveObject());
        alarmConfigRespond.setPerimeterEnhanceSwitch(Boolean.valueOf(videoAnalysePara.getEnableBehEnhance() == 1));
        alarmConfigRespond.setAlertInhibitionSwitch(Boolean.valueOf(videoAnalysePara.getAlertInhibition() == 1));
        alarmConfigRespond.setAlarmPicAiInfoSwitch(Boolean.valueOf(videoAnalysePara.getOverlayBoxEnable() == 1));
        return alarmConfigRespond;
    }

    private JSONObject getBehavior(VcmReqBaseInfo vcmReqBaseInfo, String channelCode, String configSdcType) {
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + configSdcType);
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getString("Data").startsWith("[")) {
                return (JSONObject)returnJson.getJSONArray("Data").get(0);
            }
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                return returnJson.getJSONObject("Data");
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusString"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean setPerimeterZone(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_intrusionDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_RANGE);
    }

    public boolean setPerimeterLine(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_tripwireDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_CROSS_LINE_PUT);
    }

    public boolean setItemLeave(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_abandonDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_ITEMLEAVE_PUT);
    }

    public boolean setItemMove(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_removedDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_ITEMMOVE_PUT);
    }

    public boolean setVehicleIllegal(ParamBean<VehicleParameterSetRequest> obj) {
        VehicleParameterSetRequest requestBody = (VehicleParameterSetRequest)obj.getRequestBody();
        this.updateAlarmPlanTime(obj.getVcmInfo(), ((VehicleParameterSetRequest)obj.getRequestBody()).getChannelCode(), requestBody.getAlarmPlanList(), requestBody.getAlarmInterval(), ALARM_PASS_ALARM_PARAM + "action_illegalParking");
        SdcVehicleIllegalAlarmRespond convert = this.changeVehicleIllegal(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + SdcMsgType.VLPR_APP_ILLEGA_PARKING_SET.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)convert));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, null);
    }

    private SdcVehicleIllegalAlarmRespond changeVehicleIllegal(VehicleParameterSetRequest requestBody) {
        SdcVehicleIllegalAlarmRespond sdcRespon = new SdcVehicleIllegalAlarmRespond();
        sdcRespon.setEnable(requestBody.getEnable() != false ? 1 : 0);
        sdcRespon.setParkTime(requestBody.getIllegalParkingTriggerTime().intValue());
        sdcRespon.setSnapEnable(1);
        sdcRespon.setVehStopSensitivity(requestBody.getSensitivity().intValue());
        SdcAreanBean areaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)requestBody.getAreaList())) {
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (Nvr800AreaItem areaItem : requestBody.getAreaList()) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaBean.setEnable(Integer.valueOf(1));
                areaBean.setIndex(Integer.valueOf(areaItem.getIndex()));
                areaBean.setAreaName(areaItem.getAreaName());
                areaItem.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItem.getPointList());
                area.add(areaBean);
            }
            areaList.setArea(area);
        }
        sdcRespon.setAreaList(areaList);
        return sdcRespon;
    }

    public boolean setElectroMobile(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_motorBikeDetection");
        this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_ELECTRO_MOBILE_PUT);
        if (Objects.nonNull(((BehaviorSetRequest)obj.getRequestBody()).getFilterSensitivity()) && ((BehaviorSetRequest)obj.getRequestBody()).getFilterSensitivity() > 0) {
            CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
            passThrouthRequestIvs1800.setCameraCode(((BehaviorSetRequest)obj.getRequestBody()).getChannelCode());
            CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
            infoIvs1800.setRequestUrl("PUT /SDCAPI/V1.0/ElectroMobileInvadeElevator");
            JSONObject data = new JSONObject();
            data.put("enable", (Object)(((BehaviorSetRequest)obj.getRequestBody()).getEleSwitch() != false ? 1 : 0));
            infoIvs1800.setParam(data.toJSONString());
            passThrouthRequestIvs1800.setInfo(infoIvs1800);
            this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, null);
        }
        return true;
    }

    public boolean setVehicleDetect(ParamBean<VehicleParameterSetRequest> obj) {
        VehicleParameterSetRequest requestBody = (VehicleParameterSetRequest)obj.getRequestBody();
        SdcVehicleDetectRequest convert = this.changeVehicleDetectParameter(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + SdcMsgType.VHD_APP_PARAM_SET.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)convert));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, Integer.valueOf(60));
    }

    private SdcVehicleDetectRequest changeVehicleDetectParameter(VehicleParameterSetRequest requestBody) {
        SdcVehicleDetectRequest sdcVehicleDetectRequest = new SdcVehicleDetectRequest();
        sdcVehicleDetectRequest.setLane(requestBody.getLane().toJavaList(SdcVehicleDetectRequest.LaneBean.class));
        sdcVehicleDetectRequest.setLaneNum(requestBody.getLaneNum());
        sdcVehicleDetectRequest.setEnable(Integer.valueOf(requestBody.getEnable() != false ? 1 : 0));
        sdcVehicleDetectRequest.setExposureEnable(Integer.valueOf(requestBody.getBrightCompensationSwitch() != false ? 1 : 0));
        sdcVehicleDetectRequest.setRoiMeterLevel(requestBody.getCompensationLevel());
        sdcVehicleDetectRequest.setEnhanceMeter(Integer.valueOf(1));
        sdcVehicleDetectRequest.setPlateLocalZH("\u65e0".equals(requestBody.getPriorityProvinceOrCity()) ? "" : requestBody.getPriorityProvinceOrCity());
        AreaList areaList = new AreaList();
        if (!CollectionUtils.isEmpty((Collection)requestBody.getAreaList())) {
            areaList.setAreaNum(Integer.valueOf(requestBody.getAreaList().size()));
            ArrayList<AreaList.Area> area = new ArrayList<AreaList.Area>();
            for (Nvr800AreaItem nvr800AreaItem : requestBody.getAreaList()) {
                AreaList.Area areaSdc = new AreaList.Area();
                areaSdc.setIndex(Integer.valueOf(nvr800AreaItem.getIndex()));
                areaSdc.setPointNum(Integer.valueOf(nvr800AreaItem.getPointList().size()));
                areaSdc.setAreaName(nvr800AreaItem.getAreaName());
                List pointList = nvr800AreaItem.getPointList();
                ArrayList<Point> sdcPoint = new ArrayList<Point>();
                for (PointItem pointItem : pointList) {
                    Point point = new Point();
                    point.setPointX(pointItem.getPointX() / 2);
                    point.setPointY(pointItem.getPointY() / 2);
                    sdcPoint.add(point);
                }
                areaSdc.setPoint(sdcPoint);
                area.add(areaSdc);
                areaList.setArea(area);
            }
            sdcVehicleDetectRequest.setAreaList(areaList);
        }
        return sdcVehicleDetectRequest;
    }

    public boolean setVehicleParameter(ParamBean<VehicleParameterSetRequest> obj) {
        VehicleParameterSetRequest requestBody = (VehicleParameterSetRequest)obj.getRequestBody();
        SdcVehicleParameterConfigRespond convert = this.changeVehicleRequestParameter(requestBody);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + SdcMsgType.VLPR_APP_PARAM_SET.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)convert));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, Integer.valueOf(60));
    }

    private SdcVehicleParameterConfigRespond changeVehicleRequestParameter(VehicleParameterSetRequest requestBody) {
        SdcVehicleParameterConfigRespond convert;
        SdcVehicleParameterConfigRespond sdcdConfig = requestBody.getSdcVehicleParameterConfig();
        SdcVehicleParameterConfigRespond sdcVehicleParameterConfigRespond = convert = Objects.isNull(sdcdConfig) ? new SdcVehicleParameterConfigRespond() : sdcdConfig;
        if (Objects.isNull(sdcdConfig)) {
            convert.setEnableVehicleMfrType(Integer.valueOf(1));
            convert.setEnableFacePic(Integer.valueOf(1));
            convert.setSendPanoramapic(Integer.valueOf(1));
            convert.setSendPlatePic(Integer.valueOf(1));
            convert.setVlprEnhancement(Integer.valueOf(1));
            convert.setEnableMotoDet(Integer.valueOf(1));
            convert.setAlgMode(requestBody.getAlgMode());
            convert.setPlateExposureTime(requestBody.getPlateExposureTime());
            convert.setEnhanceLevel(requestBody.getEnhanceLevel());
            convert.setCampusModePara((SdcVehicleParameterConfigRespond.CampusModeParaBean)JsonUtil.convertJsonToBean((String)requestBody.getCampusModePara().toJSONString(), SdcVehicleParameterConfigRespond.CampusModeParaBean.class).get());
            convert.setLaneAttr(JSONObject.parseArray((String)JSONObject.toJSONString((Object)requestBody.getLaneAttr()), SdcVehicleParameterConfigRespond.LaneAttrBean.class));
            convert.setLaneLineList(JSONObject.parseArray((String)JSONObject.toJSONString((Object)requestBody.getLaneLineList()), SdcVehicleParameterConfigRespond.LaneLineListBean.class));
            convert.setTripLaneList(JSONObject.parseArray((String)JSONObject.toJSONString((Object)requestBody.getTripLaneList()), SdcVehicleParameterConfigRespond.TripLaneListBean.class));
        }
        convert.setEnable(Integer.valueOf(requestBody.getEnable() != false ? 1 : 0));
        convert.setPlateLocalZH("\u65e0".equals(requestBody.getPriorityProvinceOrCity()) ? "" : requestBody.getPriorityProvinceOrCity());
        convert.setRoiMeterLevel(requestBody.getCompensationLevel());
        convert.setExposureEnable(Integer.valueOf(requestBody.getBrightCompensationSwitch() != false ? 1 : 0));
        SdcAreanBean areaList = new SdcAreanBean();
        if (!CollectionUtils.isEmpty((Collection)requestBody.getAreaList())) {
            ArrayList<SdcAreanBean.AreaBean> area = new ArrayList<SdcAreanBean.AreaBean>();
            for (Nvr800AreaItem areaItem : requestBody.getAreaList()) {
                SdcAreanBean.AreaBean areaBean = new SdcAreanBean.AreaBean();
                areaBean.setEnable(Integer.valueOf(1));
                areaItem.getPointList().forEach(pointItem -> {
                    pointItem.setPointX(pointItem.getPointX() / 2);
                    pointItem.setPointY(pointItem.getPointY() / 2);
                });
                areaBean.setPoint(areaItem.getPointList());
                area.add(areaBean);
            }
            areaList.setArea(area);
        }
        convert.setAreaList(areaList);
        return convert;
    }

    public boolean setAreaEnter(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_enteringDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_AREA_ENTER_PUT);
    }

    public boolean setAreaExit(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_exitingDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_AREA_EXIT_PUT);
    }

    public boolean setLoitering(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_wanderDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_LOITERING_PUT);
    }

    public boolean setFastMovement(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_fastMovingDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_FAST_MOVEMENT_PUT);
    }

    public boolean setIgtAlarmConfig(ParamBean<IgtAlarmConfigSetRequest> obj) {
        IgtAlarmConfigSetRequest request = (IgtAlarmConfigSetRequest)obj.getRequestBody();
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(request.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + SdcMsgType.BEHAPP_PUT.getUri());
        IgtAlarmConfigRequestIvs1800 alarmConfigIvs1800 = this.getAlarmConfigIvs1800(request);
        infoIvs1800.setParam(JSON.toJSONString((Object)alarmConfigIvs1800));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            LOGGER.debug("set IgtAlarmConfig  is end.");
            if (returnJson.getInteger("RspCode") == 0 && returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 0) {
                LOGGER.debug("set IgtAlarmConfig end..");
                return true;
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public ThirdAlgorithmRespond thirdAlgorithm(VcmReqBaseInfo vcmInfo) {
        try {
            ThirdAlgorithmRespond rsp = (ThirdAlgorithmRespond)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_THIRD_ALGORITHM, (MsgToObjectConvertor)this.msgToObjectConvertor(null, ThirdAlgorithmRespond.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
            return rsp;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public ThirdAlgorithmRespond thirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        try {
            ThirdAlgorithmRespond rsp = (ThirdAlgorithmRespond)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_THIRD_ALGORITHM_CONFIG, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ThirdAlgorithmRespond.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
            return rsp;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Boolean updateThirdalgorithmParam(VcmReqBaseInfo vcmInfo, ThirdAlgorithm request) {
        try {
            ThirdAlgorithmRespond rsp = (ThirdAlgorithmRespond)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.INTELLIGENT_THIRD_ALGORITHM_CONFIG_UPDATE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, ThirdAlgorithmRespond.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkRespond((BaseRespondIvs1800)rsp);
            return true;
        }
        catch (SDKException e) {
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public BehaviorRespond getParkDetect(ParamBean<BehaviorGetRequest> obj) {
        JSONObject behavior = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), SdcMsgType.BEHAPP_ALARM_DETECTION_PARK_DETECT_GET.getUri());
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorGetRequest)obj.getRequestBody()).getChannelCode(), ALARM_PASS_ALARM_PARAM + "action_carDetection");
        BehaviorRespond behaviorRespond = this.getBehaviorRespond(behavior, alarmPlan);
        this.getAudioAndLightAbility(obj, alarmPlan, behaviorRespond);
        return behaviorRespond;
    }

    public boolean setParkDetect(ParamBean<BehaviorSetRequest> obj) {
        this.updateAlarmPlanTimeAndAudioLight(obj, ALARM_PASS_ALARM_PARAM + "action_carDetection");
        return this.setBehavior(obj, SdcMsgType.BEHAPP_ALARM_DETECTION_PARK_DETECT_PUT);
    }

    private boolean setBehavior(ParamBean<BehaviorSetRequest> obj, SdcMsgType sdcMsgType) {
        BehaviorSetRequest requestBody = (BehaviorSetRequest)obj.getRequestBody();
        BehaviorSetRequestIvs1800 convert = BehaviorSetRequestIvs1800.convert((BehaviorSetRequest)requestBody);
        BehaviorSetRequestIvs1800.Areas newAreas = convert.getAreas();
        BehaviorSetRequestIvs1800.Lines newLines = convert.getLines();
        this.deleteBehaviorAreaList(obj, convert, sdcMsgType);
        convert.setLines(newLines);
        convert.setAreas(newAreas);
        convert.setAlarmType(Integer.valueOf(sdcMsgType.getUri().substring(sdcMsgType.getUri().length() - 1)));
        convert.setFilterSensitivity(requestBody.getFilterSensitivity());
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + sdcMsgType.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)convert));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, null);
    }

    private boolean updateAlarmPlanTimeAndAudioLight(ParamBean<BehaviorSetRequest> obj, String uri) {
        BehaviorSetRequest requestBody = (BehaviorSetRequest)obj.getRequestBody();
        List alarmPlanList = requestBody.getAlarmPlanList();
        SdcAlarmConfigRespond sdcAlarmConfigRespond = new SdcAlarmConfigRespond();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam> alarmParam = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam>();
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam = new SdcAlarmConfigRespond.SdcAlarmParam();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime> guardTimes = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime>();
        if (!CollectionUtils.isEmpty((Collection)alarmPlanList)) {
            for (Nvr800AlarmPlanItem nvr800AlarmPlanItem : alarmPlanList) {
                SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardTime = new SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime();
                guardTime.setStartTime(this.changeTimeToInteger(nvr800AlarmPlanItem.getStartTime()));
                guardTime.setEndTime(this.changeTimeToInteger(nvr800AlarmPlanItem.getEndTime()));
                guardTime.setCycle(Integer.valueOf(nvr800AlarmPlanItem.getCycleType()));
                Integer period = nvr800AlarmPlanItem.getPeriod();
                guardTime.setPeriod(this.changePeriodToIvs(period));
                guardTime.setEnable(Integer.valueOf(1));
                guardTimes.add(guardTime);
            }
        }
        boolean isAlarmAction = false;
        boolean isHavaAudio = false;
        boolean isHavaLight = false;
        JSONObject alarmPlan = this.getBehavior(obj.getVcmInfo(), ((BehaviorSetRequest)obj.getRequestBody()).getChannelCode(), uri);
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List<Object> action = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction())) {
            isAlarmAction = true;
        } else {
            action = ((SdcAlarmConfigRespond.SdcAlarmParam)alarmConfigRespond.getAlarmParam().get(0)).getAction();
            for (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies linkageStrategies : action) {
                if ("audios".equals(linkageStrategies.getName())) {
                    isHavaAudio = true;
                }
                if (!"twinkle".equals(linkageStrategies.getName())) continue;
                isHavaLight = true;
            }
        }
        if (requestBody.getAudioEnable() != null && requestBody.getAudioEnable().booleanValue()) {
            SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies audio;
            if (isAlarmAction) {
                audio = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                audio.setDesc("");
                audio.setName("audios");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
                paramBean.setName("audios");
                audio.setParam(paramBean);
                action.add(audio);
            } else if (isHavaAudio) {
                audio = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)action.stream().filter(audioParam -> "audios".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                audio.getParam().setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
            } else {
                audio = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                audio.setDesc("");
                audio.setName("audios");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getAudioBase64(requestBody.getAudioFile(), requestBody.getAudioPlaybackTimes() + ""));
                paramBean.setName("audios");
                audio.setParam(paramBean);
                action.add(audio);
            }
        } else if (isHavaAudio) {
            action = action.stream().filter(audioParam -> !"audios".equals(audioParam.getName())).collect(Collectors.toList());
        }
        if (requestBody.getWhiteLightIllumEnable() != null && requestBody.getWhiteLightIllumEnable().booleanValue()) {
            SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies light;
            if (isAlarmAction) {
                light = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                light.setName("twinkle");
                light.setDesc("");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                paramBean.setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
                light.setParam(paramBean);
                action.add(light);
            } else if (isHavaLight) {
                light = (SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies)action.stream().filter(audioParam -> "twinkle".equals(audioParam.getName())).collect(Collectors.toList()).get(0);
                light.getParam().setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                light.getParam().setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
            } else {
                light = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies();
                light.setName("twinkle");
                light.setDesc("");
                SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean paramBean = new SdcAlarmConfigRespond.SdcAlarmParam.LinkageStrategies.ParamBean();
                paramBean.setParam(this.getLightBase64(requestBody.getFlashDuration() + ""));
                paramBean.setName(this.changeLightIlluminatorToSdc(requestBody.getWhiteLightIlluminator()));
                light.setParam(paramBean);
                action.add(light);
            }
        } else if (isHavaLight) {
            action = action.stream().filter(audioParam -> !"twinkle".equals(audioParam.getName())).collect(Collectors.toList());
        }
        sdcAlarmParam.setAction(action);
        SdcAlarmConfigRespond.SdcAlarmParam.SourceParam sourceParam = new SdcAlarmConfigRespond.SdcAlarmParam.SourceParam();
        sourceParam.setTime(requestBody.getAlarmInterval());
        sdcAlarmParam.setSourceParam(sourceParam);
        sdcAlarmParam.setGuardTime(guardTimes);
        alarmParam.add(sdcAlarmParam);
        sdcAlarmConfigRespond.setAlarmParam(alarmParam);
        CameraPassThrouthRequestIvs1800 cameraPassThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        cameraPassThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + uri);
        infoIvs1800.setParam(JSON.toJSONString((Object)sdcAlarmConfigRespond));
        cameraPassThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), cameraPassThrouthRequestIvs1800, null);
    }

    private boolean updateAlarmPlanTime(VcmReqBaseInfo vcmReqBaseInfo, String channelCode, List<Nvr800AlarmPlanItem> alarmPlanList, Integer alarmInterval, String uri) {
        SdcAlarmConfigRespond sdcAlarmConfigRespond = new SdcAlarmConfigRespond();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam> alarmParam = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam>();
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam = new SdcAlarmConfigRespond.SdcAlarmParam();
        ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime> guardTimes = new ArrayList<SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime>();
        if (!CollectionUtils.isEmpty(alarmPlanList)) {
            for (Nvr800AlarmPlanItem nvr800AlarmPlanItem : alarmPlanList) {
                SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardTime = new SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime();
                guardTime.setStartTime(this.changeTimeToInteger(nvr800AlarmPlanItem.getStartTime()));
                guardTime.setEndTime(this.changeTimeToInteger(nvr800AlarmPlanItem.getEndTime()));
                guardTime.setCycle(Integer.valueOf(nvr800AlarmPlanItem.getCycleType()));
                Integer period = nvr800AlarmPlanItem.getPeriod();
                guardTime.setEnable(Integer.valueOf(1));
                guardTime.setPeriod(this.changePeriodToIvs(period));
                guardTimes.add(guardTime);
            }
        }
        sdcAlarmParam.setGuardTime(guardTimes);
        SdcAlarmConfigRespond.SdcAlarmParam.SourceParam sourceParam = new SdcAlarmConfigRespond.SdcAlarmParam.SourceParam();
        sourceParam.setTime(alarmInterval);
        sdcAlarmParam.setSourceParam(sourceParam);
        alarmParam.add(sdcAlarmParam);
        sdcAlarmConfigRespond.setAlarmParam(alarmParam);
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("PUT " + uri);
        infoIvs1800.setParam(JSON.toJSONString((Object)sdcAlarmConfigRespond));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(vcmReqBaseInfo, passThrouthRequestIvs1800, null);
    }

    private String changeLightIlluminatorToSdc(String param) {
        String SdcParam = null;
        switch (param) {
            case "Low": {
                SdcParam = "lowfre";
                break;
            }
            case "Medium": {
                SdcParam = "midfre";
                break;
            }
            case "High": {
                SdcParam = "highfre";
                break;
            }
            case "Steady on": {
                SdcParam = "lightfre";
            }
        }
        return SdcParam;
    }

    private String getAudioBase64(String audioFile, String audioPlaybackTimes) {
        StringBuilder param = new StringBuilder();
        String audioFileBase64 = Base64.getEncoder().encodeToString(audioFile.getBytes(StandardCharsets.UTF_8));
        String audioPlaybackTimesBase64 = Base64.getEncoder().encodeToString(audioPlaybackTimes.getBytes(StandardCharsets.UTF_8));
        param.append("audios=").append(audioFileBase64).append(";").append("audiocount=").append(audioPlaybackTimesBase64);
        return param.toString();
    }

    private String getLightBase64(String audioFile) {
        StringBuilder param = new StringBuilder();
        String audioFileBase64 = Base64.getEncoder().encodeToString(audioFile.getBytes(StandardCharsets.UTF_8));
        param.append("time=").append(audioFileBase64);
        return param.toString();
    }

    private Integer changeTimeToInteger(String startTime) {
        String[] split = startTime.split(":");
        Integer integer = Integer.parseInt(split[0]) * 3600;
        integer = integer + Integer.parseInt(split[1]) * 60;
        integer = integer + Integer.parseInt(split[2]);
        return integer;
    }

    private boolean deleteBehaviorAreaList(ParamBean<BehaviorSetRequest> obj, BehaviorSetRequestIvs1800 convert, SdcMsgType sdcMsgType) {
        BehaviorSetRequest requestBody = (BehaviorSetRequest)obj.getRequestBody();
        String substring = sdcMsgType.getUri().substring(sdcMsgType.getUri().length() - 1);
        convert.setAlarmType(Integer.valueOf(substring));
        ArrayList<BehaviorSetRequestIvs1800.Areas.Area> area = new ArrayList<BehaviorSetRequestIvs1800.Areas.Area>();
        BehaviorSetRequestIvs1800.Lines lines = new BehaviorSetRequestIvs1800.Lines();
        if (!"0".equals(substring)) {
            convert.setAreas(null);
            for (Object integer : requestBody.getIndexList()) {
                BehaviorSetRequestIvs1800.Areas.Area areaIndex = new BehaviorSetRequestIvs1800.Areas.Area();
                areaIndex.setIndex((Integer)integer);
                area.add(areaIndex);
            }
            BehaviorSetRequestIvs1800.Areas areas = new BehaviorSetRequestIvs1800.Areas();
            areas.setArea(area);
            convert.setAreas(areas);
        } else {
            convert.setLines(null);
            ArrayList<Line> lineList = new ArrayList<Line>();
            for (Integer integer : requestBody.getIndexList()) {
                Line line = new Line();
                line.setIndex(integer);
                lineList.add(line);
            }
            lines.setLineList(lineList);
            convert.setLines(lines);
        }
        CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800 = new CameraPassThrouthRequestIvs1800();
        passThrouthRequestIvs1800.setCameraCode(requestBody.getChannelCode());
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("DELETE " + sdcMsgType.getUri());
        infoIvs1800.setParam(JSON.toJSONString((Object)convert));
        passThrouthRequestIvs1800.setInfo(infoIvs1800);
        return this.cameraPassThrouthResult(obj.getVcmInfo(), passThrouthRequestIvs1800, null);
    }

    private boolean cameraPassThrouthResult(VcmReqBaseInfo vcmReqBaseInfo, CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800, Integer timeOut) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)(Objects.isNull(timeOut) ? 20 : timeOut));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (jsonArray.get(0) == null) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getInteger("RspCode") == 0 && returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 0) {
                return true;
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    private IgtAlarmConfigRequestIvs1800 getAlarmConfigIvs1800(IgtAlarmConfigSetRequest request) {
        IgtAlarmConfigRequestIvs1800 alarmConfigIvs1800 = new IgtAlarmConfigRequestIvs1800();
        alarmConfigIvs1800.setEnable(request.getEnable() != false ? 1 : 0);
        alarmConfigIvs1800.setSendMetaEnable(request.getSendMetadataSwitch() != false ? 1 : 0);
        IgtAlarmConfigRequestIvs1800.VideoAnalyseParaBean videoAnalyseParaBean = new IgtAlarmConfigRequestIvs1800.VideoAnalyseParaBean();
        videoAnalyseParaBean.setInsensitiveObject(request.getInsensitiveObject());
        videoAnalyseParaBean.setTrackEnable(request.getTrackEnable());
        videoAnalyseParaBean.setTrackSensitivity(request.getTrackSensitivity());
        videoAnalyseParaBean.setEnableBehEnhance(request.getEnableBehEnhance());
        videoAnalyseParaBean.setTwoBg(request.getTwoBg());
        videoAnalyseParaBean.setBgUpdateRate(this.changeBgUpdateRateToInt(request.getBackgroundUpdateRate()).intValue());
        videoAnalyseParaBean.setDetSensitivity(this.changedetectionSensitivityToInt(request.getDetectionSensitivity()).intValue());
        videoAnalyseParaBean.setShadowMode(this.changeshadowModeToInt(request.getShadowMode()).intValue());
        videoAnalyseParaBean.setMaxTargetNum(request.getMaxTargetNum());
        videoAnalyseParaBean.setFiledType(request.getFieldType());
        videoAnalyseParaBean.setMaxSize(new IgtAlarmConfigTargetRespond(request.getMaxTargetSize().getWidth(), request.getMaxTargetSize().getHeight()));
        videoAnalyseParaBean.setMinSize(new IgtAlarmConfigTargetRespond(request.getMinTargetSize().getWidth(), request.getMinTargetSize().getHeight()));
        videoAnalyseParaBean.setEnableBehEnhance(request.getPerimeterEnhanceSwitch() != false ? 1 : 0);
        videoAnalyseParaBean.setAlertInhibition(request.getAlertInhibitionSwitch() != false ? 1 : 0);
        videoAnalyseParaBean.setOverlayBoxEnable(request.getAlarmPicAiInfoSwitch() != false ? 1 : 0);
        alarmConfigIvs1800.setVideoAnalysePara(videoAnalyseParaBean);
        return alarmConfigIvs1800;
    }

    private BehaviorRespond getBehaviorRespond(JSONObject behavior, JSONObject alarmPlan) {
        Optional operateBean = JsonUtil.convertJsonToBean((String)behavior.toJSONString(), BehaviorSetRequestIvs1800.class);
        BehaviorSetRequestIvs1800 behaviorSetRequestSdc = (BehaviorSetRequestIvs1800)operateBean.get();
        BehaviorRespond behaviorRespond = new BehaviorRespond();
        behaviorRespond.setToleranceTime(behaviorSetRequestSdc.getUlRemainTime());
        behaviorRespond.setSensitivity(behaviorSetRequestSdc.getSensitivity());
        behaviorRespond.setUlRemainTime(behaviorSetRequestSdc.getUlRemainTime());
        behaviorRespond.setToleranceTime(behaviorSetRequestSdc.getUlRemainTime());
        behaviorRespond.setEnable(Boolean.valueOf(behaviorSetRequestSdc.getEnable() == 1));
        behaviorRespond.setDetectType(this.getDetectType(behaviorSetRequestSdc.getObjFilterFlag()));
        behaviorRespond.setRecognizeMode(this.changeRecongnizeModeToString(behaviorSetRequestSdc.getTargetRecMode()));
        behaviorRespond.setFilterSensitivity(behaviorSetRequestSdc.getFilterSensitivity());
        ArrayList<Integer> areaIndexList = new ArrayList<Integer>();
        ArrayList<BehaviorAreaItemRespond> areaList = new ArrayList<BehaviorAreaItemRespond>();
        if (!CollectionUtils.isEmpty((Collection)behaviorSetRequestSdc.getAreas().getArea())) {
            for (BehaviorSetRequestIvs1800.Areas.Area area : behaviorSetRequestSdc.getAreas().getArea()) {
                BehaviorAreaItemRespond areaItem = new BehaviorAreaItemRespond();
                areaItem.setAreaName(area.getAreaName());
                areaItem.setEnable(Boolean.valueOf(area.getEnable() == 1));
                areaItem.setIndex(area.getIndex());
                areaIndexList.add(area.getIndex());
                areaItem.setPointNum(area.getPointNum());
                ArrayList<PointItem> pointList = new ArrayList<PointItem>(area.getPointNum());
                for (int i = 0; i < area.getPointNum(); ++i) {
                    PointItem pointItem = new PointItem();
                    pointItem.setPointX(((Point)area.getPoint().get(i)).getPointX() * 2);
                    pointItem.setPointY(((Point)area.getPoint().get(i)).getPointY() * 2);
                    pointList.add(pointItem);
                }
                areaItem.setPointList(pointList);
                areaList.add(areaItem);
            }
        }
        behaviorRespond.setAreaList(areaList);
        behaviorRespond.setIndexList(areaIndexList);
        List alarmPlanList = this.getBehaviorAlarmPlan(alarmPlan);
        JSONObject alarmInterval = (JSONObject)alarmPlan.getJSONArray("alarmParam").get(0);
        behaviorRespond.setAlarmInterval(alarmInterval.getJSONObject("sourceParam").getInteger("time"));
        behaviorRespond.setAlarmPlanList(alarmPlanList);
        return behaviorRespond;
    }

    private List<BehaviorAlarmPlanItemRespond> getBehaviorAlarmPlan(JSONObject alarmPlan) {
        SdcAlarmConfigRespond.SdcAlarmParam sdcAlarmParam;
        ArrayList<BehaviorAlarmPlanItemRespond> behaviorAlarmPlanItemResponds = new ArrayList<BehaviorAlarmPlanItemRespond>();
        SdcAlarmConfigRespond alarmConfigRespond = (SdcAlarmConfigRespond)JsonUtil.convertJsonToBean((String)alarmPlan.toJSONString(), SdcAlarmConfigRespond.class).get();
        List alarmParam = alarmConfigRespond.getAlarmParam();
        if (!CollectionUtils.isEmpty((Collection)alarmParam) && !CollectionUtils.isEmpty((Collection)(sdcAlarmParam = (SdcAlarmConfigRespond.SdcAlarmParam)alarmParam.get(0)).getGuardTime())) {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            for (SdcAlarmConfigRespond.SdcAlarmParam.GuardAlarmTime guardAlarmTime : sdcAlarmParam.getGuardTime()) {
                BehaviorAlarmPlanItemRespond behaviorAlarmPlanItem = new BehaviorAlarmPlanItemRespond();
                behaviorAlarmPlanItem.setStartTime(format.format(guardAlarmTime.getStartTime() * 1000));
                behaviorAlarmPlanItem.setEndTime(format.format((guardAlarmTime.getEndTime() == 86400 ? 86399 : guardAlarmTime.getEndTime()) * 1000));
                behaviorAlarmPlanItem.setCycleType(guardAlarmTime.getCycle().intValue());
                Integer newPeriod = this.changePeriod(guardAlarmTime.getPeriod());
                behaviorAlarmPlanItem.setPeriod(newPeriod == null ? 0 : newPeriod);
                behaviorAlarmPlanItem.setStartDate(LocalDate.now() + "");
                behaviorAlarmPlanItemResponds.add(behaviorAlarmPlanItem);
            }
            return behaviorAlarmPlanItemResponds;
        }
        return new ArrayList<BehaviorAlarmPlanItemRespond>();
    }

    private Integer changePeriod(Integer period) {
        Integer newPeriod = null;
        switch (period) {
            case 127: {
                newPeriod = 0;
                break;
            }
            case 1: {
                newPeriod = 1;
                break;
            }
            case 2: {
                newPeriod = 2;
                break;
            }
            case 4: {
                newPeriod = 3;
                break;
            }
            case 8: {
                newPeriod = 4;
                break;
            }
            case 16: {
                newPeriod = 5;
                break;
            }
            case 32: {
                newPeriod = 6;
                break;
            }
            case 64: {
                newPeriod = 7;
            }
        }
        return newPeriod;
    }

    private Integer changePeriodToIvs(Integer period) {
        Integer newPeriod = null;
        switch (period) {
            case 0: {
                newPeriod = 127;
                break;
            }
            case 1: {
                newPeriod = 1;
                break;
            }
            case 2: {
                newPeriod = 2;
                break;
            }
            case 3: {
                newPeriod = 4;
                break;
            }
            case 4: {
                newPeriod = 8;
                break;
            }
            case 5: {
                newPeriod = 16;
                break;
            }
            case 6: {
                newPeriod = 32;
                break;
            }
            case 7: {
                newPeriod = 64;
            }
        }
        return newPeriod;
    }

    private String changeRuleTypeToString(Integer directionInt) {
        String direction = null;
        if (directionInt == 0) {
            direction = "A<->B";
        } else if (directionInt == 2) {
            direction = "A->B";
        } else if (directionInt == 1) {
            direction = "B->A";
        }
        return direction;
    }

    private List<String> getDetectType(Integer objFilterFlag) {
        String[] detect = new String[]{"Pedestrian", "Vehicle", "NonVehicle"};
        ArrayList<String> detectType = new ArrayList<String>();
        if (objFilterFlag == 1) {
            detectType.add(detect[0]);
        } else if (objFilterFlag == 2) {
            detectType.add(detect[1]);
        } else if (objFilterFlag == 4) {
            detectType.add(detect[2]);
        } else if (objFilterFlag == 3) {
            detectType.add(detect[0]);
            detectType.add(detect[1]);
        } else if (objFilterFlag == 5) {
            detectType.add(detect[0]);
            detectType.add(detect[2]);
        } else if (objFilterFlag == 6) {
            detectType.add(detect[1]);
            detectType.add(detect[2]);
        } else if (objFilterFlag == 7) {
            detectType.add(detect[0]);
            detectType.add(detect[1]);
            detectType.add(detect[2]);
        }
        return detectType;
    }

    private String changeRecongnizeModeToString(Integer targetRecMode) {
        String recongnizeMode = null;
        switch (targetRecMode) {
            case 0: {
                recongnizeMode = "Center";
                break;
            }
            case 1: {
                recongnizeMode = "Bottom";
                break;
            }
            case 2: {
                recongnizeMode = "Top";
                break;
            }
        }
        return recongnizeMode;
    }

    private String changedetectionSensitivityToString(Integer intDetectionSensitivity) {
        String detectionSensitivity = null;
        switch (intDetectionSensitivity) {
            case 0: {
                detectionSensitivity = "LowSensitivity";
                break;
            }
            case 1: {
                detectionSensitivity = "MiddleSensitivity";
                break;
            }
            case 2: {
                detectionSensitivity = "HighSensitivity";
                break;
            }
            case 3: {
                detectionSensitivity = "LowerSensitivity";
                break;
            }
            case 4: {
                detectionSensitivity = "LowestSensitivity";
                break;
            }
        }
        return detectionSensitivity;
    }

    private Integer changedetectionSensitivityToInt(String stringDetectionSensitivity) {
        Integer detectionSensitivity = null;
        switch (stringDetectionSensitivity) {
            case "LowSensitivity": {
                detectionSensitivity = 0;
                break;
            }
            case "MiddleSensitivity": {
                detectionSensitivity = 1;
                break;
            }
            case "HighSensitivity": {
                detectionSensitivity = 2;
                break;
            }
            case "LowerSensitivity": {
                detectionSensitivity = 3;
                break;
            }
            case "LowestSensitivity": {
                detectionSensitivity = 4;
                break;
            }
        }
        return detectionSensitivity;
    }

    private String changeshadowModeToString(Integer intShadowMode) {
        String shadowMode = null;
        switch (intShadowMode) {
            case 0: {
                shadowMode = "WeakShadow";
                break;
            }
            case 1: {
                shadowMode = "NormalShadow";
                break;
            }
            case 2: {
                shadowMode = "StrongShadow";
                break;
            }
        }
        return shadowMode;
    }

    private Integer changeshadowModeToInt(String StringShadowMode) {
        Integer shadowMode = null;
        switch (StringShadowMode) {
            case "WeakShadow": {
                shadowMode = 0;
                break;
            }
            case "NormalShadow": {
                shadowMode = 1;
                break;
            }
            case "StrongShadow": {
                shadowMode = 2;
                break;
            }
        }
        return shadowMode;
    }

    private String changeBgUpdateRateToString(Integer bgUpdateRate) {
        String backgroundUpdateRate = null;
        switch (bgUpdateRate) {
            case 0: {
                backgroundUpdateRate = "Low";
                break;
            }
            case 1: {
                backgroundUpdateRate = "Middle";
                break;
            }
            case 2: {
                backgroundUpdateRate = "High";
                break;
            }
        }
        return backgroundUpdateRate;
    }

    private Integer changeBgUpdateRateToInt(String bgUpdateRate) {
        Integer backgroundUpdateRate = null;
        switch (bgUpdateRate) {
            case "Low": {
                backgroundUpdateRate = 0;
                break;
            }
            case "Middle": {
                backgroundUpdateRate = 1;
                break;
            }
            case "High": {
                backgroundUpdateRate = 2;
                break;
            }
        }
        return backgroundUpdateRate;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

