/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarmLinkage.AlarmLevelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarmLinkage.AlarmLinkageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmTypeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLevelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLinkageImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmLinkage.AlarmLinkageRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmLinkageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AlarmLinkageIvs1800ServiceImpl
extends AbstractIvs1800Service
implements AlarmLinkageService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmLinkageIvs1800ServiceImpl.class);
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;

    public AlarmLinkageRespond getAlarmLinkage(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond searchRespond;
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/alarm/linkageList/v1.0/" + requestBody.getAlarmInCode() + "/" + requestBody.getDomainCode() + "/" + requestBody.getAlarmInType()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLinkageRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getAlarmLinkage error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlarmLinkageRespond getAlarmLinkageDetails(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond searchRespond;
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/alarm/alarmLinkage/v1.0/" + requestBody.getDomainCode() + "/" + requestBody.getLinkageId() + "/" + requestBody.getAlarmInCode() + "/" + requestBody.getAlarmInType() + "/" + requestBody.getAlarmType()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLinkageRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getAlarmLinkageDetails error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public PageRespond<AlarmTypeRespond> getAlarmType(ParamBean<EmptyRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("fromIndex", "1");
        httpUrlParam.addParam("toIndex", "1000");
        PageRespond respond = new PageRespond();
        List alarmTypeByThirdAlgorithm = this.getAlarmTypeByThirdAlgorithm(vcmReqBaseInfo, httpUrlParam);
        respond.setData(alarmTypeByThirdAlgorithm);
        respond.setPage(1);
        respond.setPageSize(1000);
        respond.setTotal(alarmTypeByThirdAlgorithm.size());
        return respond;
    }

    public PageRespond<AlarmTypeRespond> getThirdAlgorithmAlarmType(ParamBean<EmptyRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("fromIndex", "1");
        httpUrlParam.addParam("toIndex", "1000");
        httpUrlParam.addParam("thirdAlgorithm", "true");
        PageRespond respond = new PageRespond();
        List respondList = this.getAlarmTypeByThirdAlgorithm(vcmReqBaseInfo, httpUrlParam);
        respond.setData(respondList);
        respond.setPage(1);
        respond.setPageSize(1000);
        respond.setTotal(respondList.size());
        return respond;
    }

    private List<AlarmTypeRespond> getAlarmTypeByThirdAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, HttpUrlParam httpUrlParam) {
        ArrayList<AlarmTypeRespond> respondList = new ArrayList<AlarmTypeRespond>();
        JSONObject rsp = null;
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALARM_CODE_TYPE, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONArray alarmTypeArray = rsp.getJSONArray("alarmTypeInfos");
            if (!CollectionUtils.isEmpty((Collection)alarmTypeArray)) {
                for (int i = 0; i < alarmTypeArray.size(); ++i) {
                    AlarmTypeRespond alarmTypeRespond = new AlarmTypeRespond();
                    JSONObject alarmObject = alarmTypeArray.getJSONObject(i);
                    alarmTypeRespond.setAlarmInType(alarmObject.getString("alarmInType"));
                    alarmTypeRespond.setAlarmType(alarmObject.getString("alarmType"));
                    alarmTypeRespond.setAlarmTypeName(alarmObject.getString("alarmTypeName"));
                    alarmTypeRespond.setUserDefined(alarmObject.getIntValue("isUserDefined"));
                    alarmTypeRespond.setAlarmLevelValue(alarmObject.getIntValue("alarmLevelValue"));
                    alarmTypeRespond.setAlarmCategory(alarmObject.getString("alarmCategory"));
                    alarmTypeRespond.setAlarmLevelId(alarmObject.getIntValue("alarmTypeID"));
                    alarmTypeRespond.setAlarmTypeId(alarmObject.getIntValue("alarmTypeID"));
                    respondList.add(alarmTypeRespond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get alarm type error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respondList;
    }

    public AlarmLinkageRespond getAlarmAction(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond searchRespond;
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            requestBody.setAlarmType(requestBody.getAlarmType().replaceAll("ALARM_PERSON_LEAVE_DETECT", "ALARM_LEAVE_DETECT"));
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/alarm/linkageAction/v1.0/" + requestBody.getAlarmInCode() + "/" + requestBody.getDomainCode() + "/" + requestBody.getAlarmInType() + "/" + requestBody.getAlarmType() + "/" + requestBody.getActionType()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLinkageRespond)operateBean.get();
            searchRespond.setDomainCode(requestBody.getDomainCode());
            searchRespond.setAlarmEventId(requestBody.getAlarmEventId());
            searchRespond.setNotificationId(requestBody.getNotificationId());
            searchRespond.setAlarmType(requestBody.getAlarmType());
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getAlarmAction error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public PageRespond<AlarmLinkageImageRespond> getAlarmLinkageImage(VcmReqBaseInfo vcmInfo, AlarmLinkageRequest request) {
        JSONObject dataObject = new JSONObject();
        JSONObject alarmObject = new JSONObject();
        alarmObject.put("alarmEventId", (Object)Integer.parseInt(request.getAlarmEventId()));
        if (StringUtils.isNotBlank((CharSequence)request.getNotificationId())) {
            alarmObject.put("notificationId", (Object)request.getNotificationId());
        }
        dataObject.put("alarmInfo", (Object)alarmObject);
        PageRespond pageRespond = new PageRespond();
        ArrayList<AlarmLinkageImageRespond> imageRespondList = new ArrayList<AlarmLinkageImageRespond>();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ALARM_LINKAGE_IMAGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo), (int)20);
            this.checkJsonRespond(rsp);
            JSONArray imageArray = rsp.getJSONArray("snapShotList");
            if (!CollectionUtils.isEmpty((Collection)imageArray)) {
                for (int i = 0; i < imageArray.size(); ++i) {
                    JSONObject imageObject = imageArray.getJSONObject(i);
                    AlarmLinkageImageRespond imageRespond = new AlarmLinkageImageRespond();
                    imageRespond.setChannelCode(imageObject.getString("cameraCode"));
                    imageRespond.setSnapTime(imageObject.getString("snapTime"));
                    imageRespond.setSnapType(imageObject.getInteger("snapType"));
                    imageRespond.setImageId(imageObject.getString("pictureId"));
                    imageRespond.setDomainCode(request.getDomainCode());
                    if (StringUtils.isNotBlank((CharSequence)imageObject.getString("pictureFileID"))) {
                        imageRespond.setImage(this.smartDaraHelpService.getDynamicGroupImage(vcmInfo, imageObject.getString("pictureFileID")));
                    } else {
                        imageRespond.setImage(this.smartDaraHelpService.getUrlImage(vcmInfo, imageObject.getString("pictureUrl")));
                    }
                    imageRespondList.add(imageRespond);
                }
            }
            pageRespond.setData(imageRespondList);
            pageRespond.setPage(1);
            pageRespond.setPageSize(imageRespondList.size());
            pageRespond.setTotal(imageRespondList.size());
            return pageRespond;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get alarm linkage image error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public AlarmLinkageRespond addAlarmLinkage(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond alarmLinkageRespond = new AlarmLinkageRespond();
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject dataObject = this.requestBodyConvert(requestBody);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LINKAGE_ADD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.Linkage.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            AlarmLinkageRespond.Linkage linkage = (AlarmLinkageRespond.Linkage)operateBean.get();
            ArrayList<AlarmLinkageRespond.Linkage> linkageList = new ArrayList<AlarmLinkageRespond.Linkage>();
            linkageList.add(linkage);
            alarmLinkageRespond.setLinkageList(linkageList);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 addAlarmLinkage error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return alarmLinkageRespond;
    }

    public AlarmLinkageRespond setAlarmLinkage(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond searchRespond;
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject dataObject = this.requestBodyConvert(requestBody);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LINKAGE_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLinkageRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 setAlarmLinkage error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    private JSONObject requestBodyConvert(AlarmLinkageRequest requestBody) {
        JSONObject linkageInfoObject = new JSONObject();
        linkageInfoObject.put("alarmInCode", (Object)requestBody.getAlarmInCode());
        linkageInfoObject.put("alarmInType", (Object)requestBody.getAlarmInType());
        linkageInfoObject.put("alarmType", (Object)requestBody.getAlarmType());
        linkageInfoObject.put("deviceType", (Object)requestBody.getDeviceType());
        linkageInfoObject.put("linkageId", (Object)requestBody.getLinkageId());
        JSONArray actionListArray = new JSONArray();
        for (int i = 0; i < requestBody.getActionList().size(); ++i) {
            JSONObject actionListObject = new JSONObject();
            actionListObject.put("globalParam", (Object)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getGlobalParam());
            actionListObject.put("actionBranch", (Object)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getActionBranch());
            actionListObject.put("actionType", (Object)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getActionType());
            if (!CollectionUtils.isEmpty((Collection)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getDeviceList())) {
                actionListObject.put("deviceList", (Object)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getDeviceList());
            }
            if (!CollectionUtils.isEmpty((Collection)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getUserList())) {
                actionListObject.put("userList", (Object)((AlarmLinkageRequest.LinkageActionInfo)requestBody.getActionList().get(i)).getUserList());
            }
            actionListArray.add((Object)actionListObject);
            linkageInfoObject.put("actionList", (Object)actionListArray);
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("linkageInfo", (Object)linkageInfoObject);
        return dataObject;
    }

    public AlarmLinkageRespond delAlarmLinkage(ParamBean<AlarmLinkageRequest> obj) {
        AlarmLinkageRespond searchRespond;
        try {
            AlarmLinkageRequest requestBody = (AlarmLinkageRequest)obj.getRequestBody();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("linkageInfo", (Object)requestBody);
            if (Objects.isNull(requestBody)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LINKAGE_DEL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLinkageRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLinkageRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 delAlarmLinkage error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlarmLevelRespond getAlarmLevel(ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond searchRespond;
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LEVEL_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLevelRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLevelRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 getAlarmLevel error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlarmLevelRespond addAlarmLevel(ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond searchRespond = new AlarmLevelRespond();
        try {
            AlarmLevelRequest requestBody = (AlarmLevelRequest)obj.getRequestBody();
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LEVEL_ADD, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestBody, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLevelRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            AlarmLevelRespond.AlarmLevel alarmLevel = new AlarmLevelRespond.AlarmLevel();
            alarmLevel.setAlarmLevelId(rsp.getInteger("alarmLevelId"));
            ArrayList<AlarmLevelRespond.AlarmLevel> alarmlevellist = new ArrayList<AlarmLevelRespond.AlarmLevel>();
            alarmlevellist.add(alarmLevel);
            searchRespond.setAlarmlevellist(alarmlevellist);
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 addAlarmLevel error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlarmLevelRespond setAlarmLevel(ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond searchRespond;
        try {
            AlarmLevelRequest requestBody = (AlarmLevelRequest)obj.getRequestBody();
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LEVEL_SET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestBody, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLevelRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLevelRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 setAlarmLevel error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public AlarmLevelRespond delAlarmLevel(ParamBean<AlarmLevelRequest> obj) {
        AlarmLevelRespond searchRespond;
        try {
            AlarmLevelRequest requestBody = (AlarmLevelRequest)obj.getRequestBody();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("alarmLevelId", (Object)requestBody.getAlarmLevelId());
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_LEVEL_DEL, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            Optional operateBean = JsonUtil.convertJsonToBean((String)rsp.toJSONString(), AlarmLevelRespond.class);
            if (!operateBean.isPresent()) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            searchRespond = (AlarmLevelRespond)operateBean.get();
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 delAlarmLevel error,IP:" + obj.getVcmInfo(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return searchRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

