/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.AlarmOperateBean;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.BehaviorSearchBean;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.FaceSearchBean;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.TargetSquare;
import com.zkteco.zkbiosecurity.cuserver.dto.bean.alramSearch.VehicleSearchBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.facerepository.FaceRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.smartdatasubscribes.SmartDataSubscribesRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.vehicleRepository.VehicleRepositoryRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarm.AlarmDealRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarm.AlarmSearchRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarm.DelSubscriptionRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarm.RegisterRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.alarm.SubscriptionRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmTypeRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AreaBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.DetectObjectBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisBehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisFaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisVehicleBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.LineBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.PointBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.OperationsAlarmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.vehicleRepository.VehicleRepositorySearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.AlarmSearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.RegisterSearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.FaceRepositoryManagementService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDataSubscribesService;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.BehaviorAnalysis1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.CommonIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.VehicleRepository1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.ReflectionUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XMLConvertor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlarmIvs1800ServiceImpl
extends AbstractIvs1800Service
implements AlarmService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmIvs1800ServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private DeviceManageService<IServerType.IVS1800> deviceManageService;
    @Autowired
    private SmartDataSubscribesService<IServerType.IVS1800> smartDataSubscribesService;
    @Autowired
    private FaceRepositoryManagementService<IServerType.IVS1800> faceRepositoryManagementService;
    @Autowired
    private SmartDaraHelpService smartDaraHelpService;
    @Autowired
    private VehicleRepository1800ServiceImpl vehicleRepository1800Service;
    @Autowired
    private BehaviorAnalysis1800ServiceImpl behaviorAnalysis1800Service;
    @Autowired
    private CommonIvs1800ServiceImpl commonIvs1800Service;

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        RegisterRequestIvs1800 requestIvs1800 = new RegisterRequestIvs1800();
        requestIvs1800.setWsUri(url);
        try {
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.REGISTER_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Register fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getErrorCode(), Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        try {
            RegisterSearchRespondIvs1800 respondIvs1800 = (RegisterSearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SEARCH_REGISTER_URI, (MsgToObjectConvertor)this.msgToObjectConvertor(null, RegisterSearchRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
            return respondIvs1800.getWsUri();
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        List alarmCode;
        List channelCode;
        boolean result;
        String version = ((SubscriptionRequest)obj.getRequestBody()).getDeviceVersion();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        boolean bl = result = StringUtils.isBlank((CharSequence)version) || StringUtils.isNotBlank((CharSequence)version) && (version.startsWith("8.0") || version.startsWith("8.1") || version.startsWith("9.0"));
        if (result) {
            Map codeMap = this.getAlarmCode(obj.getVcmInfo());
            channelCode = (List)codeMap.get("channelCode");
            if (CollectionUtils.isEmpty(channelCode)) {
                throw new InvokeException("500", Ivs1800Utils.CU_ALLOWED_SUBSCRIBE_CAMERA_NOT_EXIST);
            }
            alarmCode = (List)codeMap.get("alarmCode");
            alarmCode.addAll(channelCode);
        } else {
            alarmCode = new ArrayList();
            channelCode = new ArrayList();
        }
        LOGGER.info("alarm code size:{}", (Object)alarmCode.size());
        if (((SubscriptionRequest)obj.getRequestBody()).isNatEnabled()) {
            ConfigHolder.removeIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId());
        } else {
            String ip = DeviceUtil.getListenIp((VcmReqBaseInfo)vcmReqBaseInfo);
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                ConfigHolder.putIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId(), (String)(ip + "_" + version));
            }
        }
        this.alarmSubscribe(obj, alarmCode);
        this.smartDataSubscribesService.addOrUpdateAll(obj, channelCode);
        this.subscriptionHelp.add(((SubscriptionRequest)obj.getRequestBody()).getDomainCode(), obj.getVcmInfo(), ((SubscriptionRequest)obj.getRequestBody()).getSubscribeId());
        return true;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        this.subscriptionHelp.remove(((SubscriptionRequest)obj.getRequestBody()).getDomainCode());
        try {
            this.delAlarmSubscribe(obj);
            SmartDataSubscribesRequest metaRequest = new SmartDataSubscribesRequest();
            metaRequest.setSubscribeId(((SubscriptionRequest)obj.getRequestBody()).getSubscribeId());
            this.smartDataSubscribesService.delete(obj.getVcmInfo(), metaRequest);
        }
        catch (Exception e) {
            LOGGER.error("Del subscribe fail", (Throwable)e);
        }
        return true;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        AlarmDealRequestIvs1800 requestIvs1800 = this.generateRequest((AlarmDealRequest)obj.getRequestBody());
        try {
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_CONFIRM_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("confirm alarm error,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        AlarmDealRequestIvs1800 requestIvs1800 = this.generateRequest((AlarmDealRequest)obj.getRequestBody());
        try {
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_CANCEL_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 alarm cancel error,IP:" + obj.getVcmInfo().getVcmIp(), (Object)Ivs1800Utils.reasonHelper((SDKException)e));
            throw new InvokeException("500", e.getMessage());
        }
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        AlarmSearchRespondIvs1800 respondIvs1800;
        AlarmSearchRequest request = (AlarmSearchRequest)obj.getRequestBody();
        if (CollectionUtils.isEmpty((Collection)request.getAlarmTypeList())) {
            throw new InvokeException("500", "param_error");
        }
        AlarmSearchRequestIvs1800 requestIvs1800 = this.buildSearchRequest(request);
        try {
            respondIvs1800 = (AlarmSearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.ALARM_SEARCH_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, AlarmSearchRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        }
        catch (SDKException e) {
            LOGGER.error("error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        Map repositoryMap = null;
        if ("0".equals(request.getType())) {
            repositoryMap = this.getFaceRepositoryMap(obj.getVcmInfo());
        }
        ArrayList<AlarmSearchRespond> eventRespondList = new ArrayList<AlarmSearchRespond>();
        JSONArray eventArray = respondIvs1800.getAlarmEventList();
        for (int i = 0; i < eventArray.size(); ++i) {
            JSONObject eventObj = eventArray.getJSONObject(i).getJSONObject("alarmNotify");
            AlarmSearchRespond searchRespond = new AlarmSearchRespond();
            searchRespond.setId(eventObj.getString("alarmEventID"));
            searchRespond.setChannelCode(eventObj.getString("alarmInCode"));
            searchRespond.setCode(eventObj.getString("alarmType").replaceAll("ALARM_LEAVE_DETECT", "ALARM_PERSON_LEAVE_DETECT"));
            searchRespond.setName(Ivs1800Utils.getEventName((JSONObject)eventObj));
            searchRespond.setDomainCode(obj.getVcmInfo().getDomainCode());
            searchRespond.setMsgId(eventObj.getString("alarmEventID"));
            searchRespond.setAlarmCategory(eventObj.getString("alarmCategory"));
            searchRespond.setOccurNumber(eventObj.getInteger("occurNumber"));
            searchRespond.setAlarmInName(eventObj.getString("alarmInName"));
            searchRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)searchRespond.getCode()));
            if (eventObj.getIntValue("alarmLevelValue") <= 1) {
                searchRespond.setAlarmLevel(AlarmLevelEnum.NOTICE);
            } else if (eventObj.getIntValue("alarmLevelValue") <= 50) {
                searchRespond.setAlarmLevel(AlarmLevelEnum.NORMAL);
            } else if (eventObj.getIntValue("alarmLevelValue") <= 80) {
                searchRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
            } else {
                searchRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            }
            if (eventObj.containsKey((Object)"isUserDefind") && "1".equals(eventObj.getString("isUserDefind"))) {
                searchRespond.setAlarmLevelName(eventObj.getString("alarmLevelName"));
                searchRespond.setAlarmLevelValue(eventObj.getInteger("alarmLevelValue"));
                searchRespond.setAlarmLevelColor(eventObj.getString("alarmLevelColor"));
                searchRespond.setAlarmLevelDesc(eventObj.getString("alarmDesc"));
                searchRespond.setIsUserDefined(Integer.valueOf(1));
            } else {
                searchRespond.setIsUserDefined(Integer.valueOf(0));
            }
            searchRespond.setTime(this.formatToLocalDate(eventObj.getString("occurTime")));
            searchRespond.setStatus(eventObj.getIntValue("alarmStatus"));
            searchRespond.setSource(eventObj.getString("source"));
            searchRespond.setSnapshotFileId(eventObj.getString("fileId"));
            searchRespond.setPanoramaFileId(eventObj.getString("fileIdEx"));
            Optional operateBean = JsonUtil.convertJsonToBean((String)eventArray.getJSONObject(i).getJSONObject("operateInfo").toJSONString(), AlarmOperateBean.class);
            operateBean.ifPresent(arg_0 -> ((AlarmSearchRespond)searchRespond).setAlarmOperateBean(arg_0));
            String xml = eventObj.getString("extParam");
            if (StringUtils.isNotEmpty((CharSequence)xml) && xml.startsWith("<")) {
                xml = "<content>" + xml + "</content>";
            }
            if ("0".equals(request.getType())) {
                searchRespond.setFaceBean(this.convertToFace(eventObj, xml, obj.getVcmInfo(), repositoryMap));
            } else if ("1".equals(request.getType())) {
                searchRespond.setVehicleBean(this.convertToVehicle(eventObj, xml, obj.getVcmInfo()));
            } else if ("2".equals(request.getType())) {
                searchRespond.setBehaviorBean(this.convertToBehavior(eventObj, xml, obj.getVcmInfo()));
                if (StringUtils.isEmpty((CharSequence)searchRespond.getSnapshotFileId())) {
                    searchRespond.setSnapshotFileId(searchRespond.getPanoramaFileId());
                }
            } else if ("3".equals(request.getType())) {
                searchRespond.setGeneralBusinessBean(this.convertToGeneraBusiness(eventObj, xml, obj.getVcmInfo()));
            } else if ("4".equals(request.getType())) {
                searchRespond.setCode(StringUtils.isNotEmpty((CharSequence)eventObj.getString("thirdAlarmType")) ? eventObj.getString("thirdAlarmType") : "ALARM_THIRD_ALGORITHM");
                searchRespond.setThirdAlgorithmBean(this.convertToThirdAlgorithm(eventObj, xml, obj.getVcmInfo()));
                searchRespond.setSnapshotFileId(searchRespond.getThirdAlgorithmBean().getSnapshot());
                searchRespond.setPanoramaFileId(searchRespond.getThirdAlgorithmBean().getPanorama());
            } else if ("5".equals(request.getType())) {
                searchRespond.setSituationAnalysisBean(this.convertToSituationAnalysis(eventObj, xml, obj.getVcmInfo()));
            }
            eventRespondList.add(searchRespond);
        }
        PageRespond pageRespond = new PageRespond();
        pageRespond.setPage(request.getPage());
        pageRespond.setPageSize(request.getPageSize());
        pageRespond.setTotal(respondIvs1800.getPageInfo().getRealNum());
        pageRespond.setData(eventRespondList);
        return pageRespond;
    }

    public PageRespond<OperationsAlarmRespond> searchOperations(ParamBean<AlarmSearchRequest> alarmSearch) {
        AlarmSearchRespondIvs1800 respondIvs1800;
        VcmReqBaseInfo vcmReqBaseInfo = alarmSearch.getVcmInfo();
        AlarmSearchRequest requestBody = (AlarmSearchRequest)alarmSearch.getRequestBody();
        String url = "/alarm/omulist/v1.0/?startTime=" + this.formatToUTCDate(requestBody.getStartTime()) + "&endTime=" + this.formatToUTCDate(requestBody.getEndTime()) + "&fromIndex=" + ((requestBody.getPage() - 1) * requestBody.getPageSize() + 1) + "&toIndex=" + requestBody.getPage() * requestBody.getPageSize() + "&alarmType=" + (String)requestBody.getAlarmTypeList().get(0);
        try {
            respondIvs1800 = (AlarmSearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new MsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, AlarmSearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkRespond((BaseRespondIvs1800)respondIvs1800);
        }
        catch (SDKException e) {
            LOGGER.error("search error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        ArrayList<OperationsAlarmRespond> eventRespondList = new ArrayList<OperationsAlarmRespond>();
        JSONObject deviceAlarmEvents = respondIvs1800.getDeviceAlarmEvents();
        JSONArray deviceAlarmInfos = deviceAlarmEvents.getJSONArray("deviceAlarmNotifies");
        if (CollectionUtils.isNotEmpty((Collection)deviceAlarmInfos)) {
            for (int i = 0; i < deviceAlarmInfos.size(); ++i) {
                JSONObject deviceAlarmInfo = (JSONObject)deviceAlarmInfos.get(i);
                OperationsAlarmRespond searchRespond = new OperationsAlarmRespond();
                searchRespond.setId(deviceAlarmInfo.getString("alarmEventID"));
                searchRespond.setChannelCode(deviceAlarmInfo.getString("alarmInCode"));
                searchRespond.setCode(deviceAlarmInfo.getString("alarmType"));
                searchRespond.setDomainCode(vcmReqBaseInfo.getDomainCode());
                searchRespond.setMsgId(deviceAlarmInfo.getString("alarmEventID"));
                searchRespond.setAlarmCategory(deviceAlarmInfo.getString("alarmCategory"));
                searchRespond.setOccurNumber(deviceAlarmInfo.getInteger("occurNumber"));
                searchRespond.setAlarmInName(deviceAlarmInfo.getString("alarmInName"));
                searchRespond.setAlarmInName(deviceAlarmInfo.getString("alarmInName"));
                searchRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)searchRespond.getCode()));
                if (deviceAlarmInfo.getIntValue("alarmLevelValue") <= 1) {
                    searchRespond.setAlarmLevel(AlarmLevelEnum.NOTICE);
                } else if (deviceAlarmInfo.getIntValue("alarmLevelValue") <= 50) {
                    searchRespond.setAlarmLevel(AlarmLevelEnum.NORMAL);
                } else if (deviceAlarmInfo.getIntValue("alarmLevelValue") <= 80) {
                    searchRespond.setAlarmLevel(AlarmLevelEnum.IMPORTANT);
                } else {
                    searchRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
                }
                if (deviceAlarmInfo.containsKey((Object)"locationInfo")) {
                    searchRespond.setLocationInfo(deviceAlarmInfo.getString("locationInfo"));
                }
                if (deviceAlarmInfo.containsKey((Object)"isUserDefind") && "1".equals(deviceAlarmInfo.getString("isUserDefind"))) {
                    searchRespond.setAlarmLevelName(deviceAlarmInfo.getString("alarmLevelName"));
                    searchRespond.setAlarmLevelValue(deviceAlarmInfo.getInteger("alarmLevelValue"));
                    searchRespond.setAlarmLevelColor(deviceAlarmInfo.getString("alarmLevelColor"));
                    searchRespond.setAlarmLevelDesc(deviceAlarmInfo.getString("alarmDesc"));
                    searchRespond.setIsUserDefined(Integer.valueOf(1));
                } else {
                    searchRespond.setIsUserDefined(Integer.valueOf(0));
                }
                searchRespond.setTime(this.formatToLocalDate(deviceAlarmInfo.getString("occurFirstTime")));
                searchRespond.setStatus(1);
                eventRespondList.add(searchRespond);
            }
        }
        PageRespond pageRespond = new PageRespond();
        pageRespond.setPage(requestBody.getPage());
        pageRespond.setPageSize(requestBody.getPageSize());
        pageRespond.setTotal(respondIvs1800.getDeviceAlarmEvents().getInteger("total").intValue());
        pageRespond.setData(eventRespondList);
        return pageRespond;
    }

    private Map<String, FaceRepository> getFaceRepositoryMap(VcmReqBaseInfo vcmReqBaseInfo) {
        HashMap<String, FaceRepository> repositoryMap = new HashMap<String, FaceRepository>();
        try {
            FaceRepositorySearchRespond respond = this.faceRepositoryManagementService.search(vcmReqBaseInfo, new FaceRepositoryRequest());
            if (!CollectionUtils.isEmpty((Collection)respond.getRepositories())) {
                for (FaceRepository repository : respond.getRepositories()) {
                    repositoryMap.put(repository.getGroupId(), repository);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("get face group error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return repositoryMap;
    }

    private String formatToLocalDate(String strDate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = sdf.parse(strDate);
            SimpleDateFormat sdfLocal = new SimpleDateFormat("yyyyMMddHHmmss");
            sdfLocal.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
            return sdfLocal.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("ivs 1800 history format to local Date[{}] format error", (Object)strDate);
            return strDate;
        }
    }

    private String formatToUTCDate(String strDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        sdf.setTimeZone(TimeZone.getTimeZone(ConfigHolder.getTimeZone()));
        try {
            Date date = sdf.parse(strDate);
            SimpleDateFormat sdfUTC = new SimpleDateFormat("yyyyMMddHHmmss");
            sdfUTC.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdfUTC.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("Date[{}] format error", (Object)strDate);
            throw new InvokeException("500", "cu_param_convert_error");
        }
    }

    private AlarmSearchRequestIvs1800 buildSearchRequest(AlarmSearchRequest request) {
        boolean result;
        AlarmSearchRequestIvs1800 requestIvs1800 = new AlarmSearchRequestIvs1800();
        requestIvs1800.setFromIndex((request.getPage() - 1) * request.getPageSize() + 1);
        requestIvs1800.setToIndex(request.getPage() * request.getPageSize());
        if (!StringUtils.isNotBlank((CharSequence)request.getStartTime())) {
            throw new InvokeException("500", "param_error");
        }
        requestIvs1800.setFromTime(this.formatToUTCDate(request.getStartTime()));
        if (!StringUtils.isNotBlank((CharSequence)request.getEndTime())) {
            throw new InvokeException("500", "param_error");
        }
        requestIvs1800.setToTime(this.formatToUTCDate(request.getEndTime()));
        requestIvs1800.setAlarmInCode(request.getChannelCodeList());
        requestIvs1800.setAlarmStatus(request.getStatusList());
        requestIvs1800.setMinLevel(request.getMinLevel());
        requestIvs1800.setMaxLevel(request.getMaxLevel());
        List<String> typeList = new ArrayList();
        ArrayList categoryList = new ArrayList();
        boolean bl = result = "0".equals(request.getType()) || "1".equals(request.getType()) || "3".equals(request.getType()) || "4".equals(request.getType()) || "5".equals(request.getType());
        if (result) {
            Collections.replaceAll(request.getAlarmTypeList(), "ALARM_PERSON_LEAVE_DETECT", "ALARM_LEAVE_DETECT");
            typeList = request.getAlarmTypeList();
            if ("0".equals(request.getType()) && typeList.contains("ALARM_FACE_MASK")) {
                typeList.add("ALARM_FACE_MASK_PLATFORM");
            }
        } else if ("2".equals(request.getType())) {
            typeList = request.getAlarmTypeList();
            if (typeList.contains("ALARM_TRIP_LINE")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_TRIPWIRE");
            }
            if (typeList.contains("ALARM_INTRUSION")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_INVASION");
            }
            if (typeList.contains("ALARM_OBJECT_WANDER")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_WANDER");
            }
            if (typeList.contains("ALARM_ENTER")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_ENTER");
            }
            if (typeList.contains("ALARM_EXIT")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_EXIT");
            }
            if (typeList.contains("ALARM_FASTMOVE")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_FASTMOVE");
            }
            if (typeList.contains("ALARM_FIRE_DETECT")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_FIRE");
            }
            if (typeList.contains("ALARM_CAR_DETECTION")) {
                typeList.add("ALARM_BEHAVIOR_ANALYSIS_CARDET");
            }
        }
        if (!CollectionUtils.isEmpty(typeList)) {
            requestIvs1800.setAlarmType(typeList);
        }
        if (!CollectionUtils.isEmpty(categoryList)) {
            requestIvs1800.setCategory(categoryList);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getDescribe())) {
            requestIvs1800.setDescribe(request.getDescribe());
        }
        return requestIvs1800;
    }

    public PageRespond<AlarmTypeRespond> getAlarmType(ParamBean<EmptyRequest> obj) {
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("fromIndex", "1");
        httpUrlParam.addParam("toIndex", "1000");
        PageRespond respond = new PageRespond();
        ArrayList<AlarmTypeRespond> respondList = new ArrayList<AlarmTypeRespond>();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALARM_CODE_TYPE, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONArray alarmTypeArray = rsp.getJSONArray("alarmTypeInfos");
            if (!CollectionUtils.isEmpty((Collection)alarmTypeArray)) {
                for (int i = 0; i < alarmTypeArray.size(); ++i) {
                    AlarmTypeRespond alarmTypeRespond = new AlarmTypeRespond();
                    JSONObject alarmObject = alarmTypeArray.getJSONObject(i);
                    alarmTypeRespond.setAlarmInType(alarmObject.getString("alarmInType"));
                    alarmTypeRespond.setAlarmType(alarmObject.getString("alarmType"));
                    alarmTypeRespond.setAlarmTypeName(alarmObject.getString("alarmTypeName"));
                    alarmTypeRespond.setUserDefined(alarmObject.getIntValue("isUserDefined"));
                    alarmTypeRespond.setAlarmLevelValue(alarmObject.getIntValue("alarmLevelValue"));
                    alarmTypeRespond.setAlarmCategory(alarmObject.getString("alarmCategory"));
                    alarmTypeRespond.setAlarmLevelId(alarmObject.getIntValue("alarmLevelId"));
                    respondList.add(alarmTypeRespond);
                }
            }
            respond.setData(respondList);
            respond.setPage(1);
            respond.setPageSize(1000);
            respond.setTotal(rsp.getJSONObject("pageInfo").getIntValue("realNum"));
        }
        catch (SDKException e) {
            LOGGER.error("IVS 1800 get alarm type error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return null;
    }

    private SituationAnalysisBean convertToSituationAnalysis(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
        return situationAnalysisBean;
    }

    private ThirdAlgorithmBean convertToThirdAlgorithm(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
        thirdAlgorithmBean.setSnapshot(eventObj.getString("fileId"));
        thirdAlgorithmBean.setPanorama(eventObj.getString("fileIdEx"));
        if (StringUtils.isNotEmpty((CharSequence)xml) && xml.startsWith("{")) {
            JSONObject panoramaPicObject;
            ArrayList alarmInfos = new ArrayList();
            JSONObject extParam = JSONObject.parseObject((String)xml);
            JSONArray thirdAlgorithmArray = JSONObject.parseObject((String)extParam.getString("ThirdAlgorithmObjectList")).getJSONArray("ThirdAlgorithmObject");
            if (!CollectionUtils.isEmpty((Collection)thirdAlgorithmArray)) {
                ArrayList<DetectObjectBean> detectObjectBeanList = new ArrayList<DetectObjectBean>();
                for (Object o : thirdAlgorithmArray) {
                    JSONObject jsonObject;
                    JSONArray objAttr;
                    JSONObject thirdAlgorithmObject = (JSONObject)o;
                    JSONObject detectObject = thirdAlgorithmObject.getJSONObject("ObjPos");
                    if (Objects.nonNull(detectObject)) {
                        DetectObjectBean detectObjectBean = new DetectObjectBean();
                        detectObjectBean.setTop(detectObject.getInteger("Y"));
                        detectObjectBean.setLeft(detectObject.getInteger("X"));
                        detectObjectBean.setRight(Integer.valueOf(detectObjectBean.getLeft() + detectObject.getIntValue("Width")));
                        detectObjectBean.setBottom(Integer.valueOf(detectObjectBean.getTop() + detectObject.getIntValue("Height")));
                        detectObjectBeanList.add(detectObjectBean);
                    }
                    if (thirdAlgorithmObject.getJSONObject("ObjAttrList") != null && !CollectionUtils.isEmpty((Collection)(objAttr = (jsonObject = thirdAlgorithmObject.getJSONObject("ObjAttrList")).getJSONArray("ObjAttr")))) {
                        List alarmInfoLsit = JSONObject.parseArray((String)objAttr.toJSONString(), JSONObject.class);
                        alarmInfos.addAll(alarmInfoLsit.stream().filter(info -> ObjectUtils.isNotEmpty((Object)info.getInteger("needDisplay")) && info.getInteger("needDisplay") == 1).collect(Collectors.toList()));
                    }
                    if (!thirdAlgorithmObject.containsKey((Object)"SubImageList") || CollectionUtils.isEmpty((Collection)thirdAlgorithmObject.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject"))) continue;
                    JSONObject snapshotObject = thirdAlgorithmObject.getJSONObject("SubImageList").getJSONArray("SubImageInfoObject").getJSONObject(0);
                    this.getAlarmInfos(snapshotObject, alarmInfos);
                    thirdAlgorithmBean.setSnapshot(snapshotObject.getString("Data"));
                }
                thirdAlgorithmBean.setDetectObject(detectObjectBeanList);
            }
            if (Objects.nonNull(panoramaPicObject = JSONObject.parseObject((String)extParam.getString("PanoramaPicList"))) && panoramaPicObject.containsKey((Object)"SubImageInfoObject")) {
                JSONObject panoramaObject = panoramaPicObject.getJSONArray("SubImageInfoObject").getJSONObject(0);
                thirdAlgorithmBean.setPanorama(panoramaObject.getString("Data"));
                this.getAlarmInfos(panoramaObject, alarmInfos);
            }
            thirdAlgorithmBean.setAlarmInfos(JSONArray.parseArray((String)JSON.toJSONString(alarmInfos)));
            thirdAlgorithmBean.setThirdAlgorithmName(extParam.getString("MetaName"));
        } else if (StringUtils.isNotBlank((CharSequence)eventObj.getString("alarmDest"))) {
            thirdAlgorithmBean.setThirdAlgorithmName(eventObj.getString("alarmDest"));
        } else {
            thirdAlgorithmBean.setThirdAlgorithmName("unknown");
        }
        return thirdAlgorithmBean;
    }

    private void getAlarmInfos(JSONObject imageInfo, List<JSONObject> alarmInfos) {
        JSONArray picAttr;
        JSONObject picAttrList = imageInfo.getJSONObject("PicAttrList");
        if (ObjectUtils.isNotEmpty((Object)picAttrList) && CollectionUtils.isNotEmpty((Collection)(picAttr = picAttrList.getJSONArray("PicAttr")))) {
            List alarmInfoLsit = JSONObject.parseArray((String)picAttr.toJSONString(), JSONObject.class);
            alarmInfos.addAll(alarmInfoLsit.stream().filter(info -> ObjectUtils.isNotEmpty((Object)info.getInteger("needDisplay")) && info.getInteger("needDisplay") == 1).collect(Collectors.toList()));
        }
    }

    private GeneralBusinessBean convertToGeneraBusiness(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
        try {
            if (xml.startsWith("<")) {
                SAXReader reader = new SAXReader();
                Document document = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
                Element content = document.getRootElement();
                Element extParam = content.element("extParam");
                generalBusinessBean.setTemAnomalyName(extParam.element("name").getText());
                generalBusinessBean.setTemperatureResult(extParam.element("result").getText());
                generalBusinessBean.setTemperatureAlarmContion(extParam.element("alarmContion").getText());
                generalBusinessBean.setTemperatureValue(extParam.element("temperatureValue").getText());
                generalBusinessBean.setTemperatureUnit(extParam.element("temperatureUnit").getText());
                generalBusinessBean.setTemperaturePresetId(extParam.element("presetID").getText());
            }
        }
        catch (Exception e) {
            LOGGER.error("error data:{}", (Object)eventObj);
            LOGGER.error("convert general business error", (Throwable)e);
        }
        return generalBusinessBean;
    }

    private HisBehaviorBean convertToBehavior(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        HisBehaviorBean behaviorBean = new HisBehaviorBean();
        try {
            if (xml.startsWith("<")) {
                BehaviorSearchBean behaviorSearchBean = (BehaviorSearchBean)XMLConvertor.convertXMLToBean((String)xml, BehaviorSearchBean.class);
                if ("2".equals(behaviorSearchBean.getRuleType())) {
                    behaviorBean.setLineFlag(true);
                    LineBean lineBean = new LineBean();
                    lineBean.setDirect(behaviorSearchBean.getLineDirect());
                    lineBean.setType(behaviorSearchBean.getLineType());
                    PointBean pointStartBean = new PointBean();
                    pointStartBean.setXValue(behaviorSearchBean.getLinePointStart().getX());
                    pointStartBean.setYValue(behaviorSearchBean.getLinePointStart().getY());
                    lineBean.setStartPoint(pointStartBean);
                    PointBean pointEndBean = new PointBean();
                    pointEndBean.setXValue(behaviorSearchBean.getLinePointEnd().getX());
                    pointEndBean.setYValue(behaviorSearchBean.getLinePointEnd().getY());
                    lineBean.setEndPoint(pointEndBean);
                    behaviorBean.setLineBean(lineBean);
                } else {
                    AreaBean areaBean = new AreaBean();
                    areaBean.setDirect(behaviorSearchBean.getAreaDirect());
                    areaBean.setType(behaviorSearchBean.getAreaType());
                    areaBean.setPointNum(behaviorSearchBean.getAreaPointNumber());
                    if (!CollectionUtils.isEmpty((Collection)behaviorSearchBean.getPointSearchBeanList())) {
                        ArrayList pointBeanList = new ArrayList(behaviorSearchBean.getPointSearchBeanList().size());
                        behaviorSearchBean.getPointSearchBeanList().forEach(pointSearchBean -> pointSearchBean.getAreaPoints().forEach(areaPoint -> {
                            PointBean pointBean = new PointBean();
                            pointBean.setXValue(areaPoint.getX());
                            pointBean.setYValue(areaPoint.getY());
                            pointBeanList.add(pointBean);
                        }));
                        areaBean.setPointBeans(pointBeanList);
                    }
                    behaviorBean.setAreaBean(areaBean);
                }
                behaviorBean.setAreaType(behaviorSearchBean.getAreaType());
                behaviorBean.setAreaDirect(behaviorSearchBean.getAreaDirect());
                behaviorBean.setDllId(behaviorSearchBean.getOid());
                behaviorBean.setRepositoryId(behaviorSearchBean.getRepositoryId());
                behaviorBean.setTargetId(behaviorSearchBean.getTargetId());
                behaviorBean.setRuleType(behaviorSearchBean.getRuleType());
                behaviorBean.setRuleId(behaviorSearchBean.getRuleId());
                behaviorBean.setSrc(behaviorSearchBean.getSrc());
                DetectObjectBean detectObjectBean = new DetectObjectBean();
                detectObjectBean.setBottom(Integer.valueOf(behaviorSearchBean.getBottom()));
                detectObjectBean.setLeft(Integer.valueOf(behaviorSearchBean.getLeft()));
                detectObjectBean.setRight(Integer.valueOf(behaviorSearchBean.getRight()));
                detectObjectBean.setTop(Integer.valueOf(behaviorSearchBean.getTop()));
                ArrayList<DetectObjectBean> detectObjectBeanList = new ArrayList<DetectObjectBean>();
                if (Objects.nonNull(behaviorSearchBean.getTargetSquareNumber()) && CollectionUtils.isNotEmpty((Collection)behaviorSearchBean.getTargetSquare())) {
                    for (TargetSquare targetSquare : behaviorSearchBean.getTargetSquare()) {
                        targetSquare.getTargetSquarePoints().stream().forEach(targetSquarePoint -> {
                            DetectObjectBean targetSquareBean = new DetectObjectBean();
                            targetSquareBean.setBottom(Integer.valueOf(targetSquarePoint.getBottom()));
                            targetSquareBean.setLeft(Integer.valueOf(targetSquarePoint.getLeft()));
                            targetSquareBean.setRight(Integer.valueOf(targetSquarePoint.getRight()));
                            targetSquareBean.setTop(Integer.valueOf(targetSquarePoint.getTop()));
                            detectObjectBeanList.add(targetSquareBean);
                        });
                    }
                } else {
                    detectObjectBeanList.add(detectObjectBean);
                }
                behaviorBean.setDetectObject(detectObjectBeanList);
            }
        }
        catch (Exception e) {
            LOGGER.error("convert behavior error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return behaviorBean;
    }

    private HisVehicleBean convertToVehicle(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo) {
        HisVehicleBean vehicleBean = new HisVehicleBean();
        try {
            VehicleSearchBean vehicleSearchBean = (VehicleSearchBean)XMLConvertor.convertXMLToBean((String)xml, VehicleSearchBean.class);
            vehicleBean.setAlarmMatch(eventObj.getIntValue("alarmMatch"));
            vehicleBean.setSuspectId(String.valueOf(eventObj.getIntValue("suspectId")));
            vehicleBean.setTaskId(String.valueOf(eventObj.getIntValue("taskId")));
            vehicleBean.setRepositoryId(vehicleSearchBean.getRepositoryId());
            vehicleBean.setTargetId(vehicleSearchBean.getTargetId());
            vehicleBean.setTaskType(vehicleSearchBean.getTaskType());
            vehicleBean.setRecordId(vehicleSearchBean.getRecordId());
            vehicleBean.setSrc(vehicleSearchBean.getSrc());
            vehicleBean.setVehicleAlarmType(vehicleSearchBean.getVehicleAlarmType());
            vehicleBean.setVehicleBrand(vehicleSearchBean.getVehicleBrand());
            vehicleBean.setVehicleStyles(vehicleSearchBean.getVehicleStyles());
            vehicleBean.setVehicleSubBrand(vehicleSearchBean.getVehicleSubBrand());
            vehicleBean.setDrivingDirection(vehicleSearchBean.getDrivingDirection());
            vehicleBean.setDriverSafetyBelt(vehicleSearchBean.getDriverSafetyBelt());
            vehicleBean.setCopilotSafetyBelt(vehicleSearchBean.getCopilotSafetyBelt());
            vehicleBean.setCopilot(vehicleSearchBean.getCopilot());
            vehicleBean.setAnnualInspection(vehicleSearchBean.getAnnualInspection());
            vehicleBean.setDriverVisor(vehicleSearchBean.getDriverVisor());
            vehicleBean.setCopilotVisor(vehicleSearchBean.getCopilotVisor());
            vehicleBean.setPendant(vehicleSearchBean.getPendant());
            vehicleBean.setLeftTopX(vehicleSearchBean.getLeft());
            vehicleBean.setLeftTopY(vehicleSearchBean.getTop());
            vehicleBean.setRightBtmX(vehicleSearchBean.getRight());
            vehicleBean.setRightBtmY(vehicleSearchBean.getBottom());
            ArrayList<DetectObjectBean> vehicleDetectObject = new ArrayList<DetectObjectBean>();
            DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)vehicleBean);
            vehicleDetectObject.add(detectObject);
            vehicleBean.setDetectObject(vehicleDetectObject);
            String groupName = "";
            String fileId = "";
            if (vehicleBean.getAlarmMatch() == 1 && StringUtils.isNotBlank((CharSequence)vehicleSearchBean.getRepositoryId())) {
                vehicleBean.setGroupId(vehicleSearchBean.getRepositoryId());
                vehicleBean.setTargetId(vehicleSearchBean.getTargetId());
                VehicleRepositoryRequest request = new VehicleRepositoryRequest();
                request.setRepositoryId(vehicleSearchBean.getRepositoryId());
                JSONObject vehicleObject = this.smartDaraHelpService.getVehicleByTargetIdAndGroupId(vcmReqBaseInfo, vehicleSearchBean.getTargetId(), vehicleSearchBean.getRepositoryId());
                vehicleBean.setGroupId(vehicleSearchBean.getRepositoryId());
                vehicleBean.setBlackPlateNo(vehicleObject.getString("plateNo"));
                groupName = vehicleObject.getString("groupName");
                fileId = vehicleObject.getString("fileId");
            }
            vehicleBean.setGroupName(StringUtils.isNotEmpty((CharSequence)groupName) ? groupName : "");
            vehicleBean.setGroupImageId(StringUtils.isNotEmpty((CharSequence)fileId) ? fileId : "");
            vehicleBean.setPlateNo(vehicleSearchBean.getPlateNo());
            vehicleBean.setPlateColor(vehicleSearchBean.getPlateColor());
            vehicleBean.setVehicleColor(vehicleSearchBean.getColor());
            vehicleBean.setVehicleClass(vehicleSearchBean.getType());
            vehicleBean.setPlateClass(vehicleSearchBean.getPlateType());
        }
        catch (Exception e) {
            LOGGER.error("convert vehicle error", (Throwable)e);
        }
        return vehicleBean;
    }

    private Map<String, VehicleRepository> getVehicleRepositoryMap(VcmReqBaseInfo vcmReqBaseInfo) {
        HashMap<String, VehicleRepository> repositoryMap = new HashMap<String, VehicleRepository>();
        try {
            VehicleRepositorySearchRespond respond = this.vehicleRepository1800Service.search(vcmReqBaseInfo, new VehicleRepositoryRequest());
            if (CollectionUtils.isNotEmpty((Collection)respond.getVehicleRepositories())) {
                for (VehicleRepository repository : respond.getVehicleRepositories()) {
                    repositoryMap.put(repository.getGroupId(), repository);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("IVS 1800 get vehicle error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        return repositoryMap;
    }

    private HisFaceBean convertToFace(JSONObject eventObj, String xml, VcmReqBaseInfo vcmReqBaseInfo, Map<String, FaceRepository> repositoryMap) {
        HisFaceBean hisFaceBean = new HisFaceBean();
        try {
            if (xml.startsWith("<")) {
                FaceSearchBean faceSearchBean = (FaceSearchBean)XMLConvertor.convertXMLToBean((String)xml, FaceSearchBean.class);
                hisFaceBean.setGenderCode(faceSearchBean.getGender());
                hisFaceBean.setGlassType(Objects.nonNull(faceSearchBean.getGlassesType()) ? faceSearchBean.getGlassesType() : "0");
                hisFaceBean.setAlarmMatch(eventObj.getIntValue("alarmMatch"));
                hisFaceBean.setAge(faceSearchBean.getAge());
                hisFaceBean.setMouthMask(faceSearchBean.getMouthMask());
                hisFaceBean.setLeftTopX(faceSearchBean.getLeft());
                hisFaceBean.setLeftTopY(faceSearchBean.getTop());
                hisFaceBean.setRightBtmX(faceSearchBean.getRight());
                hisFaceBean.setRightBtmY(faceSearchBean.getBottom());
                ArrayList<DetectObjectBean> faceDetectObject = new ArrayList<DetectObjectBean>();
                DetectObjectBean detectObject = ReflectionUtils.getDetectObject((Object)hisFaceBean);
                faceDetectObject.add(detectObject);
                hisFaceBean.setDetectObject(faceDetectObject);
                hisFaceBean.setSrc(faceSearchBean.getSrc());
                hisFaceBean.setDllId(faceSearchBean.getOid());
                hisFaceBean.setTaskType(faceSearchBean.getTaskType());
                hisFaceBean.setFaceAlarmType(faceSearchBean.getFaceAlarmType());
                hisFaceBean.setAlarmPicTag(faceSearchBean.getAlarmPicTag());
                hisFaceBean.setRedAlarmPicTag(faceSearchBean.getRedAlarmPicTag());
                hisFaceBean.setRedAlarmID(faceSearchBean.getRedAlarmID());
                hisFaceBean.setRedAlarmGrpID(faceSearchBean.getRedAlarmGrpID());
                hisFaceBean.setRedConfidence(faceSearchBean.getRedConfidence());
                hisFaceBean.setAgeGroup(faceSearchBean.getAgeGroup());
                hisFaceBean.setHat(faceSearchBean.getHat());
                hisFaceBean.setSkinc(faceSearchBean.getSkinc());
                hisFaceBean.setSuspectId(String.valueOf(eventObj.getIntValue("suspectId")));
                hisFaceBean.setTaskId(String.valueOf(eventObj.getIntValue("taskId")));
                hisFaceBean.setExpression(Objects.nonNull(faceSearchBean.getExpression()) ? faceSearchBean.getExpression() : "0");
                hisFaceBean.setSimilarityDegree(faceSearchBean.getConfidence());
                hisFaceBean.setRepositoryId(faceSearchBean.getRepositoryId());
                hisFaceBean.setTargetId(faceSearchBean.getTargetId());
                hisFaceBean.setFaceTemp(faceSearchBean.getFaceTemp());
                hisFaceBean.setTempUnit(faceSearchBean.getTempUnit());
                if (hisFaceBean.getAlarmMatch() == 1) {
                    String repositoryId = faceSearchBean.getRepositoryId();
                    hisFaceBean.setTargetId(faceSearchBean.getTargetId());
                    if (StringUtils.isNotEmpty((CharSequence)repositoryId) && !"0".equals(repositoryId)) {
                        FaceRepository faceRepository = repositoryMap.getOrDefault(repositoryId, new FaceRepository());
                        hisFaceBean.setGroupName(faceRepository.getName());
                        hisFaceBean.setGroupType(faceRepository.getType());
                    } else {
                        hisFaceBean.setGroupType(String.valueOf(faceSearchBean.getTaskType()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)hisFaceBean.getTargetId()) && !"0".equals(repositoryId)) {
                        People target = this.smartDaraHelpService.getTargetPeopleForIvs1800(vcmReqBaseInfo, repositoryId, hisFaceBean.getTargetId());
                        hisFaceBean.setTargetName(target.getName());
                        hisFaceBean.setTargetCredentialNumber(target.getCredentialNumber());
                        hisFaceBean.setGroupImageId(target.getGroupImageId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("IVS 1800 json error data:{}", (Object)eventObj.toJSONString());
            LOGGER.error("face alarm search convert error", (Throwable)e);
        }
        return hisFaceBean;
    }

    private AlarmDealRequestIvs1800 generateRequest(AlarmDealRequest request) {
        AlarmDealRequestIvs1800 requestIvs1800 = new AlarmDealRequestIvs1800();
        requestIvs1800.setAlarmEventId(Integer.parseInt(request.getAlarmEventId()));
        requestIvs1800.setOperatorId(request.getOperatorId());
        requestIvs1800.setOperatorName(request.getOperatorName());
        if (request.getOperatorTime() != null) {
            requestIvs1800.setOperatorTime(request.getOperatorTime());
        }
        requestIvs1800.setOperatorInfo(request.getOperatorInfo());
        if (StringUtils.isNotBlank((CharSequence)request.getNotificationId())) {
            requestIvs1800.setNotificationId(request.getNotificationId());
        }
        return requestIvs1800;
    }

    private Map<String, List<String>> getAlarmCode(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONArray alarmArray;
        HashMap<String, List<String>> codeMap = new HashMap<String, List<String>>();
        ArrayList<String> alarmCode = new ArrayList<String>();
        ArrayList<String> channelCode = new ArrayList<String>();
        JSONArray channelArray = this.getSubDeviceArray(vcmReqBaseInfo, "2");
        if (!CollectionUtils.isEmpty((Collection)channelArray)) {
            for (int i = 0; i < channelArray.size(); ++i) {
                JSONObject channel = channelArray.getJSONObject(i);
                if (!StringUtils.isNotBlank((CharSequence)channel.getString("code"))) continue;
                channelCode.add(channel.getString("code"));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(alarmArray = this.getSubDeviceArray(vcmReqBaseInfo, "4")))) {
            for (int i = 0; i < alarmArray.size(); ++i) {
                JSONObject alarm = alarmArray.getJSONObject(i);
                if (!Objects.nonNull(alarm.getInteger("channelType")) || alarm.getInteger("channelType") != 0 || !StringUtils.isNotBlank((CharSequence)alarm.getString("alarmCode"))) continue;
                String[] codeArray = alarm.getString("alarmCode").split("#");
                if (codeArray.length > 1) {
                    alarmCode.add(codeArray[0]);
                    continue;
                }
                alarmCode.add(alarm.getString("alarmCode"));
            }
        }
        codeMap.put("channelCode", channelCode);
        codeMap.put("alarmCode", alarmCode);
        return codeMap;
    }

    private JSONArray getSubDeviceArray(VcmReqBaseInfo vcmReqBaseInfo, String deviceType) {
        try {
            HttpUrlParam httpUrlParam = new HttpUrlParam();
            httpUrlParam.addParam("fromIndex", "1");
            httpUrlParam.addParam("toIndex", "1000");
            httpUrlParam.addParam("deviceType", deviceType);
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.LIST_SUB_DEVICE_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class));
            this.checkJsonRespond(rsp);
            if ("2".equals(deviceType)) {
                return rsp.getJSONObject("cameraBriefInfos").getJSONArray("cameraBriefInfoList");
            }
            if ("4".equals(deviceType)) {
                return rsp.getJSONObject("alarmBriefInfos").getJSONArray("alarmBriefInfos");
            }
            return new JSONArray();
        }
        catch (SDKException e) {
            LOGGER.error("getSubDeviceArray", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean alarmSubscribe(ParamBean<SubscriptionRequest> obj, List<String> alarmCode) {
        SubscriptionRequest subscriptionRequest = (SubscriptionRequest)obj.getRequestBody();
        VcmReqBaseInfo vcmReqBaseInfo = obj.getVcmInfo();
        vcmReqBaseInfo.setDomainCode(subscriptionRequest.getDomainCode());
        String callBackUrl = DeviceUtil.getCallBackUrl((VcmReqBaseInfo)vcmReqBaseInfo);
        this.register(obj.getVcmInfo(), callBackUrl);
        try {
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SUBSCRIPTION_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)new SubscriptionRequestIvs1800(alarmCode), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("Subscribe alarm fail,IP:" + obj.getVcmInfo().getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public void delAlarmSubscribe(ParamBean<SubscriptionRequest> obj) {
        List channels = this.deviceManageService.listChannel(obj.getVcmInfo());
        ArrayList channelCodes = new ArrayList();
        channels.forEach(channel -> {
            if (StringUtils.isNotBlank((CharSequence)channel.getIp())) {
                channelCodes.add(channel.getChannelCode());
            }
        });
        if (CollectionUtils.isEmpty(channelCodes)) {
            throw new InvokeException("500", Ivs1800Utils.CU_ALLOWED_SUBSCRIBE_CAMERA_NOT_EXIST);
        }
        DelSubscriptionRequestIvs1800 requestIvs1800 = new DelSubscriptionRequestIvs1800(channelCodes);
        try {
            BaseRespondIvs1800 respondIvs1800 = (BaseRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.SUBSCRIPTION_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, BaseRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkRespond(respondIvs1800);
        }
        catch (SDKException e) {
            LOGGER.error("Del subscription fail", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public boolean alarmCancel(ParamBean<AlarmDealRequest> obj) {
        PenetrateRequest request = new PenetrateRequest();
        request.setRequestMethod("PUT");
        request.setChannelCode(((AlarmDealRequest)obj.getRequestBody()).getChannelCode());
        request.setRequestUrl(SdcMsgType.ALARM_CANCEL.getUri());
        JSONObject data = new JSONObject();
        data.put("alarmType", (Object)Integer.parseInt(((AlarmDealRequest)obj.getRequestBody()).getAlarmType()));
        data.put("alarmCancelMode", (Object)((AlarmDealRequest)obj.getRequestBody()).getAlarmCancelMode());
        data.put("alarmSilentTime", (Object)((AlarmDealRequest)obj.getRequestBody()).getAlarmSilentTime());
        data.put("globalObjId", (Object)((AlarmDealRequest)obj.getRequestBody()).getGlobalId());
        request.setRequestParam(data.toJSONString());
        ParamBean paramBean = new ParamBean();
        paramBean.setVcmInfo(obj.getVcmInfo());
        paramBean.setRequestBody((Object)request);
        JSONObject respond = JSONArray.parseArray((String)this.commonIvs1800Service.penetrate(paramBean).getResultInfo()).getJSONObject(0).getJSONObject("Data");
        if (!"0".equals(respond.getJSONObject("ResponseStatus").getString("StatusCode"))) {
            throw new InvokeException("500", respond.getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        return true;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

