/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarmAudio.AlarmAudioRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmAudio.AlarmAudioRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmAudioService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.FileUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import sun.misc.BASE64Decoder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AlarmAudioServiceIvs1800Impl
extends AbstractIvs1800Service
implements AlarmAudioService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmAudioServiceIvs1800Impl.class);

    public AlarmAudioRespond alarmAudioGet(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        CameraPassThrouthRequestIvs1800 requestIvs1800 = new CameraPassThrouthRequestIvs1800();
        for (int i = 0; i < request.getChannel().size(); ++i) {
            requestIvs1800.setCameraCode(request.getChannel().getString(i));
        }
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + SdcMsgType.ALARM_AUDIO_GET.getUri());
        requestIvs1800.setInfo(infoIvs1800);
        JSONObject jsonObject = this.cameraPass(vcmReqBaseInfo, requestIvs1800);
        JSONArray files = jsonObject.getJSONArray("files");
        ArrayList<AlarmAudioRespond.AudioList> audioList = new ArrayList<AlarmAudioRespond.AudioList>();
        for (int i = 0; i < files.size(); ++i) {
            AlarmAudioRespond.AudioList audioList2 = new AlarmAudioRespond.AudioList();
            JSONObject jsonObject1 = files.getJSONObject(i);
            audioList2.setFileName(jsonObject1.getString("fileName"));
            audioList2.setInternal(jsonObject1.getInteger("isCustom") == 1);
            audioList.add(audioList2);
        }
        AlarmAudioRespond alarmAudioRespond = new AlarmAudioRespond();
        alarmAudioRespond.setAudioList(audioList);
        return alarmAudioRespond;
    }

    public JSONObject alarmAudioAdd(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        JSONObject rsp;
        if (StringUtils.isEmpty((Object)request.getFileData())) {
            return new JSONObject();
        }
        File file = AlarmAudioServiceIvs1800Impl.base64ToAudio((String)request.getFileData());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fileName", (Object)request.getFileName());
        jsonObject.put("audioType", (Object)"pcm");
        jsonObject.put("fileSize", (Object)file.length());
        JSONObject jsonContent = new JSONObject();
        for (int i = 0; i < request.getChannel().size(); ++i) {
            jsonContent.put("deviceCode", (Object)request.getChannel().getString(i));
        }
        jsonContent.put("fileInfo", (Object)jsonObject);
        try {
            rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.ALARM_AUDIO_LINKAGE_CONFIGURATION_ADD, (File)file, (String)jsonContent.toJSONString(), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
        }
        catch (SDKException e) {
            LOGGER.error("alarmAudioAdd exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File base64ToAudio(String base64) {
        if (base64.contains("data:audio")) {
            base64 = base64.substring(base64.indexOf(",") + 1);
        }
        base64 = base64.replace("\r\n", "");
        String prefix = ".wav";
        File file = null;
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            file = File.createTempFile(UUID.randomUUID().toString(), prefix);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes = decoder.decodeBuffer(base64);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (IOException e) {
            LOGGER.debug("base64ToAudio fail.." + e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public JSONObject alarmAudioDel(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        int i;
        CameraPassThrouthRequestIvs1800 requestIvs1800 = new CameraPassThrouthRequestIvs1800();
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        for (i = 0; i < request.getChannel().size(); ++i) {
            requestIvs1800.setCameraCode(request.getChannel().getString(i));
        }
        for (i = 0; i < request.getAudioList().size(); ++i) {
            infoIvs1800.setRequestUrl("DELETE " + SdcMsgType.ALARM_AUDIO_DELETE.getUri() + "?fileName=" + request.getAudioList().getJSONObject(i).getString("file_name"));
        }
        requestIvs1800.setInfo(infoIvs1800);
        return this.cameraPass(vcmReqBaseInfo, requestIvs1800);
    }

    public AlarmAudioRespond alarmAudioBatchGet(VcmReqBaseInfo vcmReqBaseInfo, AlarmAudioRequest request) {
        AlarmAudioRespond respond = new AlarmAudioRespond();
        JSONObject deviceObject = new JSONObject();
        deviceObject.put("deviceList", (Object)request.getDeviceList());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.AUDIO_FILE_BATCH_GET, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)deviceObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            JSONArray files = rsp.getJSONArray("files");
            if (!CollectionUtils.isEmpty((Collection)files)) {
                ArrayList<AlarmAudioRespond.AudioList> audioList = new ArrayList<AlarmAudioRespond.AudioList>();
                for (int i = 0; i < files.size(); ++i) {
                    AlarmAudioRespond.AudioList au = new AlarmAudioRespond.AudioList();
                    JSONObject audioObject = files.getJSONObject(i);
                    au.setFileName(audioObject.getString("fileName"));
                    audioList.add(au);
                }
                respond.setAudioList(audioList);
            }
        }
        catch (SDKException e) {
            LOGGER.error("alarmAudioBatchGet method exception", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return respond;
    }

    private JSONObject cameraPass(VcmReqBaseInfo vcmReqBaseInfo, CameraPassThrouthRequestIvs1800 passThrouthRequestIvs1800) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)passThrouthRequestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (CollectionUtils.isEmpty((Collection)jsonArray)) {
                throw new InvokeException("500", "param_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            JSONObject responseStatus = returnJson.getJSONObject("Data");
            if (returnJson.getInteger("RspCode") == 0) {
                LOGGER.debug("setCameraPass end..");
                return responseStatus;
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_error");
            }
            return null;
        }
        catch (SDKException e) {
            LOGGER.error("setCameraPass error", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

