/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.SdcMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThroughInfoIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.ivs1800.penetrateRequest.CameraPassThrouthRequestIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.request.sdc.intelligent.SdcAbilityRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.penetrateRequest.CameraPassThrouthRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AbilityService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="abilityIvs1800ServiceImpl")
public class AbilityIvs1800ServiceImpl
extends AbstractIvs1800Service
implements AbilityService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbilityIvs1800ServiceImpl.class);

    public Map<String, Boolean> getAbility(ParamBean<ChannelRequest> obj) {
        int i;
        String channelCode = ((ChannelRequest)obj.getRequestBody()).getChannelCode();
        CameraPassThrouthRequestIvs1800 requestIvs1800 = new CameraPassThrouthRequestIvs1800();
        requestIvs1800.setCameraCode(channelCode);
        CameraPassThroughInfoIvs1800 infoIvs1800 = new CameraPassThroughInfoIvs1800();
        infoIvs1800.setRequestUrl("GET " + SdcMsgType.ABILITY_GET.getUri());
        requestIvs1800.setInfo(infoIvs1800);
        JSONObject abilityMapJson = this.cameraPassThrouth(obj, requestIvs1800);
        Optional operateBean = JsonUtil.convertJsonToBean((String)abilityMapJson.toJSONString(), SdcAbilityRespond.class);
        Map map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(operateBean.get()), Map.class);
        map.put("CrossCounting", map.remove("humanCount"));
        map.put("LeaveDetect", map.remove("leaveDetect"));
        map.put("QueueDetect", map.remove("queueDetect"));
        map.put("CrowdDensity", map.remove("crowdDensity"));
        map.put("HeatMap", map.remove("heatMap"));
        map.put("FaceDetection", map.remove("faceDetection"));
        map.put("FaceRecognition", map.remove("featureSynergyMode"));
        map.put("LensBlocking", map.remove("occlustion"));
        map.put("MotionDetect", map.remove("motionDetection"));
        map.put("FaceAttribute", map.remove("faceAttr"));
        map.put("MaskAlarm", true);
        map.put("SoundDetect", map.remove("audio"));
        map.put("SoundAbnormalAlarm", false);
        map.put("VehicleDetection", map.remove("vhdClassify"));
        map.put("VehicleParameter", map.remove("vlpr"));
        map.put("VehicleIllegalPark", false);
        infoIvs1800.setRequestUrl("GET " + SdcMsgType.AUDIO_IAAS_CAPABILITY.getUri());
        JSONObject audioIass = this.cameraPassThrouth(obj, requestIvs1800);
        map.put("AudioOutAlarm", false);
        if (audioIass.containsKey((Object)"isSupportAudioFile")) {
            map.put("AudioOutAlarm", audioIass.getBoolean("isSupportAudioFile"));
        }
        infoIvs1800.setRequestUrl("GET " + SdcMsgType.BEHAPP_PARAMOPTION.getUri());
        JSONObject behappMapJson = this.cameraPassThrouth(obj, requestIvs1800);
        if (behappMapJson != null && behappMapJson.containsKey((Object)"paramOption")) {
            JSONArray paramOptionList = behappMapJson.getJSONArray("paramOption");
            for (i = 0; i < paramOptionList.size(); ++i) {
                JSONObject paramOption = (JSONObject)paramOptionList.get(i);
                List alarmType = JSONObject.parseArray((String)paramOption.getJSONArray("alarmType").toJSONString(), Integer.class);
                for (Integer integer : alarmType) {
                    if (integer == 0) {
                        map.put("PerimeterLine", true);
                        continue;
                    }
                    if (integer == 1) {
                        map.put("PerimeterZone", true);
                        continue;
                    }
                    if (integer == 2) {
                        map.put("Loitering", true);
                        continue;
                    }
                    if (integer == 3) {
                        map.put("ItemLeave", true);
                        continue;
                    }
                    if (integer == 4) {
                        map.put("ItemMove", true);
                        continue;
                    }
                    if (integer == 5) {
                        map.put("AreaEnter", true);
                        continue;
                    }
                    if (integer == 6) {
                        map.put("AreaExit", true);
                        continue;
                    }
                    if (integer == 7) {
                        map.put("FastMove", true);
                        continue;
                    }
                    if (integer == 8) {
                        map.put("ElectroMobile", true);
                        continue;
                    }
                    if (integer != 9) continue;
                    map.put("ParkingDetection", true);
                }
            }
        }
        infoIvs1800.setRequestUrl("GET " + SdcMsgType.MULTI_TASK_APP_ABILITY.getUri());
        JSONObject jsonObject = this.cameraPassThrouth(obj, requestIvs1800);
        if (jsonObject != null && jsonObject.containsKey((Object)"abilityList")) {
            for (i = 0; i < jsonObject.getJSONArray("abilityList").size(); ++i) {
                JSONObject abilityList = (JSONObject)jsonObject.getJSONArray("abilityList").get(i);
                JSONArray algList = abilityList.getJSONArray("algList");
                for (Object o : algList) {
                    JSONObject AlgInfo = (JSONObject)o;
                    if (AlgInfo.getInteger("algMode") != 4) continue;
                    JSONArray supportTask = AlgInfo.getJSONArray("supportTask");
                    List strings = JSONObject.parseArray((String)supportTask.toJSONString(), String.class);
                    for (String string : strings) {
                        if (!"parkingViolation".equals(string)) continue;
                        map.put("VehicleIllegalPark", true);
                    }
                }
            }
        }
        return map;
    }

    private JSONObject cameraPassThrouth(ParamBean<ChannelRequest> obj, CameraPassThrouthRequestIvs1800 requestIvs1800) {
        try {
            CameraPassThrouthRespondIvs1800 respondIvs1800 = (CameraPassThrouthRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.DEVICE_REQUEST_PASSTHROUGH, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)requestIvs1800, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, CameraPassThrouthRespondIvs1800.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("get ability from sdk is end.");
            if (respondIvs1800.getResultCode() != 0) {
                if (respondIvs1800.getResultCode() == 189108033) {
                    throw new InvokeException("500", "cu_not_supported_intelligent_error");
                }
                throw new InvokeException("500", respondIvs1800.getResultCode().toString());
            }
            JSONArray jsonArray = JSONObject.parseArray((String)respondIvs1800.getResultInfo());
            if (jsonArray == null) {
                throw new InvokeException("500", "cu_not_supported_intelligent_error");
            }
            JSONObject returnJson = (JSONObject)jsonArray.get(0);
            if (returnJson.getString("Data").startsWith("[")) {
                return (JSONObject)returnJson.getJSONArray("Data").get(0);
            }
            if (returnJson.getInteger("RspCode") == 0 && !returnJson.getJSONObject("Data").containsKey((Object)"ResponseStatus")) {
                return returnJson.getJSONObject("Data");
            }
            if (returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getInteger("StatusCode") == 3) {
                throw new InvokeException("500", "cu_not_supported_intelligent_error");
            }
            throw new InvokeException("500", returnJson.getJSONObject("Data").getJSONObject("ResponseStatus").getString("StatusCode"));
        }
        catch (SDKException e) {
            LOGGER.error("get ability happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public Map<String, Boolean> getAbilityAuth(ParamBean<ChannelRequest> obj) {
        HashMap<String, Boolean> map = null;
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)Ivs1800MsgType.HOST_ABILITY_AUTH_GET, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(rsp);
            if (rsp.containsKey((Object)"targetAbility")) {
                map = new HashMap<String, Boolean>();
                map.put("targetAbility", rsp.getIntValue("targetAbility") == 1);
            }
        }
        catch (SDKException e) {
            if ("400".equals(e.getErrorCode())) {
                throw new InvokeException("500", "cu_device_not_support");
            }
            LOGGER.error("get AbilityAuth happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        return map;
    }

    public Boolean setAbilityAuth(VcmReqBaseInfo vcmInfo, ChannelRequest request) {
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("targetAbility", (Object)(request.getTargetAbility() != false ? 1 : 0));
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.HOST_ABILITY_AUTH_PUT, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("set AbilityAuth happen exception ", (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemplate, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemplate);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

