/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision;

import com.zkteco.zkbiosecurity.cuserver.contants.HIKVISONMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision.AbstractHIKVISIONService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoHIKVSIONService")
public class VideoHIKVSIONServiceImpl
extends AbstractHIKVISIONService
implements VideoService<IServerType.HIKVISION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoHIKVSIONServiceImpl.class);

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        ArrayList<VideoItem> videoItems = new ArrayList<VideoItem>();
        try {
            List searchMatchItems;
            String rsp = this.getVideoList(vcmInfo, req, UUID.randomUUID().toString(), String.valueOf(req.getPageSize()), "0");
            Document document = DocumentHelper.parseText((String)rsp);
            Element rootElement = document.getRootElement();
            if (Objects.nonNull(rootElement.element("matchList")) && Objects.nonNull(searchMatchItems = rootElement.element("matchList").elements("searchMatchItem")) && searchMatchItems.size() > 0) {
                for (Element element : searchMatchItems) {
                    VideoItem videoItem = new VideoItem();
                    Element timeSpan = element.element("timeSpan");
                    videoItem.setStartTime(this.timeSpanConvertRes(timeSpan.elementText("startTime")));
                    videoItem.setEndTime(this.timeSpanConvertRes(timeSpan.elementText("endTime")));
                    videoItem.setType(RecordTypeEnum.PLAN);
                    videoItems.add(videoItem);
                }
            }
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISION Get Video List Error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        videoRespond.setVideoItemList(videoItems);
        return videoRespond;
    }

    private String getVideoList(VcmReqBaseInfo vcmInfo, VideoListRequest req, String searchID, String maxResults, String searchResultPostion) {
        Document document = DocumentHelper.createDocument();
        Element cmSearchDescription = document.addElement("CMSearchDescription");
        cmSearchDescription.addElement("searchID").setText(searchID);
        Element trackList = cmSearchDescription.addElement("trackList");
        trackList.addElement("trackID").setText(Integer.parseInt(req.getChannelCode().replaceAll("CH", "")) + "01");
        Element timeSpanList = cmSearchDescription.addElement("timeSpanList");
        Element timeSpan = timeSpanList.addElement("timeSpan");
        timeSpan.addElement("startTime").setText(this.timeSpanConvertReq(req.getStartTime()));
        timeSpan.addElement("endTime").setText(this.timeSpanConvertReq(req.getEndTime()));
        cmSearchDescription.addElement("maxResults").setText(maxResults);
        cmSearchDescription.addElement("searchResultPostion").setText(searchResultPostion);
        Element metadataList = cmSearchDescription.addElement("metadataList");
        metadataList.addElement("metadataDescriptor").setText("//recordType.meta.std-cgi.com");
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.CONTENTMGMT_SEARCH, null, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)document.asXML(), false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            return rsp;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVSION Nvr Build VideoList Respond Req", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        return null;
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return null;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    private String timeSpanConvertReq(String dateParam) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timeSpan = null;
        try {
            Date date = sdf.parse(dateParam);
            timeSpan = sdfUtc.format(date);
        }
        catch (ParseException e) {
            LOGGER.error("HIKVISION Time Format Conversion Error", (Throwable)e);
        }
        return timeSpan;
    }

    private String timeSpanConvertRes(String dateParam) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String timeSpan = null;
        try {
            Date date = sdfUtc.parse(dateParam);
            timeSpan = sdf.format(date);
        }
        catch (ParseException e) {
            LOGGER.error("HIKVISION Time Format Conversion Error", (Throwable)e);
        }
        return timeSpan;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

