/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision;

import com.zkteco.zkbiosecurity.cuserver.contants.HIKVISONMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotHIKVISIONService")
public class SnapshotHIKVISIONServiceImpl
implements SnapshotService<IServerType.HIKVISION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotHIKVISIONServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmInfo, SnapshotRequest req) {
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        String channelCode = req.getChannelCode();
        if (channelCode.startsWith("CH")) {
            channelCode = channelCode.substring(2) + "01";
        }
        String result = "";
        try {
            result = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)this.getSnapshotURL(channelCode), null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Nvr Get Snapshot  Fail", (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            snapshotRespond.setImgBase64Str(result);
        }
        return snapshotRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public HIKVISONMsgType getSnapshotURL(String channelId) {
        String replacedUrl = HIKVISONMsgType.GET_CREATE_SNAPSHOT.getUri().replace("%", channelId);
        return new HIKVISONMsgType(HIKVISONMsgType.GET_CREATE_SNAPSHOT.getMethod(), replacedUrl);
    }
}

