/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.HIKVISONMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision.AbstractHIKVISIONService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspHIKVISIONService")
public class RTSPHIKVISIONServiceImpl
extends AbstractHIKVISIONService
implements RTSPService<IServerType.HIKVISION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPHIKVISIONServiceImpl.class);
    private static final String RTSP_STR_SUB = "rtsp://%s:%s@%s:%s/Streaming/Channels/%s%s";
    private static final String RTSP_STR_RECORDING = "rtsp://%s:%s@%s:%s/Streaming/tracks/%s%s?starttime=%s&endtime=%s";

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        JSONObject rtspUrl;
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String rtspPort = this.getRtspPort(vcmInfo);
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "01"));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "01"));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02"));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02"));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            }
        }
        rtspRealPlayRespond.setRtspUrls(rtspUrls);
        return rtspRealPlayRespond;
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        JSONObject rtspUrl;
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        long timeZone = this.getTimeZone(vcmInfo);
        String startDate = request.getStartDate();
        String endDate = request.getEndDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        try {
            Date start = sdf.parse(startDate);
            start = new Date(start.getTime() + timeZone);
            sdfUtc.setTimeZone(TimeZone.getTimeZone("UTC"));
            startDate = sdfUtc.format(start);
            Date end = sdf.parse(endDate);
            end = new Date(end.getTime() + timeZone);
            endDate = sdfUtc.format(end);
        }
        catch (ParseException e) {
            LOGGER.error("Time format conversion error", (Throwable)e);
        }
        String rtspPort = this.getRtspPort(vcmInfo);
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "01", startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "01", startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02", startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02", startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    private long getTimeZone(VcmReqBaseInfo vcmInfo) {
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.TIME_ZONE, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            rsp = rsp.substring(4, rsp.length());
            String[] timeArr = rsp.split(":");
            return Integer.valueOf(timeArr[0]) * 3600000 + Integer.valueOf(timeArr[1]) * 60000 + Integer.valueOf(timeArr[2]) * 1000;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Nvr Get Time Zone Fail", (Throwable)e);
            return 0L;
        }
    }

    private String getRtspPort(VcmReqBaseInfo vcmInfo) {
        String port = "554";
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.ADMIN_ACCESSES, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            Document document = DocumentHelper.parseText((String)rsp);
            Element rootElement = document.getRootElement();
            List adminAccessProtocol = rootElement.elements("AdminAccessProtocol");
            for (Element element : adminAccessProtocol) {
                if (!"RTSP".equals(element.elementText("protocol"))) continue;
                port = element.elementText("portNo");
            }
            return port;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Nvr Get Rtsp Port Fail", (Throwable)e);
            return port;
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISION Get Rtsp Port Result To XML Error ", (Throwable)e);
            return port;
        }
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            if (channelCode.startsWith("CH")) {
                return channelCode.substring(2);
            }
            return channelCode;
        }
        return "";
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

