/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.HIKVISONMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.DeviceRouteRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.hikvision.HIKVISIONChannelBean;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.hikvision.AbstractHIKVISIONService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deviceManageHIKVISIONService")
public class DeviceManageHIKVISIONServiceImpl
extends AbstractHIKVISIONService
implements DeviceManageService<IServerType.HIKVISION> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageHIKVISIONServiceImpl.class);
    @Autowired
    private WebSocketService webSocketService;

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> cameraRespondList = new ArrayList<CameraRespond>();
        List channelBeans = this.getChannelList(vcmReqBaseInfo);
        Map channelStatus = this.getChannelStatus(vcmReqBaseInfo);
        for (int i = 0; i < channelBeans.size(); ++i) {
            HIKVISIONChannelBean hikvisionChannelBean = (HIKVISIONChannelBean)channelBeans.get(i);
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(hikvisionChannelBean.getId());
            cameraRespond.setCameraName(hikvisionChannelBean.getName());
            cameraRespond.setIp(hikvisionChannelBean.getIpAddress());
            cameraRespond.setPort(Integer.valueOf(hikvisionChannelBean.getManagePortNo()).intValue());
            cameraRespond.setUserName(hikvisionChannelBean.getUserName());
            cameraRespond.setVendor("");
            cameraRespond.setCameraType("FIX");
            cameraRespond.setProtocolType(hikvisionChannelBean.getProxyProtocol());
            if (!channelStatus.containsKey(cameraRespond.getCameraCode())) continue;
            JSONObject channel = (JSONObject)channelStatus.get(cameraRespond.getCameraCode());
            cameraRespond.setCameraCode("CH" + hikvisionChannelBean.getId());
            if ("true".equals(channel.getString("online"))) {
                cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else {
                cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
            }
            cameraRespondList.add(cameraRespond);
        }
        return cameraRespondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<ChannelRespond> channelRespondList = new ArrayList<ChannelRespond>();
        List channelBeans = this.getChannelList(vcmReqBaseInfo);
        Map channelStatus = this.getChannelStatus(vcmReqBaseInfo);
        for (int i = 0; i < channelBeans.size(); ++i) {
            HIKVISIONChannelBean channelBean = (HIKVISIONChannelBean)channelBeans.get(i);
            ChannelRespond channelRespond = new ChannelRespond();
            channelRespond.setCategory(DeviceTypeEnum.HIKVISION.val());
            channelRespond.setChannelCode(channelBean.getId());
            channelRespond.setParentCode("CH" + channelRespond.getChannelCode());
            channelRespond.setCameraName(channelBean.getName());
            channelRespond.setChannel(Integer.parseInt(channelBean.getId()));
            channelRespond.setProtocolType(channelBean.getProxyProtocol());
            channelRespond.setVendor("");
            channelRespond.setIp(channelBean.getIpAddress());
            channelRespond.setPort(Integer.valueOf(channelBean.getManagePortNo()).intValue());
            channelRespond.setModel("");
            channelRespond.setType(0);
            channelRespond.setCameraType("FIX");
            channelRespond.setUserName(channelBean.getUserName());
            if (!channelStatus.containsKey(channelRespond.getChannelCode())) continue;
            JSONObject channel = (JSONObject)channelStatus.get(channelRespond.getChannelCode());
            channelRespond.setChannelCode("CH" + channelBean.getId());
            if ("true".equals(channel.getString("online"))) {
                channelRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else {
                channelRespond.setStatus(ChannelStatusEnum.OFFLINE);
            }
            channelRespondList.add(channelRespond);
        }
        return channelRespondList;
    }

    private Map<String, JSONObject> getChannelStatus(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)HIKVISONMsgType.GET_CHANNELS_STATUS, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Document document = DocumentHelper.parseText((String)rsp);
            Element rootElement = document.getRootElement();
            List inputProxyChannelStatus = rootElement.elements("InputProxyChannelStatus");
            HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
            if (Objects.nonNull(inputProxyChannelStatus) && inputProxyChannelStatus.size() > 0) {
                for (Element element : inputProxyChannelStatus) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("online", (Object)element.elementText("online"));
                    jsonObject.put("chanDetectResult", (Object)element.elementText("chanDetectResult"));
                    resultMap.put(element.elementText("id"), jsonObject);
                }
            }
            return resultMap;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Get Channel Status Error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISION Get Channel Status Result To XML Error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<HIKVISIONChannelBean> getChannelList(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)HIKVISONMsgType.GET_CHANNELS_INFO, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            Document document = DocumentHelper.parseText((String)rsp);
            Element rootElement = document.getRootElement();
            List inputProxyChannel = rootElement.elements("InputProxyChannel");
            ArrayList<HIKVISIONChannelBean> channelList = new ArrayList<HIKVISIONChannelBean>();
            if (Objects.nonNull(inputProxyChannel) && inputProxyChannel.size() > 0) {
                for (Element element : inputProxyChannel) {
                    HIKVISIONChannelBean hikvisionChannelBean = new HIKVISIONChannelBean();
                    hikvisionChannelBean.setId(element.elementText("id"));
                    hikvisionChannelBean.setName(element.elementText("name"));
                    Element sourceInputPortDescriptor = element.element("sourceInputPortDescriptor");
                    if (Objects.nonNull(sourceInputPortDescriptor)) {
                        hikvisionChannelBean.setProxyProtocol(sourceInputPortDescriptor.elementText("proxyProtocol"));
                        hikvisionChannelBean.setAddressingFormatType(sourceInputPortDescriptor.elementText("addressingFormatType"));
                        hikvisionChannelBean.setIpAddress(sourceInputPortDescriptor.elementText("ipAddress"));
                        hikvisionChannelBean.setManagePortNo(sourceInputPortDescriptor.elementText("managePortNo"));
                        hikvisionChannelBean.setSrcInputPort(sourceInputPortDescriptor.elementText("srcInputPort"));
                        hikvisionChannelBean.setUserName(sourceInputPortDescriptor.elementText("userName"));
                        hikvisionChannelBean.setStreamType(sourceInputPortDescriptor.elementText("streamType"));
                        hikvisionChannelBean.setDeviceID(sourceInputPortDescriptor.elementText("deviceID"));
                    }
                    hikvisionChannelBean.setEnableAnr(element.elementText("enableAnr"));
                    channelList.add(hikvisionChannelBean);
                }
            }
            return channelList;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Get Channel List Fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISION Get Channel List Result To XML Error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        return null;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        try {
            HttpRequestUtil.requestDigestForTianDy((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new HIKVISONMsgType(HttpMethodEnum.HTTP_METHOD_DELETE, HIKVISONMsgType.DEL_DEVICE.getUri() + ((CameraRemoveRequest)obj.getRequestBody()).getCameraCode().replaceAll("CH", "")), null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Remove Camera Fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        return false;
    }

    public DeviceInfoRespond getDeviceInfo(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond respond = new DeviceInfoRespond();
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.GET_DEVICE_INFO, null, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            Document document = DocumentHelper.parseText((String)rsp);
            Element rootElement = document.getRootElement();
            respond.setModel(rootElement.element("deviceType").getStringValue());
            respond.setDeviceVersion(rootElement.element("firmwareVersion").getStringValue());
            respond.setProductName(rootElement.element("deviceName").getStringValue());
            rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmInfo, (MsgType)HIKVISONMsgType.GET_DEVICE_CAPABILITIES, null, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmInfo));
            document = DocumentHelper.parseText((String)rsp);
            rootElement = document.getRootElement();
            respond.setMaxChannelNumber(Integer.valueOf(Integer.parseInt(rootElement.element("inputProxyNums").getStringValue())));
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Get Device Info Error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        catch (DocumentException e) {
            LOGGER.error("HIKVISION Get Device Result To XML error", (Throwable)e);
        }
        return respond;
    }

    public DeviceRouteRespond getDeviceVersion(VcmReqBaseInfo vcmInfo) {
        DeviceInfoRespond deviceInfo = this.getDeviceInfo(vcmInfo);
        DeviceRouteRespond respond = new DeviceRouteRespond();
        respond.setDeviceVersion(deviceInfo.getDeviceVersion());
        respond.setIp(vcmInfo.getVcmIp());
        respond.setModel(deviceInfo.getModel());
        respond.setProductName(deviceInfo.getProductName());
        return respond;
    }

    public List<CameraSearchRespond> searchCamera(VcmReqBaseInfo vcmReqBaseInfo, CameraSearchRequest request) {
        CompletableFuture.runAsync(() -> {
            String rsp = null;
            try {
                rsp = (String)HttpRequestUtil.requestDigestForHIKVISION((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)HIKVISONMsgType.SEARCH_DEVICE, null, null, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                Document document = DocumentHelper.parseText((String)rsp);
                Element rootElement = document.getRootElement();
                List videoSourceDescriptor = rootElement.elements("VideoSourceDescriptor");
                DeviceEventRespond deviceEventRespond = new DeviceEventRespond();
                deviceEventRespond.setType(EventTypeEnum.OPERATE_RESULT);
                deviceEventRespond.setDomainCode(request.getDomainCode());
                deviceEventRespond.setPercent("100");
                deviceEventRespond.setSubtype("searchCamera");
                if (Objects.nonNull(videoSourceDescriptor) && videoSourceDescriptor.size() > 0) {
                    deviceEventRespond.getData().getCameras().addAll(this.buildCameraSearchRespondList(videoSourceDescriptor, request.getProtocolType(), request.getIpList()));
                }
                this.webSocketService.send((BaseEventRespond)deviceEventRespond);
            }
            catch (SDKException e) {
                LOGGER.error("HIKVISION Search Camera Error", (Throwable)e);
                throw new InvokeException("500", e.getMessage());
            }
            catch (DocumentException e) {
                LOGGER.error("HIKVISION Search Camera Result To XML Error", (Throwable)e);
            }
        });
        return new ArrayList<CameraSearchRespond>();
    }

    private List<CameraSearchRespond> buildCameraSearchRespondList(List<Element> videoSourceDescriptor, String protocolType, List<CameraSearchRequest.IpInfo> ipList) {
        ArrayList<CameraSearchRespond> cameraSearchResponds = new ArrayList<CameraSearchRespond>();
        for (Element element : videoSourceDescriptor) {
            String proxyProtocol = element.elementText("proxyProtocol");
            if (!proxyProtocol.equals(protocolType)) continue;
            CameraSearchRespond searchRespond = new CameraSearchRespond();
            searchRespond.setCameraType("FIX");
            searchRespond.setIp(element.elementText("ipAddress"));
            searchRespond.setProtocol(proxyProtocol);
            searchRespond.setWebPort(element.elementText("managePortNo"));
            searchRespond.setChannelNumber(Integer.valueOf(element.elementText("id")).intValue());
            searchRespond.setSerialNumber(element.elementText("serialNumber"));
            searchRespond.setSubnetMask(element.elementText("subnetMask"));
            searchRespond.setVendor(element.elementText(""));
            searchRespond.setPort(element.elementText("managePortNo"));
            searchRespond.setDeviceType("ipc");
            searchRespond.setGateway("");
            cameraSearchResponds.add(searchRespond);
        }
        return cameraSearchResponds;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

