/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.dahua;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.DHNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.dahua.AbstractDHNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoDHNvrService")
public class VideoDHNvrServiceImpl
extends AbstractDHNvrService
implements VideoService<IServerType.DHNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoDHNvrServiceImpl.class);

    public VideoRespond videoList(VcmReqBaseInfo vcmInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmInfo, (MsgType)DHNvrMsgType.GET_OBJECT_ID, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            JSONObject jsonObject = JSONObject.parseObject((String)rsp);
            String objectId = jsonObject.getString("result");
            String startTime = req.getStartTime().replaceAll(".000", "").replaceAll(" ", "%20");
            String endTime = req.getEndTime().replaceAll(".000", "").replaceAll(" ", "%20");
            String url = String.format("/cgi-bin/mediaFileFind.cgi?action=findFile&object=%s&condition.Channel=%s&condition.StartTime=%s&condition.EndTime=%s&condition.VideoStream=Main", objectId, Integer.valueOf(req.getChannelCode().substring(2)), startTime, endTime);
            rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmInfo, (MsgType)new DHNvrMsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            url = String.format("/cgi-bin/mediaFileFind.cgi?action=findNextFile&object=%s&count=-1", objectId);
            rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmInfo, (MsgType)new DHNvrMsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
            this.checkJsonRespond(rsp);
            jsonObject = JSONObject.parseObject((String)rsp);
            videoRespond = this.buildVideoList(jsonObject);
        }
        catch (SDKException e) {
            LOGGER.error("DAHUA Get Video List Error ", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return videoRespond;
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        return null;
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return null;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        return false;
    }

    private VideoRespond buildVideoList(JSONObject jsonObject) {
        VideoRespond videoRespond = new VideoRespond();
        ArrayList<VideoItem> videoItemList = new ArrayList<VideoItem>();
        Integer found = jsonObject.getInteger("found");
        for (int i = 0; i < found; ++i) {
            VideoItem videoItem = new VideoItem();
            videoItem.setType(RecordTypeEnum.PLAN);
            videoItem.setStartTime(jsonObject.getString("items[" + i + "].StartTime"));
            videoItem.setEndTime(jsonObject.getString("items[" + i + "].EndTime"));
            videoItemList.add(videoItem);
        }
        videoRespond.setVideoItemList(videoItemList);
        return videoRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

