/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.dahua;

import com.zkteco.zkbiosecurity.cuserver.contants.DHNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.SnapshotRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.SnapshotRespond;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SnapshotService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="snapshotDHNvrService")
public class SnapshotDHNvrServiceImpl
implements SnapshotService<IServerType.DHNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotDHNvrServiceImpl.class);

    public SnapshotRespond createSnapshot(VcmReqBaseInfo vcmInfo, SnapshotRequest req) throws SDKException {
        SnapshotRespond snapshotRespond = new SnapshotRespond();
        String channelCode = req.getChannelCode();
        if (channelCode.startsWith("CH")) {
            channelCode = channelCode.substring(2);
        }
        String rsp = "";
        try {
            rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmInfo, (MsgType)this.getSnapshotURL(channelCode), (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("HIKVISION Nvr Get Snapshot  Fail", (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)rsp)) {
            snapshotRespond.setImgBase64Str(rsp);
        }
        return snapshotRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public DHNvrMsgType getSnapshotURL(String channelId) {
        String replacedUrl = DHNvrMsgType.GET_CREATE_SNAPSHOT.getUri().replace("%", channelId);
        return new DHNvrMsgType(DHNvrMsgType.GET_CREATE_SNAPSHOT.getMethod(), replacedUrl);
    }
}

