/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.dahua;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.dahua.AbstractDHNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToXmlMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.XmlMsgToObjectConvertor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="rtspDHNvrServiceImpl")
public class RTSPDHNvrServiceImpl
extends AbstractDHNvrService
implements RTSPService<IServerType.DHNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RTSPDHNvrServiceImpl.class);
    private static final String RTSP_STR_SUB = "rtsp://%s:%s@%s:%s/cam/realmonitor?channel=%s&subtype=%s";
    private static final String RTSP_STR_RECORDING = "rtsp://%s:%s@%s:%s/cam/playback?channel=%s&starttime=%s&endtime=%s";

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        JSONObject rtspUrl;
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String rtspPort = "554";
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "0"));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "0"));
                rtspUrl.put("type", (Object)1);
                rtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "1"));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_SUB, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "1"));
                rtspUrl.put("type", (Object)2);
                rtspUrls.add(rtspUrl);
            }
        }
        rtspRealPlayRespond.setRtspUrls(rtspUrls);
        return rtspRealPlayRespond;
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmInfo, RTSPPlayBackRequest request) {
        JSONObject rtspUrl;
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        ArrayList<JSONObject> playBackRtspUrls = new ArrayList<JSONObject>();
        String channelCode = this.splitChannelCode(request.getChannelCode());
        String startDate = request.getStartDate();
        String endDate = request.getEndDate();
        SimpleDateFormat originalFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        try {
            Date start = originalFormat.parse(startDate);
            startDate = sdf.format(start);
            Date end = originalFormat.parse(endDate);
            endDate = sdf.format(end);
        }
        catch (ParseException e) {
            LOGGER.error("Time format conversion error", (Throwable)e);
        }
        String rtspPort = "554";
        if (request.getType() == 0 || request.getType() == 1) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, startDate, endDate));
                rtspUrl.put("type", (Object)1);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        if (request.getType() == 0 || request.getType() == 2) {
            rtspUrl = new JSONObject();
            if ("0".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02", startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            } else if ("1".equals(request.getClientType())) {
                rtspUrl.put("rtspUrl", (Object)String.format(RTSP_STR_RECORDING, vcmInfo.getSdcUserName(), vcmInfo.getSdcPassword(), vcmInfo.getVcmIp(), rtspPort, channelCode, "02", startDate, endDate));
                rtspUrl.put("type", (Object)2);
                playBackRtspUrls.add(rtspUrl);
            }
        }
        rtspPlayBackRespond.setRtspUrls(playBackRtspUrls);
        return rtspPlayBackRespond;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            if (channelCode.startsWith("CH")) {
                return channelCode.substring(2);
            }
            return channelCode;
        }
        return "";
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToXmlMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new XmlMsgToObjectConvertor(cClass);
    }
}

