/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.dahua;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.DHNvrMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.dahua.AbstractDHNvrService;
import com.zkteco.zkbiosecurity.cuserver.utils.DHNvrUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="deviceManageDHNvrService")
public class DeviceManageDHNvrServiceImpl
extends AbstractDHNvrService
implements DeviceManageService<IServerType.DHNVR> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageDHNvrServiceImpl.class);

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<CameraRespond> respondList = new ArrayList<CameraRespond>();
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)DHNvrMsgType.GET_CHANNELS, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            int channelSize = 0;
            String ret = DHNvrUtils.convertToChannelTitleSON((String)rsp);
            JSONArray jsonArray = JSON.parseArray((String)ret);
            channelSize = jsonArray.size();
            String channelInfos = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)DHNvrMsgType.GET_CHANNELS_INFO, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
            Map objectMap = DHNvrUtils.convertToChannelInfoSON((String)channelInfos, (int)channelSize);
            if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    CameraRespond cameraRespond = new CameraRespond();
                    if (Objects.nonNull(objectMap.get(i))) {
                        JSONObject object = (JSONObject)objectMap.get(i);
                        cameraRespond.setVendor(object.getString("vendor"));
                        cameraRespond.setModel(object.getString("deviceType"));
                        cameraRespond.setIp(object.getString("address"));
                        cameraRespond.setProtocolType(object.getString("protocolType"));
                        cameraRespond.setSerialNumber(object.getString("serialNo"));
                    }
                    cameraRespond.setCameraCode("CH" + jsonObject.getString("channel"));
                    cameraRespond.setCameraName(jsonObject.getString("name"));
                    cameraRespond.setStatus("0".equals(jsonObject.getString("status")) ? ChannelStatusEnum.ONLINE : ChannelStatusEnum.OFFLINE);
                    cameraRespond.setCameraType("FIX");
                    respondList.add(cameraRespond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("dahua listCamera get error", (Throwable)e);
        }
        return respondList;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        ArrayList<ChannelRespond> respondList = new ArrayList<ChannelRespond>();
        try {
            String rsp = (String)HttpRequestUtil.requestDigestForDaHua((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)DHNvrMsgType.GET_CHANNELS, (MsgToObjectConvertor)this.msgToObjectConvertor(null, String.class), (List)this.getHeaders(vcmReqBaseInfo));
            this.checkJsonRespond(rsp);
            String ret = DHNvrUtils.convertToChannelTitleSON((String)rsp);
            JSONArray jsonArray = JSON.parseArray((String)ret);
            if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                for (int i = 0; i < jsonArray.size(); ++i) {
                    ChannelRespond channelRespond = new ChannelRespond();
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    channelRespond.setChannelCode("CH" + jsonObject.getString("channel"));
                    channelRespond.setCameraName(jsonObject.getString("name"));
                    channelRespond.setChannel(jsonObject.getInteger("channel").intValue());
                    channelRespond.setStatus("0".equals(jsonObject.getString("status")) ? ChannelStatusEnum.ONLINE : ChannelStatusEnum.OFFLINE);
                    channelRespond.setCameraType("FIX");
                    respondList.add(channelRespond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("dahua listChannel get error", (Throwable)e);
        }
        return respondList;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        return null;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        return false;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

