/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudConstants;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AlarmCloudServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.CloudEventGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.WebSocketClientHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ChannelHandler.Sharable
public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ChannelHandlerContext channelHandlerContext;
    @Autowired
    AlarmCloudServiceImpl alarmCloudServiceImpl;
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    private static AlarmCloudServiceImpl alarmCloudService;
    private static SubscriptionHelp subscriptionHelpService;
    private static WebSocketClientHandler webSocketClientHandler;
    WebSocketClientHandshaker handshaker;
    ChannelPromise handshakeFuture;

    @PostConstruct
    public void init() {
        alarmCloudService = this.alarmCloudServiceImpl;
        subscriptionHelpService = this.subscriptionHelp;
    }

    private WebSocketClientHandler() {
    }

    public static synchronized WebSocketClientHandler getWebSocketClientHandler() {
        if (webSocketClientHandler == null) {
            webSocketClientHandler = new WebSocketClientHandler();
        }
        return webSocketClientHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        block16: {
            Channel ch;
            block17: {
                block15: {
                    ch = ctx.channel();
                    this.channelHandlerContext = ctx;
                    if (this.handshaker.isHandshakeComplete()) break block15;
                    try {
                        FullHttpResponse response = (FullHttpResponse)msg;
                        this.handshaker.finishHandshake(ch, response);
                        this.handshakeFuture.setSuccess();
                        LOGGER.info("cloud service info" + response.headers());
                    }
                    catch (WebSocketHandshakeException var7) {
                        LOGGER.error("webSocket hand shake error", (Throwable)var7);
                        FullHttpResponse res = (FullHttpResponse)msg;
                        String errorMsg = String.format("shake hands with fail,status:%s,reason:%s", res.status(), res.content().toString(CharsetUtil.UTF_8));
                        LOGGER.info("shake hands error:{}", (Object)errorMsg);
                        this.handshakeFuture.setFailure((Throwable)new Exception(errorMsg));
                    }
                    break block16;
                }
                if (!(msg instanceof FullHttpResponse)) break block17;
                FullHttpResponse response = (FullHttpResponse)msg;
                LOGGER.info("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
                break block16;
            }
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
                LOGGER.info("cloud client receive info:" + textFrame.text());
            }
            if (frame instanceof BinaryWebSocketFrame) {
                block14: {
                    try {
                        BinaryWebSocketFrame binFrame = (BinaryWebSocketFrame)frame;
                        ByteBuf bf = binFrame.content();
                        byte[] byteArray = new byte[bf.readableBytes()];
                        bf.readBytes(byteArray);
                        if (byteArray.length > 3) {
                            byte[] newByte = new byte[1];
                            System.arraycopy(byteArray, 0, newByte, 0, 1);
                            String result = WebSocketClientHandler.bytes2HexString((byte[])newByte);
                            if ("0x83".equals(result)) {
                                byte[] data = new byte[byteArray.length - 3];
                                System.arraycopy(byteArray, 5, data, 0, byteArray.length - 5);
                                String alarm = new String(data).trim();
                                JSONObject alarmJson = JSONObject.parseObject((String)alarm);
                                LOGGER.info("cloud push data \uff1a{}", (Object)alarmJson);
                                String userId = alarmJson.getString("user_id");
                                VcmReqBaseInfo vcmReqBaseInfo = subscriptionHelpService.get(StringUtils.isNotEmpty((CharSequence)userId) ? userId : "");
                                if (vcmReqBaseInfo != null) {
                                    CloudEventGetThread.getLinkedQueue().add(alarmJson);
                                } else {
                                    LOGGER.info("Ignore cloud push data, userId:{} ", (Object)userId);
                                }
                            }
                            break block14;
                        }
                        LOGGER.info("BinaryWebSocketFrame result size:{}", (Object)byteArray.length);
                    }
                    catch (Exception e) {
                        try {
                            LOGGER.error("web socket error", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            byte[] buffer = new byte[]{3, 0, 4, 0};
                            ByteBuf message = Unpooled.buffer((int)buffer.length);
                            message.writeBytes(buffer);
                            BinaryWebSocketFrame webSocketFrame = new BinaryWebSocketFrame(message);
                            ctx.writeAndFlush((Object)webSocketFrame);
                            throw throwable;
                        }
                        byte[] buffer = new byte[]{3, 0, 4, 0};
                        ByteBuf message = Unpooled.buffer((int)buffer.length);
                        message.writeBytes(buffer);
                        BinaryWebSocketFrame webSocketFrame = new BinaryWebSocketFrame(message);
                        ctx.writeAndFlush((Object)webSocketFrame);
                    }
                }
                byte[] buffer = new byte[]{3, 0, 4, 0};
                ByteBuf message = Unpooled.buffer((int)buffer.length);
                message.writeBytes(buffer);
                BinaryWebSocketFrame webSocketFrame = new BinaryWebSocketFrame(message);
                ctx.writeAndFlush((Object)webSocketFrame);
            }
            if (frame instanceof PongWebSocketFrame) {
                LOGGER.info("WebSocket Client received pong");
            }
            if (frame instanceof CloseWebSocketFrame) {
                LOGGER.info("receive close frame");
                ch.close();
            }
        }
    }

    public static String bytes2HexString(byte[] b) {
        String r = "";
        for (int i = 0; i < b.length; ++i) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            r = r + "0x" + hex.toUpperCase();
        }
        return r;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        byte[] buffer = new byte[]{2, 0, 4, 0};
        CloudConstants.CLOUD_SUB_STATUS = "1";
        this.scheduler.submit((Runnable)new MsgRunnable(this, ctx, buffer));
        LOGGER.info("connect cloud wss service");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("cloud wss service close");
        CloudConstants.CLOUD_SUB_STATUS = "0";
        CloudEventGetThread.getLinkedQueue().clear();
        try {
            subscriptionHelpService.remove(subscriptionHelpService.get("cloudSdcSubKey").getUserId());
            subscriptionHelpService.remove("cloudSdcSubKey");
        }
        catch (Exception e) {
            LOGGER.info("the subscription cache does not exist");
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("connection exception\uff1a", cause);
        ctx.close();
    }

    public void closeSocket() {
        try {
            this.channelHandlerContext.close();
        }
        catch (Exception e) {
            LOGGER.info("close socket fail:{}", (Object)e.getMessage());
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public WebSocketClientHandshaker getHandshaker() {
        return this.handshaker;
    }

    public void setHandshaker(WebSocketClientHandshaker handshaker) {
        this.handshaker = handshaker;
    }

    public ChannelPromise getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public void setHandshakeFuture(ChannelPromise handshakeFuture) {
        this.handshakeFuture = handshakeFuture;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public byte[] short2byte(short s) {
        byte[] b = new byte[2];
        for (int i = 0; i < 2; ++i) {
            int offset = 16 - (i + 1) * 8;
            b[i] = (byte)(s >> offset & 0xFF);
        }
        return b;
    }

    public byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

