/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RecordConfigRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoBookMarkSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoListRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoLockInfoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.VideoRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.bean.VideoItem;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordConfigRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RecordStatusRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoBookMarkRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoListRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoLockInfoRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.VideoRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.RecordTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.VideoService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="videoCloudService")
public class VideoCloudServiceImpl
extends AbstractCloudService
implements VideoService<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoCloudServiceImpl.class);

    public VideoRespond videoList(VcmReqBaseInfo vcmReqBaseInfo, VideoListRequest req) {
        VideoRespond videoRespond = new VideoRespond();
        ArrayList videoItems = new ArrayList();
        for (RecordTypeEnum recordType : req.getTypeList()) {
            if (RecordTypeEnum.PLAN.equals((Object)recordType)) {
                videoItems.addAll(this.getEntVideoList(vcmReqBaseInfo, req, RecordTypeEnum.NORMAL_RECORD));
                continue;
            }
            if (!RecordTypeEnum.ALARM.equals((Object)recordType)) continue;
            videoItems.addAll(this.getEntVideoList(vcmReqBaseInfo, req, RecordTypeEnum.MOTION_RECORD));
        }
        videoRespond.setVideoItemList(videoItems);
        return videoRespond;
    }

    private List<VideoItem> getEntVideoList(VcmReqBaseInfo vcmReqBaseInfo, VideoListRequest req, RecordTypeEnum recordType) {
        ArrayList<VideoItem> videoItems;
        block9: {
            videoItems = new ArrayList<VideoItem>();
            int offset = 0;
            try {
                JSONObject requestResult;
                while (true) {
                    String url = String.format(CloudMsgType.ENT_CLOUD_RECORDING_VIDEO_LIST.getUri(), vcmReqBaseInfo.getUserId(), req.getCameraId(), req.getChannelCode().split("\\$")[1], 100, offset, recordType, req.getEndTime().replaceAll(" ", "%20").split("\\.")[0], req.getStartTime().replaceAll(" ", "%20").split("\\.")[0], vcmReqBaseInfo.getEnterpriseId());
                    requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                    LOGGER.debug("get video list from cloud is end.");
                    if (Objects.nonNull(requestResult) && Objects.nonNull(requestResult.getJSONArray("records"))) {
                        JSONArray records = requestResult.getJSONArray("records");
                        if (records.size() > 0) {
                            for (int i = 0; i < records.size(); ++i) {
                                VideoItem videoItem = new VideoItem();
                                JSONObject recordFile = records.getJSONObject(i);
                                videoItem.setEventId(Integer.valueOf(recordFile.getString("record_id")));
                                videoItem.setRecordFileName(recordFile.getString("record_name"));
                                videoItem.setLock(Boolean.valueOf(false));
                                videoItem.setStartTime(recordFile.getString("start_time"));
                                videoItem.setEndTime(recordFile.getString("end_time"));
                                if (recordType.equals((Object)RecordTypeEnum.NORMAL_RECORD)) {
                                    videoItem.setType(RecordTypeEnum.PLAN);
                                } else if (recordType.equals((Object)RecordTypeEnum.MOTION_RECORD)) {
                                    videoItem.setType(RecordTypeEnum.ALARM);
                                }
                                videoItem.setChannelCode(req.getChannelCode());
                                videoItem.setDomainCode(req.getCameraId());
                                videoItems.add(videoItem);
                            }
                            LOGGER.debug("get video list is end..");
                            ++offset;
                            continue;
                        }
                        break block9;
                    }
                    if (!"1000".equals(requestResult.getString("code"))) break;
                }
                throw new InvokeException("500", requestResult.getString("msg"));
            }
            catch (SDKException e) {
                LOGGER.error("get ent video list fail", (Throwable)e);
                throw new InvokeException("500", e.getMessage());
            }
        }
        return videoItems;
    }

    public Boolean videoStart(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public Boolean videoStop(VcmReqBaseInfo vcmInfo, VideoRequest req) {
        return null;
    }

    public List<VideoBookMarkRespond> getVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkSearchRequest req) {
        return null;
    }

    public String createVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return null;
    }

    public boolean uptVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public boolean delVideoBookmark(VcmReqBaseInfo vcmInfo, VideoBookMarkRequest req) {
        return false;
    }

    public VideoLockInfoListRespond getVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoListRequest req) {
        return null;
    }

    public VideoLockInfoRespond createVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond delVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public VideoLockInfoRespond uptVideoLockInfo(VcmReqBaseInfo vcmInfo, VideoLockInfoRequest req) {
        return null;
    }

    public List<RecordStatusRespond> getRecordStatus(ParamBean<ChannelListRequest> obj) {
        return null;
    }

    public RecordConfigRespond getConfig(ParamBean<ChannelRequest> obj) {
        RecordConfigRespond recordConfigRespond = new RecordConfigRespond();
        ChannelRequest requestBody = (ChannelRequest)obj.getRequestBody();
        String cloudUrl = String.format(CloudMsgType.GET_RECORD_CONFIG.getUri(), requestBody.getEnterpriseId(), requestBody.getDeviceId(), requestBody.getChannelId());
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, cloudUrl), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("get config from cloud is end.");
            recordConfigRespond.setStreamMode(requestResult.getString("stream_type"));
            LOGGER.debug("get config end..");
        }
        catch (SDKException e) {
            LOGGER.error("get config fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return recordConfigRespond;
    }

    public boolean setConfig(ParamBean<RecordConfigRequest> obj) {
        LOGGER.debug("Cloud setConfig start");
        RecordConfigRequest requestBody = (RecordConfigRequest)obj.getRequestBody();
        String cloudUrl = String.format(CloudMsgType.SET_RECORD_CONFIG.getUri(), requestBody.getEnterpriseId());
        JSONObject paramJson = new JSONObject();
        JSONObject param = new JSONObject();
        JSONArray paramArr = new JSONArray();
        param.put("device_id", (Object)requestBody.getDeviceId());
        param.put("channel_id", (Object)requestBody.getChannelId());
        param.put("stream_type", (Object)requestBody.getStreamMode());
        paramArr.add((Object)param);
        paramJson.put("channel_record_configs", (Object)paramArr);
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_PUT, cloudUrl), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("set config to cloud is end.");
            if (requestResult.getInteger("failed_num") == 0) {
                LOGGER.debug("set config is end.");
                return true;
            }
        }
        catch (SDKException e) {
            LOGGER.error("set config fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return false;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

