/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cloud.RenewalTokenRequestCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChangePasswordRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.LoginRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.UserTokenRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.EntUserInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.EnterpriseInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.OrgInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.BaseRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.LoginRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.user.UserRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.UserManageService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.WebSocketClientHandler;
import com.zkteco.zkbiosecurity.cuserver.utils.EntCloudUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userManageCloudService")
public class UserManageCloudServiceImpl
extends AbstractCloudService
implements UserManageService<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManageCloudServiceImpl.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public boolean firstLogin(ParamBean<EmptyRequest> obj) {
        return false;
    }

    public String getModel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public LoginRespond login(ParamBean<LoginRequest> obj) {
        JSONObject jsonObject = this.buildLoginReqParams((LoginRequest)obj.getRequestBody());
        int requestCount = 0;
        return this.cloudLoginRequest(obj, jsonObject, requestCount);
    }

    private LoginRespond cloudLoginRequest(ParamBean<LoginRequest> obj, JSONObject jsonObject, int requestCount) {
        LoginRespond loginRespond = new LoginRespond();
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.CLOUD_USER_LOGIN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("cloud login end");
            this.checkJsonRespond(requestResult);
            if (Objects.nonNull(requestResult) && Objects.nonNull(requestResult.getJSONObject("data"))) {
                JSONObject data = requestResult.getJSONObject("data");
                if (StringUtils.isBlank((CharSequence)data.getString("token")) || StringUtils.isBlank((CharSequence)data.getString("tiken"))) {
                    if (requestCount <= 1) {
                        try {
                            Thread.sleep(1000L);
                            return this.cloudLoginRequest(obj, jsonObject, ++requestCount);
                        }
                        catch (InterruptedException e) {
                            throw new InvokeException("500", e.getMessage());
                        }
                    }
                    throw new InvokeException("500", "login_fail");
                }
                loginRespond.setVmSession(data.getString("token"));
                loginRespond.setCsrfToken(data.getString("tiken"));
            }
        }
        catch (SDKException e) {
            LOGGER.error("cloud login fail", (Throwable)e);
            throw new InvokeException("500", "login_fail");
        }
        return loginRespond;
    }

    public boolean logout(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.CLOUD_USER_LOGOUT, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            LOGGER.debug("cloud logout from cloud is end.");
            this.checkJsonRespond(requestResult);
            if (Objects.nonNull(requestResult) && Objects.nonNull(requestResult.getString("code")) && "1000".equals(requestResult.getString("code"))) {
                LOGGER.debug("cloud logout is end.");
                return true;
            }
        }
        catch (SDKException e) {
            LOGGER.error("cloud logout fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return false;
    }

    public boolean keepAlive(ParamBean<EmptyRequest> obj) {
        return false;
    }

    public boolean firstChange(ParamBean<ChangePasswordRequest> obj) {
        return false;
    }

    public List<OrgInfoRespondCloud> getCloudOrgList(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject paramsJson = new JSONObject();
        List<Object> orgInfoList = new ArrayList<OrgInfoRespondCloud>();
        paramsJson.put("enterprise_id", (Object)vcmReqBaseInfo.getEnterpriseId());
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.GET_DEVICE_AND_ORG_LIST, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            LOGGER.debug("get org list from cloud is end.");
            if (Objects.nonNull(requestResult.getJSONObject("data"))) {
                JSONArray deviceList = requestResult.getJSONObject("data").getJSONArray("org_list");
                orgInfoList = JSON.parseArray((String)deviceList.toJSONString(), OrgInfoRespondCloud.class);
                LOGGER.debug("get org list is end..");
            }
        }
        catch (SDKException e) {
            LOGGER.error("get org list fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return orgInfoList;
    }

    public JSONObject getCloudUserInfo(ParamBean<EmptyRequest> obj) {
        JSONObject resultJson = new JSONObject();
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.CLOUD_USER_GET_OWN_USER, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(requestResult);
            if (Objects.nonNull(requestResult.getJSONObject("data"))) {
                resultJson = requestResult.getJSONObject("data");
            }
        }
        catch (SDKException e) {
            LOGGER.error("getCloudUserInfo fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return resultJson;
    }

    public String renewalToken(ParamBean<RenewalTokenRequestCloud> obj) {
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("tiken", (Object)((RenewalTokenRequestCloud)obj.getRequestBody()).getCsrfToken());
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.CLOUD_USER_RENEWAL_TOKEN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            this.checkJsonRespond(requestResult);
            if (Objects.nonNull(requestResult.getJSONObject("data"))) {
                return requestResult.getJSONObject("data").getString("token");
            }
        }
        catch (SDKException e) {
            LOGGER.error("renewal token fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return "";
    }

    public LoginRespond loginCloud(VcmReqBaseInfo vcmReqBaseInfo, LoginRequest request) {
        JSONArray methodArray = new JSONArray();
        methodArray.add((Object)"password");
        JSONObject domainObject = new JSONObject();
        domainObject.put("name", (Object)request.getUserName());
        JSONObject userObject = new JSONObject();
        userObject.put("name", (Object)request.getIamUserName());
        userObject.put("password", (Object)request.getPassword());
        userObject.put("domain", (Object)domainObject);
        JSONObject passwordObject = new JSONObject();
        passwordObject.put("user", (Object)userObject);
        JSONObject identityObject = new JSONObject();
        identityObject.put("password", (Object)passwordObject);
        identityObject.put("methods", (Object)methodArray);
        JSONObject scopeDomainObject = new JSONObject();
        scopeDomainObject.put("name", (Object)request.getUserName());
        JSONObject scopeObject = new JSONObject();
        scopeObject.put("domain", (Object)scopeDomainObject);
        JSONObject authObject = new JSONObject();
        authObject.put("identity", (Object)identityObject);
        authObject.put("scope", (Object)scopeObject);
        JSONObject dataObject = new JSONObject();
        dataObject.put("auth", (Object)authObject);
        try {
            CloseableHttpResponse result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.HW_CLOUD_LOGIN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), response -> (CloseableHttpResponse)response);
            if (result.getCode() == 201) {
                LoginRespond respond = new LoginRespond();
                respond.setVmSession(result.getHeader("X-Subject-Token").getValue());
                return respond;
            }
            throw new InvokeException("500", String.valueOf(result.getCode()));
        }
        catch (SDKException | ProtocolException e) {
            LOGGER.error("login cloud error", e);
            String message = e.getMessage();
            if (StringUtils.isNotBlank((CharSequence)message) || message.startsWith("{")) {
                try {
                    JSONObject reason = JSONObject.parseObject((String)e.getMessage());
                    message = reason.getJSONObject("error").getString("message");
                }
                catch (Exception exception) {
                    LOGGER.error("login cloud fail message parse error", (Throwable)exception);
                }
            }
            throw new InvokeException("500", message);
        }
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private JSONObject buildLoginReqParams(LoginRequest requestBody) {
        JSONObject cloudLoginRequest = new JSONObject();
        cloudLoginRequest.put("account", (Object)requestBody.getUserName());
        cloudLoginRequest.put("password", (Object)requestBody.getPassword());
        cloudLoginRequest.put("app_lan", (Object)requestBody.getAppLan());
        cloudLoginRequest.put("app_type", (Object)requestBody.getAppType());
        cloudLoginRequest.put("app_version", (Object)requestBody.getAppVersion());
        return cloudLoginRequest;
    }

    public LoginRespond cloudLogin(ParamBean<LoginRequest> obj) {
        LOGGER.debug("cloud login start");
        JSONObject jsonObject = this.buildUserLoginReqParams((LoginRequest)obj.getRequestBody());
        int requestCount = 0;
        return this.cloudUsersLoginRequest(obj, jsonObject, requestCount);
    }

    private JSONObject buildUserLoginReqParams(LoginRequest requestBody) {
        JSONObject cloudUsersLoginRequest = new JSONObject();
        cloudUsersLoginRequest.put("account", (Object)requestBody.getUserName());
        cloudUsersLoginRequest.put("login_code", (Object)requestBody.getPassword());
        cloudUsersLoginRequest.put("client_type", (Object)"S100");
        cloudUsersLoginRequest.put("login_type", (Object)"PASSWORD");
        return cloudUsersLoginRequest;
    }

    private LoginRespond cloudUsersLoginRequest(ParamBean<LoginRequest> obj, JSONObject jsonObject, int requestCount) {
        LoginRespond loginRespond = new LoginRespond();
        try {
            ArrayList<EnterpriseInfoRespondCloud> enterprisesList;
            JSONObject data;
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.ENT_CLOUD_USERS_LOGIN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)jsonObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("cloud login end");
            if (Objects.nonNull(requestResult) && Objects.nonNull(requestResult.getJSONObject("data")) && "Success".equals(requestResult.getString("error_msg"))) {
                data = requestResult.getJSONObject("data");
                if (StringUtils.isBlank((CharSequence)data.getString("token"))) {
                    if (requestCount <= 1) {
                        return this.cloudUsersLoginRequest(obj, jsonObject, ++requestCount);
                    }
                    throw new InvokeException("500", "login_fail");
                }
                loginRespond.setVmSession(data.getString("token"));
                enterprisesList = new ArrayList<EnterpriseInfoRespondCloud>();
                for (int i = 0; i < data.getJSONArray("enterprises").size(); ++i) {
                    JSONObject enterprises = data.getJSONArray("enterprises").getJSONObject(i);
                    EnterpriseInfoRespondCloud enterpriseInfo = new EnterpriseInfoRespondCloud();
                    enterpriseInfo.setEnterpriseId(enterprises.getString("enterprise_id"));
                    enterpriseInfo.setEnterpriseName(enterprises.getString("enterprise_name"));
                    enterpriseInfo.setUserRole(enterprises.getInteger("user_role"));
                    enterpriseInfo.setUserStatus(enterprises.getInteger("user_status"));
                    enterprisesList.add(enterpriseInfo);
                }
            } else {
                throw new InvokeException("500", String.valueOf(requestResult.getString("error_code")));
            }
            loginRespond.setEnterprises(enterprisesList);
            loginRespond.setUserId(data.getString("user_id"));
            loginRespond.setCsrfToken(data.getString("refresh_token"));
        }
        catch (SDKException e) {
            LOGGER.error("cloud login fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), EntCloudUtils.reasonHelper((SDKException)e));
        }
        return loginRespond;
    }

    public EntUserInfoRespondCloud getEntCloudUserInfo(ParamBean<EmptyRequest> obj) {
        EntUserInfoRespondCloud result = null;
        String url = String.format(CloudMsgType.CLOUD_GET_USER_INFO.getUri(), obj.getVcmInfo().getUserId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            if (Objects.nonNull(requestResult)) {
                Optional operateBean = JsonUtil.convertJsonToBean((String)requestResult.toJSONString(), EntUserInfoRespondCloud.class);
                if (!operateBean.isPresent()) {
                    throw new InvokeException("500", "cu_device_not_return");
                }
                result = (EntUserInfoRespondCloud)operateBean.get();
                if (StringUtils.isNotEmpty((CharSequence)result.getCode()) && "21032".equals(result.getCode())) {
                    WebSocketClientHandler.getWebSocketClientHandler().closeSocket();
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("getEntCloudUserInfo fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), EntCloudUtils.reasonHelper((SDKException)e));
        }
        return result;
    }

    public boolean cloudLogout(VcmReqBaseInfo vcmReqBaseInfo) {
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.ENT_CLOUD_USER_LOGOUT, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            LOGGER.debug("cloud logout from cloud is end.");
            WebSocketClientHandler.getWebSocketClientHandler().closeSocket();
            return true;
        }
        catch (SDKException e) {
            LOGGER.error("cloud logout fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public UserRespond getCloudTicket(VcmReqBaseInfo vcmReqBaseInfo) {
        HttpUrlParam urlParam = new HttpUrlParam();
        urlParam.addParam("type", "1");
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.HW_CLOUD_GET_TICKET, (HttpUrlParam)urlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (StringUtils.isBlank((CharSequence)rsp.getString("ticket"))) {
                throw new InvokeException("500", (Object)rsp, rsp.getString("error_code"));
            }
            UserRespond respond = new UserRespond();
            respond.setToken(rsp.getString("ticket"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("cloud get ticket fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public UserRespond getTokenByTicket(VcmReqBaseInfo vcmReqBaseInfo, UserTokenRequest request) {
        JSONObject data = new JSONObject();
        data.put("ticket", (Object)request.getTicket());
        data.put("type", (Object)request.getType().toString());
        LOGGER.info("get token by ticket:{}", (Object)data.toJSONString());
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.HW_CLOUD_GET_TOKEN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (StringUtils.isBlank((CharSequence)rsp.getString("token"))) {
                throw new InvokeException("500", rsp.getString("error_code"));
            }
            UserRespond respond = new UserRespond();
            respond.setToken(rsp.getString("token"));
            respond.setUserName(rsp.getString("username"));
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("cloud get token by ticket error", (Throwable)e);
            if (e.getMessage().contains("error_code")) {
                JSONObject ret = JSONObject.parseObject((String)e.getMessage());
                throw new InvokeException("500", ret.getString("error_code"));
            }
            throw new InvokeException("500", e.getMessage());
        }
    }

    public BaseRespond checkToken(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONObject data = new JSONObject();
        data.put("token", (Object)"");
        try {
            HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.HW_CLOUD_CHECK_TOKEN, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            BaseRespond respond = new BaseRespond();
            respond.setResultCode("0");
            return respond;
        }
        catch (SDKException e) {
            LOGGER.error("cloud check token error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }
}

