/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.thirdAlgorithm.ThirdAlgorithmRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.thirdAlgorithm.ThirdAlgorithmRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.ThirdAlgorithmService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ThirdAlgorithmCloudServiceImpl")
public class ThirdAlgorithmCloudServiceImpl
extends AbstractCloudService
implements ThirdAlgorithmService<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThirdAlgorithmCloudServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public PageRespond<ThirdAlgorithmRespond> getBoughtAlgorithm(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        String urlTemplate = "/v1/holosens/hcs/order/subscriptions";
        String url = String.format(urlTemplate, request.getLimit());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("limit", String.valueOf(request.getLimit()));
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            PageRespond respond = new PageRespond();
            ArrayList<ThirdAlgorithmRespond> algorithmRespondList = new ArrayList<ThirdAlgorithmRespond>();
            if (rsp.getIntValue("code") == 200) {
                JSONArray algorithmArray = rsp.getJSONArray("subscriptionNewList");
                if (!CollectionUtils.isEmpty((Collection)algorithmArray)) {
                    for (int i = 0; i < algorithmArray.size(); ++i) {
                        JSONObject algorithmObject = algorithmArray.getJSONObject(i);
                        if (!StringUtils.isNotBlank((CharSequence)algorithmObject.getString("platform")) || !algorithmObject.getString("platform").contains("IVS1800") && !algorithmObject.getString("platform").contains("SDC")) continue;
                        ThirdAlgorithmRespond algorithmRespond = new ThirdAlgorithmRespond();
                        algorithmRespond.setAlgorithmId(algorithmObject.getString("productId"));
                        algorithmRespond.setAlgorithmName(algorithmObject.getString("algorithmName"));
                        algorithmRespond.setBoughtTime(algorithmObject.getString("purchase_time"));
                        algorithmRespond.setVendorName(algorithmObject.getString("vendor_name"));
                        algorithmRespond.setSubscriptionId(algorithmObject.getString("subscriptionId"));
                        algorithmRespond.setRemainingNumber(algorithmObject.getIntValue("Remaining_Quota"));
                        algorithmRespond.setUsedNumber(algorithmObject.getIntValue("Allocated_Quota"));
                        algorithmRespond.setTotalNumber(algorithmObject.getIntValue("Purchased_Quota"));
                        algorithmRespond.setOrderType(algorithmObject.getInteger("spec_id"));
                        algorithmRespond.setPackageName(algorithmObject.getString("algorithm_pack_name"));
                        JSONArray licenseSource = new JSONArray();
                        if (!CollectionUtils.isEmpty((Collection)algorithmObject.getJSONArray("quota_sources"))) {
                            for (int j = 0; j < algorithmObject.getJSONArray("quota_sources").size(); ++j) {
                                JSONObject license = algorithmObject.getJSONArray("quota_sources").getJSONObject(j);
                                JSONObject data = new JSONObject();
                                data.put("type", (Object)license.getString("source_type"));
                                data.put("usedAmount", (Object)license.getIntValue("used_amount"));
                                data.put("freeAmount", (Object)license.getIntValue("usable_amount"));
                                data.put("provideName", (Object)license.getString("provider_domain_name"));
                                data.put("orderType", (Object)algorithmRespond.getOrderType());
                                if (StringUtils.equals((CharSequence)"0", (CharSequence)license.getString("source_type"))) {
                                    data.put("shareId", (Object)license.getString("share_id"));
                                } else {
                                    data.put("shareId", (Object)algorithmObject.getString("subscriptionId"));
                                }
                                licenseSource.add((Object)data);
                            }
                        }
                        algorithmRespond.setLicenseSource(licenseSource);
                        algorithmRespondList.add(algorithmRespond);
                    }
                    respond.setTotal(rsp.getIntValue("total_count"));
                    respond.setPageSize(algorithmRespondList.size());
                } else {
                    respond.setTotal(0);
                    respond.setPageSize(0);
                }
                respond.setData(algorithmRespondList);
                return respond;
            }
            throw new InvokeException("500", (Object)rsp, rsp.getString("code"));
        }
        catch (SDKException e) {
            LOGGER.error("cloud getBoughtAlgorithm error", (Throwable)e);
            if (e.getMessage().contains("code")) {
                JSONObject rsp = JSONObject.parseObject((String)e.getMessage());
                throw new InvokeException("500", (Object)e.getMessage(), rsp.getString("message"));
            }
            throw new InvokeException("500", e.getErrorCode());
        }
    }

    public ThirdAlgorithmRespond getAlgorithmById(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        String urlTemplate = "/v1/modelhub/items/%s/web";
        String url = String.format(urlTemplate, request.getAlgorithmId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject detailObject = rsp.getJSONObject("item_detail");
            if (Objects.nonNull(detailObject)) {
                ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
                respond.setVendorName(detailObject.getString("vendor_name"));
                respond.setAlgorithmId(detailObject.getString("item_id"));
                respond.setAlgorithmName(detailObject.getString("item_name"));
                respond.setCoverUrl(detailObject.getString("app_icon_url"));
                respond.setAlgorithmDesc(detailObject.getString("short_desc"));
                respond.setAlgorithmType(detailObject.getString("item_type"));
                return respond;
            }
            throw new InvokeException("500", "server_rejected");
        }
        catch (SDKException e) {
            LOGGER.error("get algorithm by id error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ThirdAlgorithmRespond getAlgorithmPackageUrl(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        String urlTemplate = "/v1/holosens/iclient/items/%s/sims/file";
        String url = String.format(urlTemplate, request.getAlgorithmId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if ("200".equals(rsp.getString("code"))) {
                ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
                if (rsp.containsKey((Object)"ivs1800_ascend310")) {
                    respond.setPlatformTypeD(rsp.getJSONObject("ivs1800_ascend310").getString("url"));
                }
                if (rsp.containsKey((Object)"ivs1800_hi3559a")) {
                    respond.setPlatformTypeA(rsp.getJSONObject("ivs1800_hi3559a").getString("url"));
                }
                return respond;
            }
            throw new InvokeException("500", rsp.getString("code"));
        }
        catch (SDKException e) {
            LOGGER.error("get algorithm by id error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ThirdAlgorithmRespond getLicensePackageUrl(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
        JSONObject dataObject = new JSONObject();
        dataObject.put("quota_id", (Object)request.getSubscriptionId());
        String[] snArray = StringUtils.split((String)request.getSn(), (String)",");
        JSONArray deviceArray = new JSONArray();
        for (String sn : snArray) {
            JSONObject deviceObject = new JSONObject();
            deviceObject.put("device_id", (Object)sn);
            deviceObject.put("consume_num", (Object)"1");
            deviceArray.add((Object)deviceObject);
        }
        dataObject.put("type", (Object)"3");
        dataObject.put("data", (Object)deviceArray);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.ALGORITHM_ALLOCATE_LICENSE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (rsp == null) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            if ("200".equals(rsp.getString("code"))) {
                HttpUrlParam httpUrlParam = new HttpUrlParam();
                httpUrlParam.addParam("subscription_id", request.getSubscriptionId());
                if (Objects.nonNull(request.getSaleType()) && request.getSaleType() == 4) {
                    httpUrlParam.addParam("usageType", "1");
                } else {
                    httpUrlParam.addParam("usageType", "0");
                }
                httpUrlParam.addParam("equipment_id", request.getSn());
                rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.ALGORITHM_GET_LICENSE, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                if (rsp == null || StringUtils.isBlank((CharSequence)rsp.getString("license_url"))) {
                    throw new InvokeException("500", "cu_device_not_return");
                }
                respond.setSourceUrl(rsp.getString("license_url"));
                return respond;
            }
            throw new InvokeException("500", rsp.getString("message"));
        }
        catch (SDKException e) {
            LOGGER.error("get license package url error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ThirdAlgorithmRespond getAlgorithmPackageInfo(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        String urlTemplate = "/v1/holosens/iclient/items/%s/sims/file";
        String url = String.format(urlTemplate, request.getAlgorithmId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if ("200".equals(rsp.getString("code"))) {
                ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
                if (String.valueOf(DeviceTypeEnum.SDC.val()).equals(request.getDeviceType())) {
                    if (rsp.containsKey((Object)"sdc_bit64")) {
                        respond.setPlatformTypeD(rsp.getJSONObject("sdc_bit64").getString("url"));
                    }
                    if (rsp.containsKey((Object)"sdc_bit32")) {
                        respond.setPlatformTypeA(rsp.getJSONObject("sdc_bit32").getString("url"));
                    }
                } else if (String.valueOf(DeviceTypeEnum.IVS1800).equals(request.getDeviceType())) {
                    if (rsp.containsKey((Object)"ivs1800_ascend310")) {
                        respond.setPlatformTypeD(rsp.getJSONObject("ivs1800_ascend310").getString("url"));
                    }
                    if (rsp.containsKey((Object)"ivs1800_hi3559a")) {
                        respond.setPlatformTypeA(rsp.getJSONObject("ivs1800_hi3559a").getString("url"));
                    }
                }
                return respond;
            }
            throw new InvokeException("500", rsp.getString("code"));
        }
        catch (SDKException e) {
            LOGGER.error("cloud get algorithm by id error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ThirdAlgorithmRespond assignLicense(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
        JSONObject dataObject = new JSONObject();
        dataObject.put("quota_id", (Object)request.getSubscriptionId());
        JSONArray deviceArray = new JSONArray();
        for (String sn : request.getDeviceIds()) {
            JSONObject deviceObject = new JSONObject();
            deviceObject.put("device_id", (Object)sn);
            deviceObject.put("consume_num", (Object)"1");
            deviceArray.add((Object)deviceObject);
        }
        String type = "3";
        if (String.valueOf(DeviceTypeEnum.SDC.val()).equals(request.getDeviceType())) {
            type = "0";
        }
        if ("0".equals(request.getLicenseSourceType())) {
            dataObject.put("quota_allocation_type", (Object)2);
            dataObject.put("share_id", (Object)request.getShareId());
        } else {
            dataObject.put("quota_allocation_type", (Object)1);
        }
        dataObject.put("type", (Object)type);
        dataObject.put("data", (Object)deviceArray);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.ALGORITHM_ALLOCATE_LICENSE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (rsp == null) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            if ("200".equals(rsp.getString("code"))) {
                respond.setConsumeId(rsp.getString("consume_id"));
                return respond;
            }
            throw new InvokeException("500", rsp.getString("message"));
        }
        catch (SDKException e) {
            LOGGER.error("get license package url error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public ThirdAlgorithmRespond getLicense(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        ThirdAlgorithmRespond respond = new ThirdAlgorithmRespond();
        String template = "/v1/modelhub/consumptions/%s/license";
        String url = String.format(template, request.getConsumeId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (StringUtils.isNotBlank((CharSequence)rsp.getString("licensePath"))) {
                respond.setLicenseStatus("1");
                respond.setSourceUrl(rsp.getString("licensePath"));
                return respond;
            }
            throw new InvokeException("500", rsp.getString("message"));
        }
        catch (SDKException e) {
            LOGGER.error("get license package url detail error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    public List<ThirdAlgorithmRespond> getAlgorithmVersions(VcmReqBaseInfo vcmReqBaseInfo, ThirdAlgorithmRequest request) {
        LinkedList respondList = Lists.newLinkedList();
        String template = "/v1/holosens/iclient/items/%s/sims/file?version_type=1";
        String url = String.format(template, request.getAlgorithmId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        try {
            ThirdAlgorithmRespond respond;
            JSONObject algorithm;
            int i;
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (rsp == null) {
                throw new InvokeException("500", "cu_device_not_return");
            }
            if (!"200".equals(rsp.getString("code"))) {
                throw new InvokeException("500", rsp.getString("code"));
            }
            JSONArray algorithmArray = null;
            if (rsp.containsKey((Object)"ivs1800_hi3559a")) {
                for (i = 0; i < rsp.getJSONArray("ivs1800_hi3559a").size(); ++i) {
                    algorithm = rsp.getJSONArray("ivs1800_hi3559a").getJSONObject(i);
                    respond = new ThirdAlgorithmRespond();
                    respond.setVersion(algorithm.getString("version"));
                    respond.setPlatformTypeA(algorithm.getString("url"));
                    respond.setSourceUrl(algorithm.getString("url"));
                    respondList.add(respond);
                }
            }
            if (rsp.containsKey((Object)"ivs1800_ascend310")) {
                for (i = 0; i < rsp.getJSONArray("ivs1800_ascend310").size(); ++i) {
                    algorithm = rsp.getJSONArray("ivs1800_ascend310").getJSONObject(i);
                    respond = new ThirdAlgorithmRespond();
                    respond.setVersion(algorithm.getString("version"));
                    respond.setPlatformTypeD(algorithm.getString("url"));
                    respond.setSourceUrl(algorithm.getString("url"));
                    respondList.add(respond);
                }
            }
            if (rsp.containsKey((Object)"sdc_bit64")) {
                algorithmArray = rsp.getJSONArray("sdc_bit64");
            } else if (rsp.containsKey((Object)"sdc_bit32")) {
                algorithmArray = rsp.getJSONArray("sdc_bit32");
            }
            if (!CollectionUtils.isEmpty((Collection)algorithmArray)) {
                for (i = 0; i < algorithmArray.size(); ++i) {
                    algorithm = algorithmArray.getJSONObject(i);
                    respond = new ThirdAlgorithmRespond();
                    respond.setSourceUrl(algorithm.getString("url"));
                    respond.setVersion(algorithm.getString("version"));
                    respondList.add(respond);
                }
            }
        }
        catch (SDKException e) {
            LOGGER.error("cloud get algorithm version error", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return respondList;
    }
}

