/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPPlayBackRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPRealPlayRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVideoDownloadRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.video.RTSPVoiceRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPPlayBackRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPRealPlayRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVideoDownloadRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.video.RTSPVoiceRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.ipc.sdc.sdk.util.AESUtil;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.RTSPService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.utils.EntCloudUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="RTSPCloudServiceImpl")
public class RTSPCloudServiceImpl
extends AbstractCloudService
implements RTSPService<IServerType.Cloud> {
    private static final Logger log = LoggerFactory.getLogger(RTSPCloudServiceImpl.class);

    public RTSPRealPlayRespond realPlay(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request) {
        RTSPRealPlayRespond rtspRealPlayRespond = new RTSPRealPlayRespond();
        request.setChannelCode(this.splitChannelCode(request.getChannelCode()));
        if (request.getType() == 0 || request.getType() == 1) {
            List main = this.onlyRealPlay(vcmReqBaseInfo, request, "PRIMARY_STREAM", 1);
            rtspRealPlayRespond.getRtspUrls().addAll(main);
        }
        if (request.getType() == 0 || request.getType() == 2) {
            List sub = this.onlyRealPlay(vcmReqBaseInfo, request, "SECONDARY_STREAM_1", 2);
            rtspRealPlayRespond.getRtspUrls().addAll(sub);
        }
        return rtspRealPlayRespond;
    }

    private List<JSONObject> onlyRealPlay(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request, String streamType, int type) {
        int retryCount = 0;
        while (true) {
            try {
                if ("1".equals(request.getClientType())) {
                    request.setLiveProtocol("RTSP");
                    return this.getCloudStandardUrlInfo(vcmReqBaseInfo, request, streamType, type);
                }
                return this.sendEntRealPlay(vcmReqBaseInfo, request, streamType, type);
            }
            catch (SDKException sdkException) {
                log.error("onlyRealPlay error", (Throwable)sdkException);
                if (++retryCount <= 2) continue;
                throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
            }
            break;
        }
    }

    @Deprecated
    private List<JSONObject> sendRealPlay(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request, int streamType, int type) throws SDKException {
        JSONArray channels;
        JSONObject paramsJson = new JSONObject();
        JSONArray channelsArr = new JSONArray();
        JSONObject channel = new JSONObject();
        channel.put("device_id", (Object)request.getCameraId());
        channel.put("channel_id", (Object)request.getChannelCode());
        channel.put("stream_type", (Object)streamType);
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        channelsArr.add((Object)channel);
        paramsJson.put("channels", (Object)channelsArr);
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.CLOUD_USER_GET_LIVE_ADDRESS, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkJsonRespond(requestResult);
        if (Objects.nonNull(requestResult.getJSONObject("data")) && (channels = requestResult.getJSONObject("data").getJSONArray("channels")) != null && channels.size() > 0) {
            for (int i = 0; i < channels.size(); ++i) {
                JSONObject rtspUrl = new JSONObject();
                String url = channels.getJSONObject(i).getString("jvmp_url");
                if (request.getIsRealPlay().booleanValue()) {
                    rtspUrl.put("rtspUrl", (Object)requestResult.toJSONString());
                } else {
                    rtspUrl.put("rtspUrl", (Object)url);
                }
                rtspUrl.put("type", (Object)type);
                rtspUrls.add(rtspUrl);
            }
        }
        return rtspUrls;
    }

    private JSONObject getP2PConnectInfo(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request, String streamType, int type) throws SDKException {
        JSONObject paramsJson = new JSONObject();
        JSONArray channelsArr = new JSONArray();
        JSONObject channel = new JSONObject();
        channel.put("device_id", (Object)request.getCameraId());
        channel.put("channel_id", (Object)request.getChannelCode());
        channel.put("stream_type", (Object)streamType);
        channelsArr.add((Object)channel);
        paramsJson.put("channels", (Object)channelsArr);
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            paramsJson.put("enterprise_id", (Object)vcmReqBaseInfo.getEnterpriseId());
        }
        String url = String.format(CloudMsgType.ENT_CLOUD_LIVE_P2P_CONNECT.getUri(), vcmReqBaseInfo.getUserId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url);
        JSONObject requestObject = null;
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        if (requestResult.containsKey((Object)"channels") && requestResult.containsKey((Object)"devices")) {
            JSONArray channels = requestResult.getJSONArray("channels");
            for (int i = 0; i < channels.size(); ++i) {
                requestObject = new JSONObject();
                requestObject.put("data", (Object)requestResult);
                requestObject.put("msg", (Object)"OK");
                requestObject.put("code", (Object)1000);
            }
        }
        return requestObject;
    }

    public RTSPPlayBackRespond playBack(VcmReqBaseInfo vcmReqBaseInfo, RTSPPlayBackRequest request) {
        RTSPPlayBackRespond rtspPlayBackRespond = new RTSPPlayBackRespond();
        String url = null;
        if ("1".equals(request.getClientType())) {
            if ("101".equals(request.getVideoType())) {
                url = String.format(CloudMsgType.ENT_CLOUD_RECORDING_PLAYBACK.getUri(), vcmReqBaseInfo.getUserId(), request.getCameraId(), request.getChannelCode().split("\\$")[1], "NORMAL_RECORD", request.getEndDate().replaceAll(" ", "%20"), request.getStartDate().replaceAll(" ", "%20"), vcmReqBaseInfo.getEnterpriseId(), "RTSP");
            } else if ("0".equals(request.getVideoType())) {
                url = StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId()) ? String.format(CloudMsgType.ENT_DEVICE_CLOUD_RTSP_PLAY_BACK.getUri(), vcmReqBaseInfo.getUserId(), request.getCameraId(), request.getChannelCode().split("\\$")[1], request.getStartDate().replaceAll(" ", "%20"), request.getEndDate().replaceAll(" ", "%20"), "RTSP_DEV", vcmReqBaseInfo.getEnterpriseId()) : String.format(CloudMsgType.PPL_DEVICE_CLOUD_RTSP_PLAY_BACK.getUri(), vcmReqBaseInfo.getUserId(), request.getCameraId(), request.getChannelCode().split("\\$")[1], request.getStartDate().replaceAll(" ", "%20"), request.getEndDate().replaceAll(" ", "%20"), "RTSP_DEV");
            }
        } else {
            url = String.format(CloudMsgType.ENT_CLOUD_RECORDING_PLAYBACK.getUri(), vcmReqBaseInfo.getUserId(), request.getCameraId(), request.getChannelCode().split("\\$")[1], "NORMAL_RECORD", request.getEndDate().replaceAll(" ", "%20"), request.getStartDate().replaceAll(" ", "%20"), vcmReqBaseInfo.getEnterpriseId(), "HOLO");
        }
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.nonNull(requestResult) && requestResult.containsKey((Object)"playback_url")) {
                ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
                JSONObject channel = new JSONObject();
                channel.put("type", (Object)request.getType());
                channel.put("rtspUrl", (Object)requestResult.getString("playback_url"));
                rtspUrls.add(channel);
                rtspPlayBackRespond.setRtspUrls(rtspUrls);
            }
        }
        catch (SDKException e) {
            log.error("Cloud playBack fail");
            throw new InvokeException("500", (Object)e.getMessage(), EntCloudUtils.reasonHelper((SDKException)e));
        }
        return rtspPlayBackRespond;
    }

    private RTSPRealPlayRequest buildRtspRealPlayReq(RTSPPlayBackRequest request) {
        RTSPRealPlayRequest rtspRealPlayRequest = new RTSPRealPlayRequest();
        rtspRealPlayRequest.setCameraId(request.getCameraId());
        rtspRealPlayRequest.setChannelCode(request.getChannelCode());
        rtspRealPlayRequest.setConnectType(request.getConnectType());
        rtspRealPlayRequest.setType(request.getType());
        rtspRealPlayRequest.setEnterpriseId(request.getEnterpriseId());
        rtspRealPlayRequest.setIsRealPlay(Boolean.valueOf(false));
        return rtspRealPlayRequest;
    }

    public RTSPVoiceRespond voice(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVoiceRespond broadcast(VcmReqBaseInfo vcmInfo, RTSPVoiceRequest request) {
        return null;
    }

    public RTSPVideoDownloadRespond videoDownload(VcmReqBaseInfo vcmInfo, RTSPVideoDownloadRequest request) {
        return null;
    }

    public JSONObject getP2PConnectInfo(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request) {
        JSONObject jsonObject = new JSONObject();
        request.setChannelCode(this.splitChannelCode(request.getChannelCode()));
        try {
            if (request.getType() == 0 || request.getType() == 1) {
                jsonObject = this.getP2PConnectInfo(vcmReqBaseInfo, request, "PRIMARY_STREAM", 1);
            }
            if (request.getType() == 0 || request.getType() == 2) {
                jsonObject = this.getP2PConnectInfo(vcmReqBaseInfo, request, "SECONDARY_STREAM_1", 2);
            }
        }
        catch (SDKException sdkException) {
            log.error("getP2PConnectInfo error", (Throwable)sdkException);
            throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
        }
        return jsonObject;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            String[] channelCodeArray = channelCode.split("\\$");
            if (channelCodeArray.length >= 2) {
                return channelCodeArray[1];
            }
            return channelCode;
        }
        return "";
    }

    private List<JSONObject> sendEntRealPlay(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request, String streamType, int type) throws SDKException {
        JSONObject paramsJson = new JSONObject();
        JSONArray channelsArr = new JSONArray();
        JSONObject channel = new JSONObject();
        channel.put("device_id", (Object)request.getCameraId());
        channel.put("channel_id", (Object)request.getChannelCode());
        channel.put("stream_type", (Object)streamType);
        channelsArr.add((Object)channel);
        paramsJson.put("channels", (Object)channelsArr);
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            paramsJson.put("enterprise_id", (Object)vcmReqBaseInfo.getEnterpriseId());
        }
        String url = String.format(CloudMsgType.ENT_CLOUD_LIVE_P2P_CONNECT.getUri(), vcmReqBaseInfo.getUserId());
        CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url);
        ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        if (requestResult.containsKey((Object)"channels") && requestResult.containsKey((Object)"devices")) {
            JSONArray channels = requestResult.getJSONArray("channels");
            for (int i = 0; i < channels.size(); ++i) {
                JSONObject rtspUrl = new JSONObject();
                String jvmpUrl = channels.getJSONObject(i).getString("jvmp_url");
                if (request.getIsRealPlay().booleanValue()) {
                    JSONObject requestObject = new JSONObject();
                    requestObject.put("data", (Object)requestResult);
                    requestObject.put("msg", (Object)"OK");
                    requestObject.put("code", (Object)1000);
                    rtspUrl.put("rtspUrl", (Object)requestObject.toJSONString());
                } else {
                    rtspUrl.put("rtspUrl", (Object)jvmpUrl);
                }
                rtspUrl.put("type", (Object)type);
                rtspUrls.add(rtspUrl);
            }
        }
        return rtspUrls;
    }

    private List<JSONObject> getCloudStandardUrlInfo(VcmReqBaseInfo vcmReqBaseInfo, RTSPRealPlayRequest request, String streamType, int type) {
        try {
            String url;
            CloudMsgType uri;
            JSONObject requestResult;
            JSONObject paramsJson = new JSONObject();
            JSONArray channelsArr = new JSONArray();
            JSONObject channel = new JSONObject();
            channel.put("device_id", (Object)request.getCameraId());
            channel.put("channel_id", (Object)request.getChannelCode());
            channel.put("live_protocol", (Object)request.getLiveProtocol());
            channel.put("stream_type", (Object)streamType);
            channelsArr.add((Object)channel);
            paramsJson.put("channels", (Object)channelsArr);
            if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
                paramsJson.put("enterprise_id", (Object)vcmReqBaseInfo.getEnterpriseId());
            }
            if ((requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)(uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url = String.format(CloudMsgType.ENT_CLOUD_LIVE_CHANNELS.getUri(), vcmReqBaseInfo.getUserId()))), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo))).containsKey((Object)"channels") && !CollectionUtils.isEmpty((Collection)requestResult.getJSONArray("channels"))) {
                JSONArray channels = requestResult.getJSONArray("channels");
                ArrayList<JSONObject> rtspUrls = new ArrayList<JSONObject>();
                int i = 0;
                if (i < channels.size()) {
                    JSONObject rtspUrl = new JSONObject();
                    JSONObject result = channels.getJSONObject(i).getJSONObject("result");
                    if ("Success".equals(result.getString("msg"))) {
                        String liveUrl = channels.getJSONObject(i).getString("live_url");
                        rtspUrl.put("rtspUrl", (Object)liveUrl);
                        rtspUrl.put("type", (Object)type);
                        rtspUrls.add(rtspUrl);
                        return rtspUrls;
                    }
                    throw new InvokeException("500", (String)result.get((Object)"code"));
                }
            }
        }
        catch (SDKException e) {
            log.error("getCloudStandardUrlInfo fail", (Throwable)e);
            throw new InvokeException("500", (Object)e.getMessage(), EntCloudUtils.reasonHelper((SDKException)e));
        }
        return null;
    }

    public Boolean rtspAuthSet(VcmReqBaseInfo vcmInfo, RTSPRealPlayRequest request) {
        try {
            String url = String.format(CloudMsgType.ENT_CLOUD_RTSP_AUTH.getUri(), vcmInfo.getUserId());
            CloudMsgType uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url);
            JSONObject paramsJson = new JSONObject();
            VcmReqBaseInfo.Header header = new VcmReqBaseInfo.Header();
            header.setKey("Enterprise-id");
            header.setValue(vcmInfo.getEnterpriseId());
            vcmInfo.getHeaders().add(header);
            paramsJson.put("media_name", (Object)request.getMediaName());
            String deString = AESUtil.Decrypt((String)request.getMediaPassword(), (String)"iClientS100Cloud");
            paramsJson.put("media_password", (Object)deString);
            paramsJson.put("auth_type", (Object)"MD5");
            HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)uri, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
            return true;
        }
        catch (SDKException sdkException) {
            log.error("rtspAuthSet error", (Throwable)sdkException);
            throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
        }
        catch (Exception e) {
            log.error("media password error", (Object)e.getMessage());
            return false;
        }
    }
}

