/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.bean.PTZCmdEnum;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.GuardPointSetRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.ptz.PTZControlRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.GuardPointRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.ptz.PTZControlRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.service.v2.PTZV2Service;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ptzCloudService")
public class PTZCloudServiceImpl
extends AbstractCloudService
implements PTZV2Service<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PTZCloudServiceImpl.class);

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E el, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(el);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public PTZControlRespond control(VcmReqBaseInfo vcmInfo, PTZControlRequest request) {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        try {
            String token = this.getEntControlToken(vcmInfo, request);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                ptzControlRespond = this.sendEntControl(vcmInfo, request, token);
            } else {
                ptzControlRespond.setResult("get token fail");
            }
        }
        catch (SDKException sdkException) {
            LOGGER.error("cloud control error", (Throwable)sdkException);
        }
        return null;
    }

    private String getControlToken(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) throws SDKException {
        String token = "";
        JSONObject channel = new JSONObject();
        channel.put("device_id", (Object)request.getChannelCode().split("\\$")[0]);
        channel.put("channel_id", (Object)request.getChannelCode().split("\\$")[1]);
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.CLOUD_USER_GET_CONTROL_LOCK, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)channel, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkJsonRespond(requestResult);
        if (Objects.nonNull(requestResult.getJSONObject("data"))) {
            JSONObject jsonObject = requestResult.getJSONObject("data");
            token = jsonObject.getString("control_token");
        }
        return token;
    }

    private boolean releaseControlToken(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) throws SDKException {
        JSONObject channel = new JSONObject();
        channel.put("device_id", (Object)request.getChannelCode().split("\\$")[0]);
        channel.put("channel_id", (Object)request.getChannelCode().split("\\$")[1]);
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.CLOUD_USER_RELEASE_CONTROL_LOCK, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)channel, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkJsonRespond(requestResult);
        if (Objects.nonNull(requestResult.getJSONObject("data"))) {
            JSONObject jSONObject = requestResult.getJSONObject("data");
        }
        return true;
    }

    private PTZControlRespond sendControl(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request, String token) throws SDKException {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        String deviceId = request.getChannelCode().split("\\$")[0];
        String channelId = request.getChannelCode().split("\\$")[1];
        JSONObject channel = new JSONObject();
        JSONObject param = new JSONObject();
        boolean flag = false;
        String cloudUrl = String.format(CloudMsgType.CLOUD_USER_SEND_CMD.getUri(), deviceId, channelId, token);
        if (PTZCmdEnum.PTZ_UP.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)0);
            param.put("tilt_up", (Object)120);
            param.put("zoom_in", (Object)0);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_DOWN.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)0);
            param.put("tilt_up", (Object)-120);
            param.put("zoom_in", (Object)0);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_LEFT.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)120);
            param.put("tilt_up", (Object)0);
            param.put("zoom_in", (Object)0);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_RIGHT.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)-120);
            param.put("tilt_up", (Object)0);
            param.put("zoom_in", (Object)0);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_LENS_ZOOM_OUT.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)0);
            param.put("tilt_up", (Object)0);
            param.put("zoom_in", (Object)-120);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_LENS_ZOOM_IN.equals((Object)request.getPtzCmdEnum())) {
            param.put("pan_left", (Object)0);
            param.put("tilt_up", (Object)0);
            param.put("zoom_in", (Object)120);
            channel.put("method", (Object)"ptz_move_start");
        } else if (PTZCmdEnum.PTZ_STOP.equals((Object)request.getPtzCmdEnum())) {
            flag = true;
            channel.put("method", (Object)"ptz_move_stop");
        } else if (PTZCmdEnum.PTZ_LENS_FOCAL_NEAR.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)-120);
            param.put("iris_open", (Object)0);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_FOCAL_FAR.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)120);
            param.put("iris_open", (Object)0);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_APERTURE_CLOSE.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)0);
            param.put("iris_open", (Object)-120);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_APERTURE_OPEN.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)0);
            param.put("iris_open", (Object)120);
            channel.put("method", (Object)"ptz_fi_start");
        } else {
            flag = true;
            channel.put("method", (Object)"ptz_fi_stop");
        }
        param.put("channel_id", (Object)Integer.parseInt(channelId));
        channel.put("param", (Object)param);
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, cloudUrl), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)channel, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        this.checkJsonRespond(requestResult);
        if (Objects.nonNull(requestResult.getJSONObject("data"))) {
            ptzControlRespond.setResult("success");
            if (flag) {
                this.rleEntControlToken(vcmReqBaseInfo, request);
            }
        } else {
            ptzControlRespond.setResult("fail");
        }
        return ptzControlRespond;
    }

    public boolean setGuardPoint(ParamBean<GuardPointSetRequest> obj) {
        return false;
    }

    public GuardPointRespond getGuardPoint(ParamBean<ChannelRequest> obj) {
        return null;
    }

    private String splitChannelCode(String channelCode) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            String[] channelCodeArray = channelCode.split("\\$");
            if (channelCodeArray.length >= 2) {
                return channelCodeArray[1];
            }
            return channelCode;
        }
        return "";
    }

    private String getEntControlToken(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) {
        CloudMsgType uri;
        String url;
        String token = "";
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            url = String.format(CloudMsgType.ENT_CLOUD_USER_GET_CONTROL_LOCK.getUri(), vcmReqBaseInfo.getUserId(), request.getChannelCode().split("\\$")[0], request.getChannelCode().split("\\$")[1], vcmReqBaseInfo.getEnterpriseId());
            uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        } else {
            url = String.format(CloudMsgType.PPL_CLOUD_USER_GET_CONTROL_LOCK.getUri(), vcmReqBaseInfo.getUserId(), request.getChannelCode().split("\\$")[0], request.getChannelCode().split("\\$")[1]);
            uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url);
        }
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.nonNull(requestResult) && requestResult.containsKey((Object)"control_token")) {
                token = requestResult.getString("control_token");
            }
        }
        catch (SDKException sdkException) {
            LOGGER.error("cloud getEntControlToken error", (Throwable)sdkException);
        }
        return token;
    }

    private boolean rleEntControlToken(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request) {
        CloudMsgType uri;
        String url;
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            url = String.format(CloudMsgType.ENT_CLOUD_USER_GET_CONTROL_LOCK.getUri(), vcmReqBaseInfo.getUserId(), request.getChannelCode().split("\\$")[0], request.getChannelCode().split("\\$")[1], vcmReqBaseInfo.getEnterpriseId());
            uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url);
        } else {
            url = String.format(CloudMsgType.PPL_CLOUD_USER_GET_CONTROL_LOCK.getUri(), vcmReqBaseInfo.getUserId(), request.getChannelCode().split("\\$")[0], request.getChannelCode().split("\\$")[1]);
            uri = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, url);
        }
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (Objects.nonNull(requestResult) && requestResult.containsKey((Object)"device_id") && requestResult.containsKey((Object)"channel_id")) {
                return true;
            }
        }
        catch (SDKException sdkException) {
            LOGGER.error("cloud rleEntControlToken error", (Throwable)sdkException);
        }
        return false;
    }

    private PTZControlRespond sendEntControl(VcmReqBaseInfo vcmReqBaseInfo, PTZControlRequest request, String token) throws SDKException {
        PTZControlRespond ptzControlRespond = new PTZControlRespond();
        String deviceId = request.getChannelCode().split("\\$")[0];
        String channelId = request.getChannelCode().split("\\$")[1];
        String userId = vcmReqBaseInfo.getUserId();
        JSONObject channel = new JSONObject();
        JSONObject param = new JSONObject();
        boolean flag = false;
        String cloudUrl = String.format(CloudMsgType.ENT_CLOUD_USER_SEND_CMD.getUri(), userId, deviceId, channelId);
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            channel.put("enterprise_id", (Object)vcmReqBaseInfo.getEnterpriseId());
        }
        if (PTZCmdEnum.PTZ_UP.equals((Object)request.getPtzCmdEnum())) {
            param.put("up_down_turn", (Object)"UP_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_DOWN.equals((Object)request.getPtzCmdEnum())) {
            param.put("up_down_turn", (Object)"DOWN_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_LEFT.equals((Object)request.getPtzCmdEnum())) {
            param.put("left_right_turn", (Object)"LEFT_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_RIGHT.equals((Object)request.getPtzCmdEnum())) {
            param.put("left_right_turn", (Object)"RIGHT_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_LENS_ZOOM_OUT.equals((Object)request.getPtzCmdEnum())) {
            param.put("zoom_in_out", (Object)"OUT_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_LENS_ZOOM_IN.equals((Object)request.getPtzCmdEnum())) {
            param.put("zoom_in_out", (Object)"IN_SPEED_NORMAL");
            channel.put("method", (Object)"PTZ_MOVE_START");
        } else if (PTZCmdEnum.PTZ_STOP.equals((Object)request.getPtzCmdEnum())) {
            flag = true;
            channel.put("method", (Object)"PTZ_MOVE_STOP");
        } else if (PTZCmdEnum.PTZ_LENS_FOCAL_NEAR.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)-120);
            param.put("iris_open", (Object)0);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_FOCAL_FAR.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)120);
            param.put("iris_open", (Object)0);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_APERTURE_CLOSE.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)0);
            param.put("iris_open", (Object)-120);
            channel.put("method", (Object)"ptz_fi_start");
        } else if (PTZCmdEnum.PTZ_LENS_APERTURE_OPEN.equals((Object)request.getPtzCmdEnum())) {
            param.put("focus_far", (Object)0);
            param.put("iris_open", (Object)120);
            channel.put("method", (Object)"ptz_fi_start");
        } else {
            flag = true;
            channel.put("method", (Object)"ptz_fi_stop");
        }
        channel.put("control_lock", (Object)token);
        channel.put("params", (Object)param);
        JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new CloudMsgType(HttpMethodEnum.HTTP_METHOD_POST, cloudUrl), (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)channel, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        if (Objects.nonNull(requestResult) && requestResult.containsKey((Object)"device_id") && requestResult.containsKey((Object)"channel_id")) {
            ptzControlRespond.setResult("success");
            if (flag) {
                this.rleEntControlToken(vcmReqBaseInfo, request);
            }
        } else {
            ptzControlRespond.setResult("fail");
        }
        return ptzControlRespond;
    }
}

