/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraAddRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRebootRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.CameraRemoveRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.ChannelUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.user.PasswordUpdateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.ChannelInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.DeviceInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.EntChannelInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cloud.EntDeviceInfoRespondCloud;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraAddRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CameraRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ChannelRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.CloudDeviceRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.device.ParentCameraRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.ChannelStatusEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.DeviceManageService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="deviceManageCloudService")
public class DeviceManageCloudServiceImpl
implements DeviceManageService<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManageCloudServiceImpl.class);

    public List<CameraRespond> listCamera(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public List<ChannelRespond> listChannel(VcmReqBaseInfo vcmReqBaseInfo) {
        return null;
    }

    public ChannelRespond getChannel(ParamBean<ChannelRequest> obj) {
        return null;
    }

    public List<String> getEmptyChannel(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public boolean updateChannel(ParamBean<ChannelUpdateRequest> obj) {
        return false;
    }

    public List<ChannelRespond> listChannelsByCamera(VcmReqBaseInfo vcmReqBaseInfo, String cameraCode) {
        return null;
    }

    public CameraAddRespond addCamera(ParamBean<CameraAddRequest> obj) {
        CameraAddRequest requestBody = (CameraAddRequest)obj.getRequestBody();
        CameraAddRespond cameraAddRespond = new CameraAddRespond();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("enterprise_id", (Object)requestBody.getEnterpriseId());
        paramsJson.put("device_id", (Object)requestBody.getDeviceId());
        paramsJson.put("device_org_id", (Object)requestBody.getDeviceOrgId());
        paramsJson.put("description", (Object)requestBody.getDescription());
        paramsJson.put("device_username", (Object)requestBody.getDeviceUser());
        if (0 == requestBody.getType()) {
            paramsJson.put("device_type", (Object)"IPC");
        } else if (4 == requestBody.getType()) {
            paramsJson.put("device_type", (Object)"NVR");
        }
        paramsJson.put("device_password", (Object)requestBody.getDevicePassword());
        paramsJson.put("device_name", (Object)requestBody.getName());
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.ADD_GB28181_DEVICE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, true), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("add camera to cloud is end.");
            if (Objects.nonNull(requestResult)) {
                JSONObject data = requestResult.getJSONObject("data");
                cameraAddRespond.setServerDomain(data.getString("server_domain"));
                cameraAddRespond.setAccessGw(data.getString("access_gw"));
                cameraAddRespond.setAccessPort(data.getString("access_port"));
                cameraAddRespond.setServerId(data.getString("server_id"));
                cameraAddRespond.setDeviceId(data.getString("device_id"));
                LOGGER.debug("add camera is end..");
            }
        }
        catch (SDKException e) {
            LOGGER.error("add camera fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return cameraAddRespond;
    }

    public boolean removeCamera(ParamBean<CameraRemoveRequest> obj) {
        CameraRemoveRequest requestBody = (CameraRemoveRequest)obj.getRequestBody();
        JSONObject paramsJson = new JSONObject();
        paramsJson.put("enterprise_id", (Object)requestBody.getEnterpriseId());
        paramsJson.put("device_id", (Object)requestBody.getDeviceId());
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)obj.getVcmInfo(), (MsgType)CloudMsgType.DELETE_DEVICE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)paramsJson, true), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(obj.getVcmInfo()));
            LOGGER.debug("remove camera from cloud is end.");
            if (Objects.nonNull(requestResult) && "OK".equals(requestResult.getString("msg"))) {
                LOGGER.debug("remove camera is end.");
                return true;
            }
        }
        catch (SDKException e) {
            LOGGER.error("remove camera fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        return false;
    }

    public boolean updatePassword(ParamBean<PasswordUpdateRequest> obj) {
        return false;
    }

    public boolean rebootCamera(ParamBean<CameraRebootRequest> obj) {
        return false;
    }

    public CloudDeviceRespond getCloudDevice(VcmReqBaseInfo vcmReqBaseInfo) {
        CloudDeviceRespond cloudDeviceRespond = new CloudDeviceRespond();
        ArrayList<ParentCameraRespond> parentCameraResponds = new ArrayList<ParentCameraRespond>();
        try {
            ArrayList<DeviceInfoRespondCloud> ipcDeviceInfo;
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.CLOUD_USER_GET_ALL_DEVICES, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            LOGGER.debug("get device from cloud is end.");
            if (Objects.nonNull(requestResult.getJSONObject("data")) && "OK".equals(requestResult.getString("msg"))) {
                JSONArray deviceList = requestResult.getJSONObject("data").getJSONArray("device_list");
                List deviceInfoRespondCloudList = JSON.parseArray((String)deviceList.toJSONString(), DeviceInfoRespondCloud.class);
                ipcDeviceInfo = new ArrayList<DeviceInfoRespondCloud>();
                for (DeviceInfoRespondCloud deviceInfoRespondCloud : deviceInfoRespondCloudList) {
                    ParentCameraRespond parentCameraRespond = new ParentCameraRespond();
                    Integer deviceStatus = deviceInfoRespondCloud.getDeviceStatus();
                    if (0 == deviceStatus) {
                        parentCameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
                    } else if (1 == deviceStatus) {
                        parentCameraRespond.setStatus(ChannelStatusEnum.ONLINE);
                    } else if (2 == deviceStatus) continue;
                    if (deviceInfoRespondCloud.getDeviceType().contains("IPC")) {
                        ipcDeviceInfo.add(deviceInfoRespondCloud);
                        continue;
                    }
                    parentCameraRespond.setDomainCode(deviceInfoRespondCloud.getDeviceId());
                    parentCameraRespond.setIsFrom("1");
                    parentCameraRespond.setName(deviceInfoRespondCloud.getDeviceName());
                    parentCameraRespond.setType("4");
                    parentCameraRespond.setIsFromType("1");
                    List channelResponds = this.buildChannelRespond(deviceInfoRespondCloud.getSingleChannelInfos(), false, Integer.valueOf(0));
                    parentCameraRespond.setCameraResponds(this.buildCameraRespond(channelResponds, deviceInfoRespondCloud));
                    parentCameraResponds.add(parentCameraRespond);
                }
            } else {
                LOGGER.error("get device fail:{}", (Object)requestResult.getString("msg"));
                throw new InvokeException("500", requestResult.getString("msg"));
            }
            parentCameraResponds.add(this.buildIpcParentCameraRespond(ipcDeviceInfo));
            LOGGER.debug("get device is end..");
        }
        catch (SDKException e) {
            LOGGER.error("get device fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
        cloudDeviceRespond.setParentCameraResponds(parentCameraResponds);
        return cloudDeviceRespond;
    }

    private List<ChannelRespond> buildChannelRespond(List<ChannelInfoRespondCloud> singleChannelInfos, boolean isIpc, Integer ipcNum) {
        ArrayList<ChannelRespond> channelResponds = new ArrayList<ChannelRespond>();
        if (singleChannelInfos.size() > 0) {
            for (int i = 0; i < singleChannelInfos.size(); ++i) {
                ChannelInfoRespondCloud channelInfoRespondCloud = singleChannelInfos.get(i);
                ChannelRespond channelRespond = new ChannelRespond();
                if (0 == channelInfoRespondCloud.getChannelStatue()) {
                    channelRespond.setStatus(ChannelStatusEnum.OFFLINE);
                } else {
                    if (1 != channelInfoRespondCloud.getChannelStatue()) continue;
                    channelRespond.setStatus(ChannelStatusEnum.ONLINE);
                }
                channelRespond.setCategory(DeviceTypeEnum.CLOUD.val());
                if (isIpc) {
                    channelRespond.setChannel(ipcNum.intValue());
                } else {
                    channelRespond.setChannel(Integer.parseInt(channelInfoRespondCloud.getChannelId()) + 1);
                }
                channelRespond.setChannelCode(channelInfoRespondCloud.getDeviceId() + "$" + channelInfoRespondCloud.getChannelId());
                String list = "123678";
                int modelType = DeviceUtil.getModelType((String)channelInfoRespondCloud.getModel());
                if (list.contains(String.valueOf(modelType))) {
                    if (modelType == 2) {
                        channelRespond.setType(4);
                        channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)4));
                    } else {
                        channelRespond.setType(modelType);
                        channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)modelType));
                    }
                } else {
                    channelRespond.setType(0);
                    channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)0));
                }
                channelRespond.setVendor("HUAWEI");
                channelRespond.setCameraName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{channelInfoRespondCloud.getChannelName()}) ? channelInfoRespondCloud.getChannelName() : "CH" + channelInfoRespondCloud.getChannelId());
                channelRespond.setChannelId(channelInfoRespondCloud.getChannelId());
                channelRespond.setParentCode(channelInfoRespondCloud.getDeviceId());
                channelRespond.setProtocolType("HWSDK");
                channelRespond.setFormType(1);
                channelResponds.add(channelRespond);
            }
        }
        return channelResponds;
    }

    private ParentCameraRespond buildIpcParentCameraRespond(List<DeviceInfoRespondCloud> ipcDeviceInfo) {
        ParentCameraRespond parentCameraRespond = new ParentCameraRespond();
        parentCameraRespond.setCode("2");
        parentCameraRespond.setStatus(ChannelStatusEnum.ONLINE);
        ArrayList<CameraRespond> cameraResponds = new ArrayList<CameraRespond>();
        Integer ipcDeviceNum = 1;
        for (DeviceInfoRespondCloud deviceInfoRespondCloud : ipcDeviceInfo) {
            CameraRespond cameraRespond = new CameraRespond();
            Integer deviceStatus = deviceInfoRespondCloud.getDeviceStatus();
            if (0 == deviceStatus) {
                cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
            } else if (1 == deviceStatus) {
                cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else if (2 == deviceStatus) continue;
            cameraRespond.setCameraCode(deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setCameraName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deviceInfoRespondCloud.getDeviceName()}) ? deviceInfoRespondCloud.getDeviceName() : "CH" + deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setDomainCode(deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setConnectCode("");
            cameraRespond.setIpType(0);
            cameraRespond.setPort(0);
            cameraRespond.setModel("");
            cameraRespond.setSerialNumber("");
            cameraRespond.setFormType(1);
            cameraRespond.setLoginType(0);
            cameraRespond.setEnableSchedule(0);
            cameraRespond.setVendor("HUAWEI");
            cameraRespond.setImgType(3);
            cameraRespond.setProtocolType("HWSDK");
            List channelResponds = this.buildChannelRespond(deviceInfoRespondCloud.getSingleChannelInfos(), true, ipcDeviceNum);
            cameraRespond.setChannelResponds(channelResponds);
            cameraResponds.add(cameraRespond);
            Integer n = ipcDeviceNum;
            Integer n2 = ipcDeviceNum = Integer.valueOf(ipcDeviceNum + 1);
        }
        parentCameraRespond.setCameraResponds(cameraResponds);
        return parentCameraRespond;
    }

    List<CameraRespond> buildCameraRespond(List<ChannelRespond> channelResponds, DeviceInfoRespondCloud deviceInfoRespondCloud) {
        ArrayList<CameraRespond> cameraResponds = new ArrayList<CameraRespond>();
        for (ChannelRespond channelRespond : channelResponds) {
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(channelRespond.getChannelCode());
            cameraRespond.setCameraName(channelRespond.getCameraName());
            cameraRespond.setIpType(0);
            cameraRespond.setPort(0);
            cameraRespond.setModel("");
            cameraRespond.setFormType(1);
            cameraRespond.setLoginType(0);
            cameraRespond.setCameraType(channelRespond.getCameraType());
            cameraRespond.setEnableSchedule(0);
            cameraRespond.setVendor("HUAWEI");
            cameraRespond.setImgType(3);
            cameraRespond.setStatus(channelRespond.getStatus());
            cameraRespond.setProtocolType("HWSDK");
            channelRespond.setConnectType("HWSDK");
            cameraRespond.setChannelResponds(Collections.singletonList(channelRespond));
            cameraResponds.add(cameraRespond);
        }
        return cameraResponds;
    }

    public CloudDeviceRespond getCloudDeviceEnterprise(VcmReqBaseInfo vcmReqBaseInfo) {
        JSONArray channelArray4;
        CloudMsgType uri4;
        String url4;
        JSONArray channelArray3;
        CloudMsgType uri3;
        Object url3;
        JSONArray deviceArray2;
        CloudMsgType uri2;
        String url2;
        JSONArray deviceArray1;
        CloudMsgType uri1;
        String url1;
        long a = System.currentTimeMillis();
        LOGGER.info("====time1" + a);
        if (StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getEnterpriseId())) {
            url1 = String.format(CloudMsgType.ENT_CLOUD_USER_DEVICE_GET.getUri(), vcmReqBaseInfo.getUserId(), vcmReqBaseInfo.getEnterpriseId(), 1000, 0);
            uri1 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url1);
            deviceArray1 = this.cloudReturnData(vcmReqBaseInfo, uri1);
            url2 = String.format(CloudMsgType.ENT_CLOUD_USER_DEVICE_GET.getUri(), vcmReqBaseInfo.getUserId(), vcmReqBaseInfo.getEnterpriseId(), 1000, 1);
            uri2 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url2);
            deviceArray2 = this.cloudReturnData(vcmReqBaseInfo, uri2);
            deviceArray1.addAll((Collection)deviceArray2);
            url3 = String.format(CloudMsgType.ENT_CLOUD_USER_CHANNEL_GET.getUri(), vcmReqBaseInfo.getUserId(), vcmReqBaseInfo.getEnterpriseId(), 1000, 0);
            uri3 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, (String)url3);
            channelArray3 = this.cloudReturnData(vcmReqBaseInfo, uri3);
            url4 = String.format(CloudMsgType.ENT_CLOUD_USER_CHANNEL_GET.getUri(), vcmReqBaseInfo.getUserId(), vcmReqBaseInfo.getEnterpriseId(), 24, 1000);
            uri4 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url4);
            channelArray4 = this.cloudReturnData(vcmReqBaseInfo, uri4);
            channelArray3.addAll((Collection)channelArray4);
        } else {
            url1 = String.format(CloudMsgType.PPL_CLOUD_USER_DEVICE_GET.getUri(), vcmReqBaseInfo.getUserId(), 1000, 0);
            uri1 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url1);
            deviceArray1 = this.cloudReturnData(vcmReqBaseInfo, uri1);
            url2 = String.format(CloudMsgType.PPL_CLOUD_USER_DEVICE_GET.getUri(), vcmReqBaseInfo.getUserId(), 1000, 1);
            uri2 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url2);
            deviceArray2 = this.cloudReturnData(vcmReqBaseInfo, uri2);
            deviceArray1.addAll((Collection)deviceArray2);
            url3 = String.format(CloudMsgType.PPL_CLOUD_USER_CHANNEL_GET.getUri(), vcmReqBaseInfo.getUserId(), 1000, 0);
            uri3 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, (String)url3);
            channelArray3 = this.cloudReturnData(vcmReqBaseInfo, uri3);
            url4 = String.format(CloudMsgType.PPL_CLOUD_USER_CHANNEL_GET.getUri(), vcmReqBaseInfo.getUserId(), 24, 1000);
            uri4 = new CloudMsgType(HttpMethodEnum.HTTP_METHOD_GET, url4);
            channelArray4 = this.cloudReturnData(vcmReqBaseInfo, uri4);
            channelArray3.addAll((Collection)channelArray4);
        }
        CloudDeviceRespond cloudDeviceRespond = new CloudDeviceRespond();
        ArrayList<ParentCameraRespond> parentCameraResponds = new ArrayList<ParentCameraRespond>();
        ArrayList<EntDeviceInfoRespondCloud> ipcDeviceInfo = new ArrayList<EntDeviceInfoRespondCloud>();
        List deviceInfoRespondCloudList = JSON.parseArray((String)deviceArray1.toJSONString(), EntDeviceInfoRespondCloud.class);
        List channelInfoRespondCloudList = JSON.parseArray((String)channelArray3.toJSONString(), EntChannelInfoRespondCloud.class);
        for (EntDeviceInfoRespondCloud deviceInfoRespondCloud : deviceInfoRespondCloudList) {
            ParentCameraRespond parentCameraRespond = new ParentCameraRespond();
            String deviceState = deviceInfoRespondCloud.getDeviceState();
            if ("OFFLINE".equals(deviceState)) {
                parentCameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
            } else if ("ONLINE".equals(deviceState)) {
                parentCameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else if ("UNREGISTERED".equals(deviceState)) continue;
            if (deviceInfoRespondCloud.getDeviceType().contains("IPC")) {
                ipcDeviceInfo.add(deviceInfoRespondCloud);
                continue;
            }
            parentCameraRespond.setDomainCode(deviceInfoRespondCloud.getDeviceId());
            parentCameraRespond.setIsFrom("1");
            parentCameraRespond.setName(deviceInfoRespondCloud.getDeviceName());
            parentCameraRespond.setType("4");
            parentCameraRespond.setIsFromType("1");
            List channelInfoList = channelInfoRespondCloudList.stream().filter(e -> deviceInfoRespondCloud.getDeviceId().equals(e.getDeviceId())).collect(Collectors.toList());
            List channelResponds = this.buildEntChannelRespond(channelInfoList, false, Integer.valueOf(0));
            parentCameraRespond.setCameraResponds(this.buildEntCameraRespond(channelResponds));
            parentCameraResponds.add(parentCameraRespond);
        }
        parentCameraResponds.add(this.buildEntIpcParentCameraRespond(ipcDeviceInfo, channelInfoRespondCloudList));
        cloudDeviceRespond.setParentCameraResponds(parentCameraResponds);
        long b = System.currentTimeMillis();
        LOGGER.info("====time2" + (b - a));
        return cloudDeviceRespond;
    }

    private JSONArray cloudReturnData(VcmReqBaseInfo vcmReqBaseInfo, CloudMsgType uri) {
        try {
            JSONObject requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)uri, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo), (int)30);
            LOGGER.debug("get device from cloud is end.");
            if (requestResult.containsKey((Object)"devices")) {
                JSONArray dataArray = requestResult.getJSONArray("devices");
                return dataArray;
            }
            if (requestResult.containsKey((Object)"channels")) {
                JSONArray dataArray = requestResult.getJSONArray("channels");
                return dataArray;
            }
            LOGGER.error("get device fail:{}", (Object)requestResult.getString("msg"));
            throw new InvokeException("500", requestResult.getString("msg"));
        }
        catch (SDKException e) {
            LOGGER.error("get device fail", (Throwable)e);
            throw new InvokeException("500", e.getMessage());
        }
    }

    private List<ChannelRespond> buildEntChannelRespond(List<EntChannelInfoRespondCloud> channelInfoList, boolean isIpc, Integer ipcNum) {
        ArrayList<ChannelRespond> channelResponds = new ArrayList<ChannelRespond>();
        if (channelInfoList.size() > 0) {
            for (int i = 0; i < channelInfoList.size(); ++i) {
                EntChannelInfoRespondCloud channelInfoRespondCloud = channelInfoList.get(i);
                ChannelRespond channelRespond = new ChannelRespond();
                if ("OFFLINE".equals(channelInfoRespondCloud.getChannelState())) {
                    channelRespond.setStatus(ChannelStatusEnum.OFFLINE);
                } else if ("ONLINE".equals(channelInfoRespondCloud.getChannelState())) {
                    channelRespond.setStatus(ChannelStatusEnum.ONLINE);
                } else if ("UNALLOCATED".equals(channelInfoRespondCloud.getChannelState()) || "UNREGISTERED".equals(channelInfoRespondCloud.getChannelState())) continue;
                channelRespond.setCategory(DeviceTypeEnum.CLOUD.val());
                if (isIpc) {
                    channelRespond.setChannel(ipcNum.intValue());
                } else if (channelInfoRespondCloud.getChannelId().length() <= 10) {
                    channelRespond.setChannel(Integer.parseInt(channelInfoRespondCloud.getChannelId()) + 1);
                } else {
                    channelRespond.setChannel(i + 1);
                }
                channelRespond.setChannelCode(channelInfoRespondCloud.getDeviceId() + "$" + channelInfoRespondCloud.getChannelId());
                String list = "123678";
                int modelType = DeviceUtil.getModelType((String)channelInfoRespondCloud.getModel());
                if (list.contains(String.valueOf(modelType))) {
                    if (modelType == 2) {
                        channelRespond.setType(4);
                        channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)4));
                    } else {
                        channelRespond.setType(modelType);
                        channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)modelType));
                    }
                } else {
                    channelRespond.setType(0);
                    channelRespond.setCameraType(Ivs1800Utils.getCameraType((int)0));
                }
                channelRespond.setVendor("HUAWEI");
                channelRespond.setCameraName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{channelInfoRespondCloud.getChannelName()}) ? channelInfoRespondCloud.getChannelName() : "CH" + channelInfoRespondCloud.getChannelId());
                channelRespond.setChannelId(channelInfoRespondCloud.getChannelId());
                channelRespond.setParentCode(channelInfoRespondCloud.getDeviceId());
                channelRespond.setProtocolType("HWSDK");
                channelRespond.setFormType(1);
                channelResponds.add(channelRespond);
            }
        }
        return channelResponds;
    }

    List<CameraRespond> buildEntCameraRespond(List<ChannelRespond> channelResponds) {
        ArrayList<CameraRespond> cameraResponds = new ArrayList<CameraRespond>();
        for (ChannelRespond channelRespond : channelResponds) {
            CameraRespond cameraRespond = new CameraRespond();
            cameraRespond.setCameraCode(channelRespond.getChannelCode());
            cameraRespond.setCameraName(channelRespond.getCameraName());
            cameraRespond.setIpType(0);
            cameraRespond.setPort(0);
            cameraRespond.setModel("");
            cameraRespond.setFormType(1);
            cameraRespond.setLoginType(0);
            cameraRespond.setCameraType(channelRespond.getCameraType());
            cameraRespond.setEnableSchedule(0);
            cameraRespond.setVendor("HUAWEI");
            cameraRespond.setImgType(3);
            cameraRespond.setStatus(channelRespond.getStatus());
            cameraRespond.setProtocolType("HWSDK");
            channelRespond.setConnectType(channelRespond.getConnectType());
            cameraRespond.setChannelResponds(Collections.singletonList(channelRespond));
            cameraResponds.add(cameraRespond);
        }
        return cameraResponds;
    }

    private ParentCameraRespond buildEntIpcParentCameraRespond(List<EntDeviceInfoRespondCloud> ipcDeviceInfo, List<EntChannelInfoRespondCloud> channelInfoRespondCloudList) {
        ParentCameraRespond parentCameraRespond = new ParentCameraRespond();
        parentCameraRespond.setCode("2");
        parentCameraRespond.setStatus(ChannelStatusEnum.ONLINE);
        ArrayList<CameraRespond> cameraResponds = new ArrayList<CameraRespond>();
        Integer ipcDeviceNum = 1;
        for (EntDeviceInfoRespondCloud deviceInfoRespondCloud : ipcDeviceInfo) {
            CameraRespond cameraRespond = new CameraRespond();
            String deviceState = deviceInfoRespondCloud.getDeviceState();
            if ("OFFLINE".equals(deviceState)) {
                cameraRespond.setStatus(ChannelStatusEnum.OFFLINE);
            } else if ("ONLINE".equals(deviceState)) {
                cameraRespond.setStatus(ChannelStatusEnum.ONLINE);
            } else if ("UNREGISTERED".equals(deviceState)) continue;
            cameraRespond.setCameraCode(deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setCameraName(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{deviceInfoRespondCloud.getDeviceName()}) ? deviceInfoRespondCloud.getDeviceName() : "CH" + deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setDomainCode(deviceInfoRespondCloud.getDeviceId());
            cameraRespond.setConnectCode("");
            cameraRespond.setIpType(0);
            cameraRespond.setPort(0);
            cameraRespond.setModel("");
            cameraRespond.setSerialNumber("");
            cameraRespond.setFormType(1);
            cameraRespond.setLoginType(0);
            cameraRespond.setEnableSchedule(0);
            cameraRespond.setVendor("HUAWEI");
            cameraRespond.setImgType(3);
            cameraRespond.setProtocolType("HWSDK");
            List channelInfoList = channelInfoRespondCloudList.stream().filter(e -> deviceInfoRespondCloud.getDeviceId().equals(e.getDeviceId())).collect(Collectors.toList());
            List channelResponds = this.buildEntChannelRespond(channelInfoList, true, ipcDeviceNum);
            cameraRespond.setChannelResponds(channelResponds);
            cameraResponds.add(cameraRespond);
            Integer n = ipcDeviceNum;
            Integer n2 = ipcDeviceNum = Integer.valueOf(ipcDeviceNum + 1);
        }
        parentCameraRespond.setCameraResponds(cameraResponds);
        return parentCameraRespond;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

