/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.penetrate.PenetrateRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.CommonGetImageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.penetrate.PenetrateRespond;
import com.zkteco.zkbiosecurity.cuserver.service.CommonService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AlarmCloudServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AbstractIvs1800Service;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="commonCloudServiceImpl")
public class CommonCloudServiceImpl
extends AbstractIvs1800Service
implements CommonService<IServerType.Cloud> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonCloudServiceImpl.class);
    @Autowired
    AlarmCloudServiceImpl alarmCloudServiceImpl;

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    public CommonGetImageRespond getImage(ParamBean<CommonGetImageRequest> obj) {
        CommonGetImageRequest request = (CommonGetImageRequest)obj.getRequestBody();
        CommonGetImageRespond respond = new CommonGetImageRespond();
        String image = "";
        if (StringUtils.isNotBlank((CharSequence)request.getImageId())) {
            JSONObject alarmInfo = this.alarmCloudServiceImpl.getCloudAlarmInfo(obj.getVcmInfo(), request);
            JSONObject alarm = alarmInfo.getJSONObject("alarm");
            image = this.alarmCloudServiceImpl.getAlarmPhoto(alarm.getString("alarm_pic_url"), alarm.getString("encrypt_key"), alarm.getString("encrypt_iv"));
        }
        respond.setImage(image);
        return respond;
    }

    public PenetrateRespond penetrate(ParamBean<PenetrateRequest> obj) {
        return null;
    }

    public CommonGetImageRespond getCaptureByUUId(ParamBean<CommonGetImageRequest> obj) {
        return null;
    }
}

