/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudConstants;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AlarmCloudServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.CloudEventGetThread;
import com.zkteco.zkbiosecurity.cuserver.utils.SpringContextUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventGetThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudEventGetThread.class);
    private static final ThreadPoolExecutor executorService = new ThreadPoolExecutor(5, 10, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10), (ThreadFactory)new ThreadNameFactory());
    private final String domainCode;
    private final WebSocketService webSocketService;
    private final SubscriptionHelp subscriptionHelp;
    private final AlarmCloudServiceImpl alarmService;
    private static ConcurrentLinkedQueue<JSONObject> concurrentLinkedQueue = new ConcurrentLinkedQueue();

    public static ConcurrentLinkedQueue<JSONObject> getLinkedQueue() {
        return concurrentLinkedQueue;
    }

    public CloudEventGetThread(String domainCode, String ip) {
        super("Cloud-" + ip + "-eventThread");
        this.domainCode = domainCode;
        this.webSocketService = (WebSocketService)SpringContextUtil.getBean((String)"webSocketService");
        this.subscriptionHelp = (SubscriptionHelp)SpringContextUtil.getBean((String)"subscriptionHelp");
        this.alarmService = (AlarmCloudServiceImpl)SpringContextUtil.getBean((String)"alarmCloudServiceImpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("cloud alarm linkList start");
        while ("1".equals(CloudConstants.CLOUD_SUB_STATUS)) {
            CloudEventGetThread cloudEventGetThread = this;
            synchronized (cloudEventGetThread) {
                if (executorService.getActiveCount() < executorService.getMaximumPoolSize() && executorService.getQueue().remainingCapacity() > 0) {
                    JSONObject poll = (JSONObject)concurrentLinkedQueue.poll();
                    if (ObjectUtils.isNotEmpty((Object)poll)) {
                        LOGGER.info("cloud alarm pool size:{}", (Object)concurrentLinkedQueue.size());
                        try {
                            CompletableFuture.runAsync(() -> {
                                CommonGetImageRequest imageRequest = new CommonGetImageRequest();
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append(poll.getString("alarm_id")).append("#").append(poll.getString("alarm_classification"));
                                if (ObjectUtils.isNotEmpty((Object)poll.getString("enterprise_id"))) {
                                    stringBuilder.append("#").append(poll.getString("enterprise_id"));
                                }
                                imageRequest.setImageId(stringBuilder.toString());
                                VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(poll.getString("user_id"));
                                AlarmEventRespond alarmInfo = this.alarmService.getAlarmInfo(vcmReqBaseInfo, imageRequest);
                                this.webSocketService.send((BaseEventRespond)alarmInfo);
                            }, executorService);
                        }
                        catch (Exception e) {
                            LOGGER.info("get cloud push alarmInfo error:", (Throwable)e);
                        }
                    } else {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.info("cloud alarm pool empty sleep error:", (Throwable)e);
                        }
                    }
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("cloud alarm pool thread sleep error:", (Throwable)e);
                    }
                }
            }
        }
        this.subscriptionHelp.remove(this.domainCode);
    }
}

