/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service.impl.cloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudConstants;
import com.zkteco.zkbiosecurity.cuserver.contants.CloudMsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.EmptyRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmDealRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.alarm.AlarmSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.common.CommonGetImageRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.PageRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.AlarmEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BehaviorBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.FaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.GeneralBusinessBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.HisFaceBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.SituationAnalysisBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.ThirdAlgorithmBean;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.AlarmSearchRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarmSearch.OperationsAlarmRespond;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmCodeTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.AlarmLevelEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.AlarmService;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AbstractCloudService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.AlarmGetByCloud;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.CloudEventGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.cloud.WebSocketClientHandler;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.EntCloudUtils;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class AlarmCloudServiceImpl
extends AbstractCloudService
implements AlarmService<IServerType.Cloud> {
    private static final Logger log = LoggerFactory.getLogger(AlarmCloudServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AlarmCloudServiceImpl.class);
    private static final String ALGORITHM = "AES/CBC/NoPadding";
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public boolean subscribe(ParamBean<SubscriptionRequest> obj) {
        SubscriptionRequest requestBody = (SubscriptionRequest)obj.getRequestBody();
        String cloudUrl = obj.getVcmInfo().getVcmIp();
        if (cloudUrl.startsWith("https")) {
            cloudUrl = cloudUrl.substring(8);
        } else if (cloudUrl.startsWith("http")) {
            cloudUrl = cloudUrl.substring(7);
        }
        if ("0".equals(CloudConstants.CLOUD_SUB_STATUS)) {
            new AlarmGetByCloud(requestBody.getCloudTiken(), cloudUrl);
        }
        if (StringUtils.isNotEmpty((CharSequence)obj.getVcmInfo().getDomainCode())) {
            this.subscriptionHelp.add("cloudSdcSubKey", obj.getVcmInfo(), obj.getVcmInfo().getUserId());
        }
        if (this.subscriptionHelp.get(obj.getVcmInfo().getUserId()) == null) {
            this.subscriptionHelp.add(obj.getVcmInfo().getUserId(), obj.getVcmInfo(), obj.getVcmInfo().getUserId());
            CloudEventGetThread cloudEventGetThread = new CloudEventGetThread(obj.getVcmInfo().getUserId(), obj.getVcmInfo().getVcmIp());
            cloudEventGetThread.start();
        } else {
            this.subscriptionHelp.add(obj.getVcmInfo().getUserId(), obj.getVcmInfo(), obj.getVcmInfo().getUserId());
        }
        log.info("cloud subscribe status {}", (Object)CloudConstants.CLOUD_SUB_STATUS);
        return true;
    }

    public boolean delSubscribe(ParamBean<SubscriptionRequest> obj) {
        WebSocketClientHandler.getWebSocketClientHandler().closeSocket();
        return true;
    }

    public boolean confirm(ParamBean<AlarmDealRequest> obj) {
        return true;
    }

    public boolean cancel(ParamBean<AlarmDealRequest> obj) {
        return true;
    }

    public PageRespond<AlarmSearchRespond> search(ParamBean<AlarmSearchRequest> obj) {
        PageRespond alarmSearch = new PageRespond();
        ArrayList<AlarmSearchRespond> eventRespondList = new ArrayList<AlarmSearchRespond>();
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        AlarmSearchRequest requestBody = (AlarmSearchRequest)obj.getRequestBody();
        HttpUrlParam httpUrlParam = this.buildSearchRequest(vcmInfo, requestBody);
        JSONObject requestResult = null;
        try {
            requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)CloudMsgType.HW_CLOUD_GET_ALARM_HISTORY, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException sdkException) {
            log.error("search cloud alarm error", (Throwable)sdkException);
            throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
        }
        String alarmClassification = this.getCloudAlarmClassification(requestBody.getType(), (String)requestBody.getAlarmTypeList().get(0));
        String enterpriseId = vcmInfo.getEnterpriseId();
        JSONArray alarms = requestResult.getJSONArray("alarms");
        for (int i = 0; i < alarms.size(); ++i) {
            JSONObject alarm = (JSONObject)alarms.get(i);
            AlarmSearchRespond searchRespond = new AlarmSearchRespond();
            searchRespond.setIsUserDefined(Integer.valueOf(0));
            searchRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            String alarmType = alarm.getString("alarm_type");
            if ("face_alarm".equals(alarmType)) {
                alarmType = "target_alarm";
            }
            if ("face_high_frequency_alarm".equals(alarmType)) {
                alarmType = "high_frequency_alarm";
            }
            searchRespond.setCode(DeviceUtil.getAlarmCode((String)alarmType));
            searchRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)searchRespond.getCode()));
            searchRespond.setStatus(alarm.getInteger("read_status").intValue());
            searchRespond.setAlarmInName(alarm.getString("channel_name"));
            searchRespond.setDomainCode(alarm.getString("device_id"));
            searchRespond.setChannelCode(searchRespond.getDomainCode() + "$" + alarm.getString("channel_id"));
            String deviceType = alarm.getString("device_type");
            if (StringUtils.isNotEmpty((CharSequence)deviceType) && deviceType.contains("IPC")) {
                searchRespond.setDomainCode(this.subscriptionHelp.get("cloudSdcSubKey").getDomainCode());
                searchRespond.setChannelCode(alarm.getString("device_id") + "$0");
                searchRespond.setDeviceSubType(DeviceTypeEnum.CLOUDSDC.val() + "");
            }
            searchRespond.setMsgId(UUID.randomUUID().toString());
            searchRespond.setId(alarm.getString("id"));
            LocalDateTime date = LocalDateTime.parse(alarm.getString("alarm_time"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            searchRespond.setTime(date.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(alarm.getString("alarm_uuid")).append("#").append(alarmClassification);
            if (enterpriseId != null) {
                stringBuilder.append("#").append(enterpriseId);
            }
            String snapshotFileId = stringBuilder.toString();
            searchRespond.setSnapshotFileId(snapshotFileId);
            searchRespond.setPanoramaFileId(snapshotFileId);
            if ("ALARM_FACE_RECOGNITION".equals(searchRespond.getCode())) {
                JSONObject face = alarm.getJSONObject("face");
                HisFaceBean faceBean = new HisFaceBean();
                faceBean.setAgeGroup(this.getAgeRange(face.getInteger("age").intValue()));
                faceBean.setSimilarityDegree(face.getDouble("similarity").doubleValue());
                faceBean.setAlarmMatch(2);
                if (StringUtils.isNotEmpty((CharSequence)face.getString("group_id")) && StringUtils.isNotEmpty((CharSequence)face.getString("face_id"))) {
                    faceBean.setAlarmMatch(1);
                    faceBean.setTargetName(face.getString("name"));
                    faceBean.setGroupName(face.getString("organization"));
                }
                faceBean.setGenderCode("male".equals(face.getString("gender")) ? "1" : "2");
                searchRespond.setFaceBean(faceBean);
            } else if ("ALARM_THIRD_ALGORITHM".equals(searchRespond.getCode())) {
                ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
                thirdAlgorithmBean.setThirdAlgorithmName(alarm.getString("alarm_type_name"));
                searchRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
            }
            eventRespondList.add(searchRespond);
        }
        List eventRespondSort = eventRespondList.stream().sorted(Comparator.comparing(BaseEventRespond::getTime).reversed()).collect(Collectors.toList());
        alarmSearch.setData(eventRespondSort);
        alarmSearch.setTotal(ObjectUtils.isNotEmpty((Object)requestResult.getInteger("total")) ? requestResult.getInteger("total").intValue() : eventRespondSort.size());
        alarmSearch.setPage(requestBody.getPage());
        alarmSearch.setPageSize(requestBody.getPageSize());
        return alarmSearch;
    }

    public PageRespond<OperationsAlarmRespond> searchOperations(ParamBean<AlarmSearchRequest> paramBean) {
        AlarmSearchRequest requestBody = (AlarmSearchRequest)paramBean.getRequestBody();
        requestBody.setType("6");
        PageRespond search = this.search(paramBean);
        List data = search.getData();
        List eventRespondList = Collections.synchronizedList(new ArrayList());
        data.parallelStream().forEach(alarmSearchRespond -> {
            OperationsAlarmRespond operationsAlarmRespond = new OperationsAlarmRespond();
            BeanUtils.copyProperties((Object)alarmSearchRespond, (Object)operationsAlarmRespond);
            operationsAlarmRespond.setStatus(1);
            eventRespondList.add(operationsAlarmRespond);
        });
        List eventRespondSort = eventRespondList.stream().sorted(Comparator.comparing(OperationsAlarmRespond::getTime).reversed()).collect(Collectors.toList());
        PageRespond pageRespond = new PageRespond();
        pageRespond.setPage(search.getPage());
        pageRespond.setPageSize(search.getPageSize());
        pageRespond.setTotal(search.getTotal());
        pageRespond.setData(eventRespondSort);
        return pageRespond;
    }

    public boolean switchEnterprise(ParamBean<EmptyRequest> obj) {
        JSONObject requestResult;
        VcmReqBaseInfo vcmInfo = obj.getVcmInfo();
        StringBuilder url = new StringBuilder();
        url.append("/v1/").append(vcmInfo.getUserId()).append("/enterprises/");
        url.append(StringUtils.isEmpty((CharSequence)vcmInfo.getEnterpriseId()) ? "0" : vcmInfo.getEnterpriseId());
        url.append("/alarm-push");
        try {
            requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_PUT, url.toString()), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException sdkException) {
            log.error("switch cloud user info  error", (Throwable)sdkException);
            throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
        }
        CloudEventGetThread.getLinkedQueue().clear();
        return "success".equals(requestResult.getString("error_msg"));
    }

    public JSONObject getCloudAlarmInfo(VcmReqBaseInfo vcmReqBaseInfo, CommonGetImageRequest getImageRequest) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        String[] split = getImageRequest.getImageId().split("#");
        if (split.length > 2) {
            httpUrlParam.addParam("enterprise_id", split[2]);
        }
        httpUrlParam.addParam("alarm_classification", split[1]);
        httpUrlParam.addParam("alarm_uuid", split[0]);
        JSONObject requestResult = null;
        try {
            requestResult = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)CloudMsgType.HW_CLOUD_GET_ALARM_INFO, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
        }
        catch (SDKException sdkException) {
            LOGGER.info("search cloud alarm error,msg:{},alarmInfo:{}", (Object)sdkException, (Object)JSON.toJSONString((Object)split));
            throw new InvokeException("500", (Object)sdkException.getMessage(), EntCloudUtils.reasonHelper((SDKException)sdkException));
        }
        return requestResult;
    }

    public AlarmEventRespond getAlarmInfo(VcmReqBaseInfo vcmReqBaseInfo, CommonGetImageRequest getImageRequest) {
        AlarmEventRespond alarmEventRespond = new AlarmEventRespond();
        JSONObject requestResult = this.getCloudAlarmInfo(vcmReqBaseInfo, getImageRequest);
        JSONObject alarm = requestResult.getJSONObject("alarm");
        if (ObjectUtils.isNotEmpty((Object)alarm)) {
            alarmEventRespond.setAlarmLevel(AlarmLevelEnum.EMERGENCY);
            alarmEventRespond.setChannelCode(alarm.getString("channel_id"));
            String alarmType = alarm.getString("alarm_type");
            if ("face_alarm".equals(alarmType)) {
                alarmType = "target_alarm";
            }
            if ("face_high_frequency_alarm".equals(alarmType)) {
                alarmType = "high_frequency_alarm";
            }
            alarmEventRespond.setCode(DeviceUtil.getAlarmCode((String)alarmType));
            alarmEventRespond.setAlarmCodeType(DeviceUtil.getAlarmCodeType((String)alarmEventRespond.getCode()));
            alarmEventRespond.setId(UUID.randomUUID().toString());
            alarmEventRespond.setDomainCode(vcmReqBaseInfo.getUserId());
            alarmEventRespond.setCloudDomainCode(alarm.getString("device_id"));
            alarmEventRespond.setChannelCode(alarmEventRespond.getCloudDomainCode() + "$" + alarm.getString("channel_id"));
            String deviceType = alarm.getString("device_type");
            if (deviceType.contains("IPC") && ObjectUtils.isNotEmpty((Object)this.subscriptionHelp.get("cloudSdcSubKey"))) {
                alarmEventRespond.setCloudDomainCode(this.subscriptionHelp.get("cloudSdcSubKey").getDomainCode());
                alarmEventRespond.setChannelCode(alarm.getString("device_id") + "$0");
                if ("ALARM_DEVICE_OFFLINE".equals(alarmEventRespond.getCode())) {
                    alarmEventRespond.setDeviceSubType(DeviceTypeEnum.CLOUDSDC.val() + "");
                }
            }
            String snapshotImage = "";
            if (!"ALARM_IPC_OFFLINE".equals(alarmEventRespond.getCode()) && !"ALARM_DEVICE_OFFLINE".equals(alarmEventRespond.getCode())) {
                snapshotImage = this.getAlarmPhoto(alarm.getString("alarm_pic_url"), alarm.getString("encrypt_key"), alarm.getString("encrypt_iv"));
            }
            alarmEventRespond.setFilterName(alarmEventRespond.getCode());
            alarmEventRespond.setIsUserDefined(Integer.valueOf(0));
            alarmEventRespond.setType(EventTypeEnum.ALARM);
            LocalDateTime date = LocalDateTime.parse(alarm.getString("alarm_time"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            alarmEventRespond.setTime(date.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            if (AlarmCodeTypeEnum.ALARM_THIRD_ALGORITHM.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                ThirdAlgorithmBean thirdAlgorithmBean = new ThirdAlgorithmBean();
                thirdAlgorithmBean.setPanorama(snapshotImage);
                thirdAlgorithmBean.setSnapshot(snapshotImage);
                thirdAlgorithmBean.setThirdAlgorithmName(alarm.getString("alarm_type_name"));
                alarmEventRespond.setThirdAlgorithmBean(thirdAlgorithmBean);
                alarmEventRespond.setFilterName(thirdAlgorithmBean.getThirdAlgorithmName());
            } else if (AlarmCodeTypeEnum.ALARM_BEHAVIOR.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                BehaviorBean behaviorBean = new BehaviorBean();
                behaviorBean.setPanorama(snapshotImage);
                behaviorBean.setSnapshot(snapshotImage);
                alarmEventRespond.setBehaviorBean(behaviorBean);
            } else if (AlarmCodeTypeEnum.ALARM_SITUATION_ANALYSIS.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                SituationAnalysisBean situationAnalysisBean = new SituationAnalysisBean();
                situationAnalysisBean.setPanorama(snapshotImage);
                situationAnalysisBean.setSnapshot(snapshotImage);
                alarmEventRespond.setSituationAnalysisBean(situationAnalysisBean);
            } else if (AlarmCodeTypeEnum.ALARM_FACE.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                FaceBean faceBean = new FaceBean();
                faceBean.setPanorama(snapshotImage);
                faceBean.setSnapshot(snapshotImage);
                if ("ALARM_FACE_RECOGNITION".equals(alarmEventRespond.getCode())) {
                    JSONObject face = alarm.getJSONObject("face");
                    faceBean.setAgeGroup(this.getAgeRange(face.getInteger("age").intValue()));
                    faceBean.setSimilarityDegree(face.getDouble("similarity").doubleValue());
                    faceBean.setAlarmMatch(2);
                    if (StringUtils.isNotEmpty((CharSequence)face.getString("group_id")) && StringUtils.isNotEmpty((CharSequence)face.getString("face_id"))) {
                        faceBean.setAlarmMatch(1);
                        faceBean.setTargetName(face.getString("name"));
                        faceBean.setGroupName(face.getString("organization"));
                    }
                    faceBean.setGenderCode("male".equals(face.getString("gender")) ? "1" : "2");
                }
                alarmEventRespond.setFaceBean(faceBean);
            } else if (AlarmCodeTypeEnum.ALARM_GENERAL_BUSINESS.toString().equals(alarmEventRespond.getAlarmCodeType())) {
                if ("ALARM_TYPE_DI".equals(alarmEventRespond.getCode())) {
                    alarmEventRespond.setAlarmSourceSecType(1);
                    alarmEventRespond.setAlarmInName(alarm.getString("channel_name"));
                }
                GeneralBusinessBean generalBusinessBean = new GeneralBusinessBean();
                generalBusinessBean.setPanorama(snapshotImage);
                generalBusinessBean.setSnapshot(snapshotImage);
                alarmEventRespond.setGeneralBusinessBean(generalBusinessBean);
            } else if ("ALARM_IPC_OFFLINE".equals(alarmEventRespond.getCode()) || "ALARM_DEVICE_OFFLINE".equals(alarmEventRespond.getCode())) {
                alarmEventRespond.setStatus(1);
            }
        }
        return alarmEventRespond;
    }

    private HttpUrlParam buildSearchRequest(VcmReqBaseInfo vcmInfo, AlarmSearchRequest request) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        String alarmType = (String)request.getAlarmTypeList().get(0);
        String cloudAlarmClassification = this.getCloudAlarmClassification(request.getType(), alarmType);
        httpUrlParam.addParam("alarm_classification", cloudAlarmClassification);
        if (ObjectUtils.isNotEmpty((Object)vcmInfo.getEnterpriseId())) {
            httpUrlParam.addParam("enterprise_id", vcmInfo.getEnterpriseId());
        }
        httpUrlParam.addParam("user_id", vcmInfo.getUserId());
        if (!"4".equals(request.getType())) {
            httpUrlParam.addParam("alarm_type", DeviceUtil.getCloudAlarmCode((String)alarmType));
        }
        httpUrlParam.addParam("start_time", LocalDateTime.parse(request.getStartTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        httpUrlParam.addParam("end_time", LocalDateTime.parse(request.getEndTime(), DateTimeFormatter.ofPattern("yyyyMMddHHmmss")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        httpUrlParam.addParam("limit", request.getPageSize() + "");
        httpUrlParam.addParam("offset", (request.getPage() - 1) * request.getPageSize() + "");
        return httpUrlParam;
    }

    private int getAgeRange(int snapAge) {
        int ageRange = 0;
        if (snapAge >= 50) {
            ageRange = 5;
        } else if (snapAge >= 30) {
            ageRange = 4;
        } else if (snapAge >= 18) {
            ageRange = 3;
        } else if (snapAge >= 12) {
            ageRange = 2;
        } else if (snapAge >= 1) {
            ageRange = 1;
        }
        return ageRange;
    }

    private String getCloudAlarmClassification(String type, String alarmType) {
        String alarmClassification = "";
        switch (type) {
            case "0": {
                alarmClassification = "TARGET";
                break;
            }
            case "2": {
                alarmClassification = "INTELLIGENT";
                break;
            }
            case "4": {
                alarmClassification = "THIRDPARTY_INTELLIGENT";
                break;
            }
            case "5": {
                alarmClassification = "CROWD";
                break;
            }
            case "6": {
                alarmClassification = "DEVICE";
            }
        }
        if ("ALARM_FACE_MASK".equals(alarmType)) {
            alarmClassification = "TARGET_DET";
        }
        if ("ALARM_TYPE_MOVE_DECTION".equals(alarmType)) {
            alarmClassification = "INTELLIGENT";
        }
        if ("ALARM_TYPE_DI".equals(alarmType)) {
            alarmClassification = "INTELLIGENT";
        }
        return alarmClassification;
    }

    public String getAlarmPhoto(String url, String key, String iv) {
        String image = "";
        byte[] btImg = null;
        try {
            URL httpUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream inStream = conn.getInputStream();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            inStream.close();
            btImg = outStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.info("get alarm photo url not found:url:{},key:{},iv:{}", new Object[]{url, key, iv});
        }
        if (btImg != null) {
            void index = btImg[16] + 17;
            int length = btImg.length - index;
            int notPasFileLength = length % 16;
            byte[] realFileByte = new byte[length - notPasFileLength];
            System.arraycopy(btImg, (int)index, realFileByte, 0, length - notPasFileLength);
            byte[] notFileByte = new byte[notPasFileLength];
            System.arraycopy(btImg, btImg.length - notPasFileLength, notFileByte, 0, notPasFileLength);
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "AES");
            try {
                Cipher cipher = Cipher.getInstance(ALGORITHM);
                cipher.init(2, (Key)keySpec, new IvParameterSpec(iv.getBytes()));
                byte[] bytes = cipher.doFinal(realFileByte);
                byte[] finalBytes = new byte[bytes.length + notFileByte.length];
                System.arraycopy(bytes, 0, finalBytes, 0, bytes.length);
                System.arraycopy(notFileByte, 0, finalBytes, bytes.length, notFileByte.length);
                BASE64Encoder encoder = new BASE64Encoder();
                image = encoder.encode(finalBytes);
            }
            catch (Exception e) {
                LOGGER.info("get photo error:{}", (Object)e.getMessage());
            }
        }
        return image;
    }

    public boolean register(VcmReqBaseInfo vcmReqBaseInfo, String url) {
        return false;
    }

    public String getRegisterUrlList(ParamBean<EmptyRequest> obj) {
        return null;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E e, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(e);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }
}

