/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.alarm.BaseEventRespond;
import com.zkteco.zkbiosecurity.cuserver.enums.DeviceTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.enums.EventTypeEnum;
import com.zkteco.zkbiosecurity.cuserver.server.WebSocketServer;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import java.util.UUID;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebSocketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketService.class);
    @Autowired
    private WebSocketServer webSocketServer;
    @Autowired
    private SubscriptionHelp subscriptionHelp;

    public void send(BaseEventRespond baseEventRespond) {
        VcmReqBaseInfo vcmReqBaseInfo;
        if (!(EventTypeEnum.OPERATE_RESULT.equals((Object)baseEventRespond.getType()) || baseEventRespond.getDomainCode() != null && this.subscriptionHelp.get(baseEventRespond.getDomainCode()) != null)) {
            LOGGER.info("Ignore domain:{},type:{}", (Object)baseEventRespond.getDomainCode(), (Object)baseEventRespond.getType());
            return;
        }
        baseEventRespond.setMsgId(UUID.randomUUID().toString());
        if (!EventTypeEnum.OPERATE_RESULT.equals((Object)baseEventRespond.getType()) && ObjectUtils.isNotEmpty((Object)(vcmReqBaseInfo = this.subscriptionHelp.get(baseEventRespond.getDomainCode()))) && DeviceTypeEnum.CLOUD.val() == vcmReqBaseInfo.getVcmType().intValue()) {
            baseEventRespond.setDomainCode(baseEventRespond.getCloudDomainCode());
        }
        this.webSocketServer.sendTo(baseEventRespond);
    }
}

