/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service;

import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.EventGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.tiandy.EventTianDyGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.zknvr.EventZkGetThread;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionHelp {
    private static final Map<String, VcmReqBaseInfo> SUBSCRIBE_VCM_INFO_MAP = new Hashtable();
    private static final Map<String, EventGetThread> THREAD_MAP = new Hashtable();
    private static final Map<String, EventZkGetThread> ZKNVR_THREAD_MAP = new Hashtable();
    private static final Map<String, EventTianDyGetThread> TIANDY_THREAD_MAP = new Hashtable();
    private static final Map<String, String> SUBSCRIBE_RELATION_MAP = new HashMap();

    public static void updateThread(String domainCode, EventGetThread eventGetThread) {
        THREAD_MAP.put(domainCode, eventGetThread);
    }

    public static void removeThread(String domainCode) {
        THREAD_MAP.remove(domainCode);
    }

    public static void updateZkThread(String domainCode, EventZkGetThread eventZkGetThread) {
        ZKNVR_THREAD_MAP.put(domainCode, eventZkGetThread);
    }

    public static void removeZkThread(String domainCode) {
        ZKNVR_THREAD_MAP.remove(domainCode);
    }

    public static EventZkGetThread getEventZkGetThread(String domainCode) {
        return (EventZkGetThread)ZKNVR_THREAD_MAP.get(domainCode);
    }

    public static EventGetThread getEventGetThread(String domainCode) {
        return (EventGetThread)THREAD_MAP.get(domainCode);
    }

    public static Map<String, VcmReqBaseInfo> getSubscribeMap() {
        return SUBSCRIBE_VCM_INFO_MAP;
    }

    public void add(String domainCode, VcmReqBaseInfo vcmReqBaseInfo, String subscribeId) {
        SUBSCRIBE_VCM_INFO_MAP.put(domainCode, vcmReqBaseInfo);
    }

    public VcmReqBaseInfo get(String domainCode) {
        return (VcmReqBaseInfo)SUBSCRIBE_VCM_INFO_MAP.get(domainCode);
    }

    public void remove(String domainCode) {
        SUBSCRIBE_VCM_INFO_MAP.remove(domainCode);
        SUBSCRIBE_RELATION_MAP.remove(domainCode);
    }

    public static void updateTianDyThread(String domainCode, EventTianDyGetThread eventTianDyGetThread) {
        TIANDY_THREAD_MAP.put(domainCode, eventTianDyGetThread);
    }

    public static void removeTianDyThread(String domainCode) {
        TIANDY_THREAD_MAP.remove(domainCode);
    }
}

