/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cuserver.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.IOUtils;
import com.google.common.base.Predicate;
import com.zkteco.zkbiosecurity.cuserver.config.ConfigHolder;
import com.zkteco.zkbiosecurity.cuserver.contants.Ivs1800MsgType;
import com.zkteco.zkbiosecurity.cuserver.contants.Nvr800MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.HttpUrlParam;
import com.zkteco.zkbiosecurity.cuserver.dto.MsgType;
import com.zkteco.zkbiosecurity.cuserver.dto.ParamBean;
import com.zkteco.zkbiosecurity.cuserver.dto.VcmReqBaseInfo;
import com.zkteco.zkbiosecurity.cuserver.dto.common.CommonResponse;
import com.zkteco.zkbiosecurity.cuserver.dto.request.cu.device.MasterDeviceSearchRequest;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.FaceRepository;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.cu.facerepository.People;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.BaseRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositoryIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.respond.ivs1800.facerepository.FaceRepositorySearchRespondIvs1800;
import com.zkteco.zkbiosecurity.cuserver.dto.websocket.SubscriptionRequest;
import com.zkteco.zkbiosecurity.cuserver.enums.HttpMethodEnum;
import com.zkteco.zkbiosecurity.cuserver.exception.InvokeException;
import com.zkteco.zkbiosecurity.cuserver.exception.SDKException;
import com.zkteco.zkbiosecurity.cuserver.service.IServerType;
import com.zkteco.zkbiosecurity.cuserver.service.IService;
import com.zkteco.zkbiosecurity.cuserver.service.SmartDaraHelpService;
import com.zkteco.zkbiosecurity.cuserver.service.SubscriptionHelp;
import com.zkteco.zkbiosecurity.cuserver.service.WebSocketService;
import com.zkteco.zkbiosecurity.cuserver.service.impl.ivs1800.AlarmIvs1800ServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.EventGetThread;
import com.zkteco.zkbiosecurity.cuserver.service.impl.nvr800.PasswordServiceImpl;
import com.zkteco.zkbiosecurity.cuserver.utils.DeviceUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.HttpRequestUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.Ivs1800Utils;
import com.zkteco.zkbiosecurity.cuserver.utils.JsonUtil;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ClientSessionContext;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.JSONMsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.MsgToObjectConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToJSONMsgConvertor;
import com.zkteco.zkbiosecurity.cuserver.utils.httpclient.ObjectToMsgConvertor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import sun.misc.BASE64Encoder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SmartDaraHelpService
implements IService<IServerType.IVS1800> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartDaraHelpService.class);
    @Autowired
    private SubscriptionHelp subscriptionHelp;
    @Autowired
    private AlarmIvs1800ServiceImpl alarmIvs1800Service;
    @Autowired
    private PasswordServiceImpl passwordService;
    @Autowired
    private WebSocketService webSocketService;

    @Scheduled(cron="0 0/5 * * * ?")
    public void healthyCheck() {
        Map subscribeMap = SubscriptionHelp.getSubscribeMap();
        for (Map.Entry entry : subscribeMap.entrySet()) {
            VcmReqBaseInfo vcmReqBaseInfo = (VcmReqBaseInfo)entry.getValue();
            try {
                String[] ips;
                if (vcmReqBaseInfo.getVcmType() == 2) {
                    EventGetThread eventGetThread = SubscriptionHelp.getEventGetThread((String)((String)entry.getKey()));
                    if (eventGetThread != null && eventGetThread.isAlive()) continue;
                    LOGGER.info("EventCheck restart,domain: {},IP:{}", entry.getKey(), (Object)((VcmReqBaseInfo)entry.getValue()).getVcmIp());
                    EventGetThread newThread = new EventGetThread((String)entry.getKey(), ((VcmReqBaseInfo)entry.getValue()).getVcmIp());
                    newThread.start();
                    SubscriptionHelp.updateThread((String)((String)entry.getKey()), (EventGetThread)newThread);
                    continue;
                }
                if (vcmReqBaseInfo.getVcmType() != 0 || ConfigHolder.getNatEnabled() || !StringUtils.isNotBlank((CharSequence)vcmReqBaseInfo.getParentDeviceId())) continue;
                String ip = DeviceUtil.getListenIp((VcmReqBaseInfo)vcmReqBaseInfo);
                String oldIp = ConfigHolder.getIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId());
                LOGGER.info("IVS 1800 auto nat check data: {}", (Object)oldIp);
                if (!StringUtils.isNotBlank((CharSequence)ip) || !StringUtils.isNotBlank((CharSequence)oldIp) || ip.equals((ips = oldIp.split("_"))[0])) continue;
                ConfigHolder.putIpByParentDeviceId((String)vcmReqBaseInfo.getParentDeviceId(), (String)(ips.length > 1 ? ip + "_" + ips[1] : ips[0]));
                ParamBean paramBean = new ParamBean();
                SubscriptionRequest request = new SubscriptionRequest();
                paramBean.setVcmInfo(vcmReqBaseInfo);
                request.setDomainCode(vcmReqBaseInfo.getDomainCode());
                request.setSubscribeId(vcmReqBaseInfo.getParentDeviceId());
                request.setDeviceVersion(ips[1]);
                paramBean.setRequestBody((Object)request);
                this.alarmIvs1800Service.subscribe(paramBean);
            }
            catch (Exception e) {
                LOGGER.error("cron check subscribe error,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        }
    }

    public People getTargetInfo(String domainCode, String groupId, String peopleId) {
        VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(domainCode);
        return this.getTargetPeopleForIvs1800(vcmReqBaseInfo, groupId, peopleId);
    }

    public People getTargetPeopleForIvs1800(VcmReqBaseInfo vcmReqBaseInfo, String groupId, String peopleId) {
        JSONObject request = new JSONObject();
        request.put("groupids", (Object)groupId);
        request.put("peopleIds", (Object)peopleId);
        JSONObject page = new JSONObject();
        page.put("no", (Object)"1");
        page.put("size", (Object)"100");
        page.put("sort", (Object)"asc");
        page.put("orderName", (Object)"name");
        request.put("page", (Object)page);
        People people = new People();
        if (vcmReqBaseInfo != null) {
            try {
                JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_PEOPLE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                if (rsp.getIntValue("resultCode") == 0 && rsp.getJSONArray("peopleList").size() > 0) {
                    JSONObject peopleJson = rsp.getJSONArray("peopleList").getJSONObject(0);
                    people.setId(peopleJson.getString("tag"));
                    people.setName(peopleJson.getString("name"));
                    people.setCredentialNumber(peopleJson.getString("credentialNumber"));
                    people.setGroupImageId(peopleJson.getJSONArray("faceList").getJSONObject(0).getString("fileId"));
                }
            }
            catch (SDKException e) {
                LOGGER.error("search targetInfo error!", (Throwable)e);
            }
        }
        return people;
    }

    public FaceRepositoryIvs1800 getTargetGroupInfo(String domainCode, String groupId) {
        HttpUrlParam httpUrlParam = new HttpUrlParam();
        httpUrlParam.addParam("size", "1000");
        httpUrlParam.addParam("no", "1");
        httpUrlParam.addParam("ordername", "name");
        httpUrlParam.addParam("sort", "asc");
        httpUrlParam.addParam("id", groupId);
        VcmReqBaseInfo vcmReqBaseInfo = this.subscriptionHelp.get(domainCode);
        FaceRepositoryIvs1800 group = new FaceRepositoryIvs1800();
        if (vcmReqBaseInfo != null) {
            try {
                FaceRepositorySearchRespondIvs1800 rsp = (FaceRepositorySearchRespondIvs1800)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.SEARCH_FACE_REPOSITORY_URI, (HttpUrlParam)httpUrlParam, (MsgToObjectConvertor)this.msgToObjectConvertor(CommonResponse.class, FaceRepositorySearchRespondIvs1800.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                if (Objects.nonNull(rsp) && !CollectionUtils.isEmpty((Collection)rsp.getRepositories())) {
                    group = (FaceRepositoryIvs1800)rsp.getRepositories().get(0);
                }
            }
            catch (SDKException e) {
                LOGGER.error("search targetGroupInfo error!", (Throwable)e);
            }
        }
        return group;
    }

    public People getTargetInfoNvr800(VcmReqBaseInfo vcmReqBaseInfo, long peopleId) {
        JSONObject request = new JSONObject();
        JSONObject data = new JSONObject();
        JSONArray faceIds = new JSONArray();
        faceIds.add((Object)peopleId);
        data.put("FacesId", (Object)faceIds);
        request.put("data", (Object)data);
        People people = new People();
        try {
            JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_PEOPLE_BY_ID, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            JSONObject result = rsp.getJSONObject("data");
            if (result.getIntValue("Result") == 0 && result.getJSONArray("FaceInfo").size() > 0) {
                JSONObject peopleJson = result.getJSONArray("FaceInfo").getJSONObject(0);
                people.setId(peopleJson.getString("Remark"));
                people.setName(peopleJson.getString("Name"));
                people.setCredentialNumber(peopleJson.getString("IdCode"));
            }
        }
        catch (SDKException e) {
            LOGGER.debug("search targetInfo error!");
        }
        return people;
    }

    public FaceRepository getTargetGroupInfoNvr800(VcmReqBaseInfo vcmReqBaseInfo, long groupId) {
        FaceRepository faceRepository;
        block4: {
            faceRepository = new FaceRepository();
            try {
                JSONObject data = new JSONObject();
                data.put("DefaultVal", (Object)0);
                data.put("WithInternal", (Object)0);
                data.put("SimpleInfo", (Object)1);
                JSONObject request = new JSONObject();
                request.put("data", (Object)data);
                JSONObject rsp = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Nvr800MsgType.SEARCH_FACE_REPOSITORY_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)request, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
                if (rsp == null || 0 != rsp.getJSONObject("data").getIntValue("Result") || CollectionUtils.isEmpty((Collection)rsp.getJSONObject("data").getJSONArray("Group"))) break block4;
                JSONArray array = rsp.getJSONObject("data").getJSONArray("Group");
                for (int i = 0; i < array.size(); ++i) {
                    if (groupId != (long)array.getJSONObject(i).getIntValue("Id")) continue;
                    faceRepository.setName(array.getJSONObject(i).getString("Name"));
                    faceRepository.setType(array.getJSONObject(i).getIntValue("Policy") == 0 ? "3" : "2");
                    if (array.getJSONObject(i).getIntValue("Policy") == 2) {
                        faceRepository.setType("0");
                    }
                    break;
                }
            }
            catch (SDKException e) {
                LOGGER.error("searchGroup happen exception ", (Throwable)e);
            }
        }
        return faceRepository;
    }

    public String getTargetMatchedImage(VcmReqBaseInfo vcmReqBaseInfo, Long fileId) {
        if (vcmReqBaseInfo == null || fileId == null || "0".equals(String.valueOf(fileId))) {
            return "";
        }
        CloseableHttpResponse result = null;
        try {
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)new Ivs1800MsgType(HttpMethodEnum.HTTP_METHOD_GET, "/sdk_service/rest/image-library/file/" + fileId), response -> (CloseableHttpResponse)response);
        }
        catch (SDKException e) {
            LOGGER.error("get file failed,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
        }
        String content = "";
        if (result != null) {
            try (InputStream inputStream = result.getEntity().getContent();){
                content = this.getContentFromInputStream(inputStream);
            }
            catch (IOException e) {
                LOGGER.error("stream failed,IP:" + vcmReqBaseInfo.getVcmIp(), (Throwable)e);
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromInputStream(InputStream in) {
        byte[] data = null;
        try (ByteArrayOutputStream swapStream = new ByteArrayOutputStream();){
            int rc;
            byte[] buffer = new byte[1024];
            while ((rc = in.read(buffer, 0, 1024)) > 0) {
                swapStream.write(buffer, 0, rc);
            }
            data = swapStream.toByteArray();
            LOGGER.info("dynamic image byte size:{}", (Object)data.length);
        }
        catch (IOException e) {
            LOGGER.error("resources close failed", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("resources close failed", (Throwable)e);
                }
            }
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public String getUrlImage(VcmReqBaseInfo vcmInfo, String url) {
        String content;
        block17: {
            content = "";
            if (StringUtils.isBlank((CharSequence)url)) {
                return content;
            }
            vcmInfo.setVcmIp(url);
            vcmInfo.setVcmPort("");
            ClientSessionContext clientSessionContext = new ClientSessionContext(vcmInfo);
            try {
                HttpGet httpget = new HttpGet(url);
                CloseableHttpResponse response = clientSessionContext.getHttpClient().execute((ClassicHttpRequest)httpget);
                if (response == null) break block17;
                try (InputStream inputStream = response.getEntity().getContent();){
                    content = this.getContentFromInputStream(inputStream);
                }
                catch (IOException e) {
                    LOGGER.error("get url image stream failed,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error("get url image error,url:" + url, (Throwable)e);
            }
        }
        return content;
    }

    public String getDynamicGroupImage(VcmReqBaseInfo vcmInfo, String fileId) {
        CloseableHttpResponse result;
        if (Objects.isNull(vcmInfo) || StringUtils.isEmpty((CharSequence)fileId)) {
            return "";
        }
        JSONObject dataObject = new JSONObject();
        dataObject.put("pictureid", (Object)fileId);
        try {
            result = (CloseableHttpResponse)HttpRequestUtil.request((VcmReqBaseInfo)vcmInfo, (MsgType)Ivs1800MsgType.ALARM_GET_DYNAMIC_IMAGE, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)dataObject, false), response -> (CloseableHttpResponse)response, (List)this.getJSONHeaders(vcmInfo));
        }
        catch (SDKException e) {
            LOGGER.error("get dynamic image error,IP:" + vcmInfo.getVcmIp(), (Throwable)e);
            throw new InvokeException("500", Ivs1800Utils.reasonHelper((SDKException)e));
        }
        String content = this.getContentFromResponse(result);
        if (content.contains("resultCode")) {
            Optional baseRespondIvs1800 = JsonUtil.convertJsonToBean((String)content, BaseRespondIvs1800.class);
            if (baseRespondIvs1800.isPresent()) {
                throw new InvokeException("500", (Object)content, Ivs1800Utils.get((int)((BaseRespondIvs1800)baseRespondIvs1800.get()).getResultCode()));
            }
            throw new InvokeException("500", (Object)content, "unknown_error");
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentFromResponse(CloseableHttpResponse response) {
        String string;
        ByteArrayOutputStream swapStream;
        InputStream in;
        byte[] data;
        block7: {
            int rc;
            if (Objects.isNull(response)) {
                return "";
            }
            data = null;
            in = null;
            swapStream = null;
            in = response.getEntity().getContent();
            swapStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((rc = in.read(buffer, 0, 1024)) > 0) {
                swapStream.write(buffer, 0, rc);
            }
            data = swapStream.toByteArray();
            if (!"application/json".equalsIgnoreCase(response.getHeader("Content-Type").getValue())) break block7;
            String string2 = new String(data);
            IOUtils.close((Closeable)swapStream);
            IOUtils.close((Closeable)in);
            return string2;
        }
        try {
            string = new BASE64Encoder().encode(data);
        }
        catch (Exception e) {
            String string3;
            try {
                LOGGER.error("resources close failed", (Throwable)e);
                string3 = "";
            }
            catch (Throwable throwable) {
                IOUtils.close(swapStream);
                IOUtils.close((Closeable)in);
                throw throwable;
            }
            IOUtils.close((Closeable)swapStream);
            IOUtils.close((Closeable)in);
            return string3;
        }
        IOUtils.close((Closeable)swapStream);
        IOUtils.close((Closeable)in);
        return string;
    }

    public JSONObject getVehicleByTargetIdAndGroupId(VcmReqBaseInfo vcmReqBaseInfo, String targetId, String groupId) {
        JSONObject returnObject = new JSONObject();
        try {
            JSONObject data = new JSONObject();
            JSONObject condition = new JSONObject();
            condition.put("page", (Object)1);
            condition.put("limit", (Object)100);
            data.put("condition", (Object)condition);
            JSONObject plateObject = new JSONObject();
            plateObject.put("plateId", (Object)targetId);
            plateObject.put("groupid", (Object)groupId);
            data.put("plate", (Object)plateObject);
            JSONObject resultObject = (JSONObject)HttpRequestUtil.request((VcmReqBaseInfo)vcmReqBaseInfo, (MsgType)Ivs1800MsgType.VEHICLE_SEARCH_PLATE_URI, (ObjectToMsgConvertor)this.objectToMsgConvertor((Object)data, false), (MsgToObjectConvertor)this.msgToObjectConvertor(null, JSONObject.class), (List)this.getJSONHeaders(vcmReqBaseInfo));
            if (resultObject.getIntValue("resultCode") != 0) {
                LOGGER.error("search vehicle file id error, reason:{}", (Object)resultObject.getString("resultCode"));
                return returnObject;
            }
            JSONArray plateList = resultObject.getJSONArray("plateList");
            if (CollectionUtils.isEmpty((Collection)plateList)) {
                return returnObject;
            }
            JSONObject vehicleObject = plateList.getJSONObject(0);
            returnObject.put("groupId", (Object)vehicleObject.getJSONObject("group").getString("groupid"));
            returnObject.put("groupName", (Object)vehicleObject.getJSONObject("group").getString("groupname"));
            returnObject.put("plateNo", (Object)vehicleObject.getString("lpn"));
            if (!CollectionUtils.isEmpty((Collection)vehicleObject.getJSONArray("pictures"))) {
                returnObject.put("fileId", (Object)vehicleObject.getJSONArray("pictures").getJSONObject(0).getString("fileId"));
            } else {
                returnObject.put("fileId", (Object)"");
            }
        }
        catch (SDKException e) {
            LOGGER.error("smart data help get vehicle error", (Throwable)e);
        }
        return returnObject;
    }

    public void searchParentDeviceByMultiCast() {
        try {
            ByteBuf buf = Unpooled.buffer((int)20);
            buf.writeInt(1);
            buf.writeInt(2);
            buf.writeInt(16);
            buf.writeInt(0);
            SearchMultiCastReceiveThread receiveThread = new SearchMultiCastReceiveThread(this, "S100 Search Parent Device Thread");
            receiveThread.start();
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                        DeviceUtil.sendMulticast((InetAddress)InetAddress.getByName("239.100.100.100"), (int)32902, (byte[])buf.array(), (Integer)20, (NetworkInterface)nic);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        }
        catch (Exception e) {
            LOGGER.error("NVR 800 search master device error", (Throwable)e);
        }
    }

    public static int lBytesToInt(byte[] b) {
        int s = 0;
        for (int i = 0; i < 3; ++i) {
            s = b[3 - i] >= 0 ? (s += b[3 - i]) : s + 256 + b[3 - i];
            s *= 256;
        }
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        return s;
    }

    public static int byte4ToInt(byte[] bytes) {
        int b0 = bytes[0] & 0xFF;
        int b1 = bytes[1] & 0xFF;
        int b2 = bytes[2] & 0xFF;
        int b3 = bytes[3] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    public JSONObject changeParentDevicePasswordKey(MasterDeviceSearchRequest request) {
        MulticastSocket multicastSocket = null;
        CompletableFuture.runAsync(() -> {
            ByteBuf buf = Unpooled.buffer((int)1024);
            JSONObject data = new JSONObject();
            data.put("method", (Object)"exchange_key_req");
            data.put("sn", (Object)request.getSn());
            data.put("MAC", (Object)request.getMacAddress());
            buf.writeInt(1);
            buf.writeInt(2);
            buf.writeInt(16);
            buf.writeInt(data.toJSONString().getBytes().length);
            buf.writeBytes(data.toJSONString().getBytes());
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                try {
                    DeviceUtil.sendMulticast((InetAddress)InetAddress.getByName("239.100.100.100"), (int)32902, (byte[])buf.array(), (Integer)20, (NetworkInterface)nic);
                }
                catch (UnknownHostException e) {
                    LOGGER.error("multicast send parent device error ip", (Throwable)e);
                    throw new InvokeException("500", "cu_device_not_support");
                }
            }
        });
        try {
            JSONObject dataJson;
            multicastSocket = new MulticastSocket(32902);
            InetAddress group = InetAddress.getByName("239.100.100.100");
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                InetSocketAddress inetAddr = new InetSocketAddress(group, 32902);
                multicastSocket.joinGroup(inetAddr, nic);
            }
            multicastSocket.setSoTimeout(12000);
            while (true) {
                byte[] buffer = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                multicastSocket.receive(receivePacket);
                byte[] newBuffer = new byte[4];
                System.arraycopy(receivePacket.getData(), 12, newBuffer, 0, 4);
                int bodyLength = SmartDaraHelpService.byte4ToInt((byte[])newBuffer);
                LOGGER.info("multicast bodyLength length data:{}", (Object)bodyLength);
                if (bodyLength <= 0) {
                    LOGGER.info("multicast error head data");
                    continue;
                }
                newBuffer = new byte[bodyLength];
                System.arraycopy(receivePacket.getData(), receivePacket.getLength() - bodyLength, newBuffer, 0, bodyLength);
                String receiveData = new String(newBuffer).trim();
                if (StringUtils.isBlank((CharSequence)receiveData) || !receiveData.startsWith("{")) {
                    LOGGER.info("multicast changeParentDevicePasswordKey receive empty data:{}", (Object)receiveData);
                    continue;
                }
                dataJson = JSONObject.parseObject((String)receiveData);
                if ("exchange_key_resp".equals(dataJson.getString("method")) && request.getMacAddress().equals(dataJson.getString("MAC"))) break;
            }
            if (!"0".equals(dataJson.getString("errorcode"))) {
                throw new InvokeException("500", this.retErrorCode(dataJson.getString("errorcode")));
            }
            JSONObject jSONObject = dataJson;
            return jSONObject;
        }
        catch (SocketException e) {
            LOGGER.error("multicast receive wait time out", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (UnknownHostException e) {
            LOGGER.error("multicast send parent device error ip", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_support");
        }
        catch (IOException e) {
            LOGGER.error("multicast receive join error", (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
        finally {
            if (multicastSocket != null) {
                multicastSocket.close();
            }
        }
    }

    public boolean activateParentDevice(MasterDeviceSearchRequest request) {
        MulticastSocket multicastSocket = null;
        CompletableFuture.runAsync(() -> {
            String password;
            JSONObject pwdObject = this.changeParentDevicePasswordKey(request);
            ByteBuf buf = Unpooled.buffer((int)1024);
            buf.writeInt(1);
            buf.writeInt(2);
            buf.writeInt(16);
            JSONObject data = new JSONObject();
            data.put("method", (Object)"activate_device_req");
            data.put("sn", (Object)request.getSn());
            data.put("MAC", (Object)request.getMacAddress());
            data.put("name", (Object)"admin");
            data.put("mobile_num", (Object)"");
            if (Objects.nonNull(pwdObject)) {
                try {
                    password = this.passwordService.encrypt(request.getPassword(), pwdObject.getString("public_key"), pwdObject.getString("random"));
                }
                catch (Exception e) {
                    LOGGER.error("activateParentDevice encrypt error", (Throwable)e);
                    throw new InvokeException("500", "unknown_error");
                }
            } else {
                password = "";
            }
            data.put("passwd", (Object)password);
            buf.writeInt(data.toJSONString().getBytes().length);
            buf.writeBytes(data.toJSONString().getBytes());
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                try {
                    DeviceUtil.sendMulticast((InetAddress)InetAddress.getByName("239.100.100.100"), (int)32902, (byte[])buf.array(), (Integer)20, (NetworkInterface)nic);
                }
                catch (UnknownHostException e) {
                    LOGGER.error("multicast send parent device error ip", (Throwable)e);
                    throw new InvokeException("500", "cu_device_not_support");
                }
            }
        });
        try {
            JSONObject dataJson;
            multicastSocket = new MulticastSocket(32902);
            InetAddress group = InetAddress.getByName("239.100.100.100");
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                InetSocketAddress inetAddr = new InetSocketAddress(group, 32902);
                multicastSocket.joinGroup(inetAddr, nic);
            }
            multicastSocket.setSoTimeout(12000);
            while (true) {
                byte[] buffer = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                multicastSocket.receive(receivePacket);
                byte[] newBuffer = new byte[4];
                System.arraycopy(receivePacket.getData(), 12, newBuffer, 0, 4);
                int bodyLength = SmartDaraHelpService.byte4ToInt((byte[])newBuffer);
                LOGGER.info("multicast bodyLength length data:{}", (Object)bodyLength);
                if (bodyLength <= 0) {
                    LOGGER.info("multicast error head data");
                    continue;
                }
                newBuffer = new byte[bodyLength];
                System.arraycopy(receivePacket.getData(), receivePacket.getLength() - bodyLength, newBuffer, 0, bodyLength);
                String receiveData = new String(newBuffer).trim();
                if (StringUtils.isBlank((CharSequence)receiveData) || !receiveData.startsWith("{")) {
                    LOGGER.info("multicast activateParentDevice empty data:{}", (Object)receiveData);
                    continue;
                }
                LOGGER.info("multicast activateParentDevice data:{}", (Object)receiveData);
                dataJson = JSONObject.parseObject((String)receiveData);
                if ("activate_device_resp".equals(dataJson.getString("method")) && request.getMacAddress().equals(dataJson.getString("MAC"))) break;
            }
            if (!"0".equals(dataJson.getString("errorcode"))) {
                throw new InvokeException("500", this.retErrorCode(dataJson.getString("errorcode")));
            }
            boolean bl = true;
            return bl;
        }
        catch (SocketException e) {
            LOGGER.error("multicast receive wait time out", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (UnknownHostException e) {
            LOGGER.error("multicast send parent device error ip", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_support");
        }
        catch (IOException e) {
            LOGGER.error("multicast receive join error", (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
        finally {
            if (multicastSocket != null) {
                multicastSocket.close();
            }
        }
    }

    public boolean changeParentDeviceIp(MasterDeviceSearchRequest request) {
        String password;
        JSONObject pwdObject = null;
        MulticastSocket multicastSocket = null;
        if ("true".equals(request.getActivated())) {
            pwdObject = this.changeParentDevicePasswordKey(request);
        }
        JSONObject data = new JSONObject();
        data.put("method", (Object)"set_ip_req");
        data.put("sn", (Object)request.getSn());
        data.put("MAC", (Object)request.getMacAddress());
        data.put("clientIP", (Object)ConfigHolder.getIp());
        data.put("name", (Object)"admin");
        data.put("DHCP", (Object)false);
        data.put("ipv4_ip", (Object)request.getIp());
        data.put("ipv4_netmask", (Object)request.getNetmask());
        data.put("ipv4_gateway", (Object)request.getGateway());
        data.put("ipv4_dns", (Object)request.getDns1());
        data.put("ipv4_dns2", (Object)request.getDns2());
        if (Objects.nonNull(pwdObject)) {
            try {
                password = this.passwordService.encrypt(request.getPassword(), pwdObject.getString("public_key"), pwdObject.getString("random"));
            }
            catch (Exception e) {
                LOGGER.error("activateParentDevice encrypt error", (Throwable)e);
                throw new InvokeException("500", "unknown_error");
            }
        } else {
            password = "";
        }
        data.put("passwd", (Object)password);
        CompletableFuture.runAsync(() -> {
            ByteBuf buf = Unpooled.buffer((int)1024);
            buf.writeInt(1);
            buf.writeInt(2);
            buf.writeInt(16);
            buf.writeInt(data.toJSONString().getBytes().length);
            buf.writeBytes(data.toJSONString().getBytes());
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                try {
                    DeviceUtil.sendMulticast((InetAddress)InetAddress.getByName("239.100.100.100"), (int)32902, (byte[])buf.array(), (Integer)20, (NetworkInterface)nic);
                }
                catch (UnknownHostException e) {
                    LOGGER.error("multicast send parent device error ip", (Throwable)e);
                    throw new InvokeException("500", "cu_device_not_support");
                }
            }
        });
        try {
            JSONObject dataJson;
            multicastSocket = new MulticastSocket(32902);
            InetAddress group = InetAddress.getByName("239.100.100.100");
            for (NetworkInterface nic : DeviceUtil.getNICs((Predicate[])new Predicate[]{DeviceUtil.Filter.UP, DeviceUtil.Filter.PHYICAL_ONLY})) {
                InetSocketAddress inetAddr = new InetSocketAddress(group, 32902);
                multicastSocket.joinGroup(inetAddr, nic);
            }
            multicastSocket.setSoTimeout(12000);
            while (true) {
                byte[] buffer = new byte[1024];
                DatagramPacket receivePacket = new DatagramPacket(buffer, buffer.length);
                multicastSocket.receive(receivePacket);
                byte[] newBuffer = new byte[4];
                System.arraycopy(receivePacket.getData(), 12, newBuffer, 0, 4);
                int bodyLength = SmartDaraHelpService.byte4ToInt((byte[])newBuffer);
                LOGGER.info("multicast bodyLength length data:{}", (Object)bodyLength);
                if (bodyLength <= 0) {
                    LOGGER.info("multicast error head data");
                    continue;
                }
                newBuffer = new byte[bodyLength];
                System.arraycopy(receivePacket.getData(), receivePacket.getLength() - bodyLength, newBuffer, 0, bodyLength);
                String receiveData = new String(newBuffer).trim();
                if (StringUtils.isBlank((CharSequence)receiveData) || !receiveData.startsWith("{")) {
                    LOGGER.info("multicast changeParentDeviceIp empty data:{}", (Object)data);
                    continue;
                }
                LOGGER.info("multicast changeParentDeviceIp data:{}", (Object)receiveData);
                dataJson = JSONObject.parseObject((String)receiveData);
                if ("set_ip_resp".equals(dataJson.getString("method")) && request.getMacAddress().equals(dataJson.getString("MAC"))) break;
            }
            if (!"0".equals(dataJson.getString("errorcode"))) {
                throw new InvokeException("500", this.retErrorCode(dataJson.getString("errorcode")));
            }
            boolean bl = true;
            return bl;
        }
        catch (SocketException e) {
            LOGGER.error("multicast receive wait time out", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_return");
        }
        catch (UnknownHostException e) {
            LOGGER.error("multicast send parent device error ip", (Throwable)e);
            throw new InvokeException("500", "cu_device_not_support");
        }
        catch (IOException e) {
            LOGGER.error("multicast receive join error", (Throwable)e);
            throw new InvokeException("500", "unknown_error");
        }
        finally {
            if (multicastSocket != null) {
                multicastSocket.close();
            }
        }
    }

    private String retErrorCode(String errorCode) {
        if ("-12".equals(errorCode)) {
            errorCode = "129108068";
        }
        if ("-14".equals(errorCode)) {
            errorCode = "not_activated";
        }
        return errorCode;
    }

    public <E> ObjectToMsgConvertor<E> objectToMsgConvertor(E eTemp, boolean isTransferred) {
        return new ObjectToJSONMsgConvertor(eTemp);
    }

    public <T> MsgToObjectConvertor<T> msgToObjectConvertor(Class<?> pClass, Class<T> cClass) {
        return new JSONMsgToObjectConvertor(cClass);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }

    static /* synthetic */ WebSocketService access$100(SmartDaraHelpService x0) {
        return x0.webSocketService;
    }
}

